<?php
// public/page.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Pastikan config.php diimpor dari root proyek.
$project_root = dirname(__DIR__);
require_once $project_root . '/config.php';

$page_slug = $_GET['slug'] ?? null;
$page_content = null;
$site_title = "Halaman"; // Default
$meta_description = "";
$page_template_file = 'default_page_template.php'; // Default template file

if (isset($pdo) && !empty($page_slug)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_pages 
                               WHERE slug = :slug AND status = 'published' AND (published_at IS NULL OR published_at <= NOW())
                               LIMIT 1");
        $stmt->bindParam(':slug', $page_slug);
        $stmt->execute();
        $page_content = $stmt->fetch();

        if ($page_content) {
            $site_title = esc_html($page_content['title']);
            $meta_description = esc_html($page_content['meta_description'] ?: substr(strip_tags($page_content['content_html']), 0, 160));
            
            // Cek apakah ada template kustom yang valid
            $custom_template_path = PROJECT_ROOT . '/public/templates/' . $page_content['template'];
            if (!empty($page_content['template']) && file_exists($custom_template_path)) {
                $page_template_file = $custom_template_path;
            } else {
                 $page_template_file = PROJECT_ROOT . '/public/templates/default_page_template.php';
            }

            // Tambah views_count
            $update_views = $pdo->prepare("UPDATE portal_pages SET views_count = views_count + 1 WHERE id = :id");
            $update_views->execute([':id' => $page_content['id']]);

        } else {
            http_response_code(404);
            $site_title = "Halaman Tidak Ditemukan";
            $meta_description = "Halaman yang Anda cari tidak ditemukan atau belum dipublikasikan.";
            // Ganti template ke 404 jika ada, atau gunakan null untuk fallback rendering
            if (file_exists(PROJECT_ROOT . '/public/templates/404_template.php')) {
                 $page_template_file = PROJECT_ROOT . '/public/templates/404_template.php';
            } else {
                $page_template_file = null; 
            }
        }
    } catch (\PDOException $e) {
        error_log("Error fetching static page: " . $e->getMessage());
        http_response_code(500);
        $site_title = "Kesalahan Server";
        $meta_description = "Terjadi kesalahan saat memuat halaman.";
        $page_template_file = null;
    }
} else {
     http_response_code(400);
     $site_title = "Permintaan Tidak Valid";
     $meta_description = "Permintaan halaman tidak valid. Mohon periksa kembali URL.";
     $page_template_file = null;
}

// Tambahkan ini untuk memuat header & footer yang sama seperti index.php
require_once PROJECT_ROOT . '/public/includes/header_public.php';

?>

<main id="main-content" class="main-content py-5">
    <?php if ($page_content && $page_template_file): ?>
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <?php include $page_template_file; // Template akan menggunakan variabel $page_content ?>
                </div>
            </div>
        </div>
    <?php elseif ($page_content): // Fallback rendering jika template_file tidak ditemukan, tapi konten ada ?>
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article class="page-article">
                        <header class="mb-4">
                            <h1 class="display-5 fw-bold"><?php echo esc_html($page_content['title']); ?></h1>
                            <?php if($page_content['status'] == 'published' && $page_content['updated_at']): ?>
                            <p class="text-muted small">Terakhir diperbarui: <?php echo date('d F Y', strtotime($page_content['updated_at'])); ?></p>
                            <?php endif; ?>
                        </header>
                        <section class="page-content-section">
                            <?php echo $page_content['content_html']; // Tampilkan konten HTML ?>
                        </section>
                    </article>
                </div>
            </div>
        </div>
    <?php else: // Menampilkan halaman error jika konten tidak ditemukan atau ada masalah ?>
        <div class="container text-center py-5">
            <h1 class="display-4"><?php echo $site_title; ?></h1>
            <p class="lead"><?php echo $meta_description; ?></p>
            <a href="<?php echo resolve_url('index.php'); ?>" class="btn btn-primary mt-3">Kembali ke Beranda</a>
        </div>
    <?php endif; ?>
</main>

<?php
require_once PROJECT_ROOT . '/public/includes/footer_public.php';
?>