/**
* File JavaScript Utama untuk Portal UGKMB
* Menggabungkan fungsionalitas template "Impact" dengan fitur kustom.
* Diperbarui: 25 Agustus 2025
*/

/**
 * 1. Logika Preloader Modern
 * Dijalankan pada 'window.load' agar terlihat sampai semua aset (gambar, dll) termuat.
 */
window.addEventListener('load', () => {
  const preloader = document.querySelector('#preloader');
  if (preloader) {
    preloader.classList.add('preloader-hidden');
    preloader.addEventListener('transitionend', () => {
      preloader.remove();
    });
    // Fallback untuk memastikan preloader hilang jika transisi gagal
    setTimeout(() => {
        if(document.body.contains(preloader)){
            preloader.remove();
        }
    }, 500);
  }
});


document.addEventListener('DOMContentLoaded', () => {
  "use strict";
  
  // SEMUA KODE LAINNYA DIMULAI DARI SINI
  // Logika Preloader sudah dipindahkan ke luar event DOMContentLoaded

  /**
   * 2. Sticky Header
   * Menambahkan background pada header saat halaman di-scroll.
   */
  const selectHeader = document.querySelector('#header');
  if (selectHeader) {
    document.addEventListener('scroll', () => {
      window.scrollY > 100 ? selectHeader.classList.add('sticked') : selectHeader.classList.remove('sticked');
    });
  }

  /**
   * 3. Toggle Navigasi Mobile
   * Mengontrol buka-tutup menu di perangkat mobile.
   */
  const mobileNavShow = document.querySelector('.mobile-nav-show');
  const mobileNavHide = document.querySelector('.mobile-nav-hide');
  document.querySelectorAll('.mobile-nav-toggle').forEach(el => {
    el.addEventListener('click', function(event) {
      event.preventDefault();
      mobileNavToogle();
    })
  });

  function mobileNavToogle() {
    document.querySelector('body').classList.toggle('mobile-nav-active');
    mobileNavShow.classList.toggle('d-none');
    mobileNavHide.classList.toggle('d-none');
  }

  /**
   * 4. Toggle Dropdown pada Navigasi Mobile
   */
  const navDropdowns = document.querySelectorAll('.navbar .dropdown > a');
  navDropdowns.forEach(el => {
    el.addEventListener('click', function(event) {
      if (document.querySelector('.mobile-nav-active')) {
        event.preventDefault();
        this.classList.toggle('active');
        this.nextElementSibling.classList.toggle('dropdown-active');
        const dropDownIndicator = this.querySelector('.dropdown-indicator');
        dropDownIndicator.classList.toggle('bi-chevron-up');
        dropDownIndicator.classList.toggle('bi-chevron-down');
      }
    })
  });

  /**
   * 5. Tombol Kembali ke Atas (Scroll Top)
   */
  const scrollTop = document.querySelector('.scroll-top');
  if (scrollTop) {
    const togglescrollTop = function() {
      window.scrollY > 100 ? scrollTop.classList.add('active') : scrollTop.classList.remove('active');
    }
    window.addEventListener('load', togglescrollTop);
    document.addEventListener('scroll', togglescrollTop);
    scrollTop.addEventListener('click', (e) => {
        e.preventDefault();
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    });
  }

  /**
   * 6. Inisialisasi AOS (Animate on Scroll)
   */
  function aos_init() {
    AOS.init({
      duration: 1000,
      easing: 'ease-in-out',
      once: true,
      mirror: false
    });
  }
  window.addEventListener('load', () => {
    aos_init();
  });

  /**
   * 7. Inisialisasi GLightbox untuk Galeri
   */
  if (typeof GLightbox === 'function') {
    const glightbox = GLightbox({
      selector: '.glightbox'
    });
  }

  /**
   * 8. Inisialisasi Swiper untuk Slider Testimoni/Lainnya
   */
  if (typeof Swiper === 'function') {
    new Swiper('.testimonials-slider', {
      speed: 600,
      loop: true,
      autoplay: {
        delay: 5000,
        disableOnInteraction: false
      },
      slidesPerView: 'auto',
      pagination: {
        el: '.swiper-pagination',
        type: 'bullets',
        clickable: true
      },
      breakpoints: {
        320: { slidesPerView: 1, spaceBetween: 40 },
        1200: { slidesPerView: 2, spaceBetween: 40 }
      }
    });
  }
  
  /**
   * 9. Inisialisasi Isotope untuk Filter Portofolio
   */
  const portfolionIsotope = document.querySelector('.portfolio-isotope');
  if (portfolionIsotope && typeof Isotope === 'function') {
    window.addEventListener('load', () => {
      const portfolioIsotope = new Isotope(document.querySelector('.portfolio-container'), {
        itemSelector: '.portfolio-item',
        layoutMode: 'masonry'
      });

      const menuFilters = document.querySelectorAll('.portfolio-isotope .portfolio-flters li');
      menuFilters.forEach(function(el) {
        el.addEventListener('click', function() {
          document.querySelector('.portfolio-isotope .portfolio-flters .filter-active').classList.remove('filter-active');
          this.classList.add('filter-active');
          portfolioIsotope.arrange({
            filter: this.getAttribute('data-filter')
          });
          portfolioIsotope.on('arrangeComplete', function() {
            AOS.refresh();
          });
        }, false);
      });
    });
  }

  // =========================================================================
  // PENAMBAHAN BARU DARI PORTAL KUSTOM
  // =========================================================================

  /**
   * 10. Animasi Fade-in Saat Scroll (Intersection Observer)
   */
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.classList.add('is-visible');
            observer.unobserve(entry.target);
        }
    });
  }, {
      threshold: 0.1
  });

  document.querySelectorAll('.fade-in-section').forEach(section => {
      observer.observe(section);
  });

  /**
   * 11. Form Kontak Interaktif (AJAX)
   */
  const contactForm = document.getElementById('contact-form');
  if (contactForm) {
      contactForm.addEventListener('submit', function(e) {
          e.preventDefault();
          const form = this;
          const formData = new FormData(form);
          const actionUrl = form.getAttribute('action');
          const submitButton = form.querySelector('button[type="submit"]');
          const responseDiv = document.getElementById('form-response');
          const originalButtonText = submitButton.innerHTML;

          submitButton.disabled = true;
          submitButton.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Mengirim...';

          if(responseDiv) {
              responseDiv.innerHTML = '';
              responseDiv.className = '';
          }

          fetch(actionUrl, {
              method: 'POST',
              body: formData,
              headers: { 'X-Requested-With': 'XMLHttpRequest' }
          })
          .then(response => response.json())
          .then(data => {
              if (data.success) {
                  if(responseDiv) {
                     responseDiv.className = 'alert alert-success mt-3';
                     responseDiv.innerHTML = data.message;
                  }
                  form.reset();
              } else {
                  if(responseDiv) {
                      responseDiv.className = 'alert alert-danger mt-3';
                      let errorHtml = '<strong>Terjadi kesalahan:</strong><ul>';
                      if (data.errors && typeof data.errors === 'object') {
                          for (const key in data.errors) {
                              errorHtml += `<li>${data.errors[key]}</li>`;
                          }
                      } else {
                          errorHtml += `<li>${data.message || 'Gagal mengirim pesan.'}</li>`;
                      }
                      errorHtml += '</ul>';
                      responseDiv.innerHTML = errorHtml;
                  }
              }
          })
          .catch(error => {
              if(responseDiv) {
                  responseDiv.className = 'alert alert-danger mt-3';
                  responseDiv.innerHTML = 'Gagal terhubung ke server. Silakan coba lagi nanti.';
              }
              console.error('Fetch Error:', error);
          })
          .finally(() => {
              submitButton.disabled = false;
              submitButton.innerHTML = originalButtonText;
          });
      });
  }
/* =========================================================================
     PENAMBAHAN BARU: LOGIKA UNTUK CHAT BOX
     ========================================================================= */

  /**
   * 12. Logika Tombol Chat Box
   * Mengontrol buka-tutup widget chat.
   */
  const chatToggleButton = document.getElementById('chat-toggle-button');
  const chatWidgetContainer = document.getElementById('chat-widget-container');

  if (chatToggleButton && chatWidgetContainer) {
      chatToggleButton.addEventListener('click', () => {
          chatWidgetContainer.classList.toggle('show');
      });
  }
});