<?php
// public/includes/header_public.php
if (session_status() == PHP_SESSION_NONE) {
    session_start(); // Meskipun config.php mungkin sudah start, aman untuk dicek
}

// Pastikan PROJECT_ROOT dan BASE_URL sudah terdefinisi
if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 2)); // public/includes -> project root
}
if (!defined('BASE_URL')) {
    // Logika fallback BASE_URL jika tidak dari config.php (sebaiknya dari config.php)
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443)) ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $script_name = $_SERVER['SCRIPT_NAME'];
    $public_pos = strpos($script_name, '/public/');
    $base_path_segment = ($public_pos !== false) ? substr($script_name, 0, $public_pos) : rtrim(dirname($script_name), '/\\');
    if ($base_path_segment === '/' || $base_path_segment === '\\') $base_path_segment = '';
    define('BASE_URL', rtrim($protocol . $host . $base_path_segment, '/'));
}

// Fetch global site settings (sebaiknya hanya sekali per request)
global $pdo, $settings, $site_title, $meta_description; // Deklarasikan agar bisa diakses atau dimodifikasi oleh halaman pemanggil

if (!isset($settings) && isset($pdo)) {
    $settings = [];
    try {
        $stmt_header_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
        while ($row_header_settings = $stmt_header_settings->fetch()) {
            $settings[$row_header_settings['setting_key']] = $row_header_settings['setting_value'];
        }
    } catch (\PDOException $e) {
        error_log("Error fetching settings for public header: " . $e->getMessage());
    }
}

$current_theme = $_COOKIE['theme'] ?? 'light-theme'; // Digunakan di tag <html> dan body
$site_name_display = htmlspecialchars($settings['site_name'] ?? 'UGKMB CMS');
$site_logo_url_display = isset($settings['site_logo_url']) && !empty($settings['site_logo_url']) ? htmlspecialchars(resolve_url($settings['site_logo_url'])) : '';
$site_favicon_url_display = isset($settings['site_favicon_url']) && !empty($settings['site_favicon_url']) ? htmlspecialchars(resolve_url($settings['site_favicon_url'])) : resolve_url('assets/img/favicon.ico'); // Fallback

// Judul halaman dan meta deskripsi (bisa di-override oleh halaman pemanggil)
$page_title_display = isset($site_title) ? $site_title : $site_name_display;
if (isset($site_title) && isset($settings['site_name']) && $site_title !== $settings['site_name']) {
    $page_title_display = $site_title . ' - ' . htmlspecialchars($settings['site_name']);
}
$page_meta_desc_display = isset($meta_description) ? $meta_description : htmlspecialchars($settings['site_tagline'] ?? 'Deskripsi default situs.');

// --- Dynamic Menu Fetching & Rendering (TAMBAHAN/MODIFIKASI SIGNIFIKAN) ---
$primary_menu_items = [];
if (isset($pdo)) {
    try {
        $stmt_menu_group = $pdo->prepare("SELECT id FROM portal_menus WHERE location = 'primary_nav' LIMIT 1");
        $stmt_menu_group->execute();
        $menu_group_id = $stmt_menu_group->fetchColumn();

        if ($menu_group_id) {
            $stmt_menu_items = $pdo->prepare("SELECT * FROM portal_menu_items WHERE menu_id = :menu_id ORDER BY parent_id ASC, item_order ASC");
            $stmt_menu_items->execute([':menu_id' => $menu_group_id]);
            $raw_items = $stmt_menu_items->fetchAll(PDO::FETCH_ASSOC);

            if (!function_exists('build_public_menu_tree')) {
                function build_public_menu_tree(array $elements, $parentId = null) {
                    $branch = [];
                    foreach ($elements as $elementKey => $element) {
                        if ($element['parent_id'] == $parentId) {
                            // Penting: unset elemen yang sudah diproses dari array asli JIKA passing by reference
                            // Jika passing by value (default PHP untuk array), tidak perlu unset
                            // unset($elements[$elementKey]); // Hapus jika pass by reference
                            $children = build_public_menu_tree($elements, $element['id']);
                            if ($children) {
                                $element['children'] = $children;
                            }
                            $branch[$element['id']] = $element;
                        }
                    }
                    return $branch;
                }
            }
            $primary_menu_items = build_public_menu_tree($raw_items);
        }
    } catch (\PDOException $e) {
        error_log("Error fetching primary_nav menu items: " . $e->getMessage());
    }
}

// Function to render menu items recursively
if (!function_exists('render_public_menu_items')) {
    function render_public_menu_items($items, $is_submenu = false) {
        $html = '';
        if (empty($items)) return $html;

        $ul_class = $is_submenu ? 'dropdown-menu shadow-sm' : 'navbar-nav ms-auto mb-2 mb-lg-0 align-items-lg-center'; // Bootstrap 5 classes
        // Dapatkan parent_id dari item pertama untuk ID dropdown-menu yang unik (jika submenu)
        $first_item_parent_id_for_label = '';
        if ($is_submenu && !empty($items)) {
            $first_item = reset($items); // Dapatkan elemen pertama dari array
            $first_item_parent_id_for_label = $first_item['parent_id'] ?? rand(1000,9999); // ID random jika parent_id tidak ada (seharusnya ada)
        }
        $ul_attributes = $is_submenu ? ' aria-labelledby="navbarDropdownMenuLink' . $first_item_parent_id_for_label . '"' : '';
        $html .= '<ul class="' . $ul_class . '"' . $ul_attributes . '>';

        foreach ($items as $item) {
            $has_children = !empty($item['children']);
            $li_class = 'nav-item';
            $a_class = 'nav-link px-lg-2'; // Sedikit padding horizontal untuk item top-level
            if ($is_submenu) {
                $li_class = ''; // Tidak perlu nav-item untuk submenu Bootstrap
                $a_class = 'dropdown-item';
            }
            if ($has_children) {
                $li_class .= ' dropdown'; // Hanya untuk top-level yang punya anak
                if (!$is_submenu) { // Hanya top-level a yang jadi dropdown-toggle
                    $a_class .= ' dropdown-toggle';
                }
            }

            // Active state logic
            $current_request_uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
            $item_url_path = parse_url($item['url'], PHP_URL_PATH);
            
            $base_url_path = parse_url(BASE_URL, PHP_URL_PATH) ?? '';
            if ($base_url_path !== '' && strpos($current_request_uri_path, $base_url_path) === 0) {
                $current_request_uri_path = substr($current_request_uri_path, strlen($base_url_path));
            }
            if (substr($item['url'], 0, 1) === '/' && $item['url'] !== '//' ) { // Url relatif dari root
                 $item_url_processed_for_active_check = $item['url'];
            } else if (strpos($item['url'], BASE_URL) === 0) { // Url absolut internal
                 $item_url_processed_for_active_check = substr($item['url'], strlen(BASE_URL));
            } else { // Url eksternal atau #
                 $item_url_processed_for_active_check = null; // Tidak bisa jadi active jika eksternal atau #
            }
            $item_url_path_for_active_check = $item_url_processed_for_active_check ? parse_url($item_url_processed_for_active_check, PHP_URL_PATH) : null;


            $is_active = false;
            if ($item_url_path_for_active_check && $item['url'] !== '#') {
                // Exact match atau parent match
                if ($current_request_uri_path === $item_url_path_for_active_check ||
                    ($item_url_path_for_active_check !== '/' && strpos($current_request_uri_path, $item_url_path_for_active_check) === 0 &&
                     (strlen($current_request_uri_path) == strlen($item_url_path_for_active_check) || substr($current_request_uri_path, strlen($item_url_path_for_active_check), 1) === '/'))
                ) {
                    $is_active = true;
                }
            }
            // Home page active state (index.php atau /)
            if ( ($current_request_uri_path === '/' || basename($current_request_uri_path) === 'index.php') &&
                 ($item_url_path_for_active_check === '/' || ($item_url_path_for_active_check && basename($item_url_path_for_active_check) === 'index.php')) ) {
                $is_active = true;
            }

            if ($is_active && !$is_submenu) { // Hanya top-level yang mendapat kelas active utama
                 $a_class .= ' active';
            }


            $html .= '<li class="' . $li_class . '">';
            $html .= '<a class="' . $a_class . '" href="' . htmlspecialchars(resolve_url($item['url'])) . '" '; // resolve_url untuk konsistensi
            if ($has_children && !$is_submenu) { // Hanya top-level yang punya anak jadi dropdown
                $html .= ' id="navbarDropdownMenuLink' . $item['id'] . '" role="button" data-bs-toggle="dropdown" aria-expanded="false"';
            }
            if (!empty($item['target']) && $item['target'] === '_blank') {
                $html .= ' target="_blank" rel="noopener noreferrer"';
            }
            $html .= '>';
            if (!empty($item['icon_class'])) {
                $html .= '<i class="' . htmlspecialchars($item['icon_class']) . ' me-1"></i>';
            }
            $html .= htmlspecialchars($item['title']);
            $html .= '</a>';

            if ($has_children) {
                $html .= render_public_menu_items($item['children'], true); // Panggil rekursif
            }
            $html .= '</li>';
        }
        $html .= '</ul>';
        return $html;
    }
}
?>
<!DOCTYPE html>
<html lang="id" class="<?php echo htmlspecialchars($current_theme); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title_display; ?></title>
    <meta name="description" content="<?php echo $page_meta_desc_display; ?>">
    <?php if (isset($page_content) && !empty($page_content['meta_keywords'])): // Untuk artikel/halaman spesifik ?>
    <meta name="keywords" content="<?php echo esc_html($page_content['meta_keywords']); ?>">
    <?php elseif (isset($settings['site_meta_keywords_default']) && !empty($settings['site_meta_keywords_default'])): // Fallback ke setting global ?>
    <meta name="keywords" content="<?php echo esc_html($settings['site_meta_keywords_default']); ?>">
    <?php endif; ?>

    <link rel="icon" href="<?php echo $site_favicon_url_display; ?>" type="image/x-icon">

    <!-- Google Fonts CDN -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Animate.css CDN (jika digunakan untuk animasi slider) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" integrity="sha512-c42qTSw/wPZ3/5LBzD+Bw5f7bSF2oxou6wEb+I/lqeaKV5FDIfMvvRp772y4jcJLKuGUOpbJMdg/BTl50fJYAw==" crossorigin="anonymous" referrerpolicy="no-referrer" />


    <!-- Custom Theme CSS -->
    <link rel="stylesheet" href="<?php echo resolve_url('assets/css/theme.css'); ?>">
    <!-- Custom Global Styles (jika ada) -->
    <link rel="stylesheet" href="<?php echo resolve_url('assets/css/style.css'); ?>">

    <!-- Inline script untuk tema FOUC prevention -->
    <script>
        (function() {
            const theme = document.cookie.split('; ').find(row => row.startsWith('theme='))?.split('=')[1] || 
                          (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark-theme' : 'light-theme');
            document.documentElement.className = theme;
        })();
    </script>
    <style>
        body { padding-top: 70px; /* Sesuaikan dengan tinggi navbar Anda */ }
        .dropdown-menu .dropdown-item:hover,
        .dropdown-menu .dropdown-item:focus {
            background-color: var(--public-primary-color); /* Atau warna hover pilihan Anda */
            color: #fff;
        }
        html.dark-theme .dropdown-menu {
            background-color: var(--public-card-bg-dark); /* Warna background dropdown di dark mode */
            border-color: var(--public-border-color-dark);
        }
        html.dark-theme .dropdown-menu .dropdown-item {
            color: var(--public-text-color-dark);
        }
        html.dark-theme .dropdown-menu .dropdown-item:hover,
        html.dark-theme .dropdown-menu .dropdown-item:focus {
            background-color: var(--public-link-color-dark);
            color: var(--public-bg-color-dark);
        }
    </style>
</head>
<body class="<?php echo htmlspecialchars($current_theme); ?>">
    <header data-bs-theme="<?php echo $current_theme === 'dark-theme' ? 'dark' : 'light'; ?>">
        <nav class="navbar navbar-expand-lg <?php echo $current_theme === 'dark-theme' ? 'navbar-dark bg-dark' : 'navbar-light bg-light'; ?> fixed-top shadow-sm">
            <div class="container">
                <a class="navbar-brand fw-bold" href="<?php echo resolve_url('index.php'); ?>">
                    <?php if ($site_logo_url_display): ?>
                        <img src="<?php echo $site_logo_url_display; ?>" alt="Logo <?php echo $site_name_display; ?>" height="40" class="d-inline-block align-top">
                    <?php else: ?>
                        <?php echo $site_name_display; ?>
                    <?php endif; ?>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavPublic" aria-controls="navbarNavPublic" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNavPublic">
                    <?php
                    if (!empty($primary_menu_items)) {
                        echo render_public_menu_items($primary_menu_items);
                    } else {
                        // Fallback menu statis jika menu dinamis gagal atau kosong
                        $current_page_basename_header = basename($_SERVER['PHP_SELF']);
                    ?>
                    <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-lg-center">
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo ($current_page_basename_header == 'index.php') ? 'active' : ''; ?>" href="<?php echo resolve_url('index.php'); ?>">Beranda</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo (in_array($current_page_basename_header, ['articles.php', 'article.php', 'category.php', 'tag.php'])) ? 'active' : ''; ?>" href="<?php echo resolve_url('articles.php'); ?>">Berita</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo (in_array($current_page_basename_header, ['events.php', 'event.php'])) ? 'active' : ''; ?>" href="<?php echo resolve_url('events.php'); ?>">Agenda</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo (in_array($current_page_basename_header, ['gallery.php', 'album.php'])) ? 'active' : ''; ?>" href="<?php echo resolve_url('gallery.php'); ?>">Galeri</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo (in_array($current_page_basename_header, ['faculties.php', 'faculty.php', 'study_program.php'])) ? 'active' : ''; ?>" href="<?php echo resolve_url('faculties.php'); ?>">Akademik</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo ($current_page_basename_header == 'contact.php') ? 'active' : ''; ?>" href="<?php echo resolve_url('contact.php'); ?>">Kontak</a></li>
                    </ul>
                    <?php
                    }
                    ?>
                    <div class="d-flex align-items-center ms-lg-3 mt-2 mt-lg-0">
                        <form class="d-flex me-2" role="search" action="<?php echo resolve_url('search.php'); ?>" method="GET">
                            <input class="form-control form-control-sm" type="search" name="q" placeholder="Cari..." aria-label="Search" value="<?php echo isset($_GET['q']) ? esc_html($_GET['q']) : ''; ?>">
                            <button class="btn btn-sm btn-outline-primary ms-1" type="submit" aria-label="Tombol Cari"><i class="fas fa-search"></i></button>
                        </form>
                        <button class="btn btn-sm btn-outline-secondary" id="publicThemeToggleNav" title="Ganti Tema">
                            <i class="fas fa-moon" id="publicThemeIconMoon" style="display: <?php echo $current_theme === 'dark-theme' ? 'none' : 'inline-block'; ?>;"></i>
                            <i class="fas fa-sun" id="publicThemeIconSun" style="display: <?php echo $current_theme === 'dark-theme' ? 'inline-block' : 'none'; ?>;"></i>
                        </button>
                    </div>
                </div>
            </div>
        </nav>
    </header>
    <div style="padding-top: 65px;"> <!-- Offset content to prevent overlap with fixed navbar -->