<?php
// includes/header.php (Root level - Placeholder atau untuk bagian situs yang berbeda)
if (session_status() == PHP_SESSION_NONE) {
    // session_start(); // Diasumsikan config.php menangani ini
}
if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__)); }
if (!defined('BASE_URL')) { /* BASE_URL harus dari config.php */ }

// Fungsi helper minimal jika file ini digunakan secara independen dan tidak include functions.php lain
if (!function_exists('root_esc_html')) {
    function root_esc_html($string) { return htmlspecialchars((string)$string, ENT_QUOTES, 'UTF-8'); }
}
if (!function_exists('root_resolve_url')) {
    function root_resolve_url($path) {
        if (empty($path)) return '';
        if (preg_match('~^(?:f|ht)tps?://~i', $path) || substr($path, 0, 2) === '//') return $path;
        return rtrim(BASE_URL ?? '', '/') . '/' . ltrim($path, '/');
    }
}

// Variabel global yang mungkin diset oleh halaman pemanggil
global $site_title_page, $meta_description_page, $settings_page, $theme_page, $public_page_specific_css;

$current_theme_root = $theme_page ?? $_COOKIE['theme'] ?? 'light-theme';

// Ambil settings jika belum ada (contoh, ini bisa lebih kompleks)
if (!isset($settings_page) || empty($settings_page)) {
    // Placeholder, idealnya $settings_page di-pass atau ada mekanisme global
    $settings_page = ['site_name' => 'My Generic Site', 'site_tagline' => 'Generic Tagline', 'site_favicon_url' => 'assets/img/favicon.ico'];
}

$page_title_display = isset($site_title_page) ? root_esc_html($site_title_page) : root_esc_html($settings_page['site_name']);
$page_meta_desc_display = isset($meta_description_page) ? root_esc_html($meta_description_page) : root_esc_html($settings_page['site_tagline']);
$favicon_url_display = root_resolve_url($settings_page['site_favicon_url']);
?>
<!DOCTYPE html>
<html lang="id" class="<?php echo root_esc_html($current_theme_root); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title_display; ?></title>
    <meta name="description" content="<?php echo $page_meta_desc_display; ?>">
    <link rel="icon" href="<?php echo $favicon_url_display; ?>" type="image/x-icon">

    <!-- CDN Aset Umum -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />

    <!-- CSS Lokal -->
    <link rel="stylesheet" href="<?php echo root_resolve_url('assets/css/theme.css'); ?>"> <!-- Asumsi ada theme.css di root assets -->
    <link rel="stylesheet" href="<?php echo root_resolve_url('assets/css/style.css'); ?>">

    <?php
    if (isset($public_page_specific_css) && is_array($public_page_specific_css)) {
        foreach ($public_page_specific_css as $css_file) {
            echo '<link rel="stylesheet" href="' . root_resolve_url($css_file) . '">' . "\n";
        }
    }
    ?>

    <script>
        // FOUC Prevention
        (function() {
            const theme = document.cookie.split('; ').find(row => row.startsWith('theme='))?.split('=')[1] || 
                          (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark-theme' : 'light-theme');
            document.documentElement.className = theme;
        })();
    </script>
    <style> body { padding-top: 60px; /* Sesuaikan dengan tinggi navbar */ } </style>
</head>
<body class="<?php echo root_esc_html($current_theme_root); ?>">
    <header data-bs-theme="<?php echo $current_theme_root === 'dark-theme' ? 'dark' : 'light'; ?>">
        <nav class="navbar navbar-expand-lg <?php echo $current_theme_root === 'dark-theme' ? 'navbar-dark bg-dark' : 'navbar-light bg-light'; ?> fixed-top shadow-sm">
            <div class="container">
                <a class="navbar-brand" href="<?php echo root_resolve_url('index.php'); ?>">
                    <?php echo root_esc_html($settings_page['site_name']); ?>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#genericNavbar" aria-controls="genericNavbar" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="genericNavbar">
                    <?php
                    // Bisa include navigation.php di sini jika file itu berisi menu untuk header ini
                    // Atau render menu statis/dinamis
                    // include PROJECT_ROOT . '/includes/navigation.php'; 
                    ?>
                     <ul class="navbar-nav ms-auto">
                        <li class="nav-item"><a class="nav-link" href="<?php echo root_resolve_url('index.php'); ?>">Home</a></li>
                        <li class="nav-item"><a class="nav-link" href="#">About</a></li>
                        <li class="nav-item"><a class="nav-link" href="#">Services</a></li>
                     </ul>
                </div>
            </div>
        </nav>
    </header>
    <div style="padding-top: 60px;"> <!-- Offset untuk fixed navbar -->