<?php
// public/includes/footer_public.php
// FINAL HYBRID VERSION: Integrates WP Posts & Pages while keeping all original code.
global $pdo, $settings;

// KODE ASLI ANDA UNTUK MENGAMBIL DATA LOKAL (TIDAK DIUBAH)
$quick_links_footer = [];
if (isset($pdo)) {
    try {
        $stmt_ql = $pdo->prepare("SELECT title, url FROM portal_quick_links WHERE group_key = 'footer_links' AND is_active = 1 ORDER BY link_order ASC LIMIT 4");
        $stmt_ql->execute();
        $quick_links_footer = $stmt_ql->fetchAll(PDO::FETCH_ASSOC);
    } catch (\PDOException $e) {
        error_log("Error fetching footer quick links: " . $e->getMessage());
    }
}
if (!function_exists('get_site_setting')) {
    function get_site_setting($key, $default = '') {
        global $settings;
        return $settings[$key] ?? $default;
    }
}
?>
    </main> 
      <div id="preloader"></div>

   <button id="chat-toggle-button" class="btn btn-primary rounded-circle p-0 d-flex align-items-center justify-content-center" type="button" aria-label="Toggle Chat" aria-expanded="false">
       <i class="bi bi-chat-dots-fill fs-4"></i> </button>

   <div id="chat-widget-container">
       <iframe src="https://chat.mitrautamateknologi.co-id.id" title="ChatMUT AI Assistant"></iframe>
   </div>
    <footer id="rs-footer" class="bg3 rs-footer footer-unsri-style" style="background-image: url('<?= resolve_url(get_site_setting('footer_bg_image_url', 'public/assets/images/background-footer.jpg')) ?>');">
        <div class="container">
            <div class="footer-top">
                <div class="row">

                    <div class="col-lg-3 col-md-6 mb-4">
                        <h5 class="footer-title">KONTAK KAMI</h5>
                        <div class="about-widget">
                            <img src="<?= resolve_url(get_site_setting('site_logo_footer_url', 'public/assets/images/logo_ugkmb.png')) ?>" alt="Logo Footer" class="mb-3">
                            <ul class="sitemap-widget">
                                
                                <li>
                                    <i class="fa fa-phone" aria-hidden="true"></i>
                                    <span><?= esc_html(get_site_setting('contact_phone_display', 'Telepon belum diatur.')) ?></span>
                                </li>
                                <li>
                                    <i class="fa fa-envelope-o" aria-hidden="true"></i>
                                    <a href="mailto:<?= esc_html(get_site_setting('contact_email', '#')) ?>"><?= esc_html(get_site_setting('contact_email', 'Email belum diatur.')) ?></a>
                                    
                                </li>
                                <li>
                                <i class="fa fa-envelope-o" aria-hidden="true"></i>
                                    <a href="mailto:informasi@ugkmb.ac.id">informasi@ugkmb.ac.id</a>
                                    
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6 mb-4">
                        <h5 class="footer-title">LOKASI KAMPUS</h5>
                         <ul class="sitemap-widget">
                            <li>
                                    <i class="fa fa-map-marker" aria-hidden="true"></i>
                                    <span><?= nl2br(esc_html(get_site_setting('address', 'Alamat lengkap universitas belum diatur.'))) ?></span>
                                </li>
                        </ul>
                    </div>

                    <div class="col-lg-3 col-md-6 mb-4">
                        <h5 class="footer-title">POSTINGAN TERBARU</h5>
                        <ul id="wp-footer-posts" class="sitemap-widget">
                            <li><span class="text-white-50">Memuat...</span></li>
                        </ul>
                    </div>

                    <div class="col-lg-3 col-md-6 mb-4">
                        <h5 class="footer-title">HALAMAN PENTING</h5>
                        <ul id="wp-footer-pages" class="sitemap-widget">
                             <li><span class="text-white-50">Memuat...</span></li>
                        </ul>
                    </div>

                </div>
            </div>
             <div class="footer-share">
                 <ul>
                     <?php if(!empty($settings['social_facebook_url'])): ?><li><a href="<?= esc_html($settings['social_facebook_url']) ?>" target="_blank"><i class="fab fa-facebook"></i></a></li><?php endif; ?>
                     <?php if(!empty($settings['social_twitter_url'])): ?><li><a href="<?= esc_html($settings['social_twitter_url']) ?>" target="_blank"><i class="fab fa-twitter"></i></a></li><?php endif; ?>
                     <?php if(!empty($settings['social_instagram_url'])): ?><li><a href="<?= esc_html($settings['social_instagram_url']) ?>" target="_blank"><i class="fab fa-instagram"></i></a></li><?php endif; ?>
                     <?php if(!empty($settings['social_youtube_url'])): ?><li><a href="<?= esc_html($settings['social_youtube_url']) ?>" target="_blank"><i class="fab fa-youtube"></i></a></li><?php endif; ?>
                 </ul>
             </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="copyright">
                    <p><?= esc_html(get_site_setting('footer_copyright_text', 'Copyright © ' . date("Y") . ' ' . get_site_setting('site_name', 'Universitas Anda'))) ?></p>
                </div>
            </div>
        </div>
    </footer>
    

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo resolve_url('public/assets/js/main.js'); ?>"></script>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const baseApiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2';
        
        // Fungsi untuk mengambil data dan merender list
        const fetchAndRenderList = async (endpoint, containerId) => {
            const container = document.getElementById(containerId);
            if (!container) return;

            try {
                const response = await fetch(`${baseApiUrl}${endpoint}`);
                if (!response.ok) throw new Error('Network response was not ok.');
                const items = await response.json();

                if (items.length > 0) {
                    let listHtml = '';
                    items.forEach(item => {
                        const title = item.title.rendered;
                        const link = item.link;
                        listHtml += `<li><a href="${link}" target="_blank" rel="noopener noreferrer"><i class="fa fa-angle-right" aria-hidden="true"></i>${title}</a></li>`;
                    });
                    container.innerHTML = listHtml;
                } else {
                    container.innerHTML = '<li><span class="text-white-50">Tidak ada data.</span></li>';
                }
            } catch (error) {
                console.error(`Gagal mengambil data untuk ${containerId}:`, error);
                container.innerHTML = '<li><span class="text-white-50">Gagal memuat.</span></li>';
            }
        };

        // Panggil fungsi untuk mengisi postingan terbaru dan halaman
        fetchAndRenderList('/posts?per_page=4', 'wp-footer-posts');
        fetchAndRenderList('/pages?per_page=4', 'wp-footer-pages');
    });
    </script>
    <script>
    const chatToggleButton = document.getElementById('chat-toggle-button');
    const chatWidgetContainer = document.getElementById('chat-widget-container');
    const toggleIcon = chatToggleButton ? chatToggleButton.querySelector('i') : null;

    if (chatToggleButton && chatWidgetContainer && toggleIcon) {
        chatToggleButton.addEventListener('click', () => {
            // Check if the container is currently shown by checking for the 'show' class
            const isVisible = chatWidgetContainer.classList.contains('show');

            if (isVisible) {
                // If visible, hide it
                chatWidgetContainer.classList.remove('show');
                toggleIcon.classList.remove('bi-x-lg'); // Change from close icon
                toggleIcon.classList.add('bi-chat-dots-fill'); // Back to chat icon
                chatToggleButton.setAttribute('aria-expanded', 'false');
            } else {
                // If hidden, show it
                chatWidgetContainer.classList.add('show');
                toggleIcon.classList.remove('bi-chat-dots-fill'); // Change from chat icon
                toggleIcon.classList.add('bi-x-lg'); // To close icon
                chatToggleButton.setAttribute('aria-expanded', 'true');
            }
        });
    }
  </script>
</body>
</html>