<?php
// admin/api/dashboard_data.php
header('Content-Type: application/json');
if (session_status() == PHP_SESSION_NONE) { session_start(); }

if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__, 2)); } // api -> admin -> project root
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php'; // Untuk admin_url dan esc_html jika perlu

// Autentikasi & Otorisasi API (penting!)
// Contoh sederhana: Cek apakah user admin yang login via sesi
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Akses ditolak.']);
    exit;
}

// Validasi CSRF jika dikirim via GET/POST (untuk request dari halaman dashboard itu sendiri)
// if ($_SERVER['REQUEST_METHOD'] === 'GET' && (!isset($_GET['csrf_token']) || !validate_csrf_token($_GET['csrf_token']))) {
//     http_response_code(403);
//     echo json_encode(['success' => false, 'message' => 'CSRF token tidak valid.']);
//     exit;
// }


if (!isset($pdo)) {
    http_response_code(503);
    echo json_encode(['success' => false, 'message' => 'Koneksi database tidak tersedia.']);
    exit;
}

$response = ['success' => false, 'data' => null, 'message' => ''];

try {
    $stats = [];
    $stats['total_articles'] = $pdo->query("SELECT COUNT(*) FROM portal_articles")->fetchColumn();
    $stats['published_articles'] = $pdo->query("SELECT COUNT(*) FROM portal_articles WHERE status = 'published'")->fetchColumn();
    // ... (query statistik lainnya seperti di admin/index.php) ...
    $stats['total_pages'] = $pdo->query("SELECT COUNT(*) FROM portal_pages")->fetchColumn();
    $stats['total_categories'] = $pdo->query("SELECT COUNT(*) FROM portal_categories")->fetchColumn();
    $stats['total_tags'] = $pdo->query("SELECT COUNT(*) FROM portal_tags")->fetchColumn();
    $stats['total_users'] = $pdo->query("SELECT COUNT(*) FROM portal_users")->fetchColumn();
    $stats['active_users'] = $pdo->query("SELECT COUNT(*) FROM portal_users WHERE is_active = 1")->fetchColumn();
    $stats['unread_messages'] = $pdo->query("SELECT COUNT(*) FROM portal_contact_messages WHERE is_read = 0 AND is_archived = 0")->fetchColumn();
    $stats['upcoming_events'] = $pdo->query("SELECT COUNT(*) FROM portal_events WHERE start_datetime >= CURDATE() AND is_published = 1")->fetchColumn();


    $stmt_latest_articles = $pdo->query("SELECT id, title, slug, created_at FROM portal_articles ORDER BY created_at DESC LIMIT 5");
    $latest_articles_list = $stmt_latest_articles->fetchAll();
    // Tambahkan URL edit ke data artikel
    foreach($latest_articles_list as $key => $article) {
        $latest_articles_list[$key]['edit_url'] = admin_url('modules/articles/edit.php?id=' . $article['id'], '../'); // Sesuaikan base path jika API di /admin/api/
    }
    
    $stmt_recent_messages = $pdo->query("SELECT id, sender_name, subject, created_at FROM portal_contact_messages WHERE is_read = 0 AND is_archived = 0 ORDER BY created_at DESC LIMIT 5");
    $recent_messages_list = $stmt_recent_messages->fetchAll();
    foreach($recent_messages_list as $key => $msg) {
        $recent_messages_list[$key]['view_url'] = admin_url('modules/contact_messages/view.php?id=' . $msg['id'], '../');
    }


    $response['success'] = true;
    $response['data'] = [
        'stats' => $stats,
        'latest_articles' => $latest_articles_list,
        'recent_messages' => $recent_messages_list
    ];
    $response['message'] = 'Data dashboard berhasil dimuat.';

} catch (\PDOException $e) {
    error_log("API Dashboard Data Error: " . $e->getMessage());
    http_response_code(500);
    $response['message'] = 'Gagal mengambil data dashboard: ' . $e->getMessage();
}

echo json_encode($response);
exit;
?>