<?php
// admin/modules/tags/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    if ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'editor') {
        header('Location: ../../login.php');
        exit;
    }
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Tag Artikel";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$tags = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT t.id, t.name, t.slug, COUNT(at.article_id) as article_count
                             FROM portal_tags t
                             LEFT JOIN portal_article_tag at ON t.id = at.tag_id
                             GROUP BY t.id, t.name, t.slug
                             ORDER BY t.name ASC");
        $tags = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data tag: ' . $e->getMessage());
        error_log("Error fetching tags: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Tag'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Tag Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-tags me-1"></i>
            Daftar Tag
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableTags" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Tag</th>
                            <th>Slug</th>
                            <th>Jumlah Artikel Terkait</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($tags) > 0): ?>
                            <?php foreach ($tags as $index => $tag): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo esc_html($tag['name']); ?></td>
                                <td><?php echo esc_html($tag['slug']); ?></td>
                                <td class="text-center"><?php echo esc_html($tag['article_count']); ?></td>
                                <td class="text-center">
                                    <a href="edit.php?id=<?php echo $tag['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-tag"
                                            data-id="<?php echo $tag['id']; ?>"
                                            data-name="<?php echo esc_html(addslashes($tag['name'])); ?>"
                                            data-article-count="<?php echo $tag['article_count']; ?>"
                                            data-url="process_tag.php?action=delete&id=<?php echo $tag['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center">Belum ada tag.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableTags').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ },
            \"order\": [[ 1, \"asc\" ]] // Order by Nama Tag
        });

        // AJAX Delete untuk Tag
        $('#dataTableTags').on('click', '.btn-delete-tag', function() {
            const button = $(this);
            const tagName = button.data('name');
            const articleCount = button.data('article-count');
            const deleteUrl = button.data('url');

            let confirmMsg = 'Anda yakin ingin menghapus tag: ' + tagName + '?';
            if (articleCount > 0) {
                confirmMsg += '\\nTag ini digunakan oleh ' + articleCount + ' artikel. Menghapus tag akan melepaskannya dari artikel tersebut.';
            }

            if (confirm(confirmMsg)) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus tag.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus tag.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>