<?php
// admin/modules/tags/create.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Tambah Tag Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? ['name' => '', 'slug' => ''];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Tag', 'url' => 'index.php'],
        'Tambah Tag Baru'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); // Masih berguna jika JS AJAX gagal total dan fallback ke redirect PHP ?>

    <div class="card shadow-sm">
        <div class="card-header">
            <i class="fas fa-plus-circle me-1"></i> Formulir Tag Baru
        </div>
        <div class="card-body">
            <form action="process_tag.php" method="POST" id="tagForm">
                <input type="hidden" name="action" value="create">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Tag <span class="text-danger">*</span></label>
                    <input type="text" class="form-control <?php echo isset($form_errors['name']) ? 'is-invalid' : ''; ?>" id="name" name="name" value="<?php echo old_form_data('name', '', $form_data); ?>" required>
                    <?php echo get_form_error('name', $form_errors); ?>
                </div>

                <div class="mb-3">
                    <label for="slug" class="form-label">Slug (URL Friendly)</label>
                    <input type="text" class="form-control <?php echo isset($form_errors['slug']) ? 'is-invalid' : ''; ?>" id="slug" name="slug" value="<?php echo old_form_data('slug', '', $form_data); ?>" placeholder="Otomatis digenerate jika kosong">
                    <div class="form-text">Hanya huruf kecil, angka, dan tanda hubung (-). Biarkan kosong untuk otomatis.</div>
                    <?php echo get_form_error('slug', $form_errors); ?>
                </div>

                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveTagButton"><i class="fas fa-save me-1"></i> Simpan Tag</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
$page_scripts[] = "<script>
$(document).ready(function() {
    // Inisialisasi slug generator (asumsikan ada di admin-global.js)
    if (typeof initializeSlugGenerator === 'function') {
        initializeSlugGenerator('name', 'slug');
    }

    $('#tagForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveTagButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\" role=\"status\" aria-hidden=\"true\"></span> Menyimpan...');

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');


        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: form.serialize(), // Tidak ada file upload, jadi serialize cukup
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) {
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    } else {
                        form[0].reset(); // Reset form setelah sukses
                        if (typeof initializeSlugGenerator === 'function') { // Re-init slug jika perlu
                           $('#slug').val(''); // Kosongkan slug agar bisa auto generate lagi
                           initializeSlugGenerator('name', 'slug');
                        }
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan tag.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                    errorMsg = jqXHR.responseJSON.message;
                } else if (jqXHR.responseText) {
                    // Potentially HTML error page, log it or show generic message
                    console.error('Server Error Response:', jqXHR.responseText.substring(0,500) );
                }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>