<?php
// admin/modules/study_programs/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Hak akses, hanya admin yang boleh mengelola program studi
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Program Studi";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$study_programs = [];
if (isset($pdo)) {
    try {
        // Query untuk mengambil data program studi beserta nama fakultasnya
        $stmt = $pdo->query("SELECT sp.id, sp.name, sp.slug, sp.is_active, sp.updated_at, f.name as faculty_name
                             FROM portal_study_programs sp
                             LEFT JOIN portal_faculties f ON sp.faculty_id = f.id
                             ORDER BY f.name ASC, sp.program_order ASC, sp.name ASC");
        $study_programs = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data program studi: ' . $e->getMessage());
        error_log("Error fetching study programs: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Program Studi'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Program Studi Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-graduation-cap me-1"></i>
            Daftar Program Studi
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableStudyPrograms" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Program Studi</th>
                            <th>Fakultas</th>
                            <th>Slug</th>
                            <th>Status</th>
                            <th>Terakhir Diperbarui</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($study_programs) > 0): ?>
                            <?php foreach ($study_programs as $index => $sp): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo esc_html($sp['name']); ?></td>
                                <td><?php echo esc_html($sp['faculty_name'] ?? '<em>Belum diatur</em>'); ?></td>
                                <td><?php echo esc_html($sp['slug']); ?></td>
                                <td class="text-center">
                                    <?php if ($sp['is_active'] == 1): ?>
                                        <span class="badge bg-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Tidak Aktif</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('d M Y, H:i', strtotime($sp['updated_at'])); ?></td>
                                <td class="text-center">
                                    <a href="<?php echo resolve_url('study_program.php?slug=' . esc_html($sp['slug'])); ?>" target="_blank" class="btn btn-sm btn-outline-info mb-1" title="Lihat Halaman Publik"><i class="fas fa-eye"></i></a>
                                    <a href="edit.php?id=<?php echo $sp['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-sp"
                                            data-id="<?php echo $sp['id']; ?>"
                                            data-name="<?php echo esc_html(addslashes($sp['name'])); ?>"
                                            data-url="process_study_program.php?action=delete&id=<?php echo $sp['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">Belum ada program studi yang ditambahkan.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableStudyPrograms').DataTable({
            responsive: true,
            language: { 
                url: '//cdn.datatables.net/plug-ins/1.11.5/i18n/id.json'
            },
            'order': [[ 1, 'asc' ]] // Order by Nama Program Studi ascending
        });

        // AJAX Delete untuk Program Studi
        $('#dataTableStudyPrograms').on('click', '.btn-delete-sp', function() {
            const button = $(this);
            const spName = button.data('name');
            const deleteUrl = button.data('url');

            if (confirm('Anda yakin ingin menghapus program studi: ' + spName + '? Aksi ini tidak dapat dibatalkan.')) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                
                $.ajax({
                    url: deleteUrl,
                    method: 'GET', // Sesuai dengan process_study_program.php
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            // Hapus baris dari DataTable
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus program studi.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        let errorMessage = 'Kesalahan server saat menghapus program studi.';
                        if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                            errorMessage = jqXHR.responseJSON.message;
                        }
                        showAdminNotification('danger', errorMessage);
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>