<?php
// admin/modules/pages/create.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Tambah Halaman Statis Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => '', 'slug' => '', 'content_html' => '', 'status' => 'draft',
    'published_at' => date('Y-m-d\TH:i'), 'meta_keywords' => '', 'meta_description' => '',
    'template' => '', 'page_order' => 0
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Halaman Statis', 'url' => 'index.php'],
        'Tambah Halaman Baru'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <form action="process_page.php" method="POST" id="pageForm">
        <input type="hidden" name="action" value="create">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

        <div class="row">
            <div class="col-lg-9">
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-file-alt me-1"></i> Konten Halaman</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Judul Halaman <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', '', $form_data); ?>" required>
                            <?php echo get_form_error('title', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="slug" class="form-label">Slug (URL Friendly)</label>
                            <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', '', $form_data); ?>" placeholder="Otomatis jika kosong">
                            <div class="form-text">Hanya huruf kecil, angka, dan tanda hubung (-). Biarkan kosong untuk otomatis.</div>
                            <?php echo get_form_error('slug', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="content_html" class="form-label">Isi Halaman <span class="text-danger">*</span></label>
                            <textarea class="form-control tinymce-full-pages" id="content_html" name="content_html" rows="20"><?php echo old_form_data('content_html', '', $form_data); ?></textarea>
                            <?php echo get_form_error('content_html', $form_errors); ?>
                        </div>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-search-dollar me-1"></i> Pengaturan SEO (Opsional)</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="meta_keywords" class="form-label">Meta Keywords</label>
                            <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="<?php echo old_form_data('meta_keywords', '', $form_data); ?>" placeholder="keyword1, keyword2">
                            <?php echo get_form_error('meta_keywords', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="meta_description" class="form-label">Meta Description</label>
                            <textarea class="form-control" id="meta_description" name="meta_description" rows="3" maxlength="160"><?php echo old_form_data('meta_description', '', $form_data); ?></textarea>
                            <div class="form-text">Optimal 150-160 karakter.</div>
                            <?php echo get_form_error('meta_description', $form_errors); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3">
                <div class="card mb-4 shadow-sm sticky-lg-top" style="top: 70px;">
                    <div class="card-header"><i class="fas fa-cogs me-1"></i> Publikasi</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select" id="status" name="status" required>
                                <option value="draft" <?php echo (old_form_data('status', 'draft', $form_data) == 'draft') ? 'selected' : ''; ?>>Draft</option>
                                <option value="published" <?php echo (old_form_data('status', 'draft', $form_data) == 'published') ? 'selected' : ''; ?>>Published</option>
                                <option value="pending" <?php echo (old_form_data('status', 'draft', $form_data) == 'pending') ? 'selected' : ''; ?>>Pending Review</option>
                            </select>
                            <?php echo get_form_error('status', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="published_at" class="form-label">Tanggal Publikasi</label>
                            <input type="datetime-local" class="form-control" id="published_at" name="published_at" value="<?php echo old_form_data('published_at', date('Y-m-d\TH:i'), $form_data); ?>">
                            <div class="form-text">Kosongkan untuk publikasi segera saat status 'Published'.</div>
                            <?php echo get_form_error('published_at', $form_errors); ?>
                        </div>
                        <button type="submit" class="btn btn-primary w-100" id="savePageButton"><i class="fas fa-save me-1"></i> Simpan Halaman</button>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-puzzle-piece me-1"></i> Atribut Halaman (Opsional)</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="template" class="form-label">Template Halaman</label>
                            <input type="text" class="form-control" id="template" name="template" value="<?php echo old_form_data('template', '', $form_data); ?>" placeholder="default (biarkan kosong)">
                            <div class="form-text">Nama file template kustom (misal: kontak.php). Tanpa .php jika di public/templates/.</div>
                            <?php echo get_form_error('template', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="page_order" class="form-label">Urutan Halaman</label>
                            <input type="number" class="form-control" id="page_order" name="page_order" value="<?php echo old_form_data('page_order', '0', $form_data); ?>" min="0">
                            <div class="form-text">Untuk pengurutan kustom jika diperlukan.</div>
                            <?php echo get_form_error('page_order', $form_errors); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php
$page_scripts = [];
$page_scripts[] = "https://cdn.tiny.cloud/1/qlw978ky0kcpi9tdpmnoih6myrw4usd6crxwdzms7b9jm9ic/tinymce/6/tinymce.min.js"; // Ganti API Key Anda
$page_scripts[] = "<script>
$(document).ready(function() {
    if (typeof tinymce !== 'undefined') {
        tinymce.init({
            selector: 'textarea.tinymce-full-pages', // Gunakan kelas ini
            plugins: 'lists link image table code help wordcount autoresize preview fullscreen media visualblocks charmap anchor pagebreak searchreplace visualchars advlist importcss',
            toolbar1: 'undo redo | styleselect | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist checklist',
            toolbar2: 'forecolor backcolor casechange permanentpen formatpainter removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media pageembed template link anchor codesample | a11ycheck ltr rtl | showcomments addcomment',
            toolbar_mode: 'sliding',
            height: 600,
            menubar: 'file edit view insert format tools table help',
            // ... (konfigurasi TinyMCE lainnya jika perlu)
        });
    }

    if (typeof initializeSlugGenerator === 'function') {
        initializeSlugGenerator('title', 'slug');
    }

    $('#pageForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#savePageButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        if (typeof tinymce !== 'undefined' && tinymce.get('content_html')) {
            tinymce.get('content_html').save();
        }
        const formData = new FormData(this); // FormData untuk jika ada file upload di masa depan (meski saat ini tidak ada)

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false, // Perlu untuk FormData
            contentType: false, // Perlu untuk FormData
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) {
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    } else {
                        form[0].reset();
                        if (tinymce.get('content_html')) tinymce.get('content_html').setContent('');
                        $('#slug').val('');
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan halaman.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>