<?php
// admin/modules/quick_links/process_quick_link.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 3));
}
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

function is_ajax_request_quicklink() {
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}
$is_ajax = is_ajax_request_quicklink();
if ($is_ajax) {
    header('Content-Type: application/json');
}

$module_redirect_url_base = 'index.php';

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Akses ditolak.']); exit; }
    set_flash_message('danger', 'Anda tidak memiliki izin untuk aksi ini.'); header('Location: ../../login.php'); exit;
}
if (!isset($pdo)) {
    if ($is_ajax) { http_response_code(503); echo json_encode(['success' => false, 'message' => 'Koneksi database gagal.']); exit; }
    set_flash_message('danger', 'Koneksi database gagal.'); header('Location: ' . $module_redirect_url_base); exit;
}

// --- Validation Function ---
function validate_quick_link_input($data) {
    $errors = [];
    if (empty($data['title'])) { $errors['title'] = 'Judul tautan wajib diisi.'; }
    elseif (strlen($data['title']) > 100) { $errors['title'] = 'Judul tautan maksimal 100 karakter.';}
    if (empty($data['url'])) { $errors['url'] = 'URL tujuan wajib diisi.'; }
    elseif (!filter_var($data['url'], FILTER_VALIDATE_URL)) { $errors['url'] = 'Format URL tujuan tidak valid.';}
    elseif (strlen($data['url']) > 2048) { $errors['url'] = 'URL tujuan maksimal 2048 karakter.';}
    if (!empty($data['icon_class']) && strlen($data['icon_class']) > 100) { $errors['icon_class'] = 'Kelas ikon maksimal 100 karakter.';}
    if (!empty($data['description']) && strlen($data['description']) > 255) { $errors['description'] = 'Deskripsi maksimal 255 karakter.';}
    if (!empty($data['group_key']) && !preg_match('/^[a-zA-Z0-9_-]{1,50}$/', $data['group_key'])) { $errors['group_key'] = 'Kunci grup hanya boleh berisi huruf, angka, underscore, atau tanda hubung, maksimal 50 karakter.';}
    if (!isset($data['link_order']) || !is_numeric($data['link_order']) || (int)$data['link_order'] < 0) { $errors['link_order'] = 'Urutan tautan harus berupa angka non-negatif.';}
    if (!isset($data['is_active']) || !in_array($data['is_active'], [0, 1, '0', '1'], true)) { $errors['is_active'] = 'Status tautan tidak valid.';}
    if (!isset($data['open_in_new_tab']) || !in_array($data['open_in_new_tab'], [0, 1, '0', '1'], true)) { $errors['open_in_new_tab'] = 'Pilihan "Buka di Tab Baru" tidak valid.';}
    return $errors;
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.');
        $action_redirect = $_POST['action'] ?? 'create'; $id_redirect = $_POST['id'] ?? null;
        header('Location: ' . ($action_redirect === 'edit' && $id_redirect ? 'edit.php?id=' . $id_redirect : 'create.php')); exit;
    }

    $action = $_POST['action'] ?? null;
    $link_id = isset($_POST['id']) ? (int)$_POST['id'] : null;
    $redirect_on_error_url = ($action === 'edit' && $link_id ? 'edit.php?id=' . $link_id : 'create.php');

    $form_data_input = [
        'title' => trim($_POST['title'] ?? ''), 'url' => trim($_POST['url'] ?? ''),
        'icon_class' => trim($_POST['icon_class'] ?? ''),
        'link_order' => isset($_POST['link_order']) ? (int)$_POST['link_order'] : 0,
        'is_active' => isset($_POST['is_active']) ? (int)$_POST['is_active'] : 0,
        'description' => trim($_POST['description'] ?? ''),
        'group_key' => !empty(trim($_POST['group_key'] ?? '')) ? trim($_POST['group_key']) : 'general',
        'open_in_new_tab' => isset($_POST['open_in_new_tab']) ? (int)$_POST['open_in_new_tab'] : 0,
    ];
    $errors = validate_quick_link_input($form_data_input);

    if (!empty($errors)) {
        if ($is_ajax) { http_response_code(422); echo json_encode(['success' => false, 'message' => 'Validasi gagal.', 'errors' => $errors]); }
        else {
            $_SESSION['form_errors'] = $errors; $_SESSION['form_data'] = $form_data_input;
            set_flash_message('danger', 'Gagal menyimpan tautan cepat.'); header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }

    try {
        $sql_params = [
            ':title' => $form_data_input['title'], ':url' => $form_data_input['url'],
            ':icon_class' => $form_data_input['icon_class'], ':link_order' => $form_data_input['link_order'],
            ':is_active' => $form_data_input['is_active'], ':description' => $form_data_input['description'],
            ':group_key' => $form_data_input['group_key'], ':open_in_new_tab' => $form_data_input['open_in_new_tab'],
        ];
        if ($action === 'create') {
            $sql = "INSERT INTO portal_quick_links (title, url, icon_class, link_order, is_active, description, group_key, open_in_new_tab, created_at, updated_at)
                    VALUES (:title, :url, :icon_class, :link_order, :is_active, :description, :group_key, :open_in_new_tab, NOW(), NOW())";
            $stmt = $pdo->prepare($sql);
        } elseif ($action === 'edit' && $link_id) {
            $sql = "UPDATE portal_quick_links SET title = :title, url = :url, icon_class = :icon_class, link_order = :link_order, is_active = :is_active, description = :description, group_key = :group_key, open_in_new_tab = :open_in_new_tab, updated_at = NOW()
                    WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $sql_params[':id'] = $link_id;
        } else { throw new Exception("Aksi tidak valid."); }
        
        $stmt->execute($sql_params);

        if ($is_ajax) {
            echo json_encode(['success' => true, 'message' => 'Tautan Cepat berhasil ' . ($action === 'create' ? 'dibuat' : 'diperbarui') . '.', 'redirect_url' => $module_redirect_url_base]);
        } else {
            set_flash_message('success', 'Tautan Cepat berhasil ' . ($action === 'create' ? 'dibuat' : 'diperbarui') . '.');
            header('Location: ' . $module_redirect_url_base);
        }
        exit;
    } catch (PDOException | Exception $e) {
        error_log("Error processing quick link ($action): " . $e->getMessage());
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan server: ' . $e->getMessage()]); }
        else {
            set_flash_message('danger', 'Terjadi kesalahan server: ' . $e->getMessage());
            $_SESSION['form_data'] = $form_data_input;
            header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }

} elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'delete') {
    if (!isset($_GET['csrf_token']) || !validate_csrf_token($_GET['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.'); header('Location: ' . $module_redirect_url_base); exit;
    }

    $link_id_to_delete = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    if ($link_id_to_delete <= 0) {
        if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'ID Tautan Cepat tidak valid.']); exit; }
        set_flash_message('danger', 'ID Tautan Cepat tidak valid.'); header('Location: ' . $module_redirect_url_base); exit;
    }

    try {
        $stmt_delete = $pdo->prepare("DELETE FROM portal_quick_links WHERE id = :id");
        $stmt_delete->execute([':id' => $link_id_to_delete]);

        if ($stmt_delete->rowCount() > 0) {
            if ($is_ajax) { echo json_encode(['success' => true, 'message' => 'Tautan Cepat berhasil dihapus.']); }
            else { set_flash_message('success', 'Tautan Cepat berhasil dihapus.'); header('Location: ' . $module_redirect_url_base); }
        } else {
            if ($is_ajax) { echo json_encode(['success' => false, 'message' => 'Tautan Cepat tidak ditemukan atau sudah dihapus.']); }
            else { set_flash_message('warning', 'Tautan Cepat tidak ditemukan atau sudah dihapus.'); header('Location: ' . $module_redirect_url_base); }
        }
    } catch (PDOException $e) {
        error_log("Error deleting quick link: " . $e->getMessage());
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Gagal menghapus tautan: Kesalahan database.']); }
        else { set_flash_message('danger', 'Gagal menghapus tautan cepat karena kesalahan database.'); header('Location: ' . $module_redirect_url_base); }
    }
    exit;
} else {
    if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'Permintaan tidak valid.']); }
    else { set_flash_message('danger', 'Permintaan tidak valid.'); header('Location: ' . $module_redirect_url_base); }
    exit;
}
?>