<?php
// admin/modules/quick_links/edit.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Tautan Cepat";
$link_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($link_id_to_edit <= 0) { /* ... handle error ... */ }
$link_db_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_quick_links WHERE id = :id");
        $stmt->execute([':id' => $link_id_to_edit]);
        $link_db_data = $stmt->fetch();
    } catch (\PDOException $e) { /* ... error handling ... */ }
}
if (!$link_db_data) { /* ... handle not found ... */ }

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => $link_db_data['title'], 'url' => $link_db_data['url'],
    'icon_class' => $link_db_data['icon_class'], 'link_order' => $link_db_data['link_order'],
    'is_active' => $link_db_data['is_active'], 'description' => $link_db_data['description'],
    'group_key' => $link_db_data['group_key'], 'open_in_new_tab' => $link_db_data['open_in_new_tab'],
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?>: <?php echo esc_html($link_db_data['title']); ?></h1>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-edit me-1"></i> Formulir Edit Tautan Cepat</div>
        <div class="card-body">
            <form action="process_quick_link.php" method="POST" id="quickLinkForm">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $link_db_data['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <!-- Form fields sama seperti create.php, tapi value dari $link_db_data atau $form_data -->
                <div class="mb-3">
                    <label for="title" class="form-label">Judul Tautan <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', $link_db_data['title'], $form_data); ?>" required>
                    <?php echo get_form_error('title', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="url" class="form-label">URL Tujuan <span class="text-danger">*</span></label>
                    <input type="url" class="form-control" id="url" name="url" value="<?php echo old_form_data('url', $link_db_data['url'], $form_data); ?>" required>
                     <?php echo get_form_error('url', $form_errors); ?>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="icon_class" class="form-label">Kelas Ikon (Opsional)</label>
                        <input type="text" class="form-control" id="icon_class" name="icon_class" value="<?php echo old_form_data('icon_class', $link_db_data['icon_class'], $form_data); ?>">
                         <?php echo get_form_error('icon_class', $form_errors); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="group_key" class="form-label">Kunci Grup (Opsional)</label>
                        <input type="text" class="form-control" id="group_key" name="group_key" value="<?php echo old_form_data('group_key', $link_db_data['group_key'], $form_data); ?>">
                        <?php echo get_form_error('group_key', $form_errors); ?>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi Singkat (Opsional)</label>
                    <textarea class="form-control" id="description" name="description" rows="2"><?php echo old_form_data('description', $link_db_data['description'], $form_data); ?></textarea>
                    <?php echo get_form_error('description', $form_errors); ?>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="link_order" class="form-label">Urutan Tautan <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="link_order" name="link_order" value="<?php echo old_form_data('link_order', $link_db_data['link_order'], $form_data); ?>" min="0" required>
                        <?php echo get_form_error('link_order', $form_errors); ?>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="is_active" class="form-label">Status Tautan <span class="text-danger">*</span></label>
                        <select class="form-select" id="is_active" name="is_active" required>
                            <option value="1" <?php echo (old_form_data('is_active', $link_db_data['is_active'], $form_data) == '1') ? 'selected' : ''; ?>>Aktif</option>
                            <option value="0" <?php echo (old_form_data('is_active', $link_db_data['is_active'], $form_data) == '0') ? 'selected' : ''; ?>>Nonaktif</option>
                        </select>
                        <?php echo get_form_error('is_active', $form_errors); ?>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="open_in_new_tab" class="form-label">Buka di Tab Baru? <span class="text-danger">*</span></label>
                        <select class="form-select" id="open_in_new_tab" name="open_in_new_tab" required>
                            <option value="0" <?php echo (old_form_data('open_in_new_tab', $link_db_data['open_in_new_tab'], $form_data) == '0') ? 'selected' : ''; ?>>Tidak</option>
                            <option value="1" <?php echo (old_form_data('open_in_new_tab', $link_db_data['open_in_new_tab'], $form_data) == '1') ? 'selected' : ''; ?>>Ya</option>
                        </select>
                        <?php echo get_form_error('open_in_new_tab', $form_errors); ?>
                    </div>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveQuickLinkButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
// Skrip AJAX sama seperti di create.php untuk quick links
$page_scripts = [];
$page_scripts[] = "<script>
$(document).ready(function() {
    $('#quickLinkForm').on('submit', function(e) { /* ... logika AJAX submit seperti di create.php ... */ });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>