<?php
// admin/modules/quick_links/create.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Tambah Tautan Cepat Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => '', 'url' => '', 'icon_class' => '', 'link_order' => 0,
    'is_active' => 1, 'description' => '', 'group_key' => 'general', 'open_in_new_tab' => 0
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-plus-circle me-1"></i> Formulir Tautan Cepat Baru</div>
        <div class="card-body">
            <form action="process_quick_link.php" method="POST" id="quickLinkForm">
                <input type="hidden" name="action" value="create">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="title" class="form-label">Judul Tautan <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', '', $form_data); ?>" required>
                    <?php echo get_form_error('title', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="url" class="form-label">URL Tujuan <span class="text-danger">*</span></label>
                    <input type="url" class="form-control" id="url" name="url" value="<?php echo old_form_data('url', '', $form_data); ?>" placeholder="https://contoh.com/halaman" required>
                    <?php echo get_form_error('url', $form_errors); ?>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="icon_class" class="form-label">Kelas Ikon (Opsional)</label>
                        <input type="text" class="form-control" id="icon_class" name="icon_class" value="<?php echo old_form_data('icon_class', '', $form_data); ?>" placeholder="Contoh: fas fa-book">
                        <div class="form-text">Misalnya kelas Font Awesome. Lihat <a href="https://fontawesome.com/icons" target="_blank" rel="noopener noreferrer">Font Awesome Icons</a>.</div>
                        <?php echo get_form_error('icon_class', $form_errors); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="group_key" class="form-label">Kunci Grup (Opsional)</label>
                        <input type="text" class="form-control" id="group_key" name="group_key" value="<?php echo old_form_data('group_key', 'general', $form_data); ?>" placeholder="Contoh: akademik, layanan_mahasiswa">
                        <div class="form-text">Huruf kecil, angka, underscore (_), atau hubung (-). Default: 'general'.</div>
                        <?php echo get_form_error('group_key', $form_errors); ?>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi Singkat (Opsional)</label>
                    <textarea class="form-control" id="description" name="description" rows="2"><?php echo old_form_data('description', '', $form_data); ?></textarea>
                    <?php echo get_form_error('description', $form_errors); ?>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="link_order" class="form-label">Urutan Tautan <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="link_order" name="link_order" value="<?php echo old_form_data('link_order', '0', $form_data); ?>" min="0" required>
                        <div class="form-text">Angka lebih kecil tampil lebih dulu dalam grupnya.</div>
                        <?php echo get_form_error('link_order', $form_errors); ?>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="is_active" class="form-label">Status Tautan <span class="text-danger">*</span></label>
                        <select class="form-select" id="is_active" name="is_active" required>
                            <option value="1" <?php echo (old_form_data('is_active', '1', $form_data) == '1') ? 'selected' : ''; ?>>Aktif</option>
                            <option value="0" <?php echo (old_form_data('is_active', '1', $form_data) == '0') ? 'selected' : ''; ?>>Nonaktif</option>
                        </select>
                        <?php echo get_form_error('is_active', $form_errors); ?>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="open_in_new_tab" class="form-label">Buka di Tab Baru? <span class="text-danger">*</span></label>
                        <select class="form-select" id="open_in_new_tab" name="open_in_new_tab" required>
                            <option value="0" <?php echo (old_form_data('open_in_new_tab', '0', $form_data) == '0') ? 'selected' : ''; ?>>Tidak</option>
                            <option value="1" <?php echo (old_form_data('open_in_new_tab', '0', $form_data) == '1') ? 'selected' : ''; ?>>Ya</option>
                        </select>
                        <?php echo get_form_error('open_in_new_tab', $form_errors); ?>
                    </div>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveQuickLinkButton"><i class="fas fa-save me-1"></i> Simpan Tautan Cepat</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
$page_scripts = [];
$page_scripts[] = "<script>
$(document).ready(function() {
    $('#quickLinkForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveQuickLinkButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) {
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    } else {
                        form[0].reset();
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan tautan.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>