<?php
// admin/modules/menus/create.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Cek otorisasi
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../../login.php');
    exit;
}

// Muat file-file yang diperlukan
$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

// Inisialisasi variabel
$name = '';
$location = '';
$description = '';
$errors = [];

// --- AWAL PERBAIKAN: Logika pemrosesan form dipindah ke atas ---

// Proses data saat form disubmit (method POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($pdo)) {
    // Ambil dan bersihkan input
    $name = trim($_POST['name'] ?? '');
    $location = trim($_POST['location'] ?? '');
    $description = trim($_POST['description'] ?? '');

    // Validasi CSRF token
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = "Token CSRF tidak valid.";
    }

    // Validasi input
    if (empty($name)) {
        $errors[] = "Nama grup menu wajib diisi.";
    }
    if (empty($location)) {
        $errors[] = "Lokasi (Kunci Tema) wajib diisi.";
    } elseif (!preg_match('/^[a-z0-9_]+$/', $location)) {
        $errors[] = "Lokasi hanya boleh berisi huruf kecil, angka, dan garis bawah (_).";
    } else {
        // Cek apakah lokasi sudah ada
        $stmt_check = $pdo->prepare("SELECT id FROM portal_menus WHERE location = :location");
        $stmt_check->execute([':location' => $location]);
        if ($stmt_check->fetch()) {
            $errors[] = "Lokasi (Kunci Tema) '{$location}' sudah digunakan. Silakan gunakan kunci lain.";
        }
    }

    // Jika tidak ada error, simpan ke database
    if (empty($errors)) {
        try {
            $stmt = $pdo->prepare("INSERT INTO portal_menus (name, location, description) VALUES (:name, :location, :description)");
            $stmt->execute([
                ':name' => $name,
                ':location' => $location,
                ':description' => $description,
            ]);

            // Set pesan sukses dan alihkan halaman
            set_flash_message('success', 'Grup menu berhasil ditambahkan.');
            header('Location: index.php');
            exit; // Penting: Hentikan eksekusi skrip setelah redirect

        } catch (\PDOException $e) {
            // Tangani error database
            set_flash_message('danger', 'Gagal menyimpan grup menu: ' . $e->getMessage());
            error_log("Menu creation error: " . $e->getMessage());
            // Arahkan kembali ke halaman ini agar pesan error bisa ditampilkan
            header('Location: create.php');
            exit;
        }
    } else {
        // Jika ada error validasi, simpan error ke session untuk ditampilkan
        $_SESSION['form_errors'] = $errors;
        $_SESSION['form_data'] = $_POST;
        header('Location: create.php');
        exit;
    }
}

// --- AKHIR PERBAIKAN ---

// Ambil error dan data form dari session (jika ada redirect karena error)
if (isset($_SESSION['form_errors'])) {
    $errors = $_SESSION['form_errors'];
    unset($_SESSION['form_errors']);
}
if (isset($_SESSION['form_data'])) {
    $name = htmlspecialchars($_SESSION['form_data']['name'] ?? '');
    $location = htmlspecialchars($_SESSION['form_data']['location'] ?? '');
    $description = htmlspecialchars($_SESSION['form_data']['description'] ?? '');
    unset($_SESSION['form_data']);
}

// Konfigurasi halaman
$module_base_path = '../../';
$page_title = "Tambah Grup Menu Baru";

// Muat tampilan (header, sidebar, dll)
require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Grup Menu', 'url' => 'index.php'],
        'Tambah Grup Menu Baru'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <?php if (!empty($errors)): ?>
        <div class="alert alert-danger" role="alert">
            <h4 class="alert-heading">Terjadi Kesalahan!</h4>
            <ul class="mb-0">
                <?php foreach ($errors as $error): ?>
                    <li><?php echo htmlspecialchars($error); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="card shadow-sm">
        <div class="card-header">
            <i class="fas fa-plus me-1"></i>
            Formulir Grup Menu
        </div>
          <div class="card-body">
            <form action="process_menu.php" method="POST" id="menuGroupForm">
                <input type="hidden" name="action" value="create_group">
                
                <?php echo generate_csrf_input(); ?>

                <div class="mb-3">
                    <label for="location" class="form-label">Lokasi (Kunci Tema) <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="location" name="location" value="<?php echo $location; ?>" required pattern="[a-z0-9_]+">
                    <div class="form-text">Kunci unik untuk digunakan di tema (contoh: <code>primary_nav</code>, <code>footer_links</code>). Hanya huruf kecil, angka, dan garis bawah (_).</div>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi</label>
                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo $description; ?></textarea>
                    <div class="form-text">Penjelasan singkat tentang tujuan grup menu ini (opsional).</div>
                </div>
                <div class="d-flex justify-content-end">
                    <a href="index.php" class="btn btn-secondary me-2">Batal</a>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
// Muat footer
require_once $project_root . '/admin/includes/footer.php';
?>