<?php
// admin/modules/gallery_albums/process_gallery_item.php
if (session_status() == PHP_SESSION_NONE) {
    // session_start(); // Diasumsikan sudah dihandle oleh config.php
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 3)); 
}
require_once PROJECT_ROOT . '/config.php'; // Memuat db_connect.php dan functions.php

// Fungsi helper lokal untuk request AJAX
function is_ajax_request_gallery_item_proc_local() {
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}
$is_ajax = is_ajax_request_gallery_item_proc_local();

if ($is_ajax) {
    header('Content-Type: application/json');
}

// Ambil album_id dari request (POST atau GET)
$album_id_from_request = 0;
if (isset($_POST['album_id'])) {
    $album_id_from_request = (int)$_POST['album_id'];
} elseif (isset($_GET['album_id'])) {
    $album_id_from_request = (int)$_GET['album_id'];
}

// URL redirect default
$default_redirect_if_no_album_id = admin_url('modules/gallery_albums/index.php');
$module_redirect_url_base_item_proc = $album_id_from_request > 0 ? admin_url('modules/gallery_albums/manage_items.php?album_id=' . $album_id_from_request) : $default_redirect_if_no_album_id;

// Keamanan dan Inisialisasi
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    if ($is_ajax) { 
        http_response_code(403); 
        echo json_encode(['success' => false, 'message' => 'Akses ditolak. Anda tidak memiliki izin.']); 
        exit; 
    }
    set_flash_message('danger', 'Anda tidak memiliki izin untuk melakukan aksi ini.'); 
    header('Location: ' . admin_url('login.php'));
    exit;
}
if (!isset($pdo)) {
    if ($is_ajax) { 
        http_response_code(503); 
        echo json_encode(['success' => false, 'message' => 'Koneksi database gagal.']); 
        exit; 
    }
    set_flash_message('danger', 'Koneksi database gagal.'); 
    header('Location: ' . $module_redirect_url_base_item_proc); 
    exit;
}

// --- Fungsi Validasi Input Item Galeri ---
function validate_gallery_item_input_proc($data, $is_edit = false, $files_array = null) {
    $errors = [];
    if (empty($data['album_id']) || !is_numeric($data['album_id']) || $data['album_id'] <= 0) {
        $errors['album_id'] = 'ID Album tidak valid.';
    }
    if (empty($data['item_type']) || !in_array($data['item_type'], ['image', 'video_embed'])) {
        $errors['item_type'] = 'Tipe item galeri tidak valid.';
    }

    if ($data['item_type'] === 'image') {
        if (!$is_edit && (!isset($files_array['item_file']) || $files_array['item_file']['error'] == UPLOAD_ERR_NO_FILE)) {
            if (!isset($errors['item_file'])) $errors['item_file'] = 'File gambar wajib diunggah untuk item baru tipe gambar.';
        }
    } elseif ($data['item_type'] === 'video_embed') {
        if (empty($data['item_url_embed'])) {
            $errors['item_url_embed'] = 'URL embed video wajib diisi untuk tipe video.';
        } elseif (!filter_var($data['item_url_embed'], FILTER_VALIDATE_URL)) {
            $errors['item_url_embed'] = 'Format URL embed video tidak valid.';
        } elseif (strlen($data['item_url_embed']) > 2048) {
             $errors['item_url_embed'] = 'URL embed video maksimal 2048 karakter.';
        } else {
            $allowed_video_hosts = ['youtube.com', 'www.youtube.com', 'youtu.be', 'youtube-nocookie.com', 'www.youtube-nocookie.com', 'vimeo.com', 'player.vimeo.com'];
            $parsed_url = parse_url($data['item_url_embed']);
            $is_allowed_host = false;
            if (isset($parsed_url['host'])) {
                foreach ($allowed_video_hosts as $domain) {
                    if (strtolower($parsed_url['host']) === strtolower($domain) || str_ends_with(strtolower($parsed_url['host']), '.' . strtolower($domain))) { 
                        $is_allowed_host = true; 
                        break; 
                    }
                }
            }
            if (!$is_allowed_host) { $errors['item_url_embed'] = 'Domain URL embed video tidak diizinkan. Hanya YouTube atau Vimeo.';}
        }
    }

    if (isset($data['item_title']) && strlen($data['item_title']) > 255) { 
        $errors['item_title'] = 'Judul item maksimal 255 karakter.';
    }
    if (!isset($data['item_order']) || !is_numeric($data['item_order']) || (int)$data['item_order'] < 0) { 
        $errors['item_order'] = 'Urutan item harus berupa angka non-negatif.';
    }
    return $errors;
}

// --- Fungsi Helper Upload File Gambar Item Galeri ---
function handle_gallery_item_image_proc($file_input_name, $current_item_image_path, &$errors_array_ref) {
    $final_image_path_for_db = $current_item_image_path; 

    if (isset($_FILES[$file_input_name]) && $_FILES[$file_input_name]['error'] == UPLOAD_ERR_OK) {
        $upload_dir_relative_path = 'uploads/gallery_items/'; 
        $upload_dir_absolute_path = rtrim(PROJECT_ROOT, '/') . '/' . $upload_dir_relative_path;
        
        $upload_operation_result = upload_file($_FILES[$file_input_name], $upload_dir_absolute_path, ['image/jpeg', 'image/png', 'image/gif', 'image/webp'], 2 * 1024 * 1024);

        if ($upload_operation_result['success']) {
            if (!empty($current_item_image_path) && file_exists(rtrim(PROJECT_ROOT, '/') . '/' . ltrim($current_item_image_path, '/'))) { 
                @unlink(rtrim(PROJECT_ROOT, '/') . '/' . ltrim($current_item_image_path, '/'));
            }
            $final_image_path_for_db = $upload_operation_result['filepath_relative']; 
        } else { 
            $errors_array_ref[$file_input_name] = $upload_operation_result['message']; 
        }
    } elseif (isset($_FILES[$file_input_name]) && $_FILES[$file_input_name]['error'] != UPLOAD_ERR_NO_FILE) {
        $errors_array_ref[$file_input_name] = "Error saat upload file gambar item: Kode error PHP " . $_FILES[$file_input_name]['error'];
    }
    return $final_image_path_for_db;
}


// --- Logika Utama untuk Aksi POST ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        unset($_SESSION['csrf_token']); 
        $new_csrf_for_error = generate_csrf_token(); 
        if ($is_ajax) { 
            http_response_code(403); 
            echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF token. Sesi mungkin telah berakhir atau token tidak cocok. Harap muat ulang halaman dan coba lagi.', 'new_csrf_token' => $new_csrf_for_error]); 
            exit; 
        }
        set_flash_message('danger', 'Kesalahan CSRF token. Silakan coba lagi.'); 
        header('Location: ' . $module_redirect_url_base_item_proc);
        exit;
    }
    unset($_SESSION['csrf_token']); 
    $new_csrf_token_for_response = generate_csrf_token();


    $action = $_POST['action'] ?? null;
    $album_id = isset($_POST['album_id']) ? (int)$_POST['album_id'] : 0; 
    $item_id = isset($_POST['item_id']) ? (int)$_POST['item_id'] : null; 
    
    if ($album_id > 0 && $module_redirect_url_base_item_proc !== admin_url('modules/gallery_albums/manage_items.php?album_id=' . $album_id)) {
        $module_redirect_url_base_item_proc = admin_url('modules/gallery_albums/manage_items.php?album_id=' . $album_id);
    }
    $redirect_on_error_url_item_proc = $module_redirect_url_base_item_proc . ($action === 'edit_item' && $item_id ? '&edit_item_id=' . $item_id : '#addItemForm');

    if ($album_id <= 0 && $action !== 'save_order') { 
        if ($is_ajax) { 
            http_response_code(400); 
            echo json_encode(['success' => false, 'message' => 'ID Album tidak valid atau tidak disertakan.', 'new_csrf_token' => $new_csrf_token_for_response]); 
            exit;
        }
        set_flash_message('danger', 'ID Album tidak valid.'); 
        header('Location: ' . admin_url('modules/gallery_albums/index.php')); 
        exit;
    }

    if ($action === 'add_item' || $action === 'edit_item') {
        $form_data_item_input = [
            'album_id' => $album_id,
            'item_type' => $_POST['item_type'] ?? 'image',
            'item_url_embed' => trim($_POST['item_url_embed'] ?? ''),
            'item_title' => trim($_POST['item_title'] ?? ''),
            'item_caption' => trim($_POST['item_caption'] ?? ''),
            'item_order' => isset($_POST['item_order']) ? (int)$_POST['item_order'] : 0,
            'old_item_url' => $_POST['old_item_url'] ?? null,
        ];
        $form_data_item_input['item_url'] = $form_data_item_input['old_item_url']; 
        $errors_validation = []; 

        if ($form_data_item_input['item_type'] === 'image') {
            $form_data_item_input['item_url'] = handle_gallery_item_image_proc('item_file', $form_data_item_input['old_item_url'], $errors_validation);
        } else { 
            $form_data_item_input['item_url'] = $form_data_item_input['item_url_embed'];
        }
        
        $validation_errors_fields_proc = validate_gallery_item_input_proc($form_data_item_input, ($action === 'edit_item'), $_FILES);
        $errors_validation = array_merge($errors_validation, $validation_errors_fields_proc);

        if (!empty($errors_validation)) {
            if ($is_ajax) { 
                http_response_code(422); 
                echo json_encode(['success' => false, 'message' => 'Validasi gagal. Harap periksa input Anda.', 'errors' => $errors_validation, 'new_csrf_token' => $new_csrf_token_for_response]); 
            } else {
                if ($action === 'add_item') { $_SESSION['form_errors_item_add'] = $errors_validation; $_SESSION['form_data_item_add'] = $_POST; } 
                elseif ($action === 'edit_item') { $_SESSION['form_errors_item_edit'] = $errors_validation; $_SESSION['form_data_item_edit'] = $_POST; }
                set_flash_message('danger', 'Gagal menyimpan item galeri. Periksa error di form.'); 
                header('Location: ' . $redirect_on_error_url_item_proc);
            }
            exit;
        }

        try {
            $pdo->beginTransaction(); 

            $sql_item_params = [
                ':album_id' => $form_data_item_input['album_id'], 
                ':item_url' => $form_data_item_input['item_url'], 
                ':item_type' => $form_data_item_input['item_type'], 
                ':title' => $form_data_item_input['item_title'],
                ':caption' => $form_data_item_input['item_caption'], 
                ':item_order' => $form_data_item_input['item_order'],
            ];

            if ($action === 'add_item') {
                $sql_item = "INSERT INTO portal_gallery_items (album_id, item_url, item_type, title, caption, item_order, created_at, updated_at)
                             VALUES (:album_id, :item_url, :item_type, :title, :caption, :item_order, NOW(), NOW())";
                $stmt_item = $pdo->prepare($sql_item);
            } elseif ($action === 'edit_item' && $item_id) {
                $sql_item = "UPDATE portal_gallery_items SET 
                                item_url = :item_url, item_type = :item_type, title = :title, 
                                caption = :caption, item_order = :item_order, updated_at = NOW()
                             WHERE id = :id AND album_id = :album_id_check";
                $sql_item_params[':id'] = $item_id;
                $sql_item_params[':album_id_check'] = $form_data_item_input['album_id'];
                $stmt_item = $pdo->prepare($sql_item);
            } else { 
                throw new Exception("Aksi tidak valid atau ID Item tidak ada."); 
            }
            
            $stmt_item->execute($sql_item_params);
            $processed_item_id_val = ($action === 'add_item') ? $pdo->lastInsertId() : $item_id;
            
            $pdo->commit(); 

            $stmt_get_processed_item = $pdo->prepare("SELECT * FROM portal_gallery_items WHERE id = :id");
            $stmt_get_processed_item->execute([':id' => $processed_item_id_val]);
            $processed_item_data_val = $stmt_get_processed_item->fetch(PDO::FETCH_ASSOC);
            
            if ($is_ajax) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Item galeri berhasil ' . ($action === 'add_item' ? 'ditambahkan' : 'diperbarui') . '.',
                    'item' => $processed_item_data_val,
                    'new_csrf_token' => $new_csrf_token_for_response
                ]);
            } else {
                set_flash_message('success', 'Item galeri berhasil ' . ($action === 'add_item' ? 'ditambahkan' : 'diperbarui') . '.');
                header('Location: ' . $module_redirect_url_base_item_proc);
            }
            exit;

        } catch (PDOException | Exception $e_item_proc) {
            if ($pdo->inTransaction()) $pdo->rollBack(); 
            error_log("Error processing gallery item ($action): " . $e_item_proc->getMessage());
            $error_msg_user_item_proc = 'Terjadi kesalahan saat menyimpan item galeri: ' . $e_item_proc->getMessage();
            if ($is_ajax) { 
                http_response_code(500); 
                echo json_encode(['success' => false, 'message' => $error_msg_user_item_proc, 'new_csrf_token' => $new_csrf_token_for_response]); 
            } else {
                set_flash_message('danger', $error_msg_user_item_proc);
                if ($action === 'add_item') { $_SESSION['form_data_item_add'] = $_POST; }
                elseif ($action === 'edit_item') { $_SESSION['form_data_item_edit'] = $_POST; }
                header('Location: ' . $redirect_on_error_url_item_proc);
            }
            exit;
        }
    }
    elseif ($action === 'save_order' && $album_id > 0) {
        if (!isset($_POST['ordered_items']) || !is_array($_POST['ordered_items'])) {
            if ($is_ajax) { 
                http_response_code(400); 
                echo json_encode(['success' => false, 'message' => 'Data urutan item tidak valid atau tidak lengkap.', 'new_csrf_token' => $new_csrf_token_for_response]); 
                exit; 
            }
            set_flash_message('danger', 'Data urutan item tidak valid.'); 
            header('Location: ' . $module_redirect_url_base_item_proc); 
            exit;
        }
        $ordered_items_input_val = $_POST['ordered_items'];
        try {
            $pdo->beginTransaction();
            $stmt_update_order_proc = $pdo->prepare("UPDATE portal_gallery_items SET item_order = :item_order, updated_at = NOW() WHERE id = :id AND album_id = :album_id");
            $success_count_proc = 0;
            foreach ($ordered_items_input_val as $item_data_sort) {
                if (isset($item_data_sort['id']) && isset($item_data_sort['order'])) {
                    $stmt_update_order_proc->execute([
                        ':item_order' => (int)$item_data_sort['order'],
                        ':id' => (int)$item_data_sort['id'],
                        ':album_id' => $album_id 
                    ]);
                    if ($stmt_update_order_proc->rowCount() > 0) $success_count_proc++;
                }
            }
            $pdo->commit();
            if ($is_ajax) { 
                echo json_encode(['success' => true, 'message' => "Urutan untuk {$success_count_proc} item berhasil diperbarui.", 'new_csrf_token' => $new_csrf_token_for_response]); 
            } else { 
                set_flash_message('success', "Urutan untuk {$success_count_proc} item berhasil diperbarui."); 
                header('Location: ' . $module_redirect_url_base_item_proc); 
            }
            exit;

        } catch (PDOException $e_sort) {
            if($pdo->inTransaction()) $pdo->rollBack();
            error_log("Error saving gallery item order for album ID {$album_id}: " . $e_sort->getMessage());
            if ($is_ajax) { 
                http_response_code(500); 
                echo json_encode(['success' => false, 'message' => 'Gagal menyimpan urutan: Kesalahan database.', 'new_csrf_token' => $new_csrf_token_for_response]); 
            } else { 
                set_flash_message('danger', 'Gagal menyimpan urutan karena kesalahan database.'); 
                header('Location: ' . $module_redirect_url_base_item_proc); 
            }
            exit;
        }
    } else {
        if ($is_ajax) { 
            http_response_code(400); 
            echo json_encode(['success' => false, 'message' => 'Aksi POST tidak valid atau tidak dikenali.', 'new_csrf_token' => $new_csrf_token_for_response]); 
            exit; 
        }
        set_flash_message('danger', 'Aksi POST tidak valid.'); 
        header('Location: ' . $module_redirect_url_base_item_proc); 
        exit;
    }
} 
elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'delete_item') {
    if (!isset($_GET['csrf_token']) || !validate_csrf_token($_GET['csrf_token'])) {
        unset($_SESSION['csrf_token']);
        $new_csrf_for_error = generate_csrf_token();
        if ($is_ajax) { 
            http_response_code(403); 
            echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF token (GET). Harap muat ulang halaman.', 'new_csrf_token' => $new_csrf_for_error]); 
            exit; 
        }
        set_flash_message('danger', 'Kesalahan CSRF token. Silakan coba lagi.'); 
        header('Location: ' . $module_redirect_url_base_item_proc);
        exit;
    }
    unset($_SESSION['csrf_token']); 
    $new_csrf_token_for_response = generate_csrf_token();

    $item_id_to_delete_val = isset($_GET['id']) ? (int)$_GET['id'] : 0;

    if ($item_id_to_delete_val <= 0 || $album_id_from_request <= 0) {
        if ($is_ajax) { 
            http_response_code(400); 
            echo json_encode(['success' => false, 'message' => 'ID Item atau ID Album tidak valid untuk penghapusan.', 'new_csrf_token' => $new_csrf_token_for_response]); 
            exit; 
        }
        set_flash_message('danger', 'ID Item atau Album tidak valid untuk penghapusan.'); 
        header('Location: ' . $module_redirect_url_base_item_proc); 
        exit;
    }

    try {
        $pdo->beginTransaction();
        $stmt_get_item_file = $pdo->prepare("SELECT item_url, item_type FROM portal_gallery_items WHERE id = :id AND album_id = :album_id");
        $stmt_get_item_file->execute([':id' => $item_id_to_delete_val, ':album_id' => $album_id_from_request]);
        $item_to_delete_file_info_val = $stmt_get_item_file->fetch(PDO::FETCH_ASSOC);

        if ($item_to_delete_file_info_val) {
            $stmt_delete_item_db = $pdo->prepare("DELETE FROM portal_gallery_items WHERE id = :id");
            $stmt_delete_item_db->execute([':id' => $item_id_to_delete_val]);

            if ($stmt_delete_item_db->rowCount() > 0) {
                if ($item_to_delete_file_info_val['item_type'] === 'image' && !empty($item_to_delete_file_info_val['item_url'])) {
                    $file_to_delete_path = rtrim(PROJECT_ROOT, '/') . '/' . ltrim($item_to_delete_file_info_val['item_url'], '/');
                    if (file_exists($file_to_delete_path) && !is_dir($file_to_delete_path)) {
                        @unlink($file_to_delete_path);
                    }
                }
                $pdo->commit();
                if ($is_ajax) { 
                    echo json_encode(['success' => true, 'message' => 'Item galeri berhasil dihapus.', 'new_csrf_token' => $new_csrf_token_for_response]); 
                } else { 
                    set_flash_message('success', 'Item galeri berhasil dihapus.'); 
                    header('Location: ' . $module_redirect_url_base_item_proc); 
                }
            } else {
                $pdo->rollBack();
                if ($is_ajax) { 
                    echo json_encode(['success' => false, 'message' => 'Item galeri tidak ditemukan di database atau gagal dihapus.', 'new_csrf_token' => $new_csrf_token_for_response]); 
                } else { 
                    set_flash_message('warning', 'Item galeri tidak ditemukan di database atau gagal dihapus.'); 
                    header('Location: ' . $module_redirect_url_base_item_proc); 
                }
            }
        } else {
            $pdo->rollBack();
            if ($is_ajax) { 
                echo json_encode(['success' => false, 'message' => 'Item tidak ditemukan dalam album yang ditentukan.', 'new_csrf_token' => $new_csrf_token_for_response]); 
            } else { 
                set_flash_message('warning', 'Item tidak ditemukan dalam album yang ditentukan.'); 
                header('Location: ' . $module_redirect_url_base_item_proc); 
            }
        }
    } catch (PDOException $e_del_item) {
        if($pdo->inTransaction()) $pdo->rollBack();
        error_log("Error deleting gallery item (ID: {$item_id_to_delete_val}): " . $e_del_item->getMessage());
        if ($is_ajax) { 
            http_response_code(500); 
            echo json_encode(['success' => false, 'message' => 'Gagal menghapus item: Terjadi kesalahan database.', 'new_csrf_token' => $new_csrf_token_for_response]); 
        } else { 
            set_flash_message('danger', 'Gagal menghapus item galeri karena kesalahan database.'); 
            header('Location: ' . $module_redirect_url_base_item_proc); 
        }
    }
    exit;
} else {
    // Jika bukan POST atau GET dengan action yang dikenal
    if ($is_ajax) { 
        http_response_code(400); 
        echo json_encode(['success' => false, 'message' => 'Permintaan tidak valid atau aksi tidak dikenali.']); 
        exit;
    }
    set_flash_message('danger', 'Permintaan tidak valid atau aksi tidak dikenali.'); 
    header('Location: ' . $module_redirect_url_base_item_proc); 
    exit;
}
?>