<?php
// admin/modules/gallery_albums/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Album Galeri";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$albums = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT ga.id, ga.title, ga.slug, ga.cover_image_url, ga.album_date, ga.is_published, COUNT(gi.id) as item_count
                             FROM portal_gallery_albums ga
                             LEFT JOIN portal_gallery_items gi ON ga.id = gi.album_id
                             GROUP BY ga.id, ga.title, ga.slug, ga.cover_image_url, ga.album_date, ga.is_published
                             ORDER BY ga.album_date DESC, ga.created_at DESC");
        $albums = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data album: ' . $e->getMessage());
        error_log("Error fetching gallery albums: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Album Galeri'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Album Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-images me-1"></i>
            Daftar Album Galeri
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableGalleryAlbums" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Cover</th>
                            <th>Judul Album</th>
                            <th>Tanggal Album</th>
                            <th>Jumlah Item</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($albums) > 0): ?>
                            <?php foreach ($albums as $index => $album): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td class="text-center">
                                    <?php if (!empty($album['cover_image_url'])): ?>
                                        <img src="<?php echo resolve_url(esc_html($album['cover_image_url'])); ?>" alt="Cover <?php echo esc_html($album['title']); ?>" style="width: 100px; height: auto; max-height:70px; object-fit: cover; border-radius: 0.25rem;">
                                    <?php else: ?>
                                        <span class="text-muted small fst-italic">Tanpa Cover</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="manage_items.php?album_id=<?php echo $album['id']; ?>" title="Kelola item di album <?php echo esc_html($album['title']); ?>">
                                        <?php echo esc_html($album['title']); ?>
                                    </a><br>
                                    <small class="text-muted">Slug: <?php echo esc_html($album['slug']); ?></small>
                                </td>
                                <td><?php echo $album['album_date'] ? date('d M Y', strtotime($album['album_date'])) : '-'; ?></td>
                                <td class="text-center"><?php echo esc_html($album['item_count']); ?></td>
                                <td class="text-center">
                                    <?php if ($album['is_published']): ?>
                                        <span class="badge bg-success">Dipublikasikan</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">Draft</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <a href="manage_items.php?album_id=<?php echo $album['id']; ?>" class="btn btn-sm btn-info mb-1" title="Kelola Item">
                                        <i class="fas fa-photo-video"></i>
                                    </a>
                                    <a href="edit.php?id=<?php echo $album['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit Album">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-album"
                                            data-id="<?php echo $album['id']; ?>"
                                            data-title="<?php echo esc_html(addslashes($album['title'])); ?>"
                                            data-url="process_album.php?action=delete&id=<?php echo $album['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus Album">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">Belum ada album galeri.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableGalleryAlbums').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ },
            \"order\": [[ 3, \"desc\" ]] // Order by Tanggal Album descending
        });

        // AJAX Delete untuk Album Galeri
        $('#dataTableGalleryAlbums').on('click', '.btn-delete-album', function() {
            const button = $(this);
            const albumTitle = button.data('title');
            const deleteUrl = button.data('url');

            if (confirm('Anda yakin ingin menghapus album: ' + albumTitle + '? SEMUA item di dalamnya juga akan terhapus secara permanen.')) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET', // Sesuai process_album.php
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus album.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus album.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>