<?php
// admin/modules/gallery_albums/edit.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Album Galeri";
$album_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($album_id_to_edit <= 0) { /* ... handle error ... */ }
$album_db_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_gallery_albums WHERE id = :id");
        $stmt->execute([':id' => $album_id_to_edit]);
        $album_db_data = $stmt->fetch();
    } catch (\PDOException $e) { /* ... error handling ... */ }
}
if (!$album_db_data) { /* ... handle not found ... */ }

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => $album_db_data['title'], 'slug' => $album_db_data['slug'],
    'description' => $album_db_data['description'], 'cover_image_url' => $album_db_data['cover_image_url'],
    'album_date' => $album_db_data['album_date'], 'is_published' => $album_db_data['is_published'],
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?>: <?php echo esc_html($album_db_data['title']); ?></h1>
    <div class="mb-3">
        <a href="manage_items.php?album_id=<?php echo $album_db_data['id']; ?>" class="btn btn-info"><i class="fas fa-photo-video me-1"></i> Kelola Item di Album Ini</a>
    </div>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-edit me-1"></i> Formulir Edit Album</div>
        <div class="card-body">
            <form action="process_album.php" method="POST" enctype="multipart/form-data" id="galleryAlbumForm">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $album_db_data['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
                <input type="hidden" name="old_cover_image_url" value="<?php echo esc_html($album_db_data['cover_image_url'] ?? ''); ?>">

                <!-- Form fields sama seperti create.php, value dari $album_db_data -->
                <div class="mb-3">
                    <label for="title" class="form-label">Judul Album <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', $album_db_data['title'], $form_data); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', $album_db_data['slug'], $form_data); ?>">
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi</label>
                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo old_form_data('description', $album_db_data['description'], $form_data); ?></textarea>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="cover_image_file" class="form-label">Gambar Sampul</label>
                        <img id="coverImagePreview" 
                             src="<?php echo !empty($form_data['cover_image_url']) ? resolve_url(esc_html($form_data['cover_image_url'])) : '#'; ?>" 
                             alt="Preview Sampul" class="img-thumbnail mb-2" 
                             style="max-height: 150px; <?php echo empty($form_data['cover_image_url']) ? 'display: none;' : ''; ?>"
                             data-default-src="<?php echo !empty($form_data['cover_image_url']) ? resolve_url(esc_html($form_data['cover_image_url'])) : '#'; ?>">
                        <input type="file" class="form-control form-control-sm" id="cover_image_file" name="cover_image_file" accept="image/*">
                        <div class="form-text">Upload baru untuk mengganti.</div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="album_date" class="form-label">Tanggal Album</label>
                        <input type="date" class="form-control" id="album_date" name="album_date" value="<?php echo old_form_data('album_date', $album_db_data['album_date'], $form_data); ?>">
                    </div>
                </div>
                <div class="mb-3">
                    <label for="is_published" class="form-label">Status <span class="text-danger">*</span></label>
                    <select class="form-select" id="is_published" name="is_published" required>
                        <option value="1" <?php echo (old_form_data('is_published', $album_db_data['is_published'], $form_data) == '1') ? 'selected' : ''; ?>>Publikasikan</option>
                        <option value="0" <?php echo (old_form_data('is_published', $album_db_data['is_published'], $form_data) == '0') ? 'selected' : ''; ?>>Draft</option>
                    </select>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveAlbumButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
// Skrip AJAX, slug, image preview sama seperti di create.php untuk gallery albums
$page_scripts = [];
$page_scripts[] = "<script>
$(document).ready(function() {
    if (typeof initializeSlugGenerator === 'function') { initializeSlugGenerator('title', 'slug'); }
    if (typeof initializeImagePreview === 'function') { initializeImagePreview('cover_image_file', 'coverImagePreview'); }
    $('#galleryAlbumForm').on('submit', function(e) { /* ... AJAX submit logic ... */
        // Ingat untuk handle update UI preview gambar jika server mengembalikan path baru di response.updated_data.cover_image_url
    });

    const BASE_URL_JS_HELPER_ALBUM = '" . (defined("BASE_URL") ? BASE_URL : "") . "';
    function resolve_url_js_album(path) { // Helper untuk JS jika dibutuhkan
        if (!BASE_URL_JS_HELPER_ALBUM) return path;
        return BASE_URL_JS_HELPER_ALBUM + '/' + path.replace(/^\\//, '');
    }

    // ... (Sisa skrip AJAX submit sama seperti di create.php, sesuaikan pesan dan redirect)
    // Contoh untuk update UI setelah edit:
    // if (response.updated_data && response.updated_data.cover_image_url) {
    //      $('#coverImagePreview').attr('src', resolve_url_js_album(response.updated_data.cover_image_url)).data('default-src', resolve_url_js_album(response.updated_data.cover_image_url)).show();
    //      $('input[name=\"old_cover_image_url\"]').val(response.updated_data.cover_image_url);
    // }
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>