<?php
// admin/modules/events/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Agenda/Acara";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$events = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT id, title, slug, start_datetime, end_datetime, location, is_published, featured_image_url
                             FROM portal_events
                             ORDER BY start_datetime DESC");
        $events = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data acara: ' . $e->getMessage());
        error_log("Error fetching events: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Agenda/Acara'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Acara Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-calendar-alt me-1"></i>
            Daftar Agenda/Acara
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableEvents" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Gambar</th>
                            <th>Judul Acara</th>
                            <th>Tanggal Mulai</th>
                            <th>Tanggal Selesai</th>
                            <th>Lokasi</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($events) > 0): ?>
                            <?php foreach ($events as $index => $event): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td class="text-center">
                                    <?php if (!empty($event['featured_image_url'])): ?>
                                        <img src="<?php echo resolve_url(esc_html($event['featured_image_url'])); ?>" alt="<?php echo esc_html($event['title']); ?>" style="width: 100px; height: auto; max-height:70px; object-fit: cover; border-radius: 0.25rem;">
                                    <?php else: ?>
                                        <span class="text-muted smallfst-italic">Tanpa Gambar</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo resolve_url('public/event.php?slug=' . esc_html($event['slug'])); ?>" target="_blank" title="Lihat acara publik: <?php echo esc_html($event['title']); ?>">
                                        <?php echo esc_html($event['title']); ?>
                                    </a>
                                </td>
                                <td><?php echo date('d M Y, H:i', strtotime($event['start_datetime'])); ?></td>
                                <td><?php echo $event['end_datetime'] ? date('d M Y, H:i', strtotime($event['end_datetime'])) : '-'; ?></td>
                                <td><?php echo esc_html($event['location'] ?? 'N/A'); ?></td>
                                <td class="text-center">
                                    <?php if ($event['is_published']): ?>
                                        <span class="badge bg-success">Dipublikasikan</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">Draft</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <a href="edit.php?id=<?php echo $event['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-event"
                                            data-id="<?php echo $event['id']; ?>"
                                            data-title="<?php echo esc_html(addslashes($event['title'])); ?>"
                                            data-url="process_event.php?action=delete&id=<?php echo $event['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">Belum ada acara.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableEvents').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ },
            \"order\": [[ 3, \"desc\" ]] // Order by Tanggal Mulai descending
        });

        // AJAX Delete untuk Event
        $('#dataTableEvents').on('click', '.btn-delete-event', function() {
            const button = $(this);
            const eventTitle = button.data('title');
            const deleteUrl = button.data('url');

            if (confirm('Anda yakin ingin menghapus acara: ' + eventTitle + '?')) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus acara.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus acara.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>