<?php
// admin/modules/events/edit.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Acara";
$event_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($event_id_to_edit <= 0) { set_flash_message('danger', 'ID Acara tidak valid.'); header('Location: index.php'); exit; }
$event_db_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_events WHERE id = :id");
        $stmt->execute([':id' => $event_id_to_edit]);
        $event_db_data = $stmt->fetch();
    } catch (\PDOException $e) { /* ... error handling ... */ }
}
if (!$event_db_data) { set_flash_message('danger', 'Acara tidak ditemukan.'); header('Location: index.php'); exit; }

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => $event_db_data['title'], 'slug' => $event_db_data['slug'],
    'description_html' => $event_db_data['description_html'],
    'start_datetime' => $event_db_data['start_datetime'] ? date('Y-m-d\TH:i', strtotime($event_db_data['start_datetime'])) : '',
    'end_datetime' => $event_db_data['end_datetime'] ? date('Y-m-d\TH:i', strtotime($event_db_data['end_datetime'])) : '',
    'location' => $event_db_data['location'], 'organizer' => $event_db_data['organizer'],
    'contact_person' => $event_db_data['contact_person'], 'contact_email' => $event_db_data['contact_email'],
    'contact_phone' => $event_db_data['contact_phone'], 'event_url' => $event_db_data['event_url'],
    'featured_image_url' => $event_db_data['featured_image_url'],
    'is_published' => $event_db_data['is_published'],
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?>: <?php echo esc_html($event_db_data['title']); ?></h1>
    <?php echo display_flash_message(); ?>

    <form action="process_event.php" method="POST" enctype="multipart/form-data" id="eventForm">
        <input type="hidden" name="action" value="edit">
        <input type="hidden" name="id" value="<?php echo $event_db_data['id']; ?>">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
        <input type="hidden" name="old_featured_image_url" value="<?php echo esc_html($event_db_data['featured_image_url'] ?? ''); ?>">

        <!-- Struktur Row dan Card sama seperti create.php, hanya valuenya dari $event_db_data -->
        <div class="row">
            <div class="col-lg-9">
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-calendar-plus me-1"></i> Detail Acara</div>
                    <div class="card-body">
                        <!-- Fields: title, slug, description_html, location, organizer, event_url -->
                        <div class="mb-3">
                            <label for="title" class="form-label">Judul Acara <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', $event_db_data['title'], $form_data); ?>" required>
                        </div>
                         <div class="mb-3">
                            <label for="slug" class="form-label">Slug (URL Friendly)</label>
                            <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', $event_db_data['slug'], $form_data); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="description_html" class="form-label">Deskripsi Acara</label>
                            <textarea class="form-control" id="description_html" name="description_html" rows="10"><?php echo old_form_data('description_html', $event_db_data['description_html'], $form_data); ?></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3"><label for="location" class="form-label">Lokasi</label><input type="text" class="form-control" id="location" name="location" value="<?php echo old_form_data('location', $event_db_data['location'], $form_data); ?>"></div>
                            <div class="col-md-6 mb-3"><label for="organizer" class="form-label">Penyelenggara</label><input type="text" class="form-control" id="organizer" name="organizer" value="<?php echo old_form_data('organizer', $event_db_data['organizer'], $form_data); ?>"></div>
                        </div>
                        <div class="mb-3"><label for="event_url" class="form-label">URL Eksternal</label><input type="url" class="form-control" id="event_url" name="event_url" value="<?php echo old_form_data('event_url', $event_db_data['event_url'], $form_data); ?>"></div>
                    </div>
                </div>
                 <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-address-book me-1"></i> Kontak Acara</div>
                    <div class="card-body">
                        <!-- Fields: contact_person, contact_email, contact_phone -->
                         <div class="row">
                            <div class="col-md-4 mb-3"><label for="contact_person" class="form-label">Narahubung</label><input type="text" class="form-control" id="contact_person" name="contact_person" value="<?php echo old_form_data('contact_person', $event_db_data['contact_person'], $form_data); ?>"></div>
                            <div class="col-md-4 mb-3"><label for="contact_email" class="form-label">Email Kontak</label><input type="email" class="form-control" id="contact_email" name="contact_email" value="<?php echo old_form_data('contact_email', $event_db_data['contact_email'], $form_data); ?>"></div>
                            <div class="col-md-4 mb-3"><label for="contact_phone" class="form-label">Telepon Kontak</label><input type="tel" class="form-control" id="contact_phone" name="contact_phone" value="<?php echo old_form_data('contact_phone', $event_db_data['contact_phone'], $form_data); ?>"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="card mb-4 shadow-sm sticky-lg-top" style="top: 70px;">
                    <div class="card-header"><i class="fas fa-cog me-1"></i> Publikasi</div>
                    <div class="card-body">
                        <!-- Fields: start_datetime, end_datetime, is_published -->
                         <div class="mb-3">
                            <label for="start_datetime" class="form-label">Mulai <span class="text-danger">*</span></label>
                            <input type="datetime-local" class="form-control" id="start_datetime" name="start_datetime" value="<?php echo old_form_data('start_datetime', $event_db_data['start_datetime'] ? date('Y-m-d\TH:i', strtotime($event_db_data['start_datetime'])) : '', $form_data); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="end_datetime" class="form-label">Selesai</label>
                            <input type="datetime-local" class="form-control" id="end_datetime" name="end_datetime" value="<?php echo old_form_data('end_datetime', $event_db_data['end_datetime'] ? date('Y-m-d\TH:i', strtotime($event_db_data['end_datetime'])) : '', $form_data); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="is_published" class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select" id="is_published" name="is_published" required>
                                <option value="1" <?php echo (old_form_data('is_published', $event_db_data['is_published'], $form_data) == '1') ? 'selected' : ''; ?>>Publikasikan</option>
                                <option value="0" <?php echo (old_form_data('is_published', $event_db_data['is_published'], $form_data) == '0') ? 'selected' : ''; ?>>Draft</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary w-100" id="saveEventButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-image me-1"></i> Gambar Unggulan</div>
                    <div class="card-body text-center">
                         <img id="featuredImagePreview" 
                             src="<?php echo !empty($form_data['featured_image_url']) ? resolve_url(esc_html($form_data['featured_image_url'])) : '#'; ?>" 
                             alt="Preview Gambar" class="img-thumbnail mb-2" 
                             style="max-height: 150px; <?php echo empty($form_data['featured_image_url']) ? 'display: none;' : ''; ?>"
                             data-default-src="<?php echo !empty($form_data['featured_image_url']) ? resolve_url(esc_html($form_data['featured_image_url'])) : '#'; ?>">
                        <input type="file" class="form-control form-control-sm" id="featured_image_file" name="featured_image_file" accept="image/*">
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php
// Skrip AJAX, TinyMCE, slug, image preview sama seperti di create.php untuk event
$page_scripts = [];
$page_scripts[] = "https://cdn.tiny.cloud/1/qlw978ky0kcpi9tdpmnoih6myrw4usd6crxwdzms7b9jm9ic/tinymce/6/tinymce.min.js";
$page_scripts[] = "<script>
$(document).ready(function() {
    tinymce.init({ selector: 'textarea#description_html', /* ... konfig TinyMCE ... */ });
    if (typeof initializeSlugGenerator === 'function') { initializeSlugGenerator('title', 'slug'); }
    if (typeof initializeImagePreview === 'function') { initializeImagePreview('featured_image_file', 'featuredImagePreview'); }
    $('#eventForm').on('submit', function(e) { /* ... AJAX submit logic, sama seperti create ... */
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveEventButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');
        if (typeof tinymce !== 'undefined' && tinymce.get('description_html')) { tinymce.get('description_html').save(); }
        const formData = new FormData(this);
        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');
        $.ajax({
            url: form.attr('action'), method: form.attr('method'), data: formData,
            processData: false, contentType: false, dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) { setTimeout(function() { window.location.href = response.redirect_url; }, 1500); }
                    // Update UI jika ada data baru dari server (misal gambar)
                    if (response.updated_data && response.updated_data.featured_image_url) {
                         $('#featuredImagePreview').attr('src', resolve_url_js_event(response.updated_data.featured_image_url)).data('default-src', resolve_url_js_event(response.updated_data.featured_image_url)).show();
                         $('input[name=\"old_featured_image_url\"]').val(response.updated_data.featured_image_url);
                    }
                } else { /* ... handle error ... */ }
            },
            error: function(jqXHR) { /* ... handle error ... */ },
            complete: function() { submitButton.prop('disabled', false).html(originalButtonText); }
        });
    });
    const BASE_URL_JS_HELPER_EVENT = '" . (defined("BASE_URL") ? BASE_URL : "") . "';
    function resolve_url_js_event(path) { if (!BASE_URL_JS_HELPER_EVENT) return path; return BASE_URL_JS_HELPER_EVENT + '/' + path.replace(/^\\//, ''); }
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>