<?php
// admin/modules/contact_messages/process_message.php

// Impor kelas PHPMailer (jika belum di autoload global)
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// 1. Load Konfigurasi Utama & Mulai Session
$project_root_pm = dirname(dirname(dirname(__DIR__))); 

if (file_exists($project_root_pm . '/includes/db_connect.php')) {
    require_once $project_root_pm . '/includes/db_connect.php';
} else {
    http_response_code(500);
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Kesalahan konfigurasi server (PM_DBC).']);
    error_log("CRITICAL FAILURE: db_connect.php not found from process_message.php.");
    exit;
}

if (file_exists($project_root_pm . '/admin/includes/functions.php')) {
    require_once $project_root_pm . '/admin/includes/functions.php';
} else {
    http_response_code(500);
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Kesalahan konfigurasi server (PM_FUNC).']);
    error_log("CRITICAL FAILURE: admin/includes/functions.php not found from process_message.php.");
    exit;
}

if (session_status() == PHP_SESSION_NONE) {
    session_start(); // Pastikan session sudah dimulai
}

// DEBUGGING: Log data yang diterima
// error_log("process_message.php - Received REQUEST data: " . print_r($_REQUEST, true));

// Default response
$response = ['success' => false, 'message' => 'Aksi tidak valid atau gagal.'];
http_response_code(400); 

$request_data = $_SERVER['REQUEST_METHOD'] === 'POST' ? $_POST : $_GET;

// Validasi CSRF Token
if (!function_exists('validate_csrf_token') || !isset($request_data['csrf_token']) || !validate_csrf_token($request_data['csrf_token'])) {
    http_response_code(403);
    $response = ['success' => false, 'message' => 'Validasi keamanan gagal (CSRF).'];
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

$action = isset($request_data['action']) ? trim(strip_tags($request_data['action'])) : null;
$message_id = isset($request_data['message_id']) ? (int)$request_data['message_id'] : (isset($request_data['id']) ? (int)$request_data['id'] : 0);

if (empty($action)) {
    $response['message'] = 'Parameter "action" tidak boleh kosong.';
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
// Untuk aksi tertentu, message_id mungkin tidak wajib jika aksi itu global, tapi untuk semua case di bawah ini, message_id wajib.
if ($message_id <= 0) {
    $response['message'] = 'Parameter "message_id" atau "id" tidak valid.';
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

global $pdo;
if (!isset($pdo)) {
    http_response_code(500);
    $response = ['success' => false, 'message' => 'Koneksi database tidak tersedia (PM_PDO).'];
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

try {
    $new_csrf_token = generate_csrf_token(); // Generate token baru untuk respons jika diperlukan
    $response['new_csrf_token'] = $new_csrf_token; // Selalu kirim token baru

    switch ($action) {
        case 'mark_read':
            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET is_read = 1, read_at = NOW() WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Pesan ditandai sudah dibaca.', 'new_csrf_token' => $new_csrf_token];
            } else {
                $checkStmt = $pdo->prepare("SELECT is_read FROM portal_contact_messages WHERE id = :id");
                $checkStmt->bindParam(':id', $message_id, PDO::PARAM_INT);
                $checkStmt->execute();
                $msgExists = $checkStmt->fetch();
                if ($msgExists && $msgExists['is_read'] == 1) {
                    http_response_code(200);
                    $response = ['success' => true, 'message' => 'Pesan sudah ditandai dibaca sebelumnya.', 'new_csrf_token' => $new_csrf_token];
                } else {
                     $response = ['success' => false, 'message' => 'Gagal menandai pesan atau status tidak berubah.', 'new_csrf_token' => $new_csrf_token];
                }
            }
            break;

        case 'mark_unread':
            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET is_read = 0, read_at = NULL WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
             if ($stmt->rowCount() > 0) {
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Pesan ditandai belum dibaca.', 'new_csrf_token' => $new_csrf_token];
            } else {
                $checkStmt = $pdo->prepare("SELECT is_read FROM portal_contact_messages WHERE id = :id");
                $checkStmt->bindParam(':id', $message_id, PDO::PARAM_INT);
                $checkStmt->execute();
                $msgExists = $checkStmt->fetch();
                 if ($msgExists && $msgExists['is_read'] == 0) {
                    http_response_code(200);
                    $response = ['success' => true, 'message' => 'Pesan sudah ditandai belum dibaca sebelumnya.', 'new_csrf_token' => $new_csrf_token];
                } else {
                    $response = ['success' => false, 'message' => 'Gagal menandai pesan atau status tidak berubah.', 'new_csrf_token' => $new_csrf_token];
                }
            }
            break;
        
        case 'archive':
            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET is_archived = 1, archived_at = NOW() WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            http_response_code(200); // Anggap sukses jika query jalan, rowCount bisa 0 jika sudah diarsipkan
            $response = ['success' => true, 'message' => 'Pesan berhasil diarsipkan.', 'new_csrf_token' => $new_csrf_token];
            break;

        case 'unarchive':
            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET is_archived = 0, archived_at = NULL WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            http_response_code(200);
            $response = ['success' => true, 'message' => 'Pengarsipan pesan dibatalkan.', 'new_csrf_token' => $new_csrf_token];
            break;

        case 'delete':
            $stmt = $pdo->prepare("DELETE FROM portal_contact_messages WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            http_response_code(200); // Anggap sukses jika query jalan
            $response = ['success' => true, 'message' => 'Pesan berhasil dihapus permanen.', 'new_csrf_token' => $new_csrf_token];
            break;

        case 'add_note':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                 http_response_code(405);
                 $response = ['success' => false, 'message' => 'Metode tidak diizinkan. Hanya POST.', 'new_csrf_token' => $new_csrf_token];
                 break;
            }
            $note_content = isset($_POST['note_content']) ? trim($_POST['note_content']) : '';
            if (empty($note_content)) {
                $response = ['success' => false, 'message' => 'Isi catatan tidak boleh kosong.', 'errors' => ['note_content' => 'Isi catatan wajib diisi.'], 'new_csrf_token' => $new_csrf_token];
                break;
            }
            $stmt_get_notes = $pdo->prepare("SELECT notes FROM portal_contact_messages WHERE id = :id");
            $stmt_get_notes->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt_get_notes->execute();
            $current_notes_data = $stmt_get_notes->fetch();
            if (!$current_notes_data) {
                http_response_code(404);
                $response = ['success' => false, 'message' => 'Pesan tidak ditemukan.', 'new_csrf_token' => $new_csrf_token];
                break;
            }
            $current_notes = $current_notes_data['notes'];
            $user_info = $_SESSION['nama_lengkap'] ?? $_SESSION['username'] ?? 'Admin';
            $new_note_entry = "[" . date('d M Y H:i') . " - " . esc_html($user_info) . "]:\n" . esc_html($note_content); // esc_html isi catatan juga
            $updated_notes = $current_notes ? $current_notes . "\n\n---\n\n" . $new_note_entry : $new_note_entry;
            $stmt_update_notes = $pdo->prepare("UPDATE portal_contact_messages SET notes = :notes WHERE id = :id");
            $stmt_update_notes->bindParam(':notes', $updated_notes, PDO::PARAM_STR);
            $stmt_update_notes->bindParam(':id', $message_id, PDO::PARAM_INT);
            if ($stmt_update_notes->execute()) {
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Catatan berhasil ditambahkan.', 'new_csrf_token' => $new_csrf_token];
            } else {
                $response = ['success' => false, 'message' => 'Gagal menyimpan catatan.', 'new_csrf_token' => $new_csrf_token];
            }
            break;

        case 'send_reply_email':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                 http_response_code(405);
                 $response = ['success' => false, 'message' => 'Metode tidak diizinkan. Hanya POST.', 'new_csrf_token' => $new_csrf_token];
                 break;
            }
            $recipient_email = filter_var($_POST['recipient_email'] ?? '', FILTER_VALIDATE_EMAIL);
            $reply_subject = trim(strip_tags($_POST['reply_subject'] ?? ''));
            $reply_message_content = trim($_POST['reply_message_content'] ?? '');

            $errors = [];
            if (!$recipient_email) { $errors['recipient_email'] = 'Alamat email penerima tidak valid.'; }
            if (empty($reply_subject)) { $errors['reply_subject'] = 'Subjek balasan tidak boleh kosong.'; }
            if (empty($reply_message_content)) { $errors['reply_message_content'] = 'Isi balasan tidak boleh kosong.'; }

            if (!empty($errors)) {
                $response = ['success' => false, 'message' => 'Formulir mengandung kesalahan.', 'errors' => $errors, 'new_csrf_token' => $new_csrf_token];
                break;
            }

            $stmt_orig_msg = $pdo->prepare("SELECT sender_name, subject AS original_subject, message_content AS original_message FROM portal_contact_messages WHERE id = :id");
            $stmt_orig_msg->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt_orig_msg->execute();
            $original_message_data = $stmt_orig_msg->fetch();
            if (!$original_message_data) {
                http_response_code(404);
                $response = ['success' => false, 'message' => 'Pesan asli tidak ditemukan.', 'new_csrf_token' => $new_csrf_token];
                break;
            }

            $full_email_body = "<html><body style='font-family: Arial, sans-serif; font-size: 14px;'>";
            $full_email_body .= "<p>" . nl2br(esc_html($reply_message_content)) . "</p>";
            $full_email_body .= "<br><br><hr style='border: none; border-top: 1px solid #eee;'>";
            $full_email_body .= "<p style='color: #555; font-size: 0.9em;'><strong>Pada " . date('d F Y, H:i', strtotime($message_data['created_at'] ?? 'now')) . ", " . esc_html($original_message_data['sender_name']) . " <" . esc_html($recipient_email) . "> menulis:</strong></p>";
            $full_email_body .= "<blockquote style='border-left: 3px solid #ccc; margin: 10px 0 10px 5px; padding: 10px; background-color: #f9f9f9; color: #555; font-size: 0.9em;'>";
            $full_email_body .= nl2br(esc_html($original_message_data['original_message']));
            $full_email_body .= "</blockquote>";
            $full_email_body .= "</body></html>";

            // Path ke autoload PHPMailer
            $phpmailer_autoload_path = $project_root_pm . '/vendor/autoload.php'; // GANTI JIKA PERLU
            if (!file_exists($phpmailer_autoload_path)) {
                 error_log("PHPMailer autoload not found at: " . $phpmailer_autoload_path);
                 $response = ['success' => false, 'message' => 'Konfigurasi pengiriman email tidak ditemukan. (PMA01)', 'new_csrf_token' => $new_csrf_token];
                 http_response_code(500);
                 break;
            }
            require $phpmailer_autoload_path;
            $mail = new PHPMailer(true);

            try {
                // Pengaturan Server SMTP - GANTI DENGAN DETAIL ANDA
                $mail->isSMTP();
                $mail->Host       = 'smtp.example.com';         // GANTI INI
                $mail->SMTPAuth   = true;
                $mail->Username   = 'user@example.com';     // GANTI INI
                $mail->Password   = 'YOUR_SMTP_PASSWORD';       // GANTI INI
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // atau PHPMailer::ENCRYPTION_SMTPS
                $mail->Port       = 587;                        // atau 465 untuk SMTPS

                // Pengirim dan Penerima
                $admin_email_address = 'admin-noreply@ugkmb.ac.id'; // GANTI ATAU AMBIL DARI KONFIGURASI
                $admin_email_name = 'Admin UGKMB';                 // GANTI ATAU AMBIL DARI KONFIGURASI
                $mail->setFrom($admin_email_address, $admin_email_name);
                $mail->addAddress($recipient_email);
                $mail->addReplyTo($admin_email_address, $admin_email_name);

                // Konten
                $mail->isHTML(true);
                $mail->Subject = $reply_subject;
                $mail->Body    = $full_email_body;
                $mail->AltBody = strip_tags(str_replace(["<br>","<br/>","<br />"], "\n", $full_email_body));

                $mail->send();
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Email balasan berhasil dikirim ke ' . esc_html($recipient_email), 'new_csrf_token' => $new_csrf_token];

                // Tambah catatan otomatis bahwa email telah dibalas
                $note_reply_sent = "Email balasan dikirim ke " . $recipient_email . ". Subjek: \"" . $reply_subject . "\"";
                // (Logika penambahan catatan bisa disatukan atau dibuat fungsi terpisah)
                $stmt_get_notes_reply = $pdo->prepare("SELECT notes FROM portal_contact_messages WHERE id = :id");
                $stmt_get_notes_reply->bindParam(':id', $message_id, PDO::PARAM_INT);
                $stmt_get_notes_reply->execute();
                $current_notes_data_reply = $stmt_get_notes_reply->fetch();
                $current_notes_reply = $current_notes_data_reply ? $current_notes_data_reply['notes'] : '';
                $user_info_reply = $_SESSION['nama_lengkap'] ?? $_SESSION['username'] ?? 'Sistem';
                $new_note_entry_reply = "[" . date('d M Y H:i') . " - " . esc_html($user_info_reply) . " (Balasan Email)]:\n" . esc_html($note_reply_sent);
                $updated_notes_reply = $current_notes_reply ? $current_notes_reply . "\n\n---\n\n" . $new_note_entry_reply : $new_note_entry_reply;
                $stmt_update_notes_reply = $pdo->prepare("UPDATE portal_contact_messages SET notes = :notes WHERE id = :id");
                $stmt_update_notes_reply->bindParam(':notes', $updated_notes_reply, PDO::PARAM_STR);
                $stmt_update_notes_reply->bindParam(':id', $message_id, PDO::PARAM_INT);
                $stmt_update_notes_reply->execute();

            } catch (Exception $e) {
                error_log("PHPMailer Error for message ID $message_id: " . $mail->ErrorInfo . " | PHP Exception: " . $e->getMessage());
                $response = ['success' => false, 'message' => 'Gagal mengirim email. Kesalahan: ' . esc_html($mail->ErrorInfo), 'new_csrf_token' => $new_csrf_token];
                http_response_code(500);
            }
            break;
            
        default:
            $response = ['success' => false, 'message' => 'Aksi "' . esc_html($action) . '" tidak dikenal atau tidak valid.', 'new_csrf_token' => $new_csrf_token];
            break;
    }
} catch (\PDOException $e) {
    error_log("PDOException in process_message.php for action: $action, id: $message_id. Error: " . $e->getMessage());
    http_response_code(500);
    $response = ['success' => false, 'message' => 'Terjadi kesalahan database saat memproses permintaan.', 'new_csrf_token' => $new_csrf_token ?? generate_csrf_token()];
} catch (\Exception $e) {
    error_log("General Exception in process_message.php for action: $action, id: $message_id. Error: " . $e->getMessage());
    http_response_code(500);
    $response = ['success' => false, 'message' => 'Terjadi kesalahan umum pada server.', 'new_csrf_token' => $new_csrf_token ?? generate_csrf_token()];
}

header('Content-Type: application/json');
echo json_encode($response);
exit;
?>