<?php
// admin/modules/categories/edit.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Hanya admin dan editor yang bisa edit
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}
// ... (kode PHP untuk fetch $category_db_data dan $parent_categories seperti sebelumnya) ...

$project_root = dirname(__DIR__, 3); // Pastikan didefinisikan
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Kategori";

$category_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($category_id_to_edit <= 0) { /* ... handle error ... */ }
$category_db_data = null; // Akan diisi
$parent_categories = []; // Akan diisi

if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_categories WHERE id = :id");
        $stmt->bindParam(':id', $category_id_to_edit, PDO::PARAM_INT);
        $stmt->execute();
        $category_db_data = $stmt->fetch();

        if($category_db_data){
            $stmt_parents = $pdo->prepare("SELECT id, name FROM portal_categories WHERE id != :current_id ORDER BY name ASC");
            $stmt_parents->bindParam(':current_id', $category_id_to_edit, PDO::PARAM_INT);
            $stmt_parents->execute();
            $parent_categories = $stmt_parents->fetchAll();
        } else {
            set_flash_message('danger', 'Kategori tidak ditemukan.');
            header('Location: index.php');
            exit;
        }
    } catch (\PDOException $e) { /* ... */ }
}
if (!$category_db_data) { /* ... handle error, redirect ... */ }


require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'name' => $category_db_data['name'], 'slug' => $category_db_data['slug'],
    'parent_id' => $category_db_data['parent_id'], 'description' => $category_db_data['description']
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-edit me-1"></i> Formulir Edit Kategori: <?php echo esc_html($category_db_data['name']); ?></div>
        <div class="card-body">
            <form action="process_category.php" method="POST" id="categoryForm">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $category_db_data['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Kategori <span class="text-danger">*</span></label>
                    <input type="text" class="form-control <?php echo isset($form_errors['name']) ? 'is-invalid' : ''; ?>" id="name" name="name" value="<?php echo old_form_data('name', $category_db_data['name'], $form_data); ?>" required>
                    <?php echo get_form_error('name', $form_errors); ?>
                </div>

                <div class="mb-3">
                    <label for="slug" class="form-label">Slug (URL Friendly)</label>
                    <input type="text" class="form-control <?php echo isset($form_errors['slug']) ? 'is-invalid' : ''; ?>" id="slug" name="slug" value="<?php echo old_form_data('slug', $category_db_data['slug'], $form_data); ?>" placeholder="Otomatis jika kosong">
                    <div class="form-text">Hanya huruf kecil, angka, dan tanda hubung (-).</div>
                    <?php echo get_form_error('slug', $form_errors); ?>
                </div>

                <div class="mb-3">
                    <label for="parent_id" class="form-label">Parent Kategori (Opsional)</label>
                    <select class="form-select <?php echo isset($form_errors['parent_id']) ? 'is-invalid' : ''; ?>" id="parent_id" name="parent_id">
                        <option value="">-- Tidak Ada Parent --</option>
                        <?php foreach ($parent_categories as $pcat): ?>
                            <option value="<?php echo $pcat['id']; ?>" <?php echo (old_form_data('parent_id', $category_db_data['parent_id'], $form_data) == $pcat['id']) ? 'selected' : ''; ?>>
                                <?php echo esc_html($pcat['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <?php echo get_form_error('parent_id', $form_errors); ?>
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi (Opsional)</label>
                    <textarea class="form-control <?php echo isset($form_errors['description']) ? 'is-invalid' : ''; ?>" id="description" name="description" rows="4"><?php echo old_form_data('description', $category_db_data['description'], $form_data); ?></textarea>
                    <?php echo get_form_error('description', $form_errors); ?>
                </div>

                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveCategoryButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
// Skrip AJAX dan slug generator sama seperti di create.php
$page_scripts[] = "<script>
$(document).ready(function() {
    if (typeof initializeSlugGenerator === 'function') {
        initializeSlugGenerator('name', 'slug');
    }
    $('#categoryForm').on('submit', function(e) { /* ... logika AJAX submit ... */ });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>