<?php
// admin/logout.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Hapus semua variabel sesi
$_SESSION = array();

// Hancurkan sesi.
// Ini akan menghapus semua data sesi dari server.
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

session_destroy();

// Tentukan path ke login.php dari lokasi logout.php
// Jika logout.php ada di root admin/, maka login.php adalah 'login.php'
// Jika logout.php ada di admin/includes/ (tidak umum), maka pathnya '../login.php'
// Asumsi logout.php ada di root admin/
$login_page_url = 'login.php'; 

// Redirect ke halaman login
header("Location: " . $login_page_url);
exit;
?>
