<?php
// public/templates/default_page_template.php
// Variabel $page_content tersedia dari public/page.php
if (!$page_content) return; // Jangan render jika tidak ada konten
?>
<div class="container page-container my-5">
    <div class="row">
        <div class="col-lg-10 mx-auto">
            <article class="page-article">
                <header class="mb-4">
                    <h1 class="display-5 fw-bold page-title"><?php echo esc_html($page_content['title']); ?></h1>
                    <?php if($page_content['status'] == 'published' && $page_content['updated_at']): ?>
                    <p class="text-muted small page-meta">
                        Terakhir diperbarui: <?php echo date('d F Y', strtotime($page_content['updated_at'])); ?>
                        <?php if(!empty($page_content['author_name'])): // Anda perlu join dengan tabel users di query page.php jika ingin ini ?>
                            <?php endif; ?>
                    </p>
                    <?php endif; ?>
                </header>
                <section class="page-content-section entry-content">
                    <?php echo $page_content['content_html']; // Konten HTML dari WYSIWYG ?>
                </section>
            </article>
        </div>
    </div>
</div>