<?php
// public/index.php
if (session_status() == PHP_SESSION_NONE) {
    // session_start(); // Handled by config.php
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__));
}

require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php'; // Untuk resolve_url dan esc_html

// Inisialisasi variabel
$settings = [];
$sliders = [];
$latest_articles_section_1 = [];
$featured_story_section_2 = null;
$side_stories_section_2 = [];
$media_text_blocks = []; // Ini akan digunakan untuk section alternating
$spotlight_categories_with_articles = []; // Variabel baru untuk kategori sorotan
$featured_stories_slider = [];
$quick_links_homepage = [];


if (isset($pdo)) {
    try {
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
        while ($row = $stmt_settings->fetch()) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }

        // Sliders
        $stmt_sliders = $pdo->query("SELECT title, description, image_url_desktop, image_url_mobile, link_url, button_text
                                     FROM portal_sliders
                                     WHERE is_active = 1 AND (start_date IS NULL OR start_date <= NOW()) AND (end_date IS NULL OR end_date >= NOW())
                                     ORDER BY slide_order ASC LIMIT 5");
        $sliders = $stmt_sliders->fetchAll();

        // Section 1: Berita Terkini
        $stmt_s1 = $pdo->query("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug, u.full_name as author_name, a.published_at
                                 FROM portal_articles a 
                                 LEFT JOIN portal_categories c ON a.category_id = c.id
                                 LEFT JOIN portal_users u ON a.author_id = u.id
                                 WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.published_at DESC LIMIT 3");
        $latest_articles_section_1 = $stmt_s1->fetchAll();

        // Section 2: Artikel Utama & Sampingan
        $stmt_s2_main = $pdo->query("SELECT a.id, a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug, u.full_name as author_name, a.published_at
                                      FROM portal_articles a 
                                      LEFT JOIN portal_categories c ON a.category_id = c.id
                                      LEFT JOIN portal_users u ON a.author_id = u.id
                                      WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.views_count DESC, a.published_at DESC LIMIT 1"); // Ambil yang paling banyak dilihat
        $featured_story_section_2 = $stmt_s2_main->fetch();

        $side_stories_section_2_query_id_exclude = $featured_story_section_2['id'] ?? 0;
        $stmt_s2_side = $pdo->prepare("SELECT a.title, a.slug, c.name as category_name, c.slug as category_slug, u.full_name as author_name, a.published_at
                                       FROM portal_articles a 
                                       LEFT JOIN portal_categories c ON a.category_id = c.id
                                       LEFT JOIN portal_users u ON a.author_id = u.id
                                       WHERE a.status = 'published' AND a.published_at <= NOW() AND a.id != :exclude_id 
                                       ORDER BY a.published_at DESC LIMIT 4");
        $stmt_s2_side->execute(['exclude_id' => $side_stories_section_2_query_id_exclude]);
        $side_stories_section_2 = $stmt_s2_side->fetchAll();

        // Media Text Blocks (Untuk section alternating)
        $stmt_media_text_all = $pdo->query("SELECT title, slug, excerpt, featured_image_url, published_at, u.full_name as author_name
                                             FROM portal_articles 
                                             LEFT JOIN portal_users u ON portal_articles.author_id = u.id
                                             WHERE status='published' AND published_at <= NOW() 
                                             ORDER BY RAND() LIMIT 3"); // Ambil 3 acak untuk contoh
        $media_text_blocks = $stmt_media_text_all->fetchAll();


        // BARU: Query untuk Kategori Sorotan
        $spotlight_category_slugs = ['berita-kampus', 'riset', 'event-kampus']; // Contoh slug
        foreach ($spotlight_category_slugs as $slug) {
            $stmt_spotlight_cat_info = $pdo->prepare("SELECT id, name, slug FROM portal_categories WHERE slug = :slug LIMIT 1");
            $stmt_spotlight_cat_info->execute(['slug' => $slug]);
            $category_info = $stmt_spotlight_cat_info->fetch();

            if ($category_info) {
                $stmt_articles_in_cat = $pdo->prepare("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, u.full_name as author_name, a.published_at
                                                        FROM portal_articles a
                                                        LEFT JOIN portal_users u ON a.author_id = u.id
                                                        WHERE a.category_id = :category_id AND a.status = 'published' AND a.published_at <= NOW()
                                                        ORDER BY a.published_at DESC LIMIT 3");
                $stmt_articles_in_cat->execute(['category_id' => $category_info['id']]);
                $articles = $stmt_articles_in_cat->fetchAll();

                if (!empty($articles)) {
                    $spotlight_categories_with_articles[] = [
                        'category_info' => $category_info,
                        'articles' => $articles
                    ];
                }
            }
        }


        // Featured Stories Slider (Carousel di tengah halaman)
        $stmt_feat_slider = $pdo->query("SELECT title, slug, excerpt, featured_image_url, u.full_name as author_name, published_at 
                                         FROM portal_articles 
                                         LEFT JOIN portal_users u ON portal_articles.author_id = u.id
                                         WHERE status='published' AND published_at <= NOW() 
                                         ORDER BY views_count DESC, published_at DESC LIMIT 5");
        $featured_stories_slider = $stmt_feat_slider->fetchAll();

        // Quick Links
        $stmt_ql_home = $pdo->query("SELECT title, url, icon_class, open_in_new_tab FROM portal_quick_links WHERE is_active = 1 AND group_key = 'homepage_focus' ORDER BY link_order ASC LIMIT 4"); // Ambil 4 quick links
        $quick_links_homepage = $stmt_ql_home->fetchAll();

    } catch (\PDOException $e) {
        error_log("Error fetching data for public/index.php: " . $e->getMessage());
    }
}

// Pengaturan Judul Halaman & Meta
$site_title = htmlspecialchars($settings['site_name'] ?? 'UGKMB Portal');
if (!empty($settings['homepage_title_seo'])) { $site_title = htmlspecialchars($settings['homepage_title_seo']); }
$meta_description = htmlspecialchars($settings['site_tagline'] ?? 'Universitas Graha Karya Muara Bulian');
if (!empty($settings['homepage_meta_description_seo'])) { $meta_description = htmlspecialchars($settings['homepage_meta_description_seo']); }

require_once PROJECT_ROOT . '/public/includes/header_public.php'; // Pastikan path ini benar
?>

<main class="homepage-main">

    <?php if (!empty($sliders)): ?>
    <section id="hero-slider" class="carousel slide main-hero-slider" data-bs-ride="carousel" data-bs-interval="7000">
        <div class="carousel-indicators">
            <?php foreach ($sliders as $index => $slide): ?>
            <button type="button" data-bs-target="#hero-slider" data-bs-slide-to="<?php echo $index; ?>" class="<?php echo ($index == 0) ? 'active' : ''; ?>" aria-current="<?php echo ($index == 0) ? 'true' : 'false'; ?>" aria-label="Slide <?php echo $index + 1; ?>"></button>
            <?php endforeach; ?>
        </div>
        <div class="carousel-inner">
            <?php foreach ($sliders as $index => $slide): ?>
            <div class="carousel-item <?php echo ($index == 0) ? 'active' : ''; ?>">
                <div class="hero-slider-image-wrapper">
                    <picture>
                        <?php if(!empty($slide['image_url_mobile'])): ?>
                        <source media="(max-width: 767px)" srcset="<?php echo htmlspecialchars(resolve_url($slide['image_url_mobile'])); ?>">
                        <?php endif; ?>
                        <img src="<?php echo htmlspecialchars(resolve_url($slide['image_url_desktop'])); ?>" class="d-block w-100 hero-slider-image" alt="<?php echo esc_html($slide['title']); ?>" loading="<?php echo ($index == 0) ? 'eager' : 'lazy'; ?>">
                    </picture>
                </div>
                <div class="container h-100">
                    <div class="carousel-caption text-start">
                        <h1 class="display-4 fw-bold animate__animated animate__fadeInDown animate__delay-0.5s"><?php echo esc_html($slide['title']); ?></h1>
                        <?php if(!empty($slide['description'])): ?><p class="lead d-none d-md-block animate__animated animate__fadeInUp animate__delay-0.8s col-md-8 col-lg-7"><?php echo esc_html($slide['description']); ?></p><?php endif; ?>
                        <?php if(!empty($slide['link_url']) && !empty($slide['button_text'])): ?>
                            <a href="<?php echo esc_html($slide['link_url']); ?>" class="btn btn-primary btn-lg mt-3 animate__animated animate__fadeInUp animate__delay-1s"><?php echo esc_html($slide['button_text']); ?> <i class="fas fa-arrow-right ms-1"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php if (count($sliders) > 1): ?>
        <button class="carousel-control-prev" type="button" data-bs-target="#hero-slider" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span><span class="visually-hidden">Previous</span></button>
        <button class="carousel-control-next" type="button" data-bs-target="#hero-slider" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span><span class="visually-hidden">Next</span></button>
        <?php endif; ?>
    </section>
    <?php endif; ?>

    <section class="py-5 section-latest-news">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold custom-page-title">Berita & Informasi Terkini</h2>
            </header>
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                <?php if (!empty($latest_articles_section_1)): ?>
                    <?php foreach($latest_articles_section_1 as $article): ?>
                    <div class="col d-flex align-items-stretch">
                        <div class="card h-100 shadow-sm custom-card article-card-hover">
                            <?php if (!empty($article['featured_image_url'])): ?>
                            <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="article-card-image-link">
                                <img src="<?php echo resolve_url(esc_html($article['featured_image_url'])); ?>" class="card-img-top custom-card-img" alt="<?php echo esc_html($article['title']); ?>" loading="lazy">
                            </a>
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <?php if(!empty($article['category_name'])): ?><a href="<?php echo resolve_url('category.php?slug='.esc_html($article['category_slug'])); ?>" class="badge bg-primary text-decoration-none mb-2 align-self-start"><?php echo esc_html($article['category_name']); ?></a><?php endif; ?>
                                <h5 class="card-title h6 custom-card-title mb-2"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($article['title']); ?></a></h5>
                                <p class="card-text small text-muted custom-card-excerpt flex-grow-1 mb-2"><?php echo esc_html(substr(strip_tags($article['excerpt'] ?? ''), 0, 100)) . '...'; ?></p>
                                <div class="mt-auto">
                                    <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($article['published_at'])); ?></small>
                                    <?php if (!empty($article['author_name'])): ?>
                                        <small class="text-muted article-meta ms-2"><i class="fas fa-user fa-xs me-1"></i> <?php echo esc_html($article['author_name']); ?></small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12"><p class="text-muted text-center">Belum ada berita terkini.</p></div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light-subtle section-wordpress-feed">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title h3 fw-bold custom-page-title">Postingan Terdahulu dari Situs Utama</h2>
            </header>
            <div id="wordpress-posts-container-index" class="row row-cols-1 row-cols-sm-2 row-cols-lg-4 g-4">
                <div id="wp-loading-indicator-index" class="col-12 text-center">
                    <div class="spinner-border text-secondary" role="status">
                        <span class="visually-hidden">Memuat...</span>
                    </div>
                </div>
            </div>
            <div class="text-center mt-5">
                <a href="<?php echo resolve_url('articles.php'); ?>" class="btn btn-outline-primary">Lihat Arsip Berita Lengkap <i class="fas fa-arrow-right ms-1"></i></a>
            </div>
        </div>
    </section>

    <section class="py-5 section-news-layout-B">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold custom-page-title">Wawasan & Pendanaan</h2>
                <p class="lead text-muted section-subtitle">Wawasan mendalam mengenai pendanaan riset dan dampaknya.</p>
            </header>
            <div class="row g-lg-5"> 
                <div class="col-lg-7 mb-4 mb-lg-0">
                    <?php if ($featured_story_section_2): ?>
                    <div class="card custom-card-featured shadow-lg h-100 article-card-hover">
                        <?php if($featured_story_section_2['featured_image_url']): ?>
                        <a href="<?php echo resolve_url('article.php?slug=' . esc_html($featured_story_section_2['slug'])); ?>" class="article-card-image-link">
                            <img src="<?php echo resolve_url(esc_html($featured_story_section_2['featured_image_url'])); ?>" class="card-img-top custom-card-img-featured" alt="<?php echo esc_html($featured_story_section_2['title']); ?>" loading="lazy" style="min-height: 300px; object-fit:cover;">
                        </a>
                        <?php endif; ?>
                        <div class="card-body d-flex flex-column p-4"> 
                            <?php if(!empty($featured_story_section_2['category_name'])): ?><a href="<?php echo resolve_url('category.php?slug='.esc_html($featured_story_section_2['category_slug'])); ?>" class="badge bg-danger text-decoration-none mb-2 align-self-start"><?php echo esc_html($featured_story_section_2['category_name']); ?></a><?php endif; ?>
                            <h3 class="card-title h4 fw-bold custom-card-title mb-2"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($featured_story_section_2['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($featured_story_section_2['title']); ?></a></h3>
                            <p class="text-muted small custom-card-excerpt flex-grow-1 mb-3"><?php echo esc_html(substr(strip_tags($featured_story_section_2['excerpt'] ?? ''), 0, 180)) . '...'; ?></p>
                             <div class="mt-auto">
                                <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($featured_story_section_2['published_at'])); ?></small>
                                <?php if (!empty($featured_story_section_2['author_name'])): ?>
                                    <small class="text-muted article-meta ms-2"><i class="fas fa-user fa-xs me-1"></i> <?php echo esc_html($featured_story_section_2['author_name']); ?></small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                        <div class="alert alert-secondary text-center">Cerita unggulan sedang disiapkan.</div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-5">
                    <h4 class="h5 fw-semibold mb-3">Baca Juga:</h4>
                    <ul class="list-group list-group-flush custom-side-list">
                        <?php if(!empty($side_stories_section_2)): ?>
                            <?php foreach($side_stories_section_2 as $idx_side => $story): ?>
                            <li class="list-group-item bg-transparent px-0 py-3 <?php echo ($idx_side < count($side_stories_section_2) - 1) ? 'border-bottom' : '';?>">
                                <?php if(!empty($story['category_name'])): ?><a href="<?php echo resolve_url('category.php?slug='.esc_html($story['category_slug'])); ?>" class="text-uppercase text-decoration-none text-danger small fw-bold custom-side-list-category d-block mb-1"><?php echo esc_html($story['category_name']); ?></a><?php endif; ?>
                                <h5 class="h6 mb-1 custom-side-list-title line-clamp-2"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($story['slug'])); ?>" class="text-decoration-none"><?php echo esc_html($story['title']); ?></a></h5>
                                <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs"></i> <?php echo date('d M \'y', strtotime($story['published_at'])); ?></small>
                            </li>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <li class="list-group-item bg-transparent px-0 text-muted">Cerita lainnya akan segera hadir.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <section class="py-4 section-divider-header">
        <div class="container">
            <header class="text-start mb-0"> <h2 class="section-title-divider h3 fw-bold custom-page-title">Riset yang Mengubah Kehidupan</h2> </header>
        </div>
    </section>

    <?php $layout_left_C = true; foreach($media_text_blocks as $block): if(!$block) continue; ?>
    <section class="py-4 section-media-text-C <?php echo $layout_left_C ? '' : 'bg-light-subtle'; ?>">
        <div class="container">
            <div class="row align-items-center g-lg-5 <?php echo $layout_left_C ? '' : 'flex-row-reverse'; ?>">
                <div class="col-md-6 mb-4 mb-md-0">
                    <?php if($block['featured_image_url']): ?>
                    <a href="<?php echo resolve_url('article.php?slug=' . esc_html($block['slug'])); ?>" class="d-block rounded shadow-lg overflow-hidden">
                        <img src="<?php echo resolve_url(esc_html($block['featured_image_url'])); ?>" class="img-fluid media-text-img article-card-image-link" alt="<?php echo esc_html($block['title']); ?>" loading="lazy" style="transition: transform 0.3s ease;">
                    </a>
                    <?php else: ?>
                    <div class="bg-secondary rounded shadow-lg media-text-img-placeholder d-flex align-items-center justify-content-center" style="min-height:300px;"><span class="text-white h3">Gambar Segera Hadir</span></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6 <?php echo $layout_left_C ? 'ps-lg-5' : 'pe-lg-5'; ?>">
                    <p class="text-muted small text-uppercase media-text-leadin fw-semibold">Studi Kasus Riset</p>
                    <h3 class="h4 fw-bold media-text-title mb-3"><?php echo esc_html($block['title']); ?></h3>
                    <p class="text-muted media-text-excerpt mb-3"><?php echo esc_html(substr(strip_tags($block['excerpt'] ?? ''), 0, 220)) . '...'; ?></p>
                    <small class="text-muted article-meta d-block mb-3"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($block['published_at'])); ?>
                        <?php if (!empty($block['author_name'])): ?>
                            <span class="ms-2"><i class="fas fa-user fa-xs me-1"></i> <?php echo esc_html($block['author_name']); ?></span>
                        <?php endif; ?>
                    </small>
                    <a href="<?php echo resolve_url('article.php?slug=' . esc_html($block['slug'])); ?>" class="btn btn-outline-primary media-text-cta">Pelajari Lebih Lanjut <i class="fas fa-angle-right ms-1"></i></a>
                </div>
            </div>
        </div>
    </section>
    <?php $layout_left_C = !$layout_left_C; endforeach; ?>


    <?php if (!empty($spotlight_categories_with_articles)): ?>
    <section class="py-5 section-spotlight-categories <?php echo !$layout_left_C ? '' : 'bg-light-subtle'; ?>">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold custom-page-title">Fokus Kategori Pilihan</h2>
                <p class="lead text-muted section-subtitle">Jelajahi topik-topik menarik dari berbagai bidang di UGKMB.</p>
            </header>

            <?php foreach ($spotlight_categories_with_articles as $index_cat_spotlight => $category_data): ?>
            <div class="category-spotlight-group mb-5 <?php echo $index_cat_spotlight > 0 ? 'pt-5 border-top mt-5' : ''; ?>">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="h4 fw-bold mb-0">
                        <a href="<?php echo resolve_url('category.php?slug=' . esc_html($category_data['category_info']['slug'])); ?>" class="text-decoration-none">
                            <?php echo esc_html($category_data['category_info']['name']); ?>
                        </a>
                    </h3>
                    <a href="<?php echo resolve_url('category.php?slug=' . esc_html($category_data['category_info']['slug'])); ?>" class="btn btn-sm btn-outline-primary">
                        Lihat Semua <i class="fas fa-angle-right ms-1"></i>
                    </a>
                </div>

                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                    <?php foreach ($category_data['articles'] as $article): ?>
                    <div class="col d-flex align-items-stretch">
                        <div class="card h-100 shadow-sm custom-card article-card-hover">
                            <?php if (!empty($article['featured_image_url'])): ?>
                            <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="article-card-image-link">
                                <img src="<?php echo resolve_url(esc_html($article['featured_image_url'])); ?>" class="card-img-top custom-card-img" alt="<?php echo esc_html($article['title']); ?>" loading="lazy">
                            </a>
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title h6 custom-card-title mb-2"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($article['title']); ?></a></h5>
                                <p class="card-text small text-muted custom-card-excerpt flex-grow-1 mb-2"><?php echo esc_html(substr(strip_tags($article['excerpt'] ?? ''), 0, 100)) . '...'; ?></p>
                                <div class="mt-auto">
                                    <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($article['published_at'])); ?></small>
                                    <?php if (!empty($article['author_name'])): ?>
                                        <small class="text-muted article-meta ms-2"><i class="fas fa-user fa-xs me-1"></i> <?php echo esc_html($article['author_name']); ?></small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </section>
    <?php endif; ?>

    <section class="py-4 section-divider-header">
        <div class="container">
            <header class="text-start mb-0"> <h2 class="section-title-divider h3 fw-bold custom-page-title">Kemajuan dalam Praktik</h2> </header>
        </div>
    </section>

    <?php if(!empty($featured_stories_slider)): ?>
    <section class="py-5 section-interstitial-slider-E">
        <div class="container">
            <div id="progressPracticeSlider" class="carousel slide" data-bs-ride="carousel" data-bs-interval="8000">
                <div class="carousel-inner rounded shadow-lg">
                    <?php foreach($featured_stories_slider as $idx => $story): ?>
                    <div class="carousel-item <?php echo $idx === 0 ? 'active' : ''; ?>">
                        <div class="row align-items-center interstitial-slide-content g-0 <?php echo $idx % 2 === 0 ? '' : 'flex-md-row-reverse'; ?>"> 
                            <div class="col-md-6 interstitial-slide-image-col">
                                 <?php if($story['featured_image_url']): ?>
                                <img src="<?php echo resolve_url(esc_html($story['featured_image_url'])); ?>" class="d-block w-100 interstitial-slide-image" alt="<?php echo esc_html($story['title']); ?>" loading="lazy" style="min-height: 350px; object-fit: cover;">
                                <?php else: ?>
                                <div class="bg-secondary interstitial-slide-image-placeholder d-flex align-items-center justify-content-center" style="min-height:350px;"><span class="text-white h3">Gambar Segera Hadir</span></div>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-6 interstitial-slide-text-col py-4 px-4 px-lg-5 <?php echo $idx % 2 === 0 ? '' : 'text-md-end'; ?>">
                                <h3 class="h4 fw-bold mb-3"><?php echo esc_html($story['title']); ?></h3>
                                <p class="text-muted lead-sm mb-3"><?php echo esc_html(substr(strip_tags($story['excerpt'] ?? ''), 0, 220)) . '...'; ?></p>
                                <small class="text-muted article-meta d-block mb-3"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($story['published_at'])); ?>
                                    <?php if (!empty($story['author_name'])): ?>
                                        <span class="ms-2"><i class="fas fa-user fa-xs me-1"></i> <?php echo esc_html($story['author_name']); ?></span>
                                    <?php endif; ?>
                                </small>
                                <a href="<?php echo resolve_url('article.php?slug=' . esc_html($story['slug'])); ?>" class="btn btn-primary">Baca Cerita <i class="fas fa-angle-right ms-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php if(count($featured_stories_slider) > 1): ?>
                <button class="carousel-control-prev" type="button" data-bs-target="#progressPracticeSlider" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span> <span class="visually-hidden">Previous</span></button>
                <button class="carousel-control-next" type="button" data-bs-target="#progressPracticeSlider" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span> <span class="visually-hidden">Next</span></button>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <?php if(!empty($quick_links_homepage)): ?>
    <section class="py-5 bg-light-subtle section-link-list-F">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-4 mb-4 mb-lg-0 text-center text-lg-start">
                    <p class="text-muted small text-uppercase mb-1 fw-semibold">Anda Mungkin Juga Tertarik</p>
                    <h2 class="h3 fw-bold custom-page-title mt-0 mb-0">Topik Terkait & Layanan</h2>
                </div>
                <div class="col-lg-8">
                    <div class="row row-cols-1 row-cols-sm-2 <?php echo count($quick_links_homepage) >= 3 ? (count($quick_links_homepage) == 3 ? 'row-cols-md-3' : 'row-cols-md-2 row-cols-lg-3') : 'row-cols-md-2';?> g-3">
                        <?php foreach($quick_links_homepage as $link): ?>
                        <li class="col list-unstyled">
                            <a href="<?php echo esc_html($link['url']); ?>" class="text-decoration-none fs-5 d-block py-3 px-3 quick-link-item-hover h-100" <?php echo $link['open_in_new_tab'] ? 'target="_blank" rel="noopener noreferrer"' : ''; ?>>
                                <div class="d-flex align-items-center">
                                    <?php if(!empty($link['icon_class'])): ?>
                                        <i class="<?php echo esc_html($link['icon_class']); ?> fa-lg me-3 text-primary"></i>
                                    <?php else: ?>
                                        <i class="fas fa-link fa-lg me-3 text-primary"></i>
                                    <?php endif; ?>
                                    <span class="fw-medium"><?php echo esc_html($link['title']); ?></span>
                                    <i class="fas fa-angle-right fa-xs ms-auto text-muted"></i>
                                </div>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>

</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const wpContainer = document.getElementById('wordpress-posts-container-index');
    const wpLoading = document.getElementById('wp-loading-indicator-index');

    if (wpContainer) {
        // Ambil 4 postingan terbaru dari WordPress
        const apiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2/posts?per_page=4&_embed';

        async function fetchWpPostsForIndex() {
            try {
                const response = await fetch(apiUrl);
                if (!response.ok) throw new Error('Network response was not ok');
                const posts = await response.json();

                // Bersihkan indikator loading
                if(wpLoading) wpLoading.remove();

                if (posts.length === 0) {
                    wpContainer.innerHTML = '<p class="text-muted text-center col-12">Tidak ada postingan yang bisa ditampilkan.</p>';
                    return;
                }

                posts.forEach(post => {
                    const featuredImage = post._embedded?.['wp:featuredmedia']?.[0]?.source_url || '<?php echo resolve_url("assets/images/default-placeholder.png"); ?>';
                    const postDate = new Date(post.date).toLocaleDateString('id-ID', { day: 'numeric', month: 'short', year: 'numeric' });

                    const postCard = `
                        <div class="col d-flex align-items-stretch">
                            <div class="card h-100 shadow-sm custom-card article-card-hover">
                                <a href="${post.link}" target="_blank" rel="noopener noreferrer" class="article-card-image-link">
                                    <img src="${featuredImage}" class="card-img-top custom-card-img" alt="${post.title.rendered}" loading="lazy">
                                </a>
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title h6 custom-card-title mb-2">
                                        <a href="${post.link}" target="_blank" rel="noopener noreferrer" class="text-decoration-none stretched-link">${post.title.rendered}</a>
                                    </h5>
                                    <div class="mt-auto">
                                        <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs me-1"></i> ${postDate}</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                    wpContainer.insertAdjacentHTML('beforeend', postCard);
                });

            } catch (error) {
                console.error("Error fetching WP posts for index:", error);
                if(wpLoading) wpLoading.remove();
                wpContainer.innerHTML = '<p class="text-muted text-center col-12">Gagal memuat postingan dari situs utama.</p>';
            }
        }
        
        fetchWpPostsForIndex();
    }
});
</script>

<?php
$public_page_scripts = [];
require_once PROJECT_ROOT . '/includes/footer_public.php'; // Pastikan path ini benar
?>