<?php
// index.php (FINAL VERSION - CV MUT Layout + UGKMB Data Integration + AI Chat)

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__));
}

// Integrasi dengan sistem portal UGKMB
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

// --- Mengambil data dari database portal lokal ---
$settings = [];
$latest_articles_section_1 = [];

if (isset($pdo)) {
    try {
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
        while ($row = $stmt_settings->fetch()) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }

        // Mengambil 3 berita terkini dari portal lokal
        $stmt_s1 = $pdo->query("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug, a.published_at FROM portal_articles a LEFT JOIN portal_categories c ON a.category_id = c.id WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.published_at DESC LIMIT 3");
        $latest_articles_section_1 = $stmt_s1->fetchAll();

    } catch (\PDOException $e) {
        error_log("Error fetching data for index.php: " . $e->getMessage());
    }
}

// Mengatur judul halaman dan meta deskripsi secara dinamis
$site_title = htmlspecialchars($settings['site_name'] ?? 'UGKMB Portal');
$meta_description = htmlspecialchars($settings['site_tagline'] ?? 'Universitas Graha Karya Muara Bulian');
?>
<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title><?php echo $site_title; ?></title>
  <meta content="<?php echo $meta_description; ?>" name="description">
  <meta content="UGKMB, Universitas, Pendidikan, Jambi, Teknologi, WordPress" name="keywords">

  <link href="<?php echo resolve_url($settings['site_favicon_url'] ?? 'assets/logo.png'); ?>" rel="icon">
  <link href="<?php echo resolve_url($settings['site_favicon_url'] ?? 'assets/logo.png'); ?>" rel="apple-touch-icon">

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,600;1,700&family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Raleway:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">

  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />

  <link href="assets/css/main.css" rel="stylesheet">

  <style>
    /* --- START: Chat Widget Styles --- */
    #chat-toggle-button {
      position: fixed;
      bottom: 20px;
      left: 20px;
      width: 60px;
      height: 60px;
      z-index: 1050;
      box-shadow: 0 2px 10px rgba(0,0,0,0.2);
      transition: transform 0.3s ease;
      border: none;
    }
    #chat-toggle-button:hover {
        transform: scale(1.1);
    }
    #chat-widget-container {
      position: fixed;
      bottom: 90px;
      left: 20px;
      width: 370px;
      height: 550px;
      max-width: calc(100vw - 40px);
      max-height: calc(100vh - 110px);
      z-index: 1049;
      border-radius: 15px;
      overflow: hidden;
      box-shadow: 0 5px 15px rgba(0,0,0,0.3);
      background-color: #fff;
      opacity: 0;
      transform: translateY(20px) scale(0.95);
      transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0.3s;
      visibility: hidden;
    }
    #chat-widget-container.show {
      opacity: 1;
      transform: translateY(0) scale(1);
      visibility: visible;
      transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0s;
    }
    #chat-widget-container iframe {
      width: 100%;
      height: 100%;
      border: none;
    }
    /* --- END: Chat Widget Styles --- */

    /* Style untuk bagian berita */
    .article-card {
        border-radius: 0.75rem;
        transition: box-shadow 0.3s ease, transform 0.3s ease;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        border: none;
    }
    .article-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    }
  </style>
</head>

<body>

  <header id="header" class="header d-flex align-items-center fixed-top">
    <div class="container-fluid container-xl d-flex align-items-center justify-content-between">
      <a href="index.php" class="logo d-flex align-items-center">
        <h1><?php echo esc_html($settings['site_name_short'] ?? 'UGKMB'); ?><span>.</span></h1>
      </a>
      <nav id="navbar" class="navbar">
        <ul>
          <li><a href="#hero" class="active">Home</a></li>
          <li><a href="#about">Tentang Kami</a></li>
          <li><a href="#berita">Berita</a></li>
          <li><a href="#contact">Kontak</a></li>
        </ul>
      </nav>
      <i class="mobile-nav-toggle mobile-nav-show bi bi-list"></i>
      <i class="mobile-nav-toggle mobile-nav-hide d-none bi bi-x"></i>
    </div>
  </header>

  <section id="hero" class="hero">
    <div class="container position-relative">
      <div class="row gy-5" data-aos="fade-in">
        <div class="col-lg-6 order-2 order-lg-1 d-flex flex-column justify-content-center text-center text-lg-start">
          <h2>Selamat Datang di <span><?php echo $site_title; ?></span></h2>
          <p><?php echo $meta_description; ?></p>
          <div class="d-flex justify-content-center justify-content-lg-start">
            <a href="#about" class="btn-get-started">Selengkapnya</a>
          </div>
        </div>
        <div class="col-lg-6 order-1 order-lg-2">
          <img src="assets/img/hero-img.svg" class="img-fluid" alt="" data-aos="zoom-out" data-aos-delay="100">
        </div>
      </div>
    </div>
  </section>

<main id="main">

    <section id="berita" class="services sections-bg">
        <div class="container" data-aos="fade-up">
            <div class="section-header">
                <h2>Berita & Informasi</h2>
                <p>Kumpulan berita terbaru dari portal internal dan situs utama kami.</p>
            </div>

            <div class="row gy-4" data-aos="fade-up" data-aos-delay="100">
                <?php if (!empty($latest_articles_section_1)): ?>
                    <?php foreach($latest_articles_section_1 as $article): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="service-item position-relative article-card">
                            <div class="icon"><i class="fas fa-newspaper"></i></div>
                            <h3><?php echo esc_html($article['title']); ?></h3>
                            <p><?php echo esc_html(substr(strip_tags($article['excerpt'] ?? ''), 0, 100)) . '...'; ?></p>
                            <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="readmore stretched-link">Baca Selengkapnya <i class="bi bi-arrow-right"></i></a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

            <hr class="my-5">

            <div id="wordpress-posts-container" class="row gy-4" data-aos="fade-up" data-aos-delay="200">
                <script>
                    for(let i = 0; i < 3; i++) {
                        document.write(`
                            <div class="col-lg-4 col-md-6">
                                <div class="service-item position-relative placeholder-glow article-card">
                                    <div class="icon"><i class="fab fa-wordpress"></i></div>
                                    <h3><span class="placeholder col-8"></span></h3>
                                    <p><span class="placeholder col-10"></span> <span class="placeholder col-6"></span></p>
                                    <a href="#" tabindex="-1" class="btn btn-primary disabled placeholder col-6 stretched-link readmore"></a>
                                </div>
                            </div>
                        `);
                    }
                </script>
            </div>
        </div>
    </section>

    </main>

  <footer id="footer" class="footer">
    <div class="container">
        <div class="copyright">
        © Copyright <strong><span><?php echo esc_html($settings['site_name'] ?? 'UGKMB'); ?></span></strong>. All Rights Reserved
        </div>
    </div>
  </footer>

  <a href="#" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>
  <div id="preloader"></div>

  <button id="chat-toggle-button" class="btn btn-primary rounded-circle p-0 d-flex align-items-center justify-content-center" type="button" aria-label="Toggle Chat" aria-expanded="false">
      <i class="bi bi-chat-dots-fill fs-4"></i>
  </button>
  <div id="chat-widget-container">
      <iframe src="https://chat.mitrautamateknologi.co-id.id/" title="ChatMUT AI Assistant"></iframe>
  </div>

  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
  <script src="assets/js/main.js"></script>

  <script>
  document.addEventListener('DOMContentLoaded', function() {
      // --- LOGIKA TOGGLE CHAT ---
      const chatToggleButton = document.getElementById('chat-toggle-button');
      const chatWidgetContainer = document.getElementById('chat-widget-container');
      const toggleIcon = chatToggleButton ? chatToggleButton.querySelector('i') : null;

      if (chatToggleButton && chatWidgetContainer && toggleIcon) {
          chatToggleButton.addEventListener('click', () => {
              const isVisible = chatWidgetContainer.classList.contains('show');
              if (isVisible) {
                  chatWidgetContainer.classList.remove('show');
                  toggleIcon.classList.remove('bi-x-lg');
                  toggleIcon.classList.add('bi-chat-dots-fill');
                  chatToggleButton.setAttribute('aria-expanded', 'false');
              } else {
                  chatWidgetContainer.classList.add('show');
                  toggleIcon.classList.remove('bi-chat-dots-fill');
                  toggleIcon.classList.add('bi-x-lg');
                  chatToggleButton.setAttribute('aria-expanded', 'true');
              }
          });
      }

      // --- LOGIKA INTEGRASI WORDPRESS ---
      const wpContainer = document.getElementById('wordpress-posts-container');
      if (wpContainer) {
          const baseApiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2';

          const renderPosts = (posts) => {
              return posts.map(post => {
                  return `
                    <div class="col-lg-4 col-md-6">
                        <div class="service-item position-relative article-card">
                            <div class="icon"><i class="fab fa-wordpress"></i></div>
                            <h3>${post.title.rendered}</h3>
                            <div>${post.excerpt.rendered}</div>
                            <a href="${post.link}" target="_blank" rel="noopener noreferrer" class="readmore stretched-link">Baca Selengkapnya <i class="bi bi-arrow-right"></i></a>
                        </div>
                    </div>`;
              }).join('');
          };

          const fetchWpPosts = async () => {
              try {
                  const response = await fetch(`${baseApiUrl}/posts?per_page=3&_embed`);
                  if (!response.ok) throw new Error('Gagal ambil data WordPress.');
                  const data = await response.json();
                  
                  if (data.length > 0) {
                      setTimeout(() => {
                          wpContainer.innerHTML = renderPosts(data);
                      }, 500);
                  } else {
                       wpContainer.innerHTML = '<div class="col-12"><p class="text-center">Tidak ada berita dari situs utama.</p></div>';
                  }
              } catch (error) {
                  console.error("Error fetching WP posts:", error);
                  wpContainer.innerHTML = '<div class="col-12"><p class="text-center text-danger">Gagal memuat berita dari situs utama.</p></div>';
              }
          };

          fetchWpPosts();
      }
  });
  </script>
</body>
</html>