<?php
// public/index.php (FINAL & COMPLETE VERSION)
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__)); }
// `PROJECT_ROOT` will be defined by `config.php`
if (session_status() == PHP_SESSION_NONE) { session_start(); }

define('ENVIRONMENT', 'developtment'); // Ganti menjadi 'development' saat di localhost

if (ENVIRONMENT === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    // Pastikan direktori 'logs' ada dan bisa ditulis oleh server
    ini_set('error_log', PROJECT_ROOT . '/logs/php_error.log');
}
require_once dirname(__DIR__) . '/config.php';
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

// ======================================================================
// PENGAMBILAN DATA DARI DATABASE LOKAL
// ======================================================================
$settings = [];
$sliders = [];
$latest_articles_section_1 = [];
$upcoming_events = [];

if (isset($pdo)) {
    try {
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
        while ($row = $stmt_settings->fetch()) { $settings[$row['setting_key']] = $row['setting_value']; }

        $stmt_sliders = $pdo->query("SELECT title, description, image_url_desktop, image_url_mobile, link_url, button_text FROM portal_sliders WHERE is_active = 1 AND (start_date IS NULL OR start_date <= NOW()) AND (end_date IS NULL OR end_date >= NOW()) ORDER BY slide_order ASC LIMIT 5");
        $sliders = $stmt_sliders->fetchAll();

        $stmt_s1 = $pdo->query("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug, u.full_name as author_name, a.published_at FROM portal_articles a LEFT JOIN portal_categories c ON a.category_id = c.id LEFT JOIN portal_users u ON a.author_id = u.id WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.published_at DESC LIMIT 3");
        $latest_articles_section_1 = $stmt_s1->fetchAll();

        $stmt_events = $pdo->query("SELECT e.title, e.slug, e.start_datetime, e.location, e.featured_image_url FROM portal_events e WHERE e.is_published = 1 AND e.start_datetime >= CURDATE() ORDER BY e.start_datetime ASC LIMIT 5");
        $upcoming_events = $stmt_events->fetchAll();

    } catch (\PDOException $e) {
        error_log("Error fetching data for public/index.php: " . $e->getMessage());
    }
}
$site_title = htmlspecialchars($settings['site_name'] ?? 'UGKMB Portal');
$meta_description = htmlspecialchars($settings['site_tagline'] ?? 'Universitas Graha Karya Muara Bulian');

// --- MEMANGGIL HEADER BARU ---
require_once PROJECT_ROOT . '/public/includes/header_public.php';
?>

<style>
    :root { --card-shadow: 0 4px 15px rgba(0,0,0,0.05); --card-shadow-hover: 0 8px 25px rgba(0,0,0,0.1); --card-border-radius: 0.75rem; --transition-speed: 0.3s; }
    .custom-card-img { transition: transform var(--transition-speed) ease; }
    .article-card-hover:hover .custom-card-img { transform: scale(1.05); }
    .article-card-hover { border-radius: var(--card-border-radius); transition: all var(--transition-speed) ease; box-shadow: var(--card-shadow); border: none; overflow: hidden; }
    .article-card-hover:hover { transform: translateY(-5px); box-shadow: var(--card-shadow-hover); }
    .section-title.custom-page-title { font-size: clamp(1.75rem, 5vw, 2.5rem); }
    @keyframes skeleton-loading { 0% { background-color: hsl(200, 20%, 80%); } 100% { background-color: hsl(200, 20%, 95%); } }
    .skeleton { animation: skeleton-loading 1.5s linear infinite alternate; border-radius: 0.25rem; }
    .skeleton-card .skeleton-img { height: 180px; }
    .skeleton-text { height: 1em; margin-bottom: 0.5rem; }
    .fade-in-section { opacity: 0; transform: translateY(30px); transition: opacity 0.6s ease-out, transform 0.6s ease-out; }
    .fade-in-section.is-visible { opacity: 1; transform: translateY(0); }
    .agenda-slider .carousel-item { height: 450px; background-size: cover; background-position: center; border-radius: var(--card-border-radius); color: #fff; }
    .agenda-slider .carousel-caption { top: 0; bottom: 0; background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0.1) 100%); padding: 2rem; display: flex; flex-direction: column; justify-content: flex-end; align-items: flex-start; text-align: left; }
    .agenda-date-box { background-color: rgba(255,255,255,0.15); backdrop-filter: blur(5px); border: 1px solid rgba(255,255,255,0.2); border-radius: 0.5rem; padding: 0.5rem 1rem; text-align: center; width: 80px; }
    .agenda-date-box .day { font-size: 2rem; font-weight: 700; line-height: 1; }
    .agenda-date-box .month { font-size: 0.9rem; text-transform: uppercase; }
    .hero-slider-image { height: 60vh; object-fit: cover; }
    @media (max-width: 768px) { .hero-slider-image { height: 80vh; } }
    
    
    /* --- Generic Widget Styles --- */

/* Styles the floating circular buttons */
.widget-toggle-button {
  position: fixed;
  bottom: 20px;
  width: 60px;
  height: 60px;
  z-index: 1050; /* Ensures it's above most content */
  box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
  transition: transform 0.3s ease, bottom 0.3s ease;
}
.widget-toggle-button:hover {
  transform: scale(1.1); /* Slightly enlarges on hover */
}

/* Styles the pop-up container (initially hidden) */
.widget-container {
  position: fixed;
  bottom: 90px;
  width: 370px;
  height: 550px;
  z-index: 1049;
  border-radius: 15px;
  overflow: hidden;
  box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
  background-color: #fff;
  /* Hides the container by default */
  opacity: 0;
  transform: translateY(20px) scale(0.95);
  transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0.3s;
  visibility: hidden;
}

/* This class is added by JavaScript to show the container */
.widget-container.show {
  opacity: 1;
  transform: translateY(0) scale(1);
  visibility: visible;
  transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0s;
}

/* Ensures the iframe fills its container */
.widget-container iframe {
  width: 100%;
  height: 100%;
  border: none;
}

/* Positions the AI Chat button/container on the left */
#chat-toggle-button { left: 20px; }
#chat-widget-container { left: 20px; }

/* Positions the CS Chat button/container on the right */
#cs-toggle-button { right: 120px; } /* Note: Original file has 120px, likely a typo and should be 20px */
#cs-widget-container { right: 20px; }

/* Responsive adjustment for mobile */
@media (max-width: 768px) {
  #chat-toggle-button {
    left: auto;
    right: 20px;
    bottom: 90px;
  }
  #chat-widget-container {
    left: auto;
    right: 20px;
  }
}
</style>

<div class="homepage-main">

    <?php if (!empty($sliders)): ?>
    <section id="hero-slider" class="carousel slide" data-bs-ride="carousel" data-bs-interval="7000">
        <div class="carousel-indicators">
            <?php foreach ($sliders as $index => $slide): ?>
            <button type="button" data-bs-target="#hero-slider" data-bs-slide-to="<?php echo $index; ?>" class="<?php echo ($index == 0) ? 'active' : ''; ?>" aria-current="true" aria-label="Slide <?php echo $index + 1; ?>"></button>
            <?php endforeach; ?>
        </div>
        <div class="carousel-inner">
            <?php foreach ($sliders as $index => $slide): ?>
            <div class="carousel-item <?php echo ($index == 0) ? 'active' : ''; ?>">
                <img src="<?php echo htmlspecialchars(resolve_url($slide['image_url_desktop'])); ?>" class="d-block w-100 hero-slider-image" alt="<?php echo esc_html($slide['title']); ?>">
                <div class="container"><div class="carousel-caption text-start">
                    <h1 class="display-4 fw-bold"><?php echo esc_html($slide['title']); ?></h1>
                    <p class="lead d-none d-md-block col-md-8"><?php echo esc_html($slide['description']); ?></p>
                    <a href="<?php echo esc_html($slide['link_url']); ?>" class="btn btn-primary btn-lg mt-3"><?php echo esc_html($slide['button_text']); ?></a>
                </div></div>
            </div>
            <?php endforeach; ?>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#hero-slider" data-bs-slide="prev"><span class="carousel-control-prev-icon"></span></button>
        <button class="carousel-control-next" type="button" data-bs-target="#hero-slider" data-bs-slide="next"><span class="carousel-control-next-icon"></span></button>
    </section>
    <?php endif; ?>

    <section class="py-5 fade-in-section">
        <div class="container">
            <header class="text-center mb-5"><h2 class="section-title display-5 fw-bold custom-page-title">Berita & Informasi Terkini</h2></header>
            <div class="row row-cols-1 row-cols-md-3 g-4">
                <?php if (!empty($latest_articles_section_1)): ?>
                <?php foreach($latest_articles_section_1 as $article): ?>
                <div class="col d-flex align-items-stretch"><div class="card h-100 article-card-hover">
                    <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>"><img src="<?php echo resolve_url(esc_html($article['featured_image_url'])); ?>" class="card-img-top custom-card-img" alt="<?php echo esc_html($article['title']); ?>" style="height: 200px; object-fit: cover;"></a>
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title h6"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($article['title']); ?></a></h5>
                        <p class="card-text small text-muted flex-grow-1"><?php echo esc_html(substr(strip_tags($article['excerpt'] ?? ''), 0, 100)) . '...'; ?></p>
                        <div class="mt-auto"><small class="text-muted"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($article['published_at'])); ?></small></div>
                    </div>
                </div></div>
                <?php endforeach; ?>
                <?php else: ?>
                <div class="col-12"><p class="text-center text-muted">Belum ada berita untuk ditampilkan.</p></div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light-subtle fade-in-section">
        <div class="container">
            <header class="text-center mb-5"><h3 class="section-title h3 fw-bold custom-page-title">Postingan dari Situs Utama</h3></header>
            <div id="wordpress-posts-container-index" class="row row-cols-1 row-cols-sm-2 row-cols-lg-4 g-4">
                <script> for(let i=0;i<4;i++){document.write('<div class="col"><div class="card h-100 skeleton-card"><div class="skeleton skeleton-img"></div><div class="card-body"><div class="skeleton skeleton-text" style="width:90%"></div><div class="skeleton skeleton-text" style="width:60%"></div></div></div></div>');} </script>
            </div>
        </div>
    </section>
    
    <section class="py-5 fade-in-section">
        <div class="container">
            <header class="text-center mb-5"><h2 class="section-title display-5 fw-bold custom-page-title">Agenda Mendatang</h2></header>
            <?php if (!empty($upcoming_events)): ?>
            <div id="agendaSlider" class="carousel slide agenda-slider shadow-lg" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php foreach ($upcoming_events as $index => $event): ?>
                    <div class="carousel-item <?php if($index==0) echo 'active'; ?>" style="background-image: url('<?php echo resolve_url(esc_html($event['featured_image_url'])); ?>');">
                        <div class="carousel-caption">
                            <div class="agenda-date-box mb-3"><div class="day"><?php echo date('d', strtotime($event['start_datetime'])); ?></div><div class="month"><?php echo strtoupper(date('M', strtotime($event['start_datetime']))); ?></div></div>
                            <h3 class="fw-bold"><?php echo esc_html($event['title']); ?></h3>
                            <p class="d-none d-md-block"><i class="fas fa-map-marker-alt me-2"></i><?php echo esc_html($event['location']); ?></p>
                            <a href="<?php echo resolve_url('event.php?slug=' . esc_html($event['slug'])); ?>" class="btn btn-primary">Lihat Detail</a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#agendaSlider" data-bs-slide="prev"><span class="carousel-control-prev-icon"></span></button>
                <button class="carousel-control-next" type="button" data-bs-target="#agendaSlider" data-bs-slide="next"><span class="carousel-control-next-icon"></span></button>
            </div>
            <?php else: ?>
            <div class="alert alert-info text-center">Belum ada agenda acara yang akan datang.</div>
            <?php endif; ?>
        </div>
    </section>

    <section class="py-5 fade-in-section">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-4">
                    <h3 class="h4 fw-bold custom-page-title">Halaman Penting</h3>
                     <div id="wordpress-pages-container" class="list-group list-group-flush mt-3">
                         <script> for(let i=0;i<5;i++){document.write('<div class="skeleton skeleton-text" style="height:2.5em;margin-bottom:0.5rem;"></div>');} </script>
                     </div>
                </div>
                <div class="col-lg-8">
                    <h3 class="h4 fw-bold custom-page-title">Galeri Media</h3>
                    <div id="wordpress-media-container" class="row row-cols-3 row-cols-md-4 g-3 mt-3">
                        <script> for(let i=0;i<8;i++){document.write('<div class="col"><div class="skeleton" style="aspect-ratio:1/1;border-radius:var(--card-border-radius);"></div></div>');} </script>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<button id="chat-toggle-button" class="widget-toggle-button btn btn-primary rounded-circle p-0 d-flex align-items-center justify-content-center" type="button" aria-label="Toggle Chat" aria-expanded="false" data-icon-open="bi-chat-dots-fill" data-icon-close="bi-x-lg">
  <i class="bi bi-chat-dots-fill fs-4"></i>
 </button>

 <div id="chat-widget-container" class="widget-container">
  <iframe data-src="https://chat.mitrautamateknologi.co-id.id/" title="ChatMUT AI Assistant"></iframe>
 </div>
 <button id="cs-toggle-button" class="widget-toggle-button btn btn-success rounded-circle p-0 d-flex align-items-center justify-content-center" type="button" aria-label="Toggle Message" aria-expanded="false" data-icon-open="bi-whatsapp" data-icon-close="bi-x-lg">
  <i class="bi bi-whatsapp fs-4"></i>
 </button>

 <div id="cs-widget-container" class="widget-container">
  <iframe data-src="https://msg.mitrautamateknologi.co-id.id/" title="CS Message Assistant"></iframe>
  
 </div>
 <script>const initializeWidgetToggle = (buttonId, containerId) => {
  const toggleButton = document.getElementById(buttonId);
  const widgetContainer = document.getElementById(containerId);
  const iconElement = toggleButton ? toggleButton.querySelector('i') : null;
  const iframe = widgetContainer ? widgetContainer.querySelector('iframe') : null;
  
  if (!toggleButton || !widgetContainer || !iconElement || !iframe) return;

  const iconOpen = toggleButton.dataset.iconOpen;
  const iconClose = toggleButton.dataset.iconClose;
  let isIframeLoaded = false;

  toggleButton.addEventListener('click', () => {
    const isVisible = widgetContainer.classList.contains('show');

    // Lazy load the iframe source only on the first click to open
    if (!isVisible && !isIframeLoaded) {
      iframe.src = iframe.dataset.src;
      isIframeLoaded = true;
    }

    // Toggle the container's visibility
    widgetContainer.classList.toggle('show');

    // Swap the icon on the button
    const isNowVisible = widgetContainer.classList.contains('show');
    iconElement.classList.remove(isNowVisible ? iconOpen : iconClose);
    iconElement.classList.add(isNowVisible ? iconClose : iconOpen);
    toggleButton.setAttribute('aria-expanded', isNowVisible);
  });
};

// Calling the function for both widgets
initializeWidgetToggle('chat-toggle-button', 'chat-widget-container');
initializeWidgetToggle('cs-toggle-button', 'cs-widget-container');</script>

<?php require_once PROJECT_ROOT . '/public/includes/footer_public.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    
    const preloader = document.querySelector('#preloader');
    if (preloader) { window.addEventListener('load', () => { preloader.classList.add('preloader-hidden'); }); }

    const headerWrapper = document.querySelector('.header-wrapper');
    if(headerWrapper) {
        document.body.style.paddingTop = headerWrapper.offsetHeight + 'px';
        window.addEventListener('scroll', () => { headerWrapper.classList.toggle("scrolled", window.pageYOffset > 50); });
    }

    const chatToggleButton = document.getElementById('chat-toggle-button');
    const chatWidgetContainer = document.getElementById('chat-widget-container');
    if (chatToggleButton && chatWidgetContainer) {
        chatToggleButton.addEventListener('click', () => {
            chatWidgetContainer.classList.toggle('show');
            const icon = chatToggleButton.querySelector('i');
            icon.classList.toggle('fa-comments');
            icon.classList.toggle('fa-times');
        });
    }

    const fadeInSections = document.querySelectorAll('.fade-in-section');
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => { if (entry.isIntersecting) entry.target.classList.add('is-visible'); });
    }, { threshold: 0.1 });
    fadeInSections.forEach(section => observer.observe(section));

    const baseApiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2';
    const fetchAndRender = async (endpoint, containerId, renderFunction) => {
        const container = document.getElementById(containerId);
        if (!container) return;
        try {
            const response = await fetch(`${baseApiUrl}${endpoint}`);
            if (!response.ok) throw new Error('Network response was not ok');
            const data = await response.json();
            if (data.length > 0) {
                 setTimeout(() => { container.innerHTML = renderFunction(data); }, 500);
            } else {
                 container.innerHTML = '<div class="col-12"><p class="text-muted">Tidak ada konten yang tersedia saat ini.</p></div>';
            }
        } catch (error) { 
            console.error(`Fetch Error for ${containerId}:`, error);
            container.innerHTML = '<div class="col-12"><p class="text-danger">Gagal memuat konten dari server.</p></div>';
        }
    };

    const renderPosts = (posts) => {
        return posts.map(post => {
            const img = post._embedded?.['wp:featuredmedia']?.[0]?.source_url || '<?php echo resolve_url("public/assets/images/logo_ugk.png"); ?>';
            const date = new Date(post.date).toLocaleDateString('id-ID', { day:'numeric', month:'short', year:'numeric' });
            return `<div class="col d-flex align-items-stretch"><div class="card h-100 article-card-hover"><a href="${post.link}" target="_blank" rel="noopener noreferrer"><img src="${img}" class="card-img-top custom-card-img" alt="${post.title.rendered}" style="height: 180px; object-fit: cover;"></a><div class="card-body d-flex flex-column"><h5 class="card-title h6" style="font-size:0.9rem; line-height:1.4;"><a href="${post.link}" target="_blank" rel="noopener noreferrer" class="text-decoration-none stretched-link">${post.title.rendered}</a></h5><div class="mt-auto pt-2"><small class="text-muted"><i class="fas fa-calendar-alt fa-xs me-1"></i> ${date}</small></div></div></div></div>`;
        }).join('');
    };

    const renderPages = (pages) => pages.map(page => `<a href="${page.link}" target="_blank" rel="noopener noreferrer" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center px-0"><span>${page.title.rendered}</span><i class="fas fa-chevron-right fa-xs text-muted"></i></a>`).join('');
    
    const renderMedia = (media) => media.map(item => (item.media_type === 'image') ? `<div class="col"><a href="${item.source_url}" target="_blank" rel="noopener noreferrer"><img src="${item.media_details.sizes.thumbnail.source_url}" class="img-fluid rounded shadow-sm article-card-hover" alt="${item.title.rendered}" style="aspect-ratio:1/1;object-fit:cover;"></a></div>` : '').join('');

    fetchAndRender('/posts?per_page=4&_embed', 'wordpress-posts-container-index', renderPosts);
    fetchAndRender('/pages?per_page=5', 'wordpress-pages-container', renderPages);
    fetchAndRender('/media?per_page=8&media_type=image', 'wordpress-media-container', renderMedia);
});
</script>

</body>
</html>