<?php
// public/index.php (FINAL & COMPLETE VERSION)
// This version is ready for production deployment.
// It combines the original local portal data with a new Agenda Slider
// and modern WordPress integration (Posts, Pages, Media) with enhanced UX/UI.

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__));
}

require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

// ======================================================================
// PENGAMBILAN DATA DARI DATABASE LOKAL (TERMASUK DATA AGENDA BARU)
// ======================================================================
$settings = [];
$sliders = [];
$latest_articles_section_1 = [];
$upcoming_events = []; // Variabel baru untuk agenda
$media_text_blocks = [];
$spotlight_categories_with_articles = [];
$featured_stories_slider = [];
$quick_links_homepage = [];

if (isset($pdo)) {
    try {
        // Query untuk data portal asli Anda
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
        while ($row = $stmt_settings->fetch()) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }

        $stmt_sliders = $pdo->query("SELECT title, description, image_url_desktop, image_url_mobile, link_url, button_text FROM portal_sliders WHERE is_active = 1 AND (start_date IS NULL OR start_date <= NOW()) AND (end_date IS NULL OR end_date >= NOW()) ORDER BY slide_order ASC LIMIT 5");
        $sliders = $stmt_sliders->fetchAll();

        $stmt_s1 = $pdo->query("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug, u.full_name as author_name, a.published_at FROM portal_articles a LEFT JOIN portal_categories c ON a.category_id = c.id LEFT JOIN portal_users u ON a.author_id = u.id WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.published_at DESC LIMIT 3");
        $latest_articles_section_1 = $stmt_s1->fetchAll();

        // --- QUERY BARU UNTUK MENGAMBIL AGENDA ACARA ---
        $stmt_events = $pdo->query("SELECT e.title, e.slug, e.start_datetime, e.location, e.featured_image_url
                                     FROM portal_events e
                                     WHERE e.is_published = 1 AND e.start_datetime >= CURDATE()
                                     ORDER BY e.start_datetime ASC
                                     LIMIT 5");
        $upcoming_events = $stmt_events->fetchAll();

        // Sisa query asli Anda...
        $stmt_media_text_all = $pdo->query("SELECT title, slug, excerpt, featured_image_url, published_at, u.full_name as author_name FROM portal_articles LEFT JOIN portal_users u ON portal_articles.author_id = u.id WHERE status='published' AND published_at <= NOW() ORDER BY RAND() LIMIT 3");
        $media_text_blocks = $stmt_media_text_all->fetchAll();
        
        $spotlight_category_slugs = ['berita-kampus', 'riset', 'event-kampus'];
        foreach ($spotlight_category_slugs as $slug) {
            $stmt_spotlight_cat_info = $pdo->prepare("SELECT id, name, slug FROM portal_categories WHERE slug = :slug LIMIT 1");
            $stmt_spotlight_cat_info->execute(['slug' => $slug]);
            $category_info = $stmt_spotlight_cat_info->fetch();

            if ($category_info) {
                $stmt_articles_in_cat = $pdo->prepare("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, u.full_name as author_name, a.published_at FROM portal_articles a LEFT JOIN portal_users u ON a.author_id = u.id WHERE a.category_id = :category_id AND a.status = 'published' AND a.published_at <= NOW() ORDER BY a.published_at DESC LIMIT 3");
                $stmt_articles_in_cat->execute(['category_id' => $category_info['id']]);
                $articles_in_cat = $stmt_articles_in_cat->fetchAll();

                if (!empty($articles_in_cat)) {
                    $spotlight_categories_with_articles[] = ['category_info' => $category_info, 'articles' => $articles_in_cat];
                }
            }
        }

        $stmt_feat_slider = $pdo->query("SELECT title, slug, excerpt, featured_image_url, u.full_name as author_name, published_at FROM portal_articles LEFT JOIN portal_users u ON portal_articles.author_id = u.id WHERE status='published' AND published_at <= NOW() ORDER BY views_count DESC, published_at DESC LIMIT 5");
        $featured_stories_slider = $stmt_feat_slider->fetchAll();

        $stmt_ql_home = $pdo->query("SELECT title, url, icon_class, open_in_new_tab FROM portal_quick_links WHERE is_active = 1 AND group_key = 'homepage_focus' ORDER BY link_order ASC LIMIT 4");
        $quick_links_homepage = $stmt_ql_home->fetchAll();

    } catch (\PDOException $e) {
        error_log("Error fetching data for public/index.php: " . $e->getMessage());
    }
}
$site_title = htmlspecialchars($settings['site_name'] ?? 'UGKMB Portal');
$meta_description = htmlspecialchars($settings['site_tagline'] ?? 'Universitas Graha Karya Muara Bulian');

require_once PROJECT_ROOT . '/public/includes/header_public.php';
?>

<style>
    :root {
        --card-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        --card-shadow-hover: 0 8px 25px rgba(0, 0, 0, 0.1);
        --card-border-radius: 0.75rem;
        --transition-speed: 0.3s;
    }
    .custom-card-img {
        transition: transform var(--transition-speed) ease;
    }
    .article-card-hover:hover .custom-card-img {
        transform: scale(1.05);
    }
    .article-card-hover {
        border-radius: var(--card-border-radius);
        transition: box-shadow var(--transition-speed) ease, transform var(--transition-speed) ease;
        box-shadow: var(--card-shadow);
        border: none;
    }
    .article-card-hover:hover {
        transform: translateY(-5px);
        box-shadow: var(--card-shadow-hover);
    }
    .section-title.custom-page-title {
        font-size: clamp(1.75rem, 5vw, 2.5rem); /* Font responsif */
    }

    /* Skeleton Loader Styles */
    @keyframes skeleton-loading {
        0% { background-color: hsl(200, 20%, 80%); }
        100% { background-color: hsl(200, 20%, 95%); }
    }
    .skeleton {
        animation: skeleton-loading 1.5s linear infinite alternate;
        border-radius: 0.25rem;
    }
    .skeleton-card .skeleton-img {
        height: 180px;
        border-radius: var(--card-border-radius) var(--card-border-radius) 0 0;
    }
    .skeleton-card .card-body { padding: 1rem; }
    .skeleton-text { height: 1em; margin-bottom: 0.5rem; }

    /* Fade-in Animation on Scroll */
    .fade-in-section {
        opacity: 0;
        transform: translateY(30px);
        transition: opacity 0.6s ease-out, transform 0.6s ease-out;
    }
    .fade-in-section.is-visible {
        opacity: 1;
        transform: translateY(0);
    }

    /* Style untuk Agenda Slider BARU */
    .agenda-slider .carousel-item {
        height: 450px;
        background-size: cover;
        background-position: center center;
        border-radius: var(--card-border-radius);
        color: #fff;
    }
    .agenda-slider .carousel-caption {
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0.4) 50%, rgba(0,0,0,0.1) 100%);
        padding: 2rem;
        display: flex;
        flex-direction: column;
        justify-content: flex-end;
        align-items: flex-start;
        text-align: left;
    }
    .agenda-date-box {
        background-color: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(5px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 0.5rem;
        padding: 0.5rem 1rem;
        text-align: center;
        width: 80px;
    }
    .agenda-date-box .day { font-size: 2rem; font-weight: 700; line-height: 1; }
    .agenda-date-box .month { font-size: 0.9rem; text-transform: uppercase; letter-spacing: 1px; }
    
    
    
    
    
</style>

<main class="homepage-main">

    <?php if (!empty($sliders)): ?>
    <section id="hero-slider" class="carousel slide main-hero-slider" data-bs-ride="carousel" data-bs-interval="7000">
        <div class="carousel-indicators">
            <?php foreach ($sliders as $index => $slide): ?>
            <button type="button" data-bs-target="#hero-slider" data-bs-slide-to="<?php echo $index; ?>" class="<?php echo ($index == 0) ? 'active' : ''; ?>" aria-current="<?php echo ($index == 0) ? 'true' : 'false'; ?>" aria-label="Slide <?php echo $index + 1; ?>"></button>
            <?php endforeach; ?>
        </div>
        <div class="carousel-inner">
            <?php foreach ($sliders as $index => $slide): ?>
            <div class="carousel-item <?php echo ($index == 0) ? 'active' : ''; ?>">
                <div class="hero-slider-image-wrapper">
                    <picture>
                        <?php if(!empty($slide['image_url_mobile'])): ?>
                        <source media="(max-width: 767px)" srcset="<?php echo htmlspecialchars(resolve_url($slide['image_url_mobile'])); ?>">
                        <?php endif; ?>
                        <img src="<?php echo htmlspecialchars(resolve_url($slide['image_url_desktop'])); ?>" class="d-block w-100 hero-slider-image" alt="<?php echo esc_html($slide['title']); ?>" loading="<?php echo ($index == 0) ? 'eager' : 'lazy'; ?>">
                    </picture>
                </div>
                <div class="container h-100">
                    <div class="carousel-caption text-start">
                        <h1 class="display-4 fw-bold animate__animated animate__fadeInDown animate__delay-0.5s"><?php echo esc_html($slide['title']); ?></h1>
                        <?php if(!empty($slide['description'])): ?><p class="lead d-none d-md-block animate__animated animate__fadeInUp animate__delay-0.8s col-md-8 col-lg-7"><?php echo esc_html($slide['description']); ?></p><?php endif; ?>
                        <?php if(!empty($slide['link_url']) && !empty($slide['button_text'])): ?>
                            <a href="<?php echo esc_html($slide['link_url']); ?>" class="btn btn-primary btn-lg mt-3 animate__animated animate__fadeInUp animate__delay-1s"><?php echo esc_html($slide['button_text']); ?> <i class="fas fa-arrow-right ms-1"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php if (count($sliders) > 1): ?>
        <button class="carousel-control-prev" type="button" data-bs-target="#hero-slider" data-bs-slide="prev"><span class="carousel-control-prev-icon" aria-hidden="true"></span><span class="visually-hidden">Previous</span></button>
        <button class="carousel-control-next" type="button" data-bs-target="#hero-slider" data-bs-slide="next"><span class="carousel-control-next-icon" aria-hidden="true"></span><span class="visually-hidden">Next</span></button>
        <?php endif; ?>
    </section>
    <?php endif; ?>

    <section class="py-5 section-latest-news fade-in-section">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold custom-page-title">Berita & Informasi Terkini</h2>
            </header>
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                <?php if (!empty($latest_articles_section_1)): ?>
                    <?php foreach($latest_articles_section_1 as $article): ?>
                    <div class="col d-flex align-items-stretch">
                        <div class="card h-100 shadow-sm custom-card article-card-hover">
                            <?php if (!empty($article['featured_image_url'])): ?>
                            <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="article-card-image-link overflow-hidden" style="border-radius: var(--card-border-radius) var(--card-border-radius) 0 0;">
                                <img src="<?php echo resolve_url(esc_html($article['featured_image_url'])); ?>" class="card-img-top custom-card-img" alt="<?php echo esc_html($article['title']); ?>" loading="lazy">
                            </a>
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <?php if(!empty($article['category_name'])): ?><a href="<?php echo resolve_url('category.php?slug='.esc_html($article['category_slug'])); ?>" class="badge bg-primary text-decoration-none mb-2 align-self-start"><?php echo esc_html($article['category_name']); ?></a><?php endif; ?>
                                <h5 class="card-title h6 custom-card-title mb-2"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($article['title']); ?></a></h5>
                                <p class="card-text small text-muted custom-card-excerpt flex-grow-1 mb-2"><?php echo esc_html(substr(strip_tags($article['excerpt'] ?? ''), 0, 100)) . '...'; ?></p>
                                <div class="mt-auto">
                                    <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($article['published_at'])); ?></small>
                                    <?php if (!empty($article['author_name'])): ?>
                                        <small class="text-muted article-meta ms-2"><i class="fas fa-user fa-xs me-1"></i> <?php echo esc_html($article['author_name']); ?></small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12"><p class="text-muted text-center">Belum ada berita terkini.</p></div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light-subtle fade-in-section">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h3 class="section-title h3 fw-bold custom-page-title">Postingan Terdahulu dari Situs Utama</h3>
            </header>
            <div id="wordpress-posts-container-index" class="row row-cols-1 row-cols-sm-2 row-cols-lg-4 g-4">
                <script>
                    for(let i = 0; i < 4; i++) {
                        document.write(`
                            <div class="col">
                                <div class="card h-100 skeleton-card" aria-hidden="true">
                                    <div class="skeleton skeleton-img"></div>
                                    <div class="card-body">
                                        <div class="skeleton skeleton-text" style="width: 90%;"></div>
                                        <div class="skeleton skeleton-text" style="width: 70%;"></div>
                                        <div class="skeleton skeleton-text mt-3" style="width: 50%;"></div>
                                    </div>
                                </div>
                            </div>
                        `);
                    }
                </script>
            </div>
            <div class="text-center mt-5">
                <a href="<?php echo resolve_url('articles.php'); ?>" class="btn btn-outline-primary">Lihat Arsip Berita Lengkap <i class="fas fa-arrow-right ms-1"></i></a>
            </div>
        </div>
    </section>
    
    <section class="py-5 fade-in-section">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold custom-page-title">Agenda Acara Mendatang</h2>
                <p class="lead text-muted section-subtitle">Jangan lewatkan berbagai kegiatan menarik dari kami.</p>
            </header>
            
            <?php if (!empty($upcoming_events)): ?>
            <div id="agendaSlider" class="carousel slide agenda-slider shadow-lg" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php foreach ($upcoming_events as $index => $event): ?>
                    <div class="carousel-item <?php if ($index == 0) echo 'active'; ?>" style="background-image: url('<?php echo !empty($event['featured_image_url']) ? resolve_url(esc_html($event['featured_image_url'])) : resolve_url('assets/images/default-event.jpg'); ?>');">
                        <div class="carousel-caption">
                            <div class="agenda-date-box mb-3">
                                <div class="day"><?php echo date('d', strtotime($event['start_datetime'])); ?></div>
                                <div class="month"><?php echo strtoupper(date('M', strtotime($event['start_datetime']))); ?></div>
                            </div>
                            <h3 class="fw-bold"><?php echo esc_html($event['title']); ?></h3>
                            <p class="mb-3 d-none d-md-block">
                                <i class="fas fa-map-marker-alt fa-fw me-2"></i><?php echo esc_html($event['location'] ?? 'Informasi lokasi menyusul'); ?>
                            </p>
                            <a href="<?php echo resolve_url('event.php?slug=' . esc_html($event['slug'])); ?>" class="btn btn-primary">Lihat Detail Acara</a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php if (count($upcoming_events) > 1): ?>
                <button class="carousel-control-prev" type="button" data-bs-target="#agendaSlider" data-bs-slide="prev"><span class="carousel-control-prev-icon" aria-hidden="true"></span><span class="visually-hidden">Previous</span></button>
                <button class="carousel-control-next" type="button" data-bs-target="#agendaSlider" data-bs-slide="next"><span class="carousel-control-next-icon" aria-hidden="true"></span><span class="visually-hidden">Next</span></button>
                <?php endif; ?>
            </div>
            <?php else: ?>
            <div class="alert alert-info text-center">
                Belum ada agenda acara yang akan datang. Silakan periksa kembali nanti.
            </div>
            <?php endif; ?>
        </div>
    </section>

    <?php if (!empty($media_text_blocks)): ?>
    <section class="py-4 fade-in-section">
        </section>
    <?php endif; ?>
    
    <?php if (!empty($spotlight_categories_with_articles)): ?>
    <section class="py-5 bg-light-subtle fade-in-section">
        </section>
    <?php endif; ?>
    
    <section class="py-5 fade-in-section">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-4">
                    <h3 class="h4 fw-bold custom-page-title">Halaman Penting</h3>
                     <div id="wordpress-pages-container" class="list-group list-group-flush mt-3">
                        <script>
                             for(let i = 0; i < 4; i++) {
                                document.write('<div class="skeleton skeleton-text" style="height: 2.5em; margin-bottom: 0.5rem;" aria-hidden="true"></div>');
                             }
                        </script>
                     </div>
                </div>
                <div class="col-lg-8">
                    <h3 class="h4 fw-bold custom-page-title">Galeri Media Terbaru</h3>
                    <div id="wordpress-media-container" class="row row-cols-3 row-cols-md-4 g-3 mt-3">
                        <script>
                            for(let i = 0; i < 8; i++) {
                                document.write('<div class="col"><div class="skeleton" style="aspect-ratio: 1/1; border-radius: var(--card-border-radius);" aria-hidden="true"></div></div>');
                            }
                        </script>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>

   
<script>
document.addEventListener('DOMContentLoaded', function() {
    
    // --- ANIMATION ON SCROLL ---
    const fadeInSections = document.querySelectorAll('.fade-in-section');
    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('is-visible');
                observer.unobserve(entry.target);
            }
        });
    }, { threshold: 0.1 });
    fadeInSections.forEach(section => observer.observe(section));

    // --- WORDPRESS API INTEGRATION ---
    const baseApiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2';
    
    const fetchAndRender = async (endpoint, containerId, renderFunction) => {
        const container = document.getElementById(containerId);
        if (!container) return;

        try {
            const response = await fetch(`${baseApiUrl}${endpoint}`);
            if (!response.ok) throw new Error(`Network response error.`);
            const data = await response.json();
            
            if (data.length === 0) {
                container.innerHTML = `<div class="col-12"><p class="text-muted small fst-italic">Konten tidak tersedia.</p></div>`;
            } else {
                setTimeout(() => { container.innerHTML = renderFunction(data); }, 350);
            }
        } catch (error) {
            console.error(`Fetch Error for ${endpoint}:`, error);
            container.innerHTML = `<div class="col-12"><p class="text-danger small fst-italic">Gagal memuat konten.</p></div>`;
        }
    };

    const renderPosts = (posts) => {
        return posts.map(post => {
            const featuredImage = post._embedded?.['wp:featuredmedia']?.[0]?.source_url || '<?php echo resolve_url("assets/images/default-placeholder.png"); ?>';
            const postDate = new Date(post.date).toLocaleDateString('id-ID', { day: 'numeric', month: 'short', year: 'numeric' });
            return `
                <div class="col d-flex align-items-stretch">
                    <div class="card h-100 custom-card article-card-hover">
                        <a href="${post.link}" target="_blank" rel="noopener noreferrer" class="article-card-image-link overflow-hidden" style="border-radius: var(--card-border-radius) var(--card-border-radius) 0 0;">
                            <img src="${featuredImage}" class="card-img-top custom-card-img" alt="${post.title.rendered}" loading="lazy">
                        </a>
                        <div class="card-body d-flex flex-column p-3">
                            <h5 class="card-title h6 custom-card-title mb-2" style="font-size: 0.9rem; line-height: 1.4;">
                                <a href="${post.link}" target="_blank" rel="noopener noreferrer" class="text-decoration-none stretched-link">${post.title.rendered}</a>
                            </h5>
                            <div class="mt-auto pt-2">
                                <small class="text-muted article-meta" style="font-size: 0.8rem;"><i class="fas fa-calendar-alt fa-xs me-1"></i> ${postDate}</small>
                            </div>
                        </div>
                    </div>
                </div>`;
        }).join('');
    };

    const renderPages = (pages) => {
        return pages.map(page => `
            <a href="${page.link}" target="_blank" rel="noopener noreferrer" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center px-0">
                <span class="fw-medium">${page.title.rendered}</span>
                <i class="fas fa-chevron-right fa-xs text-muted"></i>
            </a>`
        ).join('');
    };

    const renderMedia = (media) => {
        return media.map(item => {
            if (item.media_type === 'image' && item.media_details?.sizes?.thumbnail) {
                return `
                    <div class="col">
                        <a href="${item.source_url}" target="_blank" rel="noopener noreferrer" class="d-block" title="${item.title.rendered}">
                            <img src="${item.media_details.sizes.thumbnail.source_url}" class="img-fluid rounded shadow-sm article-card-hover" alt="${item.title.rendered}" loading="lazy" style="aspect-ratio: 1/1; object-fit: cover; width: 100%;">
                        </a>
                    </div>`;
            }
            return '';
        }).join('');
    };

    // Panggil semua fungsi fetch untuk setiap bagian WordPress
    fetchAndRender('/posts?per_page=4&_embed', 'wordpress-posts-container-index', renderPosts);
    fetchAndRender('/pages?per_page=5', 'wordpress-pages-container', renderPages);
    fetchAndRender('/media?per_page=8&media_type=image', 'wordpress-media-container', renderMedia);
});
</script>

<?php
require_once PROJECT_ROOT . '/includes/footer_public.php';
?>