<?php
// public/index.php
if (session_status() == PHP_SESSION_NONE) {
    // session_start(); // Handled by config.php
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__));
}

require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php'; // Untuk resolve_url dan esc_html

$theme = $_COOKIE['theme'] ?? 'light-theme';
$settings = [];
$sliders = [];
$latest_articles_section_1 = [];
$featured_story_section_2 = null;
$side_stories_section_2 = [];
$media_text_blocks = [];
$people_research_cards = [];
$featured_stories_slider = [];
$quick_links_homepage = [];

if (isset($pdo)) {
    try {
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
        while ($row = $stmt_settings->fetch()) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }

        // Sliders (ambil path mobile dan desktop)
        $stmt_sliders = $pdo->query("SELECT title, description, image_url_desktop, image_url_mobile, link_url, button_text
                                    FROM portal_sliders
                                    WHERE is_active = 1 AND (start_date IS NULL OR start_date <= NOW()) AND (end_date IS NULL OR end_date >= NOW())
                                    ORDER BY slide_order ASC LIMIT 5");
        $sliders = $stmt_sliders->fetchAll();

        // Section 1: "Research at risk" - fetch 3 articles
        $stmt_s1 = $pdo->query("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug
                                FROM portal_articles a LEFT JOIN portal_categories c ON a.category_id = c.id
                                WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.published_at DESC LIMIT 3");
        $latest_articles_section_1 = $stmt_s1->fetchAll();

        // Section 2: "Understanding federal funding" - 1 main, few side
        $stmt_s2_main = $pdo->query("SELECT a.id, a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug
                                     FROM portal_articles a LEFT JOIN portal_categories c ON a.category_id = c.id
                                     WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY RAND() LIMIT 1");
        $featured_story_section_2 = $stmt_s2_main->fetch();

        $side_stories_section_2_query_id_exclude = $featured_story_section_2['id'] ?? 0;
        $stmt_s2_side = $pdo->query("SELECT a.title, a.slug, c.name as category_name, c.slug as category_slug
                                     FROM portal_articles a LEFT JOIN portal_categories c ON a.category_id = c.id
                                     WHERE a.status = 'published' AND a.published_at <= NOW() AND a.id != " . $side_stories_section_2_query_id_exclude . " ORDER BY RAND() LIMIT 4");
        $side_stories_section_2 = $stmt_s2_side->fetchAll();

        // Media Text Blocks & People Cards
        // Menggunakan query yang lebih bervariasi untuk contoh data (hindari RAND() berlebihan di produksi)
        $stmt_media_text_all = $pdo->query("SELECT title, slug, excerpt, featured_image_url FROM portal_articles WHERE status='published' ORDER BY views_count DESC, published_at DESC LIMIT 6");
        $all_media_people_cards = $stmt_media_text_all->fetchAll();
        $media_text_blocks = array_slice($all_media_people_cards, 0, 3);
        $people_research_cards = array_slice($all_media_people_cards, 3, 3);


        $stmt_feat_slider = $pdo->query("SELECT title, slug, excerpt, featured_image_url FROM portal_articles WHERE status='published' ORDER BY views_count DESC, published_at DESC LIMIT 5");
        $featured_stories_slider = $stmt_feat_slider->fetchAll();

        $stmt_ql_home = $pdo->query("SELECT title, url, open_in_new_tab FROM portal_quick_links WHERE is_active = 1 AND group_key = 'homepage_focus' ORDER BY link_order ASC LIMIT 3");
        $quick_links_homepage = $stmt_ql_home->fetchAll();

    } catch (\PDOException $e) {
        error_log("Error fetching data for public/index.php: " . $e->getMessage());
        // Tambahkan penanganan error yang lebih baik di sini jika diperlukan
    }
}

$site_title_prefix = htmlspecialchars($settings['site_name'] ?? 'UGKMB');
$site_title = $site_title_prefix;
$meta_description = htmlspecialchars($settings['site_tagline'] ?? 'Universitas Graha Karya Muara Bulian');

// Header_public.php akan menangani output HTML <head> dan navigasi
require_once PROJECT_ROOT . '/includes/header_public.php';
?>

<main class="homepage-main">

    <!-- Hero Section -->
    <?php if (!empty($sliders)): ?>
    <section id="hero-slider" class="carousel slide main-hero-slider" data-bs-ride="carousel" data-bs-interval="7000">
        <div class="carousel-indicators">
            <?php foreach ($sliders as $index => $slide): ?>
            <button type="button" data-bs-target="#hero-slider" data-bs-slide-to="<?php echo $index; ?>" class="<?php echo ($index == 0) ? 'active' : ''; ?>" aria-current="<?php echo ($index == 0) ? 'true' : 'false'; ?>" aria-label="Slide <?php echo $index + 1; ?>"></button>
            <?php endforeach; ?>
        </div>
        <div class="carousel-inner">
            <?php foreach ($sliders as $index => $slide): ?>
            <div class="carousel-item <?php echo ($index == 0) ? 'active' : ''; ?>">
                <div class="hero-slider-image-wrapper">
                    <picture>
                        <?php if (!empty($slide['image_url_mobile'])): ?>
                        <source media="(max-width: 767px)" srcset="<?php echo htmlspecialchars(resolve_url($slide['image_url_mobile'])); ?>">
                        <?php endif; ?>
                        <img src="<?php echo htmlspecialchars(resolve_url($slide['image_url_desktop'])); ?>" class="d-block w-100 hero-slider-image" alt="<?php echo esc_html($slide['title']); ?>" loading="<?php echo ($index == 0) ? 'eager' : 'lazy'; ?>">
                    </picture>
                </div>
                <div class="container h-100">
                    <div class="carousel-caption">
                        <h1 class="display-4 fw-bold animate__animated animate__fadeInDown animate__delay-0.5s"><?php echo esc_html($slide['title']); ?></h1>
                        <?php if(!empty($slide['description'])): ?><p class="lead d-none d-md-block animate__animated animate__fadeInUp animate__delay-0.8s"><?php echo esc_html($slide['description']); ?></p><?php endif; ?>
                        <?php if(!empty($slide['link_url']) && !empty($slide['button_text'])): ?>
                            <a href="<?php echo esc_html($slide['link_url']); ?>" class="btn btn-primary btn-lg mt-3 animate__animated animate__fadeInUp animate__delay-1s"><?php echo esc_html($slide['button_text']); ?> <i class="fas fa-arrow-right ms-1"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php if (count($sliders) > 1): ?>
        <button class="carousel-control-prev" type="button" data-bs-target="#hero-slider" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#hero-slider" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
        </button>
        <?php endif; ?>
    </section>
    <?php endif; ?>

    <!-- Section: Research at risk (Card Grid) -->
    <section class="py-5 section-cards-A">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold">Berita & Riset Terkini</h2>
                <!-- Tailwind example: <h2 class="tw-text-4xl tw-font-bold tw-text-center tw-mb-12">Research at Risk</h2> -->
            </header>
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                <?php if (!empty($latest_articles_section_1)): ?>
                    <?php foreach($latest_articles_section_1 as $article): ?>
                    <div class="col d-flex align-items-stretch">
                        <div class="card h-100 custom-card article-card-hover">
                            <?php if (!empty($article['featured_image_url'])): ?>
                            <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>">
                                <img src="<?php echo resolve_url(esc_html($article['featured_image_url'])); ?>" class="card-img-top custom-card-img" alt="<?php echo esc_html($article['title']); ?>" loading="lazy">
                            </a>
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <?php if(!empty($article['category_name'])): ?><span class="badge bg-danger mb-2 custom-card-badge"><?php echo esc_html($article['category_name']); ?></span><?php endif; ?>
                                <h5 class="card-title custom-card-title"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($article['title']); ?></a></h5>
                                <p class="card-text small custom-card-excerpt flex-grow-1"><?php echo esc_html(substr(strip_tags($article['excerpt'] ?? ''), 0, 100)) . '...'; ?></p>
                                <!-- <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="btn btn-sm btn-outline-primary mt-auto align-self-start">Baca Selengkapnya</a> -->
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12"><p class="text-muted text-center">Konten untuk bagian ini sedang disiapkan.</p></div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Section: Understanding federal funding (News Layout) -->
    <section class="py-5 bg-light-subtle section-news-layout-B">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold">Wawasan & Pendanaan</h2>
                <p class="lead text-muted section-subtitle">Wawasan mendalam mengenai pendanaan riset dan dampaknya.</p>
            </header>
            <div class="row">
                <div class="col-lg-7 mb-4 mb-lg-0">
                    <?php if ($featured_story_section_2): ?>
                    <div class="card custom-card-featured shadow-sm h-100 article-card-hover">
                        <?php if($featured_story_section_2['featured_image_url']): ?>
                        <a href="<?php echo resolve_url('article.php?slug=' . esc_html($featured_story_section_2['slug'])); ?>">
                            <img src="<?php echo resolve_url(esc_html($featured_story_section_2['featured_image_url'])); ?>" class="card-img-top custom-card-img-featured" alt="<?php echo esc_html($featured_story_section_2['title']); ?>" loading="lazy">
                        </a>
                        <?php endif; ?>
                        <div class="card-body d-flex flex-column">
                            <h3 class="card-title h4 custom-card-title"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($featured_story_section_2['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($featured_story_section_2['title']); ?></a></h3>
                            <p class="card-text text-muted small custom-card-excerpt flex-grow-1"><?php echo esc_html(substr(strip_tags($featured_story_section_2['excerpt'] ?? ''), 0, 150)) . '...'; ?></p>
                            <!-- <a href="<?php echo resolve_url('article.php?slug=' . esc_html($featured_story_section_2['slug'])); ?>" class="btn btn-sm btn-primary mt-auto align-self-start">Detail</a> -->
                        </div>
                    </div>
                    <?php else: ?>
                        <div class="col-12"><p class="text-muted">Cerita unggulan sedang disiapkan.</p></div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-5">
                    <ul class="list-group list-group-flush custom-side-list">
                        <?php if(!empty($side_stories_section_2)): ?>
                            <?php foreach($side_stories_section_2 as $story): ?>
                            <li class="list-group-item bg-transparent px-0 py-3">
                                <?php if(!empty($story['category_name'])): ?><small class="text-uppercase text-danger fw-bold custom-side-list-category"><?php echo esc_html($story['category_name']); ?></small><?php endif; ?>
                                <h5 class="h6 mb-1 custom-side-list-title"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($story['slug'])); ?>" class="text-decoration-none"><?php echo esc_html($story['title']); ?></a></h5>
                            </li>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <li class="list-group-item bg-transparent px-0 text-muted">Cerita lainnya akan segera hadir.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Section Header: Research that changes lives -->
    <section class="py-4 section-divider-header">
        <div class="container">
            <header class="text-start mb-0"> <h2 class="section-title-divider h3 fw-bold">Riset yang Mengubah Kehidupan</h2> </header>
            <hr class="mt-1 mb-5 hr-divider" />
        </div>
    </section>

    <!-- Alternating Media+Text Blocks -->
    <?php $layout_left_C = true; foreach($media_text_blocks as $block): if(!$block) continue; ?>
    <section class="py-4 section-media-text-C">
        <div class="container">
            <div class="row align-items-center g-lg-5 <?php echo $layout_left_C ? '' : 'flex-row-reverse'; ?>">
                <div class="col-md-6 mb-4 mb-md-0">
                    <?php if($block['featured_image_url']): ?>
                    <a href="<?php echo resolve_url('article.php?slug=' . esc_html($block['slug'])); ?>">
                        <img src="<?php echo resolve_url(esc_html($block['featured_image_url'])); ?>" class="img-fluid rounded shadow-lg media-text-img" alt="<?php echo esc_html($block['title']); ?>" loading="lazy">
                    </a>
                    <?php else: ?>
                    <div class="bg-secondary rounded shadow-lg media-text-img-placeholder d-flex align-items-center justify-content-center"><span class="text-white h3">Gambar Segera Hadir</span></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6 <?php echo $layout_left_C ? 'ps-md-5' : 'pe-md-5'; ?>">
                    <p class="text-muted small text-uppercase media-text-leadin">Riset Unggulan</p>
                    <h3 class="h4 fw-bold media-text-title"><?php echo esc_html($block['title']); ?></h3>
                    <p class="text-muted media-text-excerpt"><?php echo esc_html(substr(strip_tags($block['excerpt'] ?? ''), 0, 200)) . '...'; ?></p>
                    <a href="<?php echo resolve_url('article.php?slug=' . esc_html($block['slug'])); ?>" class="btn btn-outline-primary media-text-cta">Selengkapnya <i class="fas fa-angle-right ms-1"></i></a>
                </div>
            </div>
        </div>
    </section>
    <?php $layout_left_C = !$layout_left_C; endforeach; ?>


    <!-- Section: The people behind the research (Card Grid) -->
    <section class="py-5 bg-light-subtle section-card-grid-D">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold">Tokoh di Balik Riset</h2>
                <p class="lead text-muted section-subtitle">Para ahli, peneliti, ilmuwan, dan cendekiawan yang berkontribusi setiap hari.</p>
            </header>
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                 <?php if (!empty($people_research_cards)): ?>
                    <?php foreach($people_research_cards as $card): ?>
                    <div class="col d-flex align-items-stretch">
                        <div class="card h-100 custom-card flat-card article-card-hover">
                             <?php if($card['featured_image_url']): ?>
                            <a href="<?php echo resolve_url('article.php?slug=' . esc_html($card['slug'])); ?>">
                                <img src="<?php echo resolve_url(esc_html($card['featured_image_url'])); ?>" class="card-img-top custom-card-img" alt="<?php echo esc_html($card['title']); ?>" loading="lazy">
                            </a>
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title h6 custom-card-title"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($card['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($card['title']); ?></a></h5>
                                <p class="card-text small text-muted custom-card-excerpt flex-grow-1"><?php echo esc_html(substr(strip_tags($card['excerpt'] ?? ''), 0, 100)) . '...'; ?></p>
                            </div>
                             <div class="card-footer bg-transparent border-0 pt-0">
                                <a href="<?php echo resolve_url('article.php?slug=' . esc_html($card['slug'])); ?>" class="btn btn-sm btn-outline-primary">Baca Profil</a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                     <div class="col-12"><p class="text-muted text-center">Konten untuk bagian ini sedang disiapkan.</p></div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Section Header: Progress in practice -->
     <section class="py-4 section-divider-header">
        <div class="container">
            <header class="text-start mb-0"> <h2 class="section-title-divider h3 fw-bold">Kemajuan dalam Praktik</h2> </header>
            <hr class="mt-1 mb-5 hr-divider" />
        </div>
    </section>

    <!-- Featured Stories Slider (Interstitial style) -->
    <?php if(!empty($featured_stories_slider)): ?>
    <section class="py-5 section-interstitial-slider-E">
        <div class="container">
            <div id="progressPracticeSlider" class="carousel slide" data-bs-ride="carousel" data-bs-interval="8000">
                <div class="carousel-inner">
                    <?php foreach($featured_stories_slider as $idx => $story): ?>
                    <div class="carousel-item <?php echo $idx === 0 ? 'active' : ''; ?>">
                        <div class="row align-items-center interstitial-slide-content <?php echo $idx % 2 === 0 ? '' : 'flex-md-row-reverse'; ?>">
                            <div class="col-md-6 interstitial-slide-image-col mb-4 mb-md-0">
                                 <?php if($story['featured_image_url']): ?>
                                <img src="<?php echo resolve_url(esc_html($story['featured_image_url'])); ?>" class="d-block w-100 rounded shadow-lg interstitial-slide-image" alt="<?php echo esc_html($story['title']); ?>" loading="lazy">
                                <?php else: ?>
                                <div class="bg-secondary rounded shadow-lg interstitial-slide-image-placeholder d-flex align-items-center justify-content-center"><span class="text-white h3">Gambar Segera Hadir</span></div>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-6 interstitial-slide-text-col py-3 <?php echo $idx % 2 === 0 ? 'ps-md-5' : 'pe-md-5 text-md-end'; ?>">
                                <h3 class="h4 fw-bold"><?php echo esc_html($story['title']); ?></h3>
                                <p class="text-muted lead-sm"><?php echo esc_html(substr(strip_tags($story['excerpt'] ?? ''), 0, 250)) . '...'; ?></p>
                                <a href="<?php echo resolve_url('article.php?slug=' . esc_html($story['slug'])); ?>" class="btn btn-primary">Baca Cerita <i class="fas fa-angle-right ms-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php if(count($featured_stories_slider) > 1): ?>
                <button class="carousel-control-prev" type="button" data-bs-target="#progressPracticeSlider" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#progressPracticeSlider" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Related In Focus Topics (Quick Links) -->
    <?php if(!empty($quick_links_homepage)): ?>
    <section class="py-5 bg-light-subtle section-link-list-F">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-4 col-lg-3 mb-4 mb-md-0">
                    <p class="text-muted small text-uppercase mb-1">Anda Mungkin Juga Tertarik</p>
                    <h2 class="h3 fw-bold">Topik Terkait</h2>
                </div>
                <div class="col-md-8 col-lg-9">
                    <ul class="list-unstyled row row-cols-1 row-cols-sm-2 row-cols-lg-3 mb-0 g-3">
                        <?php foreach($quick_links_homepage as $link): ?>
                        <li class="col">
                            <a href="<?php echo esc_html($link['url']); ?>" class="text-decoration-none fs-5 link-primary d-block py-2 border-bottom-on-hover" <?php echo $link['open_in_new_tab'] ? 'target="_blank" rel="noopener noreferrer"' : ''; ?>>
                                <?php echo esc_html($link['title']); ?> <i class="fas fa-angle-right fa-xs ms-1"></i>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>

</main>

<?php
// Menambahkan skrip khusus untuk halaman ini jika diperlukan
$public_page_scripts = [
    // "https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css", // CSS untuk animasi (tambahkan link di header jika pakai)
    // "https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js", // jQuery jika diperlukan untuk plugin tertentu
];
// (Jika menggunakan Animate.css, tambahkan link CSS-nya di header_public.php)

require_once PROJECT_ROOT . '/includes/footer_public.php';
?>