<?php
// public/includes/header_public.php (Versi Final dengan Fixed Main Navbar)

// Inisialisasi dasar
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__, 2)); }

// Memuat file konfigurasi dan fungsi
if (file_exists(PROJECT_ROOT . '/config.php')) {
    require_once PROJECT_ROOT . '/config.php';
} else {
    require_once PROJECT_ROOT . '/includes/db_connect.php';
    require_once PROJECT_ROOT . '/admin/includes/functions.php';
}

global $pdo, $settings, $site_title, $meta_description;

// Mengambil pengaturan situs dari database jika belum ada
if (!isset($settings) && isset($pdo)) {
    $settings = [];
    try {
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings");
        while ($row = $stmt_settings->fetch(PDO::FETCH_ASSOC)) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }
    } catch (\PDOException $e) { error_log("Error fetching settings: " . $e->getMessage()); }
}

// Fungsi untuk membangun struktur menu tree
if (!function_exists('build_public_menu_tree')) {
    function build_public_menu_tree(array &$elements, $parentId = null) {
        $branch = [];
        foreach ($elements as $key => &$element) {
            if ($element['parent_id'] == $parentId) {
                $children = build_public_menu_tree($elements, $element['id']);
                if ($children) {
                    $element['children'] = $children;
                }
                $branch[$element['id']] = $element;
            }
        }
        return $branch;
    }
}

// Fungsi untuk mengambil semua item menu dari database
if (!function_exists('get_all_public_menus')) {
    function get_all_public_menus($pdo) {
        $menus = [];
        try {
            $sql = "SELECT m.location, mi.* FROM portal_menus m JOIN portal_menu_items mi ON m.id = mi.menu_id ORDER BY m.location, mi.parent_id ASC, mi.item_order ASC";
            $stmt = $pdo->query($sql);
            $all_items = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $items_by_location = [];
            foreach ($all_items as $item) {
                $items_by_location[$item['location']][] = $item;
            }
            foreach ($items_by_location as $location => $items) {
                $menus[$location] = build_public_menu_tree($items);
            }
        } catch (\PDOException $e) {
            error_log("Error fetching all public menus: " . $e->getMessage());
        }
        return $menus;
    }
}

// Fungsi untuk merender menu menjadi HTML
if (!function_exists('render_public_menu_items')) {
    function render_public_menu_items($items, $is_submenu = false, $ul_class_override = null) {
        $html = ''; if (empty($items)) return $html;
        $ul_class = $ul_class_override ? $ul_class_override : ($is_submenu ? 'dropdown-menu shadow-sm' : 'navbar-nav');
        $ul_attributes = $is_submenu ? ' aria-labelledby="navbarDropdownMenuLink' . ($items[array_key_first($items)]['parent_id'] ?? rand()) . '"' : '';
        $html .= '<ul class="' . $ul_class . '"' . $ul_attributes . '>';
        foreach ($items as $item) {
            $has_children = !empty($item['children']);
            $li_class = 'nav-item' . ($has_children && !$is_submenu ? ' dropdown' : '');
            $a_class = $is_submenu ? 'dropdown-item' : 'nav-link px-lg-3' . ($has_children && !$is_submenu ? ' dropdown-toggle' : '');
            $current_page_path = $_SERVER['PHP_SELF'] ?? '';
            $menu_item_path = parse_url($item['url'], PHP_URL_PATH) ?? '';
            if (basename($current_page_path) == basename($menu_item_path) && $item['url'] != '#') {
                if(!$is_submenu) $a_class .= ' active';
            }
            $html .= '<li class="' . $li_class . '">';
            $item_url = esc_html((strpos($item['url'], 'http') === 0 || substr($item['url'], 0, 1) === '#') ? $item['url'] : resolve_url($item['url']));
            $html .= '<a class="' . $a_class . '" href="' . $item_url . '"';
            if ($has_children && !$is_submenu) { $html .= ' id="navbarDropdownMenuLink' . $item['id'] . '" role="button" data-bs-toggle="dropdown" aria-expanded="false"'; }
            if (!empty($item['target']) && $item['target'] === '_blank') { $html .= ' target="_blank" rel="noopener noreferrer"'; }
            $html .= '>';
            if (!empty($item['icon_class'])) {
                $html .= '<i class="' . esc_html($item['icon_class']) . ' me-2"></i>';
            }
            $html .= esc_html($item['title']);
            $html .= '</a>';
            if ($has_children) { $html .= render_public_menu_items($item['children'], true); }
            $html .= '</li>';
        } $html .= '</ul>'; return $html;
    }
}

// Menyiapkan variabel dinamis untuk digunakan di HTML
$all_menus = isset($pdo) ? get_all_public_menus($pdo) : [];
$current_theme = $_COOKIE['theme'] ?? 'light-theme';
$site_name_display = esc_html($settings['site_name'] ?? 'Universitas Graha Karya');
$site_logo_url_display = isset($settings['site_logo_url']) && !empty($settings['site_logo_url']) ? esc_html(resolve_url($settings['site_logo_url'])) : resolve_url('public/assets/images/logo_ugk.png');
$site_favicon_url_display = isset($settings['site_favicon_url']) && !empty($settings['site_favicon_url']) ? esc_html(resolve_url($settings['site_favicon_url'])) : resolve_url('public/assets/images/favicon.ico');
$page_title_display = isset($site_title) ? $site_title . ' - ' . $site_name_display : $site_name_display;
$page_meta_desc_display = isset($meta_description) ? $meta_description : esc_html($settings['site_tagline'] ?? 'Deskripsi default situs.');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title_display; ?></title>
    <meta name="description" content="<?php echo $page_meta_desc_display; ?>">

    <link rel="icon" href="<?php echo $site_favicon_url_display; ?>" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800&family=Montserrat:ital,wght@0,100..900;1,100..900&family=Raleway:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <link rel="stylesheet" href="<?php echo resolve_url('public/assets/css/theme.css'); ?>">
    <link rel="stylesheet" href="<?php echo resolve_url('public/assets/css/style.css'); ?>">
    
    <style>
        :root { --ugkmb-primary: #006400; --ugkmb-secondary: #98fb98; }
        #preloader { position: fixed; top: 0; left: 0; right: 0; bottom: 0; z-index: 9999; background: #fff; display: flex; align-items: center; justify-content: center; transition: opacity 0.5s ease-out, visibility 0.5s ease-out; }
        #preloader.preloader-hidden { opacity: 0; visibility: hidden; }
        .preloader-logo { max-width: 150px; animation: preloader-pulse 1.5s ease-in-out infinite; }
        @keyframes preloader-pulse { 0%, 100% { transform: scale(1); opacity: 1; } 50% { transform: scale(1.05); opacity: 0.8; } }

        .header-logo-area { background-color: #fff; padding: 1.5rem 0; }
        .logo-title-container { display: flex; align-items: center; justify-content: center; }
        .logo-title-container img { max-height: 90px; margin-right: 25px; }
        .logo-title-container h1 { font-size: clamp(2rem, 5vw, 2.8rem); color: var(--ugkmb-primary); font-weight: 700; margin: 0; }
        
        .header-menu-area { background-color: #333; transition: all 0.3s ease-in-out; }
        .header-menu-area.fixed-top { position: fixed; top: 0; left: 0; right: 0; z-index: 1030; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        body { padding-top: 0; /* Dihapus dari sini, diatur oleh JS */ }
        .header-placeholder { display: none; } /* Placeholder dinamis */
        
        .header-menu-area .navbar-nav .nav-link { color: #fff !important; font-weight: 600; text-transform: uppercase; padding: 1rem 1.25rem; border-bottom: 3px solid transparent; transition: border-color 0.3s ease; }
        .header-menu-area .navbar-nav .nav-link:hover, .header-menu-area .navbar-nav .nav-link.active { color: var(--ugkmb-secondary) !important; border-bottom-color: var(--ugkmb-secondary); }

        #chat-toggle-button { position: fixed; bottom: 20px; left: 20px; width: 60px; height: 60px; z-index: 1050; box-shadow: 0 2px 10px rgba(0,0,0,0.2); transition: transform 0.3s ease; border: none; border-radius: 50%; background-color: var(--ugkmb-primary); color: white; display:flex; align-items:center; justify-content:center; font-size:1.5rem;}
        #chat-toggle-button:hover { transform: scale(1.1); }
        #chat-widget-container { position: fixed; bottom: 90px; left: 20px; width: 370px; height: 550px; max-width: calc(100vw - 40px); max-height: calc(100vh - 110px); z-index: 1049; border-radius: 15px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.3); background-color: #fff; opacity: 0; transform: translateY(20px); transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0.3s; visibility: hidden; }
        #chat-widget-container.show { opacity: 1; transform: translateY(0); visibility: visible; transition: opacity 0.3s ease, transform 0.3s ease; }
        #chat-widget-container iframe { width: 100%; height: 100%; border: none; }
    </style>
</head>
<body class="<?php echo esc_html($current_theme); ?>">

<div id="preloader">
    <img src="<?php echo resolve_url('public/assets/images/logo_ugk.png'); ?>" alt="Memuat..." class="preloader-logo">
</div>

<header class="full-width-header">
    <div class="header-logo-area">
        <div class="container">
            <div class="logo-title-container">
                <a href="<?php echo resolve_url('index.php'); ?>">
                    <img src="<?php echo $site_logo_url_display; ?>" alt="Logo <?php echo $site_name_display; ?>">
                </a>
                <h1><?php echo $site_name_display; ?></h1>
            </div>
        </div>
    </div>
    <div class="header-menu-area shadow-sm">
        <nav class="navbar navbar-expand-lg">
            <div class="container">
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavPublic" aria-controls="navbarNavPublic" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNavPublic">
                    <?php
                    if (!empty($all_menus['primary_nav'])) {
                        echo render_public_menu_items($all_menus['primary_nav'], false, 'navbar-nav mx-auto mb-2 mb-lg-0');
                    } else {
                    ?>
                    <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
                        <li class="nav-item"><a class="nav-link px-lg-3 active" href="#">Beranda</a></li>
                    </ul>
                    <?php } ?>
                </div>
            </div>
        </nav>
    </div>
</header>
<div class="header-placeholder"></div>
<main id="main-content">