<?php
// public/includes/header_public.php - Updated for Multi-Level Dropdown
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__, 2)); }

if (file_exists(PROJECT_ROOT . '/config.php')) {
    require_once PROJECT_ROOT . '/config.php';
} else {
    require_once PROJECT_ROOT . '/includes/db_connect.php';
    require_once PROJECT_ROOT . '/admin/includes/functions.php';
}

global $pdo, $settings, $site_title, $meta_description;

if (!isset($settings) && isset($pdo)) {
    $settings = [];
    try {
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings");
        while ($row = $stmt_settings->fetch(PDO::FETCH_ASSOC)) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }
    } catch (\PDOException $e) { error_log("Error fetching settings: " . $e->getMessage()); }
}

$primary_menu_items = [];
if (isset($pdo)) {
    try {
        $stmt_menu_group = $pdo->prepare("SELECT id FROM portal_menus WHERE location = 'primary_nav' LIMIT 1");
        $stmt_menu_group->execute();
        if ($menu_group_id = $stmt_menu_group->fetchColumn()) {
            $stmt_items = $pdo->prepare("SELECT * FROM portal_menu_items WHERE menu_id = :menu_id ORDER BY parent_id ASC, item_order ASC");
            $stmt_items->execute([':menu_id' => $menu_group_id]);
            $raw_items = $stmt_items->fetchAll(PDO::FETCH_ASSOC);

            if (!function_exists('build_public_menu_tree_multi')) { // Renamed function
                function build_public_menu_tree_multi(array $elements, $parentId = null) {
                    $branch = [];
                    foreach ($elements as $element) {
                        // Check if parent_id is NULL for top level, or matches the parentId for sub levels
                        if (($parentId === null && $element['parent_id'] === null) || $element['parent_id'] == $parentId) {
                            $children = build_public_menu_tree_multi($elements, $element['id']);
                            if ($children) {
                                $element['children'] = $children;
                            }
                            $branch[$element['id']] = $element;
                        }
                    }
                    return $branch;
                }
            }
            $primary_menu_items = build_public_menu_tree_multi($raw_items);
        }
    } catch (\PDOException $e) { error_log("Error fetching menu: " . $e->getMessage()); }
}

// =========================================================================
// === FUNGSI RENDER MENU DIPERBARUI UNTUK MULTI-LEVEL DROPDOWN ===
// =========================================================================
if (!function_exists('render_public_menu_items_multi')) { // Renamed function
    function render_public_menu_items_multi($items, $level = 0) {
        $html = '';
        if (empty($items)) return $html;

        // Tentukan kelas UL berdasarkan level
        $ul_class = 'navbar-nav mx-auto mb-2 mb-lg-0'; // Level 0 (utama)
        if ($level > 0) {
            $ul_class = 'dropdown-menu shadow-sm'; // Level 1+ (submenu)
        }

        // Atribut tambahan untuk submenu
        $ul_attributes = '';
        if ($level > 0 && !empty($items)) {
             // Dapatkan parent_id dari item pertama (seharusnya sama untuk semua item di level ini)
             $first_item = reset($items); // Ambil elemen pertama dari array
             $parent_id_attr = $first_item['parent_id'] ?? rand(); // Fallback jika tidak ada parent_id
             $ul_attributes = ' aria-labelledby="navbarDropdownMenuLink' . $parent_id_attr . '"';
        }


        $html .= '<ul class="' . $ul_class . '"' . $ul_attributes . '>';

        foreach ($items as $item) {
            $has_children = !empty($item['children']);
            $is_submenu_item = ($level > 0);

            // Tentukan kelas LI
            $li_class = 'nav-item';
            if ($has_children) {
                $li_class .= ' dropdown';
                // Tambahkan kelas khusus jika ini adalah submenu yang punya submenu lagi
                if ($is_submenu_item) {
                     $li_class .= ' dropdown-submenu';
                }
            }

            // Tentukan kelas A
            $a_class = 'nav-link px-lg-3';
             if ($is_submenu_item) {
                 $a_class = 'dropdown-item';
             }
             if ($has_children) {
                 $a_class .= ' dropdown-toggle';
             }

            // Cek halaman aktif (logika sebelumnya)
            $current_page_path = $_SERVER['PHP_SELF'] ?? '';
            $menu_item_path = parse_url($item['url'], PHP_URL_PATH) ?? '';
            $is_active = (basename($current_page_path) == basename($menu_item_path));
            if ($is_active && !$is_submenu_item) { // Hanya aktifkan di level utama
                $a_class .= ' active';
            }

            $html .= '<li class="' . $li_class . '">';

            $item_url = esc_html((strpos($item['url'], 'http') === 0 || substr($item['url'], 0, 1) === '#') ? $item['url'] : resolve_url($item['url']));

            $html .= '<a class="' . $a_class . '" href="' . $item_url . '"';
            // Atribut data-bs-toggle hanya untuk level utama dan submenu pertama
            if ($has_children && $level < 2) { // Batasi data-bs-toggle hingga level 1
                 $html .= ' id="navbarDropdownMenuLink' . $item['id'] . '" role="button" data-bs-toggle="dropdown" aria-expanded="false"';
            }
            // Atribut target blank
            if (!empty($item['target']) && $item['target'] === '_blank') {
                $html .= ' target="_blank" rel="noopener noreferrer"';
            }
            $html .= '>' . esc_html($item['title']);
            // Tambahkan ikon panah untuk submenu di level > 0
            if ($has_children && $is_submenu_item) {
                $html .= ' <i class="fas fa-caret-right fa-sm ms-1"></i>'; // Ikon panah kanan kecil
            }
            $html .= '</a>';

            // Rekursif untuk anak-anaknya
            if ($has_children) {
                $html .= render_public_menu_items_multi($item['children'], $level + 1); // Naikkan level
            }

            $html .= '</li>';
        }
        $html .= '</ul>';
        return $html;
    }
}
// =========================================================================
// === AKHIR FUNGSI RENDER MENU ===
// =========================================================================


$current_theme = $_COOKIE['theme'] ?? 'light-theme';
$site_name_display = esc_html($settings['site_name'] ?? 'Universitas Graha Karya');
$site_logo_url_display = isset($settings['site_logo_url']) && !empty($settings['site_logo_url']) ? esc_html(resolve_url($settings['site_logo_url'])) : resolve_url('public/assets/images/logo_ugk.png');
$site_favicon_url_display = isset($settings['site_favicon_url']) && !empty($settings['site_favicon_url']) ? esc_html(resolve_url($settings['site_favicon_url'])) : resolve_url('public/assets/images/favicon.ico');
$page_title_display = isset($site_title) ? $site_title . ' - ' . $site_name_display : $site_name_display;
$page_meta_desc_display = isset($meta_description) ? $meta_description : esc_html($settings['site_tagline'] ?? 'Deskripsi default situs.');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title_display; ?></title>
    <meta name="description" content="<?php echo $page_meta_desc_display; ?>">

    <link rel="icon" href="<?php echo $site_favicon_url_display; ?>" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="<?php echo resolve_url('public/assets/css/theme.css'); ?>">
    <link rel="stylesheet" href="<?php echo resolve_url('public/assets/css/style.css'); ?>">
    <!-- Font Awesome 5 (jika masih diperlukan, tapi 6 sudah ada) -->
    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" /> -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,600;1,700&family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Raleway:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">

    <style>
    /* ... (CSS sebelumnya untuk navbar wrap, widget, header umum tetap di sini) ... */

/* ===== BARU: CSS untuk membuat navbar wrap otomatis ===== */
@media (min-width: 992px) {
    #navbarNavPublic.navbar-collapse {
        display: flex !important; flex-basis: auto !important; flex-grow: 1;
    }
    .header-menu-area .navbar-nav {
        flex-direction: row; flex-wrap: wrap; width: 100%; justify-content: center;
    }
}
/* --- Generic Widget Styles --- */
.widget-toggle-button { position: fixed; bottom: 20px; width: 60px; height: 60px; z-index: 1050; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2); transition: transform 0.3s ease, bottom 0.3s ease; }
.widget-toggle-button:hover { transform: scale(1.1); }
.widget-container { position: fixed; bottom: 90px; width: 370px; height: 550px; z-index: 1049; border-radius: 15px; overflow: hidden; box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3); background-color: #fff; opacity: 0; transform: translateY(20px) scale(0.95); transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0.3s; visibility: hidden; }
.widget-container.show { opacity: 1; transform: translateY(0) scale(1); visibility: visible; transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0s; }
.widget-container iframe { width: 100%; height: 100%; border: none; }
#chat-toggle-button { left: 20px; }
#chat-widget-container { left: 20px; }
#cs-toggle-button { right: 120px; }
#cs-widget-container { right: 20px; }
@media (max-width: 768px) {
  #chat-toggle-button { left: auto; right: 20px; bottom: 90px; }
  #chat-widget-container { left: auto; right: 20px; }
}
/* --- Header Styles --- */
body { padding-top: 0; }
.header-logo-area { background-color: #f0c000; padding: 1.5rem 0; }
.logo-title-container { display: flex; align-items: center; justify-content: center; }
.logo-title-container img { max-height: 90px; margin-right: 25px; }
.logo-title-container h1 { font-size: 2.8rem; color: #006400; font-weight: 700; margin: 0; line-height: 1.2; }
.header-menu-area { background-color: #333; }
.header-menu-area .navbar { background-color: transparent !important; }
.header-menu-area .navbar-nav .nav-link { color: #fff !important; font-weight: 600; text-transform: uppercase; padding: 1rem 1.25rem; border-bottom: 3px solid transparent; transition: border-color 0.3s ease; }
.header-menu-area .navbar-nav .nav-link:hover,
.header-menu-area .navbar-nav .nav-link.active { color: #98fb98 !important; border-bottom-color: #98fb98; }
.navbar-toggler { border-color: rgba(255,255,255,0.5); }
.navbar-toggler-icon { background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.8%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e"); }
@media (max-width: 991px) {
    .logo-title-container { flex-direction: column; text-align: center; }
    .logo-title-container img { margin-right: 0; margin-bottom: 15px; }
    .logo-title-container h1 { font-size: 2rem; }
    .navbar-collapse { background-color: #333; padding: 1rem; border-top: 1px solid #444; }
}
/* --- Chat Widget Styles (Duplikat, bisa dihapus jika sudah ada di atas) --- */
/* ... */


    /* ================================================== */
    /* === CSS BARU UNTUK MULTI-LEVEL DROPDOWN (DESKTOP) === */
    /* ================================================== */
    @media (min-width: 992px) {
        .dropdown-menu .dropdown-submenu {
            position: relative; /* Diperlukan agar submenu absolut terhadap parent ini */
        }

        /* Styling dasar submenu level 2+ */
        .dropdown-menu .dropdown-submenu .dropdown-menu {
            top: 0;
            left: 100%; /* Posisikan ke kanan parent */
            margin-top: -1px; /* Sedikit overlap agar tidak ada celah */
            margin-left: 0.1rem;
            border-radius: 0.25rem; /* Samakan radius border */
            display: none; /* Sembunyikan secara default */
            position: absolute; /* Penting untuk positioning */
        }

        /* Tampilkan submenu level 2+ saat parent di-hover */
        .dropdown-menu .dropdown-submenu:hover > .dropdown-menu {
            display: block; /* Tampilkan saat hover */
        }

        /* Styling link di dalam submenu yang punya anak lagi */
        .dropdown-menu .dropdown-submenu > .dropdown-item.dropdown-toggle::after {
            /* Sembunyikan panah default bootstrap jika ada, kita pakai FontAwesome */
            display: none;
        }
        /* Ikon panah FontAwesome yang ditambahkan di PHP */
        .dropdown-menu .dropdown-submenu > .dropdown-item .fa-caret-right {
             /* Atur posisi ikon panah jika perlu */
             margin-left: auto; /* Pindahkan ke paling kanan */
        }
    }

    /* Penyesuaian untuk Mobile (opsional, multi-level dropdown sulit di mobile) */
    @media (max-width: 991px) {
         /* Mungkin perlu styling khusus agar submenu tidak tumpang tindih */
         .dropdown-menu .dropdown-submenu .dropdown-menu {
             /* Reset posisi absolut */
             position: static;
             display: none; /* Tetap sembunyikan awalnya */
             width: 100%;
             margin-top: 0;
             margin-left: 0;
             border: none;
             box-shadow: none;
             background-color: rgba(0,0,0,0.1); /* Sedikit bedakan background */
         }
         /* Tampilkan submenu level 2+ saat parent diklik (memerlukan JS tambahan, CSS ini hanya visual) */
         .dropdown-menu .dropdown-submenu.show > .dropdown-menu {
             display: block;
         }
         /* Ubah ikon panah */
         .dropdown-menu .dropdown-submenu > .dropdown-item .fa-caret-right {
             display: none; /* Sembunyikan panah kanan */
         }
         .dropdown-menu .dropdown-submenu > .dropdown-item.dropdown-toggle::after {
             /* Tampilkan panah bawah default bootstrap lagi */
             display: inline-block;
             vertical-align: 0.255em;
             content: "";
             border-top: 0.3em solid;
             border-right: 0.3em solid transparent;
             border-bottom: 0;
             border-left: 0.3em solid transparent;
             margin-left: 0.255em;
         }
    }
    /* === AKHIR CSS MULTI-LEVEL DROPDOWN === */

    </style>
</head>
<body class="<?php echo esc_html($current_theme); ?>">

    <header class="full-width-header">
        <div class="header-logo-area">
            <div class="container">
                <div class="logo-title-container">
                    <div class="logo-area">
                        <a href="<?= resolve_url('index.php') ?>">
                            <img src="<?= $site_logo_url_display ?>" alt="Logo UGK">
                        </a>
                    </div>
                    <div class="site-title-area">
                        <h1><?= $site_name_display ?></h1>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-menu-area shadow-sm">
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavPublic" aria-controls="navbarNavPublic" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarNavPublic">
                        <?php
                        // Panggil fungsi render menu yang sudah diperbarui
                        if (!empty($primary_menu_items)) {
                            echo render_public_menu_items_multi($primary_menu_items, 0); // Mulai dari level 0
                        } else {
                            // Menu fallback
                            $current_page_basename_header = basename($_SERVER['PHP_SELF'] ?? '');
                        ?>
                        <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
                            <li class="nav-item"><a class="nav-link px-lg-3 <?php echo ($current_page_basename_header == 'index.php') ? 'active' : ''; ?>" href="<?php echo resolve_url('index.php'); ?>">Beranda</a></li>
                            <li class="nav-item"><a class="nav-link px-lg-3" href="#">Akademik</a></li>
                            <li class="nav-item"><a class="nav-link px-lg-3" href="<?php echo resolve_url('contact.php'); ?>">Kontak</a></li>
                        </ul>
                        <?php } ?>
                    </div>
                </div>
            </nav>
        </div>
        </header>

    <main id="main-content">
        <!-- Konten Halaman Anda -->
