<?php
// public/faculties.php (Listing all faculties)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
$project_root = dirname(__DIR__);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php'; // For resolve_url, esc_html

$site_title = "Daftar Fakultas";
$meta_description = "Jelajahi berbagai fakultas yang ada di UGKMB.";

$faculties = [];
if (isset($pdo)) {
    try {
        // Fetch all faculties, ordered by 'faculty_order' then 'name'
        // We also count the number of active study programs for each faculty
        $stmt = $pdo->query("SELECT f.id, f.name, f.slug, f.description_html, f.website_url, 
                                    (SELECT COUNT(sp.id) FROM portal_study_programs sp WHERE sp.faculty_id = f.id AND sp.is_active = 1) as active_study_programs_count
                             FROM portal_faculties f
                             ORDER BY f.faculty_order ASC, f.name ASC");
        $faculties = $stmt->fetchAll();
    } catch (\PDOException $e) {
        error_log("Error fetching faculties list: " . $e->getMessage());
        // Set a user-friendly error message if needed
    }
}

// Fetch global settings for header/footer
$settings = []; // Will be populated by header_public.php
$theme = $_COOKIE['theme'] ?? 'light-theme'; // For body class

// Include header
require_once PROJECT_ROOT . '/public/includes/header_public.php';
?>

<main class="container py-5">
    <div class="row">
        <div class="col-lg-12">
            <header class="mb-5 text-center">
                <h1 class="display-4 fw-bold"><?php echo $site_title; ?></h1>
                <p class="lead text-muted"><?php echo $meta_description; ?></p>
            </header>

            <?php if (isset($_SESSION['flash_message'])): ?>
                <div class="alert alert-<?php echo $_SESSION['flash_message']['type']; ?> alert-dismissible fade show" role="alert">
                    <?php echo $_SESSION['flash_message']['text']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php unset($_SESSION['flash_message']); ?>
            <?php endif; ?>

            <?php if (!empty($faculties)): ?>
                <div class="row row-cols-1 row-cols-md-2 g-4">
                    <?php foreach ($faculties as $faculty): ?>
                    <div class="col">
                        <div class="card h-100 shadow-sm faculty-card">
                            <div class="card-body">
                                <h3 class="card-title h4"><a href="<?php echo resolve_url('faculty.php?slug=' . esc_html($faculty['slug'])); ?>" class="text-decoration-none stretched-link faculty-title-link"><?php echo esc_html($faculty['name']); ?></a></h3>
                                <?php
                                $description_excerpt = !empty($faculty['description_html']) ? strip_tags($faculty['description_html']) : 'Informasi lebih lanjut mengenai fakultas ini.';
                                ?>
                                <p class="card-text faculty-excerpt"><?php echo esc_html(substr($description_excerpt, 0, 150)) . (strlen($description_excerpt) > 150 ? '...' : ''); ?></p>
                                <p class="card-text"><small class="text-muted">Jumlah Program Studi Aktif: <?php echo $faculty['active_study_programs_count']; ?></small></p>
                                <?php if (!empty($faculty['website_url'])): ?>
                                    <a href="<?php echo esc_html($faculty['website_url']); ?>" class="btn btn-sm btn-outline-primary mt-2" target="_blank" rel="noopener noreferrer">
                                        <i class="fas fa-globe me-1"></i> Website Fakultas
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="alert alert-info text-center" role="alert">
                    Tidak ada informasi fakultas yang tersedia saat ini.
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php
require_once $project_root . '/includes/footer_public.php';
?>
