<?php
// public/contact_tailwind_new.php

// 1. Load Konfigurasi Utama BARU (WAJIB PALING ATAS)
// Ini akan mendefinisikan PROJECT_ROOT, BASE_URL, memulai session, error reporting,
// membuat koneksi $pdo, memuat $settings, dan functions_new.php.
if (file_exists(dirname(__DIR__) . '/config_new.php')) {
    require_once dirname(__DIR__) . '/config_new.php';
} else {
    // Fallback jika config_new.php tidak ada di root proyek
    if (!defined('PROJECT_ROOT')) {
        define('PROJECT_ROOT', dirname(__DIR__)); // Asumsi contact_tailwind_new.php ada di 'public'
    }
    // Coba include file-file penting secara manual (kurang ideal)
    $manual_includes_ok = true;
    if (file_exists(PROJECT_ROOT . '/includes/db_connect_new.php')) {
        require_once PROJECT_ROOT . '/includes/db_connect_new.php';
    } else { $manual_includes_ok = false; error_log("FATAL: db_connect_new.php not found"); }

    if (file_exists(PROJECT_ROOT . '/admin/includes/functions_new.php')) {
        require_once PROJECT_ROOT . '/admin/includes/functions_new.php';
    } else { $manual_includes_ok = false; error_log("FATAL: functions_new.php not found"); }
    
    if (session_status() == PHP_SESSION_NONE) { session_start(); }

    if (!$manual_includes_ok) {
        die("Kesalahan konfigurasi sistem inti. Harap hubungi administrator. (Error Code: CFG01)");
    }
}

// Pastikan variabel global $pdo dan $settings tersedia dari config_new.php
global $pdo, $settings;
if (!isset($pdo)) {
    error_log("FATAL ERROR: \$pdo not available in contact_tailwind_new.php after config.");
    die("Kesalahan database (CNT-PDO). Harap hubungi administrator.");
}
if (!isset($settings) || !is_array($settings)) {
    $settings = []; // Inisialisasi jika config_new.php gagal memuatnya
    // Coba muat settings sekali lagi jika perlu (sebagai darurat)
    try {
        $stmt_s = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
        while ($row_s = $stmt_s->fetch(PDO::FETCH_ASSOC)) {
            $settings[$row_s['setting_key']] = $row_s['setting_value'];
        }
    } catch (\PDOException $e) { /* biarkan kosong jika gagal, get_site_setting akan return default */ }
}


// 2. Metadata Halaman (akan digunakan oleh header_public_new.php)
// Menggunakan logika dari script contact.php (Bootstrap) yang Anda berikan
$page_title_for_layout = "Hubungi Kami"; // Default
if (!empty($settings['site_name'])) {
    $page_title_for_layout .= " - " . esc_html($settings['site_name']);
}
$page_meta_description_for_layout = !empty($settings['contact_page_meta_description']) ? esc_html($settings['contact_page_meta_description']) : "Kirimkan pesan, pertanyaan, atau saran Anda kepada " . esc_html($settings['site_name'] ?? 'Universitas Graha Karya Muara Bulian') . ".";


// 3. Penanganan Session Form (dari script PHP yang Anda berikan)
$form_data = $_SESSION['form_data'] ?? [
    'sender_name' => '', 'sender_email' => '', 'sender_phone' => '', 
    'subject' => '', 'message_content' => ''
];
$form_errors = $_SESSION['form_errors'] ?? [];

// Panggil clear_form_session_data() jika ada, jika tidak unset manual
if (function_exists('clear_form_session_data')) {
    clear_form_session_data();
} else {
    unset($_SESSION['form_data']);
    unset($_SESSION['form_errors']);
}


// 4. Proses Form (POST Request) - Menggunakan logika dari script PHP yang Anda berikan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !function_exists('validate_csrf_token') || !validate_csrf_token($_POST['csrf_token'])) {
        if(function_exists('set_flash_message')) set_flash_message('danger', 'Kesalahan validasi keamanan (CSRF). Silakan coba lagi.');
        $_SESSION['form_data'] = $_POST; // Persist form data
        header('Location: ' . resolve_url('public/contact_tailwind_new.php')); // Redirect ke file ini
        exit;
    }

    // Ambil & Sanitize Data (menggunakan trim seperti di script Anda)
    $submitted_data_from_form = [
        'sender_name'     => trim($_POST['sender_name'] ?? ''),
        'sender_email'    => trim($_POST['sender_email'] ?? ''),
        'sender_phone'    => trim($_POST['sender_phone'] ?? ''),
        'subject'         => trim($_POST['subject'] ?? ''),
        'message_content' => trim($_POST['message_content'] ?? '')
    ];
    
    $current_validation_errors = []; 

    if (empty($submitted_data_from_form['sender_name'])) {
        $current_validation_errors['sender_name'] = 'Nama lengkap wajib diisi.';
    } elseif (strlen($submitted_data_from_form['sender_name']) > 100) {
        $current_validation_errors['sender_name'] = 'Nama lengkap maksimal 100 karakter.';
    }

    if (empty($submitted_data_from_form['sender_email'])) {
        $current_validation_errors['sender_email'] = 'Email wajib diisi.';
    } elseif (!filter_var($submitted_data_from_form['sender_email'], FILTER_VALIDATE_EMAIL)) {
        $current_validation_errors['sender_email'] = 'Format email tidak valid.';
    } elseif (strlen($submitted_data_from_form['sender_email']) > 100) {
        $current_validation_errors['sender_email'] = 'Email maksimal 100 karakter.';
    }
    
    if (!empty($submitted_data_from_form['sender_phone']) && !preg_match('/^[0-9\-\+\s\(\)\/\.]{7,20}$/', $submitted_data_from_form['sender_phone'])) {
        $current_validation_errors['sender_phone'] = 'Format nomor telepon tidak valid.';
    }

    if (empty($submitted_data_from_form['subject'])) {
        $current_validation_errors['subject'] = 'Subjek wajib diisi.';
    } elseif (strlen($submitted_data_from_form['subject']) > 200) {
        $current_validation_errors['subject'] = 'Subjek maksimal 200 karakter.';
    }

    if (empty($submitted_data_from_form['message_content'])) {
        $current_validation_errors['message_content'] = 'Isi pesan wajib diisi.';
    } elseif (strlen($submitted_data_from_form['message_content']) > 5000) {
        $current_validation_errors['message_content'] = 'Isi pesan maksimal 5000 karakter.';
    }

    if (empty($current_validation_errors)) {
        if (isset($pdo)) {
            try {
                // Menggunakan query INSERT dari script Anda (termasuk updated_at)
                $stmt_insert_msg = $pdo->prepare("INSERT INTO portal_contact_messages
                                                (sender_name, sender_email, sender_phone, subject, message_content, ip_address, user_agent, created_at, updated_at, status)
                                                VALUES (:name, :email, :phone, :subject, :message, :ip, :ua, NOW(), NOW(), 'unread')"); // Tambah status default
                
                $ip_addr_contact = $_SERVER['REMOTE_ADDR'] ?? null;
                $user_agent_contact_info = isset($_SERVER['HTTP_USER_AGENT']) ? substr($_SERVER['HTTP_USER_AGENT'],0,255) : null;
                $phone_val_to_db = !empty($submitted_data_from_form['sender_phone']) ? $submitted_data_from_form['sender_phone'] : null;


                $stmt_insert_msg->execute([
                    ':name'    => $submitted_data_from_form['sender_name'],
                    ':email'   => $submitted_data_from_form['sender_email'],
                    ':phone'   => $phone_val_to_db,
                    ':subject' => $submitted_data_from_form['subject'],
                    ':message' => $submitted_data_from_form['message_content'],
                    ':ip'      => $ip_addr_contact,
                    ':ua'      => $user_agent_contact_info
                ]);
                
                if(function_exists('set_flash_message')) set_flash_message('success', 'Pesan Anda telah berhasil terkirim. Terima kasih!');
                
                $recipient_email_val = get_site_setting('contact_form_recipient_email');
                $site_name_val_email = get_site_setting('site_name', 'UGKMB Website');

                if ($recipient_email_val && filter_var($recipient_email_val, FILTER_VALIDATE_EMAIL)) {
                    $email_subj_admin = "Pesan Baru dari Form Kontak (" . $site_name_val_email . "): " . $submitted_data_from_form['subject'];
                    $email_body_admin = "Anda menerima pesan baru dari formulir kontak website:\n\n" .
                                         "Nama: " . $submitted_data_from_form['sender_name'] . "\n" .
                                         "Email: " . $submitted_data_from_form['sender_email'] . "\n" .
                                         "Telepon: " . ($phone_val_to_db ?: '-') . "\n" .
                                         "Subjek: " . $submitted_data_from_form['subject'] . "\n\n" .
                                         "Pesan:\n" . $submitted_data_from_form['message_content'] . "\n\n" .
                                         "IP Address: " . $ip_addr_contact . "\n" .
                                         "User Agent: " . $user_agent_contact_info;
                    $base_url_host_val = defined('BASE_URL') ? parse_url(BASE_URL, PHP_URL_HOST) : ($_SERVER['SERVER_NAME'] ?? 'localhost');
                    $from_email_domain_val = str_replace('www.', '', $base_url_host_val);
                    $email_headers = "From: " . $site_name_val_email . " <noreply@" . $from_email_domain_val . ">\r\n" .
                               "Reply-To: " . $submitted_data_from_form['sender_email'] . "\r\n" .
                               "X-Mailer: PHP/" . phpversion();
                    
                    // @mail($recipient_email_val, $email_subj_admin, $email_body_admin, $email_headers);
                     error_log("Contact form email (not sent, @mail commented): " . $recipient_email_val . " Subj: " . $email_subj_admin);
                }
                
                // Tidak perlu clear session $_SESSION['form_data'] di sini karena redirect akan membersihkannya untuk request berikutnya
                // Namun, jika ingin form kosong setelah sukses, pastikan $form_data di atas halaman diset ulang
                // Script Anda sebelumnya mengosongkan $_SESSION['form_data'] di sini, lalu redirect
                // Hal ini membuat repopulasi setelah sukses tidak terjadi, yang mana benar.
                $_SESSION['form_data'] = [ 
                    'sender_name' => '', 'sender_email' => '', 'sender_phone' => '', 
                    'subject' => '', 'message_content' => ''
                ]; // Bersihkan untuk pengisian berikutnya jika user kembali

                header('Location: ' . resolve_url('public/contact_tailwind_new.php'));
                exit;

            } catch (\PDOException $e_contact) {
                if(function_exists('set_flash_message')) set_flash_message('danger', 'Terjadi kesalahan saat mengirim pesan. Silakan coba lagi nanti.');
                error_log("Contact form submission DB error (contact_tailwind_new.php): " . $e_contact->getMessage());
                $_SESSION['form_data'] = $submitted_data_from_form; 
                $_SESSION['form_errors'] = $current_validation_errors; // Kembalikan error validasi
                header('Location: ' . resolve_url('public/contact_tailwind_new.php'));
                exit;
            }
        } else { // $pdo tidak tersedia
             if(function_exists('set_flash_message')) set_flash_message('danger', 'Koneksi database tidak tersedia. Pesan tidak dapat dikirim.');
            $_SESSION['form_data'] = $submitted_data_from_form;
            $_SESSION['form_errors'] = $current_validation_errors;
            header('Location: ' . resolve_url('public/contact_tailwind_new.php'));
            exit;
        }
    } else { // Ada error validasi
        if(function_exists('set_flash_message')) set_flash_message('danger', 'Harap perbaiki kesalahan pada formulir.');
        $_SESSION['form_data'] = $submitted_data_from_form; 
        $_SESSION['form_errors'] = $current_validation_errors;
        header('Location: ' . resolve_url('public/contact_tailwind_new.php'));
        exit;
    }
}

// 5. Include Header BARU (Tailwind version)
// Pastikan USE_TAILWIND_CDN_HEADER di config_new.php adalah true
if (defined('USE_TAILWIND_CDN_HEADER') && USE_TAILWIND_CDN_HEADER !== true) {
    // Jika config_new.php memaksa Bootstrap, override untuk halaman ini jika perlu
    // define('USE_TAILWIND_CDN_HEADER', true); // Ini tidak bisa karena konstanta sudah didefinisi
    // Sebaiknya pastikan config_new.php sudah benar.
    // Jika tidak, header_public_new.php mungkin render versi Bootstrap.
} elseif (!defined('USE_TAILWIND_CDN_HEADER')) {
    define('USE_TAILWIND_CDN_HEADER', true); // Default ke Tailwind untuk halaman ini jika belum diset
}
require_once PROJECT_ROOT . '/includes/header_public_new.php';
?>

<main id="main-content" class="flex-grow">
    <section class="py-10 md:py-16 bg-slate-100 dark:bg-slate-900">
        <div class="container mx-auto px-4">
            <header class="mb-8 md:mb-12 text-center animate-on-scroll fade-in-up-scroll">
                <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold text-ugkmb_primary dark:text-ugkmb_secondary">
                    <?php echo esc_html(get_site_setting('contact_page_title_setting', 'Hubungi Kami')); // Ambil dari setting jika ada, atau default ?>
                </h1>
                <p class="text-lg md:text-xl text-slate-600 dark:text-slate-400 mt-3 max-w-3xl mx-auto">
                     <?php echo esc_html(get_site_setting('contact_page_subtitle_setting', 'Kami siap mendengar pertanyaan, saran, dan masukan Anda. Silakan hubungi kami melalui formulir di bawah ini atau detail kontak yang tersedia.')); ?>
                </p>
            </header>

            <?php 
            if (function_exists('display_flash_message')) {
                echo display_flash_message(); 
            }
            ?>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 md:gap-12 items-start">
                <div class="bg-white dark:bg-slate-800 p-6 md:p-8 rounded-2xl shadow-xl animate-on-scroll fade-in-left-scroll border-t-4 border-ugkmb_primary dark:border-ugkmb_secondary">
                    <h3 class="text-xl md:text-2xl font-semibold text-ugkmb_text_dark dark:text-slate-100 mb-6 flex items-center">
                        <i class="fas fa-paper-plane me-3 text-2xl text-ugkmb_primary dark:text-ugkmb_secondary"></i>Kirim Pesan Anda
                    </h3>
                    <form action="<?php echo resolve_url('public/contact_tailwind_new.php'); ?>" method="POST" id="contactPublicFormNew" novalidate>
                        <input type="hidden" name="csrf_token" value="<?php echo function_exists('generate_csrf_token') ? generate_csrf_token() : 'csrf-token-not-set'; ?>">
                        
                        <div class="mb-5">
                            <label for="sender_name" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Nama Lengkap <span class="text-red-500">*</span></label>
                            <input type="text" class="form-input w-full px-4 py-2.5 border <?php echo isset($form_errors['sender_name']) ? 'border-red-500 focus:border-red-500 focus:ring-red-500' : 'border-slate-300 dark:border-slate-600 focus:border-ugkmb_primary dark:focus:ring-ugkmb_primary focus:ring-opacity-50'; ?> rounded-md shadow-sm dark:bg-slate-700 dark:text-slate-100 placeholder-slate-400 dark:placeholder-slate-500 transition duration-150 ease-in-out" 
                                   id="sender_name" name="sender_name" value="<?php echo function_exists('old_form_data') ? old_form_data('sender_name', '', $form_data) : esc_html($form_data['sender_name']); ?>" placeholder="Contoh: Budi Santoso" required aria-describedby="sender_name_error_msg">
                            <?php echo function_exists('get_form_error') ? get_form_error('sender_name', $form_errors) : (isset($form_errors['sender_name']) ? '<p id="sender_name_error_msg" class="text-red-500 text-xs mt-1.5">'.esc_html($form_errors['sender_name']).'</p>' : ''); ?>
                        </div>

                        <div class="mb-5">
                            <label for="sender_email" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Alamat Email <span class="text-red-500">*</span></label>
                            <input type="email" class="form-input w-full px-4 py-2.5 border <?php echo isset($form_errors['sender_email']) ? 'border-red-500 focus:border-red-500 focus:ring-red-500' : 'border-slate-300 dark:border-slate-600 focus:border-ugkmb_primary dark:focus:ring-ugkmb_primary focus:ring-opacity-50'; ?> rounded-md shadow-sm dark:bg-slate-700 dark:text-slate-100 placeholder-slate-400 dark:placeholder-slate-500 transition duration-150 ease-in-out" 
                                   id="sender_email" name="sender_email" value="<?php echo function_exists('old_form_data') ? old_form_data('sender_email', '', $form_data) : esc_html($form_data['sender_email']); ?>" placeholder="contoh@email.com" required aria-describedby="sender_email_error_msg">
                             <?php echo function_exists('get_form_error') ? get_form_error('sender_email', $form_errors) : (isset($form_errors['sender_email']) ? '<p id="sender_email_error_msg" class="text-red-500 text-xs mt-1.5">'.esc_html($form_errors['sender_email']).'</p>' : ''); ?>
                        </div>

                        <div class="mb-5">
                            <label for="sender_phone" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Nomor Telepon (Opsional)</label>
                            <input type="tel" class="form-input w-full px-4 py-2.5 border <?php echo isset($form_errors['sender_phone']) ? 'border-red-500 focus:border-red-500 focus:ring-red-500' : 'border-slate-300 dark:border-slate-600 focus:border-ugkmb_primary dark:focus:ring-ugkmb_primary focus:ring-opacity-50'; ?> rounded-md shadow-sm dark:bg-slate-700 dark:text-slate-100 placeholder-slate-400 dark:placeholder-slate-500 transition duration-150 ease-in-out" 
                                   id="sender_phone" name="sender_phone" value="<?php echo function_exists('old_form_data') ? old_form_data('sender_phone', '', $form_data) : esc_html($form_data['sender_phone']); ?>" placeholder="0812xxxxxxxx" aria-describedby="sender_phone_error_msg">
                            <?php echo function_exists('get_form_error') ? get_form_error('sender_phone', $form_errors) : (isset($form_errors['sender_phone']) ? '<p id="sender_phone_error_msg" class="text-red-500 text-xs mt-1.5">'.esc_html($form_errors['sender_phone']).'</p>' : ''); ?>
                        </div>

                        <div class="mb-5">
                            <label for="subject" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Subjek Pesan <span class="text-red-500">*</span></label>
                            <input type="text" class="form-input w-full px-4 py-2.5 border <?php echo isset($form_errors['subject']) ? 'border-red-500 focus:border-red-500 focus:ring-red-500' : 'border-slate-300 dark:border-slate-600 focus:border-ugkmb_primary dark:focus:ring-ugkmb_primary focus:ring-opacity-50'; ?> rounded-md shadow-sm dark:bg-slate-700 dark:text-slate-100 placeholder-slate-400 dark:placeholder-slate-500 transition duration-150 ease-in-out" 
                                   id="subject" name="subject" value="<?php echo function_exists('old_form_data') ? old_form_data('subject', '', $form_data) : esc_html($form_data['subject']); ?>" placeholder="Pertanyaan tentang PMB" required aria-describedby="subject_error_msg">
                            <?php echo function_exists('get_form_error') ? get_form_error('subject', $form_errors) : (isset($form_errors['subject']) ? '<p id="subject_error_msg" class="text-red-500 text-xs mt-1.5">'.esc_html($form_errors['subject']).'</p>' : ''); ?>
                        </div>

                        <div class="mb-6">
                            <label for="message_content" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Isi Pesan <span class="text-red-500">*</span></label>
                            <textarea class="form-textarea w-full px-4 py-2.5 border <?php echo isset($form_errors['message_content']) ? 'border-red-500 focus:border-red-500 focus:ring-red-500' : 'border-slate-300 dark:border-slate-600 focus:border-ugkmb_primary dark:focus:ring-ugkmb_primary focus:ring-opacity-50'; ?> rounded-md shadow-sm dark:bg-slate-700 dark:text-slate-100 placeholder-slate-400 dark:placeholder-slate-500 transition duration-150 ease-in-out" 
                                      id="message_content" name="message_content" rows="6" placeholder="Tuliskan pesan Anda di sini..." required aria-describedby="message_content_error_msg"><?php echo function_exists('old_form_data') ? old_form_data('message_content', '', $form_data) : esc_html($form_data['message_content']); ?></textarea>
                            <?php echo function_exists('get_form_error') ? get_form_error('message_content', $form_errors) : (isset($form_errors['message_content']) ? '<p id="message_content_error_msg" class="text-red-500 text-xs mt-1.5">'.esc_html($form_errors['message_content']).'</p>' : ''); ?>
                        </div>
                        
                        <button type="submit" class="w-full inline-flex justify-center items-center ugkmb_primary_bg hover:ugkmb_primary_hover dark:bg-ugkmb_secondary dark:hover:bg-ugkmb_secondary_hover text-white dark:text-ugkmb_text_dark font-semibold py-3 px-6 rounded-lg text-base transition duration-150 ease-in-out shadow-md hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-ugkmb_primary dark:focus:ring-ugkmb_secondary">
                            <i class="fas fa-envelope me-2"></i>Kirim Pesan Sekarang
                        </button>
                    </form>
                </div>
                
                <div class="animate-on-scroll fade-in-right-scroll" style="animation-delay: 0.1s;">
                    <div class="bg-white dark:bg-slate-800 p-6 md:p-8 rounded-2xl shadow-xl mb-6 md:mb-8 border-t-4 border-ugkmb_secondary dark:border-ugkmb_primary">
                        <h3 class="text-xl md:text-2xl font-semibold text-ugkmb_text_dark dark:text-slate-100 mb-6 flex items-center">
                            <i class="fas fa-info-circle me-3 text-2xl text-ugkmb_primary dark:text-ugkmb_secondary"></i>Informasi Kontak
                        </h3>
                        <ul class="space-y-5 text-slate-700 dark:text-slate-300 text-sm md:text-base">
                            <li class="flex items-start">
                                <i class="fas fa-map-marker-alt fa-fw w-6 text-center me-4 mt-1 text-lg text-ugkmb_primary dark:text-ugkmb_secondary"></i>
                                <div>
                                    <strong class="block text-slate-800 dark:text-slate-200 text-base mb-0.5">Alamat Kampus:</strong>
                                    <address class="not-italic leading-relaxed">
                                        <?php echo nl2br(esc_html(get_site_setting('address', 'Alamat belum diatur.'))); ?>
                                    </address>
                                </div>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-phone fa-fw w-6 text-center me-4 mt-1 text-lg text-ugkmb_primary dark:text-ugkmb_secondary"></i>
                                <div>
                                    <strong class="block text-slate-800 dark:text-slate-200 text-base mb-0.5">Telepon:</strong>
                                    <?php $phone_info = get_site_setting('contact_phone', 'Telepon belum diatur.'); echo esc_html($phone_info); ?>
                                </div>
                            </li>
                            <?php $whatsapp_info = get_site_setting('contact_whatsapp_number'); if (!empty($whatsapp_info)): ?>
                            <li class="flex items-start">
                                <i class="fab fa-whatsapp fa-fw w-6 text-center me-4 mt-1 text-lg text-green-500 dark:text-green-400"></i>
                                <div>
                                    <strong class="block text-slate-800 dark:text-slate-200 text-base mb-0.5">WhatsApp:</strong>
                                    <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', esc_html($whatsapp_info)); ?>" target="_blank" rel="noopener noreferrer" class="hover:text-ugkmb_primary dark:hover:text-ugkmb_secondary transition-colors">
                                        <?php echo esc_html($whatsapp_info); ?>
                                    </a>
                                </div>
                            </li>
                            <?php endif; ?>
                            <li class="flex items-start">
                                <i class="fas fa-envelope fa-fw w-6 text-center me-4 mt-1 text-lg text-ugkmb_primary dark:text-ugkmb_secondary"></i>
                                <div>
                                    <strong class="block text-slate-800 dark:text-slate-200 text-base mb-0.5">Email:</strong>
                                    <?php $email_info = get_site_setting('contact_email', 'email@belum.diatur'); ?>
                                    <a href="mailto:<?php echo esc_attr($email_info); ?>" class="hover:text-ugkmb_primary dark:hover:text-ugkmb_secondary transition-colors">
                                        <?php echo esc_html($email_info); ?>
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <?php 
                    $maps_url_setting = get_site_setting('maps_embed_url');
                    $iframe_src_for_map = '';
                    if (!empty($maps_url_setting)) {
                        if (strpos(strtolower($maps_url_setting), '<iframe') !== false) { // Jika berupa kode iframe lengkap
                            preg_match('/src="([^"]+)"/', $maps_url_setting, $map_matches);
                            $iframe_src_for_map = $map_matches[1] ?? '';
                        } elseif (filter_var($maps_url_setting, FILTER_VALIDATE_URL)) { // Jika berupa URL saja
                             // Validasi dasar apakah URL Google Maps yang bisa di-embed
                            if (preg_match('~(?:google\.com/maps/embed|google\.com/maps\?q=|google\.com/maps/place/|maps\.google\.com/maps\?f=q&source=s_q&hl=en&geocode=&q=)~i', $maps_url_setting)) {
                                // Untuk URL view, konversi ke embed bisa rumit. Idealnya, admin memasukkan URL embed langsung.
                                // Jika bukan format /embed/, mungkin perlu penyesuaian manual atau URL yang lebih baik dari admin.
                                // Untuk sekarang, kita coba gunakan langsung jika mengandung kata kunci maps Google.
                               $iframe_src_for_map = $maps_url_setting;
                               if (strpos($maps_url_setting, '/maps/place/') !== false) {
                                   // Coba ganti /place/NamaTempat dengan /embed?pb=!1sNamaTempat (ini sangat spekulatif)
                                   // $iframe_src_for_map = preg_replace('~\/maps\/place\/([^\/?]+)~', '/maps/embed?pb=!1s$1', $maps_url_setting);
                               } elseif (strpos($maps_url_setting, '/maps?q=') !== false && strpos($maps_url_setting, 'output=embed') === false) {
                                   // $iframe_src_for_map = str_replace('/maps?q=', '/maps/embed?q=', $maps_url_setting);
                               }
                               // Jika sudah ada /embed/ di URL, itu bagus.
                               // Contoh: https://maps.google.com/maps?q=1
                               // Logika dari user: (strpos($iframe_src_contact, 'https://maps.google.com/maps?q=2') !== false ...
                               // Ini sepertinya untuk domain googleusercontent.com yang spesifik untuk iframe.
                               // Jika URL dari setting adalah google.com/maps biasa, itu tidak akan langsung cocok dengan pola itu.
                               // Kita akan asumsikan admin memasukkan URL yang benar-benar bisa di-embed atau src dari iframe.
                            }
                        }
                    }
                    
                    if (!empty($iframe_src_for_map) && filter_var($iframe_src_for_map, FILTER_VALIDATE_URL)): 
                    ?>
                    <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-xl overflow-hidden">
                        <h3 class="text-xl text-center font-semibold text-ugkmb_text_dark dark:text-slate-100 pt-6 pb-2 flex items-center justify-center">
                            <i class="fas fa-map-marked-alt me-3 text-2xl text-ugkmb_primary dark:text-ugkmb_secondary"></i>Peta Lokasi
                        </h3>
                        <div class="aspect-w-16 aspect-h-9">
                             <iframe src="<?php echo esc_attr($iframe_src_for_map); ?>" width="100%" height="400" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" class="w-full h-full block"></iframe>
                        </div>
                    </div>
                    <?php 
                    // Fallback jika iframe_src_for_map tidak valid tapi ada lat/long
                    elseif (get_site_setting('latitude') && get_site_setting('longitude')):
                        $lat_map_val = esc_attr(get_site_setting('latitude'));
                        $lng_map_val = esc_attr(get_site_setting('longitude'));
                        $fallback_embed_url = "https://maps.google.com/maps?q={$lat_map_val},{$lng_map_val}&hl=id&z=15&output=embed";
                    ?>
                     <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-xl overflow-hidden">
                        <p class="p-3 text-xs text-center text-slate-500 dark:text-slate-400">URL Peta dari setting tidak dapat digunakan, menampilkan peta berdasarkan koordinat.</p>
                        <h3 class="text-xl text-center font-semibold text-ugkmb_text_dark dark:text-slate-100 pt-2 pb-2 flex items-center justify-center">
                            <i class="fas fa-map-marked-alt me-3 text-2xl text-ugkmb_primary dark:text-ugkmb_secondary"></i>Peta Lokasi
                        </h3>
                        <div class="aspect-w-16 aspect-h-9">
                             <iframe src="<?php echo esc_attr($fallback_embed_url); ?>" width="100%" height="370" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" class="w-full h-full block"></iframe>
                        </div>
                    </div>
                    <?php else: ?>
                        <div class="bg-white dark:bg-slate-800 p-6 md:p-8 rounded-2xl shadow-xl text-center">
                             <i class="fas fa-map-marked-alt fa-3x text-slate-400 dark:text-slate-500 mb-3"></i>
                             <p class="text-slate-600 dark:text-slate-400">Peta lokasi belum diatur atau tidak dapat ditampilkan.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</main>

<?php
// Include Footer BARU
require_once PROJECT_ROOT . '/includes/footer_public_new.php';
?>