// public/assets/js/main.js
document.addEventListener('DOMContentLoaded', function () {
    // Inisialisasi Bootstrap Carousel (jika ada di banyak halaman)
    const carousels = document.querySelectorAll('.carousel');
    carousels.forEach(carousel => {
        if (carousel.dataset.bsRide === 'carousel') { // Hanya jika auto-ride
            new bootstrap.Carousel(carousel);
        }
    });

    // Inisialisasi Lightbox (jika bs5-lightbox digunakan secara global)
    // Ini sudah ada di album.php, jika hanya di sana, tidak perlu di sini.
    // Jika digunakan di banyak tempat:
    // if (typeof bootstrap !== 'undefined' && typeof bootstrap.Lightbox !== 'undefined') {
    //     document.querySelectorAll('[data-bs-toggle="lightbox"]').forEach(el => el.addEventListener('click', (e) => {
    //         e.preventDefault();
    //         const lightbox = new bootstrap.Lightbox(el);
    //         lightbox.show();
    //     }));
    // }

    // Public Theme Switcher Logic (pindahkan dari footer_public.php)
    const publicThemeToggleBtn = document.getElementById('publicThemeToggleNav'); // ID dari tombol di header
    const htmlElement = document.documentElement;

    function applyPublicSiteTheme(theme) {
        htmlElement.className = theme; // Set kelas di <html>

        // Update ikon tombol (jika ada)
        const moonIcon = document.getElementById('publicThemeIconMoon');
        const sunIcon = document.getElementById('publicThemeIconSun');
        if (moonIcon && sunIcon) {
            moonIcon.style.display = (theme === 'dark-theme') ? 'none' : 'inline-block';
            sunIcon.style.display = (theme === 'dark-theme') ? 'inline-block' : 'none';
        }
        
        // Update data-bs-theme pada header dan footer jika perlu (Bootstrap 5.3+)
        // Ini mungkin lebih baik ditangani oleh CSS Variables saja jika memungkinkan
        const headerEl = document.querySelector('header > nav.navbar'); // Target nav di dalam header
        const footerEl = document.querySelector('footer.py-5'); // Target footer utama

        if(headerEl) {
            headerEl.setAttribute('data-bs-theme', theme === 'dark-theme' ? 'dark' : 'light');
            headerEl.classList.toggle('navbar-dark', theme === 'dark-theme');
            headerEl.classList.toggle('bg-dark', theme === 'dark-theme');
            headerEl.classList.toggle('navbar-light', theme !== 'dark-theme');
            headerEl.classList.toggle('bg-light', theme !== 'dark-theme');
        }
        if(footerEl) {
            footerEl.classList.toggle('bg-dark', theme === 'dark-theme');
            footerEl.classList.toggle('text-white-50', theme === 'dark-theme');
            footerEl.classList.toggle('bg-body-tertiary', theme !== 'dark-theme'); // atau .bg-light
            footerEl.classList.toggle('text-muted', theme !== 'dark-theme');
        }

        document.cookie = "theme=" + theme + ";path=/;max-age=" + (60 * 60 * 24 * 365) + ";SameSite=Lax";
    }

    if (publicThemeToggleBtn) {
        publicThemeToggleBtn.addEventListener('click', () => {
            let newTheme = htmlElement.classList.contains('dark-theme') ? 'light-theme' : 'dark-theme';
            applyPublicSiteTheme(newTheme);
        });
    }
    // Apply initial theme (FOUC script di <head> sudah menangani kelas <html>)
    // Panggil ini untuk memastikan ikon dan atribut data-bs-theme benar saat load
    applyPublicSiteTheme(htmlElement.classList.contains('dark-theme') ? 'dark-theme' : 'light-theme');


    // Smooth scroll untuk link internal #
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        if (anchor.getAttribute('href') === '#' || anchor.getAttribute('href') === '' || anchor.dataset.bsToggle) return; // Abaikan link Bootstrap
        anchor.addEventListener('click', function (e) {
            const targetId = this.getAttribute('href');
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                e.preventDefault();
                targetElement.scrollIntoView({ behavior: 'smooth' });
            }
        });
    });

    // Back to top button
    const backToTopButton = document.createElement('button');
    backToTopButton.innerHTML = '<i class="fas fa-arrow-up"></i>';
    backToTopButton.className = 'btn btn-primary btn-lg rounded-circle shadow d-none';
    backToTopButton.id = 'backToTopBtn';
    backToTopButton.style.position = 'fixed';
    backToTopButton.style.bottom = '20px';
    backToTopButton.style.right = '20px';
    backToTopButton.style.zIndex = '1030';
    document.body.appendChild(backToTopButton);

    window.addEventListener('scroll', function() {
        if (window.pageYOffset > 300) {
            backToTopButton.classList.remove('d-none');
        } else {
            backToTopButton.classList.add('d-none');
        }
    });
    backToTopButton.addEventListener('click', function() {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });

});