
<?php
// includes/functions.php (Root level - for globally used functions)

// PROJECT_ROOT and BASE_URL are defined by config.php which includes this file.
// session_start() is handled by config.php

/**
 * Escapes HTML entities for secure output.
 * @param string|null $string The string to escape.
 * @return string The escaped string.
 */
// if (!function_exists('esc_html')) {
//     function esc_html($string) {
//         return htmlspecialchars((string)$string, ENT_QUOTES, 'UTF-8');
//     }
// }

/**
 * Resolves a URL, ensuring it's absolute.
 * Relies on BASE_URL being defined in config.php.
 * BASE_URL should point to the web-accessible root of the application.
 * @param string $path The path or URL (e.g., 'public/assets/css/style.css' or 'admin/index.php').
 *                     Paths should be relative to the BASE_URL.
 * @return string The resolved absolute URL.
 */
// if (!function_exists('resolve_url')) {
//     function resolve_url($path) {
//         if (empty($path)) {
//             return '';
//         }
//         if (preg_match('~^(?:f|ht)tps?://~i', $path) || substr($path, 0, 2) === '//') {
//             return $path; // Already an absolute or protocol-relative URL
//         }
        
//         if (!defined('BASE_URL')) {
//             error_log("CRITICAL: BASE_URL not defined when calling resolve_url() for path: " . esc_html($path) . ". Check config.php.");
//             return '/' . ltrim($path, '/'); // Fallback, might be incorrect
//         }
//         // Ensure no double slashes between BASE_URL and path
//         return rtrim(BASE_URL, '/') . '/' . ltrim($path, '/');
//     }
// }

/**
 * Generates a text excerpt from HTML content.
 * @param string $html_content The HTML content.
 * @param int $length Desired length of the excerpt.
 * @param string $suffix Suffix to append if truncated.
 * @return string The generated text excerpt.
 */
if (!function_exists('public_generate_excerpt')) {
    function public_generate_excerpt($html_content, $length = 150, $suffix = '...') {
        $text_content = strip_tags((string)$html_content);
        $text_content = preg_replace('/\s+/', ' ', $text_content);
        $text_content = trim($text_content);

        if (mb_strlen($text_content) > $length) {
            $text_content = mb_substr($text_content, 0, $length);
            $last_space = mb_strrpos($text_content, ' ');
            if ($last_space !== false) {
                $text_content = mb_substr($text_content, 0, $last_space);
            }
            $text_content .= $suffix;
        }
        return esc_html($text_content); 
    }
}

/**
 * Formats a date for public display using IntlDateFormatter if available.
 * @param string|null $date_string The date string to format.
 * @param string $format The desired ICU date format pattern.
 * @return string Formatted date or empty string if input is invalid.
 */
if (!function_exists('public_format_date')) {
    function public_format_date($date_string, $format = 'd MMMM yyyy') { 
        if (empty($date_string) || $date_string === '0000-00-00 00:00:00' || $date_string === '0000-00-00') {
            return '';
        }
        try {
            $date = new DateTime($date_string);
            if (class_exists('IntlDateFormatter')) {
                 $fmt_custom = new IntlDateFormatter(
                    'id_ID', 
                    IntlDateFormatter::FULL, 
                    IntlDateFormatter::FULL, 
                    date_default_timezone_get(), 
                    IntlDateFormatter::GREGORIAN, 
                    $format 
                 );
                 if ($fmt_custom) {
                    return $fmt_custom->format($date);
                 } else {
                     error_log("IntlDateFormatter creation failed for locale id_ID and format " . esc_html($format));
                     // Fallback to PHP date format if Intl failed (map common ICU to PHP)
                     $php_format = $format;
                     if ($format === 'd MMMM yyyy') $php_format = 'd F Y';
                     else if ($format === 'd MMM yyyy, HH:mm') $php_format = 'd M Y, H:i';
                     else if ($format === 'd MMMM yyyy, HH:mm') $php_format = 'd F Y, H:i';
                     return $date->format($php_format);
                 }
            } else {
                // Fallback if IntlDateFormatter class not available
                $php_format = $format;
                if ($format === 'd MMMM yyyy') $php_format = 'd F Y';
                else if ($format === 'd MMM yyyy, HH:mm') $php_format = 'd M Y, H:i';
                else if ($format === 'd MMMM yyyy, HH:mm') $php_format = 'd F Y, H:i';
                return $date->format($php_format);
            }
        } catch (Exception $e) {
            error_log("Error formatting date string '{$date_string}' with format '{$format}': " . $e->getMessage());
            return ''; 
        }
    }
}

/**
 * Retrieves a site setting from the globally loaded $settings array.
 * @param string $key The setting key.
 * @param mixed $default Default value if setting is not found.
 * @return mixed The setting value or default.
 */
if (!function_exists('get_site_setting')) {
    function get_site_setting($key, $default = null) {
        global $settings; 
        return isset($settings[$key]) ? $settings[$key] : $default;
    }
}

?>
