<?php
// ugkmb_cms/includes/db_connect.php

// config.php MUST have been loaded before this file.
if (!defined('DB_HOST') || !defined('PROJECT_ROOT')) {
    // This situation should ideally not occur if config.php is always the entry point.
    $bootstrap_config_path = dirname(__DIR__) . '/config.php'; // Try to find config one level up
    if (file_exists($bootstrap_config_path)) {
        require_once $bootstrap_config_path;
    } else {
        error_log("FATAL ERROR: db_connect.php included without config.php. DB_HOST or PROJECT_ROOT not defined.");
        http_response_code(503);
        echo "Critical system configuration error. Please contact the administrator. (Error Code: DBC01)";
        exit;
    }
}

global $pdo;
if (!isset($pdo) || $pdo === null) { // Initialize $pdo only if not already done
    $pdo = null;
    $pdo_options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $pdo_options);
    } catch (\PDOException $e) {
        error_log("Database Connection Error: " . $e->getMessage() . " (DSN: " . $dsn . ")");
        http_response_code(503);
        // Avoid echoing detailed errors in production directly on the page
        echo "<!DOCTYPE html><html lang='id'><head><title>Kesalahan Koneksi Database</title>";
        echo "<style>body{font-family: Arial, sans-serif; margin: 50px; text-align: center; background-color: #f0f0f0;} .container{background-color: #fff; padding: 20px; border-radius: 5px; box-shadow: 0 0 10px rgba(0,0,0,0.1);}</style>";
        echo "</head><body><div class='container'>";
        echo "<h1>Terjadi Masalah Koneksi</h1>";
        echo "<p>Mohon maaf, kami tidak dapat terhubung ke database saat ini. Silakan coba lagi beberapa saat.</p>";
        echo "</div></body></html>";
        exit;
    }
}
?>