<?php
// config_new.php

// 1. Mulai Session
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// 2. Pengaturan Error Reporting (Sesuaikan untuk Development/Production)
// Untuk development:
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Untuk production (nantinya):
// error_reporting(0);
// ini_set('display_errors', 0);

// 3. Definisi Konstanta Path dan URL Dasar
if (!defined('PROJECT_ROOT')) {
    // Diasumsikan config_new.php ada di root proyek, 
    // dan direktori 'public', 'includes', 'admin' ada di dalamnya.
    define('PROJECT_ROOT', __DIR__); 
}

if (!defined('BASE_URL')) {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443)) ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    
    // Menentukan base path dari SCRIPT_NAME
    // Contoh: jika SCRIPT_NAME adalah /folderproyek/public/index.php, maka base_path akan /folderproyek
    $script_name_path = dirname($_SERVER['SCRIPT_NAME']);
    $base_path_segment = '';
    if (strpos($script_name_path, '/public') !== false) {
        // Jika '/public' ada di path, ambil segmen sebelum '/public'
        $base_path_segment = substr($script_name_path, 0, strpos($script_name_path, '/public'));
    } else {
        // Jika tidak ada '/public', atau jika web root sudah di 'public'
        // Atur base_path_segment ke direktori di atas skrip saat ini jika skrip ada di subfolder.
        // Jika skrip ada di root domain, base_path_segment akan kosong.
        $base_path_segment = ($script_name_path === '/' || $script_name_path === '\\') ? '' : rtrim($script_name_path, '/\\');
    }
    // Hapus duplikasi slash jika $base_path_segment adalah root '/'
    $base_path_segment = ($base_path_segment === '/') ? '' : $base_path_segment;

    define('BASE_URL', rtrim($protocol . $host . $base_path_segment, '/'));
}


// 4. Pengaturan Zona Waktu (Opsional, tapi direkomendasikan)
date_default_timezone_set('Asia/Jakarta');

// 5. Include File Koneksi Database BARU (akan membuat variabel $pdo dan memuat $settings)
require_once PROJECT_ROOT . '/includes/db_connect_new.php';

// 6. Include File Fungsi Inti BARU (fungsi helper seperti resolve_url, esc_html, dll.)
require_once PROJECT_ROOT . '/admin/includes/functions_new.php';

// 7. Pengaturan Tema Default untuk header_public_new.php
// Untuk halaman kontak Tailwind yang baru, kita ingin header Tailwind.
if (!defined('USE_TAILWIND_CDN_HEADER')) {
    define('USE_TAILWIND_CDN_HEADER', true); 
}

// Inisialisasi variabel global $settings jika belum di-set oleh db_connect_new.php
global $settings;
if (!isset($settings) || !is_array($settings)) {
    $settings = []; // Pastikan $settings adalah array
    // Bisa juga coba load settings dari DB di sini jika db_connect_new tidak melakukannya
    if (isset($pdo)) {
        try {
            // Ambil semua settings (baik public maupun non-public jika config ini dipakai admin juga)
            $stmt_cfg_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings"); 
            while ($row_cfg_settings = $stmt_cfg_settings->fetch(PDO::FETCH_ASSOC)) {
                $settings[$row_cfg_settings['setting_key']] = $row_cfg_settings['setting_value'];
            }
        } catch (\PDOException $e) {
            error_log("config_new.php: Failed to load settings from DB: " . $e->getMessage());
        }
    }
}
?>