<?php
// config.php (Project Root, e.g., /oldugk/config.php or /ugkmb_cms/config.php)

// --- CORE DEFINITIONS ---

// Define Project Root - __DIR__ in this file (project root) is correct.
if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', __DIR__);
}

// --- ERROR REPORTING ---

define('ENVIRONMENT', 'production'); // Ganti menjadi 'development' saat di localhost

if (ENVIRONMENT === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    // Pastikan direktori 'logs' ada dan bisa ditulis oleh server
    ini_set('error_log', PROJECT_ROOT . '/logs/php_error.log');
}
// For development:
// eror_reporting(E_ALL);
// ini_set('drisplay_errors', 1);
// For production, you would typically use:
// error_reporting(0);
// ini_set('display_errors', 0);
// ini_set('log_errors', 1);
// ini_set('error_log', PROJECT_ROOT . '/logs/php_errors.log'); // Ensure 'logs' directory exists and is writable

// --- TIMEZONE ---
date_default_timezone_set('Asia/Jakarta'); // Set to your server's timezone or application's default

// --- SESSION MANAGEMENT ---
// Start session if not already active.
// This is the central place for session_start.
if (session_status() == PHP_SESSION_NONE) {
    // Optional: Configure session save path if your default path has permission issues.
    // Ensure the path is outside your web root if possible and writable by the web server.
    // $session_save_path = PROJECT_ROOT . '/_sessions_storage'; // Example path
    // if (!is_dir($session_save_path)) {
    //     @mkdir($session_save_path, 0700, true); // Create if not exists, restrict permissions
    // }
    // if (is_writable($session_save_path)) {
    //     ini_set('session.save_path', $session_save_path);
    // } else {
    //     error_log("WARNING: PHP Session save path not writable or not configured: " . $session_save_path);
    // }
    session_start();
}

// --- BASE URL DEFINITION ---
// Defines the web-accessible root URL of your project.
// Example: http://localhost/ugkmb_cms OR https://www.yourdomain.com/oldugk
if (!defined('BASE_URL')) {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443)) ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost'; // Fallback for CLI or misconfigured server

    // Calculate the base path segment if the project is in a subfolder
    $script_name_for_base_url = $_SERVER['SCRIPT_NAME'] ?? '';
    $base_path_segment_for_url = '';

    // This logic assumes that if 'public/', 'admin/', or 'api/' is part of the script name,
    // the base path is whatever comes before it.
    // This is robust for typical entry points.
    if (strpos($script_name_for_base_url, '/public/') !== false) {
        $base_path_segment_for_url = substr($script_name_for_base_url, 0, strpos($script_name_for_base_url, '/public/'));
    } elseif (strpos($script_name_for_base_url, '/admin/') !== false) {
        $base_path_segment_for_url = substr($script_name_for_base_url, 0, strpos($script_name_for_base_url, '/admin/'));
    } elseif (strpos($script_name_for_base_url, '/api/') !== false) {
        $base_path_segment_for_url = substr($script_name_for_base_url, 0, strpos($script_name_for_base_url, '/api/'));
    } else {
        // If script is directly in project root (e.g. /index.php if project root is web root)
        // or for CLI scripts where SCRIPT_NAME might be just the filename.
        $base_path_segment_for_url = rtrim(dirname($script_name_for_base_url), '/\\');
        // If dirname results in '.' (current dir) or is empty (root access), set to empty string.
        if ($base_path_segment_for_url === '.' || $base_path_segment_for_url === '') {
            $base_path_segment_for_url = '';
        }
    }
    // Ensure no double slashes if $base_path_segment_for_url is empty or already has a slash
    define('BASE_URL', rtrim($protocol . $host . $base_path_segment_for_url, '/'));
}

// --- DATABASE CREDENTIALS ---
// Ensure these are not directly accessible via web if this file were somehow exposed.
// Best practice is to store credentials outside the web root or in environment variables.
if (!defined('DB_HOST')) define('DB_HOST', 'localhost');
if (!defined('DB_NAME')) define('DB_NAME', 'u6178854_ugk3'); // Your database name
if (!defined('DB_USER')) define('DB_USER', 'u6178854_ugk');   // Your database username
if (!defined('DB_PASS')) define('DB_PASS', 'ugkmb1!');       // Your database password
if (!defined('DB_CHARSET')) define('DB_CHARSET', 'utf8mb4');

// --- LOAD ESSENTIAL FUNCTIONS & DATABASE CONNECTION ---

// Load Global Public Functions (resolve_url, esc_html, get_site_setting, etc.)
if (file_exists(PROJECT_ROOT . '/includes/functions.php')) {
    require_once PROJECT_ROOT . '/includes/functions.php';
} else {
    error_log("CRITICAL FAILURE: Global public functions file (includes/functions.php) not found.");
    die("Kesalahan konfigurasi sistem (F01). Situs tidak dapat dimuat.");
}

// Load Admin-Specific Functions (admin_url, CSRF helpers, admin-specific formatting, etc.)
// This is loaded globally because public forms (like contact) might use CSRF or flash messages.
if (file_exists(PROJECT_ROOT . '/admin/includes/functions.php')) {
    require_once PROJECT_ROOT . '/admin/includes/functions.php';
} else {
    // This is a non-fatal error for public pages, but admin panel will break.
    error_log("NOTICE: Admin-specific functions file (admin/includes/functions.php) not found. Admin panel functionality will be affected.");
}

// Establish Database Connection (defines global $pdo)
if (file_exists(PROJECT_ROOT . '/includes/db_connect.php')) {
    require_once PROJECT_ROOT . '/includes/db_connect.php';
} else {
    error_log("CRITICAL FAILURE: Database connection script (includes/db_connect.php) not found.");
    die("Kesalahan konfigurasi sistem (DB01). Situs tidak dapat dimuat.");
}

// --- LOAD GLOBAL SITE SETTINGS ---
// Loads all settings from `portal_settings` into a global $settings array.
// This is done once per request.
global $settings; // Make it explicitly global to be accessible everywhere after config.php is included.
if (isset($pdo) && (!isset($settings_loaded_flag) || !$settings_loaded_flag)) { // Load only if $pdo exists and not already loaded
    $settings = [];
    try {
        $stmt_all_portal_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings");
        while ($row_portal_setting = $stmt_all_portal_settings->fetch(PDO::FETCH_ASSOC)) {
            $settings[$row_portal_setting['setting_key']] = $row_portal_setting['setting_value'];
        }
        $settings_loaded_flag = true; // Flag to prevent re-loading in the same request
    } catch (\PDOException $e) {
        error_log("DATABASE ERROR in config.php - Could not fetch global settings: " . $e->getMessage());
        // Site might still run with defaults provided by get_site_setting(), but this is an issue.
    }
} elseif (!isset($pdo)) {
    error_log("NOTICE in config.php: PDO object not available, cannot load global site settings from database.");
}
?>