<?php
// setup_admin.php
// Pastikan file ini hanya dijalankan SEKALI dan SEGERA DIHAPUS setelahnya.

// Definisi dasar jika file ini dijalankan standalone tanpa include config.php
if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__)); // Sesuaikan jika path berbeda
}
// Anda mungkin perlu me-require config.php atau db_connect.php di sini
// untuk mendapatkan kredensial DB dan objek $pdo.
// Untuk contoh ini, saya akan asumsikan $pdo sudah ada (misalnya dari db_connect.php).

require_once 'includes/db_connect.php'; // Pastikan path ini benar

if (!isset($pdo)) {
    die("Koneksi database gagal. Pastikan db_connect.php sudah benar.");
}

// --- DATA ADMIN BARU ---
$admin_username = 'b'; // GANTI DENGAN USERNAME YANG KUAT
$admin_password_plain = 'b!'; // GANTI DENGAN PASSWORD KUAT
$admin_email = 'a@example.com'; // GANTI DENGAN EMAIL VALID
$admin_full_name = 'Administrator Utama';
// ------------------------

$password_hash = password_hash($admin_password_plain, PASSWORD_DEFAULT);

try {
    // Cek apakah username sudah ada
    $stmt_check = $pdo->prepare("SELECT id FROM portal_users WHERE username = :username OR email = :email");
    $stmt_check->execute([':username' => $admin_username, ':email' => $admin_email]);
    if ($stmt_check->fetch()) {
        die("Error: Username atau Email admin sudah ada di database.");
    }

    $sql = "INSERT INTO portal_users (username, password_hash, email, full_name, role, is_active, created_at, updated_at)
            VALUES (:username, :password_hash, :email, :full_name, 'admin', 1, NOW(), NOW())";
    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':username', $admin_username);
    $stmt->bindParam(':password_hash', $password_hash);
    $stmt->bindParam(':email', $admin_email);
    $stmt->bindParam(':full_name', $admin_full_name);

    $stmt->execute();

    echo "User admin berhasil dibuat dengan username: " . htmlspecialchars($admin_username) . "<br>";
    echo "Password yang Anda set: " . htmlspecialchars($admin_password_plain) . "<br>";
    echo "<strong>PENTING: HAPUS FILE INI (setup_admin.php) SEKARANG JUGA!</strong>";

} catch (PDOException $e) {
    die("Error saat membuat user admin: " . $e->getMessage());
}
?>