<?php
// admin/modules/users/create.php (Form Tambah Pengguna Baru)

// Pastikan config.php dimuat paling awal dan hanya sekali
// dan session_start() sudah ada di config.php
if (file_exists(dirname(__DIR__, 3) . '/config.php')) {
    require_once dirname(__DIR__, 3) . '/config.php';
} elseif (file_exists(dirname(__FILE__, 4) . '/config.php')) { 
    require_once dirname(__FILE__, 4) . '/config.php';
} else {
    error_log("CRITICAL FAILURE: config.php not found from users/create.php. Path checked: " . dirname(__DIR__, 3) . '/config.php' . " AND " . dirname(__FILE__, 4) . '/config.php');
    die("Konfigurasi sistem tidak ditemukan. Harap hubungi administrator. (create.php)");
}

// Autentikasi dan Otorisasi (Hanya admin yang bisa tambah user)
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    set_flash_message('danger', 'Akses ditolak. Anda tidak memiliki izin untuk halaman ini.');
    if (!headers_sent()) { // Cek sebelum mengirim header
        header('Location: ' . admin_url('login.php')); 
    }
    exit;
}

$page_title = "Tambah Pengguna Baru";

// Ambil data form dan error dari session jika ada (setelah redirect karena validasi gagal di server)
// Nama session konsisten dengan yang di-set di process_user.php untuk aksi 'create'
$form_values_create_user = $_SESSION['form_data_user_admin'] ?? [ // '_admin' untuk membedakan dari form profil
    'username' => '',
    'email' => '',
    'full_name' => '',
    'role' => 'author', // Default role untuk pengguna baru
    'is_active' => 1,   // Default aktif untuk pengguna baru
    // Password dan konfirmasi tidak perlu di-repopulate dari session untuk keamanan
    'password' => '',   
    'confirm_password' => '' 
];
$form_errors_create_user = $_SESSION['form_errors_user_admin'] ?? [];

// Hapus dari session agar tidak muncul lagi setelah refresh berikutnya
unset($_SESSION['form_data_user_admin']);
unset($_SESSION['form_errors_user_admin']);

require_once PROJECT_ROOT . '/admin/includes/header.php';
// sidebar.php biasanya di-include oleh header.php
?>
<div class="container-fluid px-4">
    <?php 
    echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => admin_url('index.php')],
        ['label' => 'Manajemen Pengguna', 'url' => admin_url('modules/users/index.php')],
        'Tambah Pengguna Baru' // Halaman saat ini tidak perlu URL
    ]); 
    ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <hr class="mb-4">

    <?php echo display_flash_message(); // Untuk menampilkan pesan umum dari set_flash_message() ?>

    <div class="card shadow-sm">
        <div class="card-header">
            <i class="fas fa-user-plus me-1"></i>
            Formulir Tambah Pengguna Baru
        </div>
        <div class="card-body">
            <form action="<?php echo admin_url('modules/users/process_user.php'); ?>" method="POST" id="createUserForm">
                <input type="hidden" name="action" value="create">
                <input type="hidden" name="csrf_token" id="csrf_token_create_user_page" value="<?php echo generate_csrf_token(); ?>">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="username" class="form-label">Username <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control <?php echo isset($form_errors_create_user['username']) ? 'is-invalid' : ''; ?>" 
                               id="username" name="username" 
                               value="<?php echo esc_html($form_values_create_user['username']); ?>" required maxlength="50" autocomplete="off">
                        <?php if (isset($form_errors_create_user['username'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_create_user['username']); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                        <input type="email" 
                               class="form-control <?php echo isset($form_errors_create_user['email']) ? 'is-invalid' : ''; ?>" 
                               id="email" name="email" 
                               value="<?php echo esc_html($form_values_create_user['email']); ?>" required maxlength="100">
                        <?php if (isset($form_errors_create_user['email'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_create_user['email']); ?></div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                        <input type="password" 
                               class="form-control <?php echo isset($form_errors_create_user['password']) ? 'is-invalid' : ''; ?>" 
                               id="password" name="password" required minlength="6" autocomplete="new-password">
                        <div class="form-text">Minimal 6 karakter.</div>
                        <?php if (isset($form_errors_create_user['password'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_create_user['password']); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="confirm_password" class="form-label">Konfirmasi Password <span class="text-danger">*</span></label>
                        <input type="password" 
                               class="form-control <?php echo isset($form_errors_create_user['confirm_password']) ? 'is-invalid' : ''; ?>" 
                               id="confirm_password" name="confirm_password" required autocomplete="new-password">
                        <?php if (isset($form_errors_create_user['confirm_password'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_create_user['confirm_password']); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label for="full_name" class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                    <input type="text" 
                           class="form-control <?php echo isset($form_errors_create_user['full_name']) ? 'is-invalid' : ''; ?>" 
                           id="full_name" name="full_name" 
                           value="<?php echo esc_html($form_values_create_user['full_name']); ?>" required maxlength="100">
                    <?php if (isset($form_errors_create_user['full_name'])): ?>
                        <div class="invalid-feedback"><?php echo esc_html($form_errors_create_user['full_name']); ?></div>
                    <?php endif; ?>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="role" class="form-label">Role <span class="text-danger">*</span></label>
                        <select class="form-select <?php echo isset($form_errors_create_user['role']) ? 'is-invalid' : ''; ?>" id="role" name="role" required>
                            <option value="author" <?php echo ($form_values_create_user['role'] === 'author') ? 'selected' : ''; ?>>Author</option>
                            <option value="editor" <?php echo ($form_values_create_user['role'] === 'editor') ? 'selected' : ''; ?>>Editor</option>
                            <option value="admin" <?php echo ($form_values_create_user['role'] === 'admin') ? 'selected' : ''; ?>>Admin</option>
                        </select>
                        <?php if (isset($form_errors_create_user['role'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_create_user['role']); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6 mb-3 align-self-center pt-md-3"> 
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" id="is_active" name="is_active" value="1" <?php echo ($form_values_create_user['is_active'] == 1) ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="is_active" id="is_active_label_create">
                                <?php echo ($form_values_create_user['is_active'] == 1) ? 'Aktif' : 'Nonaktif'; ?>
                            </label>
                        </div>
                         <?php if (isset($form_errors_create_user['is_active'])): ?>
                            <div class="text-danger small mt-1 d-block"><?php echo esc_html($form_errors_create_user['is_active']); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div id="generalFormErrors" class="mb-3 text-danger small">
                     <?php if (isset($form_errors_create_user['_general'])): ?>
                        <div class="alert alert-danger p-2"><?php echo esc_html($form_errors_create_user['_general']); ?></div>
                    <?php endif; ?>
                </div>

                <div class="mt-4 pt-3 border-top">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-plus-circle me-1"></i> Tambah Pengguna</button>
                    <a href="<?php echo admin_url('modules/users/index.php'); ?>" class="btn btn-outline-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
$page_scripts = []; // Inisialisasi array untuk script khusus halaman ini
// Menggunakan json_encode untuk variabel PHP yang akan dimasukkan ke JavaScript dengan aman
$js_initial_csrf_token_create_user_page = json_encode(generate_csrf_token());
$js_process_user_url = json_encode(admin_url('modules/users/process_user.php'));

// Menggunakan Heredoc untuk blok JavaScript yang panjang
$inline_script_content_create_user = <<<JS_CREATE_USER_FORM
<script>
    // Fallback functions jika admin-global.js belum termuat atau fungsi tidak ada
    if (typeof showAdminNotification === 'undefined') { function showAdminNotification(type, message) { console.warn('showAdminNotification fallback:', type, message); alert(type + ': ' + message); } }
    if (typeof displayAdminFormErrors === 'undefined') { function displayAdminFormErrors(form, errors) { console.warn('displayAdminFormErrors fallback', errors); if(errors && errors._general) alert('Error: ' + errors._general); else if(errors) { let errStr = ""; for(const key in errors){errStr += key + ": " + errors[key] + "\\n";} alert(errStr); } } }

    let currentCreateUserFormCsrfToken_Page = $js_initial_csrf_token_create_user_page;
    const processUserUrl_Page = $js_process_user_url;

    function updateCreateUserFormCsrf_Page(newToken) {
        currentCreateUserFormCsrfToken_Page = newToken;
        $('#csrf_token_create_user_page').val(newToken);
    }

    $(document).ready(function() {
        // Update label checkbox 'is_active' saat statusnya berubah
        $('#is_active').change(function() {
            const label = $('#is_active_label_create'); 
            if ($(this).is(':checked')) {
                label.text('Aktif');
            } else {
                label.text('Nonaktif');
            }
        });

        $('#createUserForm').submit(function(e) {
            e.preventDefault();
            const form = $(this);
            const button = form.find('button[type="submit"]');
            const originalButtonHtml = button.html();

            button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1"></span>Menyimpan...');
            // Bersihkan error validasi sebelumnya
            form.find('.is-invalid').removeClass('is-invalid');
            form.find('.invalid-feedback').empty();
            $('#generalFormErrors').empty().hide(); // Sembunyikan dan kosongkan error umum

            // Pastikan CSRF token terbaru digunakan
            form.find('input[name="csrf_token"]').val(currentCreateUserFormCsrfToken_Page);
            
            $.ajax({
                url: form.attr('action'), // Diambil dari form action
                method: form.attr('method'), // Diambil dari form method
                data: form.serialize(), // Kirim semua data form
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        showAdminNotification('success', response.message || 'Pengguna berhasil ditambahkan.');
                        if (response.redirect_url) {
                            setTimeout(function() {
                                window.location.href = response.redirect_url;
                            }, 1500); // Beri waktu notifikasi terlihat
                        } else {
                            form[0].reset(); // Reset form jika tidak ada redirect (misal: tambah lagi)
                            $('#role').val('author'); // Set default role lagi
                            $('#is_active').prop('checked', true).trigger('change'); // Set default active dan update label
                        }
                    } else {
                        showAdminNotification('danger', response.message || 'Terjadi kesalahan validasi atau penyimpanan.');
                        if (response.errors) {
                            displayAdminFormErrors(form, response.errors);
                        } else if (response.message) {
                             $('#generalFormErrors').html('<div class="alert alert-danger p-2">' + response.message + '</div>').show();
                        }
                    }
                    // Update CSRF token dari server
                    if (response.new_csrf_token) {
                        updateCreateUserFormCsrf_Page(response.new_csrf_token);
                    }
                },
                error: function(jqXHR) {
                    let errorMsg = 'Kesalahan server. Tidak dapat mengirim permintaan.';
                    if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                        errorMsg = jqXHR.responseJSON.message;
                    } else if (jqXHR.statusText && jqXHR.status) {
                        errorMsg = 'Error: ' + jqXHR.status + ' - ' + jqXHR.statusText;
                    }
                    showAdminNotification('danger', errorMsg);
                    $('#generalFormErrors').html('<div class="alert alert-danger p-2">' + errorMsg + '</div>').show();
                    console.error("AJAX create user form submission error:", jqXHR.status, jqXHR.responseText);
                },
                complete: function() {
                    button.prop('disabled', false).html(originalButtonHtml);
                }
            });
        });
    });
</script>
JS_CREATE_USER_FORM;

$page_scripts[] = $inline_script_content_create_user; 
require_once PROJECT_ROOT . '/admin/includes/footer.php';
?>