<?php
// admin/modules/sliders/process_slider.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 3)); // Pastikan ini benar: /oldugk
}
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php'; // upload_file(), validate_csrf_token(), dll.

// Fungsi untuk cek AJAX request
function is_ajax_request_slider() {
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}
$is_ajax = is_ajax_request_slider();

// Set header JSON jika ini AJAX request di awal
if ($is_ajax) {
    header('Content-Type: application/json');
}

$module_redirect_url_base = 'index.php'; // Redirect ke daftar slider

// Autentikasi dan Otorisasi
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Akses ditolak. Anda tidak memiliki izin.']); exit; }
    set_flash_message('danger', 'Anda tidak memiliki izin untuk aksi ini.'); 
    header('Location: ' . PROJECT_ROOT . '/admin/login.php'); // Redirect ke login utama
    exit;
}

// Cek koneksi DB
if (!isset($pdo)) {
    if ($is_ajax) { http_response_code(503); echo json_encode(['success' => false, 'message' => 'Koneksi database gagal (PS_PDO).']); exit; }
    set_flash_message('danger', 'Koneksi database gagal.'); 
    header('Location: ' . $module_redirect_url_base); 
    exit;
}

// --- Definisi Fungsi Lokal atau Pastikan ada di functions.php ---
// Pastikan fungsi validate_slider_input dan handle_slider_image_upload sudah ada di functions.php
// atau definisikan di sini. Untuk kebersihan, lebih baik di functions.php.
// Saya akan asumsikan sudah ada di functions.php, tapi jika tidak, pindahkan dari kode Anda sebelumnya.

// Contoh, jika belum ada di functions.php:
if (!function_exists('validate_slider_input')) {
    function validate_slider_input($data, $is_edit = false) {
        $errors = [];
        if (empty($data['title'])) { $errors['title'] = 'Judul slider wajib diisi.'; }
        elseif (strlen($data['title']) > 255) { $errors['title'] = 'Judul slider maksimal 255 karakter.';}
        
        // Validasi gambar hanya untuk create jika tidak ada gambar lama
        // atau jika file baru diupload untuk edit
        if (!$is_edit && (!isset($_FILES['image_file_desktop']) || $_FILES['image_file_desktop']['error'] == UPLOAD_ERR_NO_FILE)) {
            $errors['image_url_desktop'] = 'Gambar desktop wajib diupload untuk slider baru.';
        }
        // Jika file diupload (baik create atau edit), validasi file tersebut (ukuran, tipe) akan ditangani oleh handle_slider_image_upload

        if (!empty($data['link_url'])) {
            if(!filter_var($data['link_url'], FILTER_VALIDATE_URL)) { $errors['link_url'] = 'Format URL tujuan klik tidak valid.';}
            elseif (strlen($data['link_url']) > 2048) { $errors['link_url'] = 'URL tujuan klik maksimal 2048 karakter.';}
        }
        if (!empty($data['button_text']) && strlen($data['button_text']) > 50) { $errors['button_text'] = 'Teks tombol maksimal 50 karakter.';}
        
        if (!isset($data['slide_order']) || !is_numeric($data['slide_order']) || (int)$data['slide_order'] < 0) { 
            $errors['slide_order'] = 'Urutan slide harus berupa angka non-negatif.';
        } else {
            $data['slide_order'] = (int)$data['slide_order']; // Pastikan integer
        }

        if (!isset($data['is_active']) || !in_array($data['is_active'], [0, 1, '0', '1'], true)) { 
            $errors['is_active'] = 'Status slider tidak valid.';
        } else {
            $data['is_active'] = (int)$data['is_active']; // Pastikan integer
        }

        $d_start = null;
        if (!empty($data['start_date'])) { 
            try { $d_start = new DateTime($data['start_date']);} 
            catch (Exception $e) { $errors['start_date'] = 'Format tanggal & waktu mulai tayang tidak valid.';}
        }
        if (!empty($data['end_date'])) {
            try { 
                $d_end = new DateTime($data['end_date']); 
                if ($d_start && $d_end < $d_start) { 
                    $errors['end_date'] = 'Tanggal & waktu selesai tayang harus setelah tanggal & waktu mulai.';
                }
            }
            catch (Exception $e) { $errors['end_date'] = 'Format tanggal & waktu selesai tayang tidak valid.';}
        }
        return $errors;
    }
}

if (!function_exists('handle_slider_image_upload')) {
    function handle_slider_image_upload($file_key_name, $old_file_path_relative, $max_size_mb, &$errors_ref) {
        // Pastikan upload_file() sudah ada di functions.php
        if (!function_exists('upload_file')) {
            $errors_ref[$file_key_name] = "Fungsi inti 'upload_file' tidak ditemukan.";
            return $old_file_path_relative; // Kembalikan path lama jika fungsi upload tidak ada
        }

        $uploaded_file_db_path = $old_file_path_relative; // Default ke path lama

        if (isset($_FILES[$file_key_name]) && $_FILES[$file_key_name]['error'] == UPLOAD_ERR_OK) {
            $upload_dir_relative_from_root = 'uploads/sliders/'; // Path relatif dari PROJECT_ROOT
            $upload_dir_absolute = PROJECT_ROOT . '/' . $upload_dir_relative_from_root;

            $upload_result = upload_file(
                $_FILES[$file_key_name], 
                $upload_dir_absolute, 
                ['image/jpeg', 'image/png', 'image/gif', 'image/webp'], 
                ($max_size_mb * 1024 * 1024)
            );

            if ($upload_result['success']) {
                // Hapus file lama jika ada dan upload baru berhasil
                if (!empty($old_file_path_relative) && file_exists(PROJECT_ROOT . '/' . $old_file_path_relative)) {
                    @unlink(PROJECT_ROOT . '/' . $old_file_path_relative);
                }
                // upload_file() harus mengembalikan 'filepath_relative' yang merupakan path dari PROJECT_ROOT
                $uploaded_file_db_path = $upload_result['filepath_relative']; 
            } else {
                // Key untuk error di form adalah 'image_url_desktop' atau 'image_url_mobile'
                $error_key_for_form = ($file_key_name === 'image_file_desktop' ? 'image_url_desktop' : 'image_url_mobile');
                $errors_ref[$error_key_for_form] = $upload_result['message'];
            }
        } elseif (isset($_FILES[$file_key_name]) && $_FILES[$file_key_name]['error'] != UPLOAD_ERR_NO_FILE) {
            $error_key_for_form = ($file_key_name === 'image_file_desktop' ? 'image_url_desktop' : 'image_url_mobile');
            $errors_ref[$error_key_for_form] = "Error saat upload file (kode: " . $_FILES[$file_key_name]['error'] . ")";
        }
        return $uploaded_file_db_path;
    }
}


// Proses utama
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF. Segarkan halaman dan coba lagi.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.');
        $action_redirect = $_POST['action'] ?? 'create'; 
        $id_redirect = $_POST['id'] ?? null;
        header('Location: ' . ($action_redirect === 'edit' && $id_redirect ? 'edit.php?id=' . $id_redirect : 'create.php')); 
        exit;
    }

    $action = $_POST['action'] ?? null;
    $slider_id = isset($_POST['id']) ? (int)$_POST['id'] : null;
    $redirect_on_error_url = ($action === 'edit' && $slider_id ? 'edit.php?id=' . $slider_id : 'create.php');

    // Ambil data dari form
    $form_data_input = [
        'title' => trim($_POST['title'] ?? ''), 
        'description' => trim($_POST['description'] ?? null), // Bisa null
        'link_url' => trim($_POST['link_url'] ?? null),      // Bisa null
        'button_text' => trim($_POST['button_text'] ?? null), // Bisa null
        'slide_order' => isset($_POST['slide_order']) ? (int)$_POST['slide_order'] : 0,
        'is_active' => isset($_POST['is_active']) ? (int)$_POST['is_active'] : 0, // Default ke 0 (Nonaktif) jika tidak diset
        'start_date' => !empty($_POST['start_date']) ? $_POST['start_date'] : null,
        'end_date' => !empty($_POST['end_date']) ? $_POST['end_date'] : null,
        // Path gambar lama (jika edit)
        'old_image_url_desktop' => $_POST['old_image_url_desktop'] ?? null,
        'old_image_url_mobile' => $_POST['old_image_url_mobile'] ?? null,
    ];
    
    // Inisialisasi path gambar dengan path lama (atau null jika baru)
    $form_data_input['image_url_desktop'] = $form_data_input['old_image_url_desktop'];
    $form_data_input['image_url_mobile'] = $form_data_input['old_image_url_mobile'];

    $errors = []; // Array untuk menampung semua error (dari upload dan validasi field)

    // Handle upload gambar
    // Fungsi handle_slider_image_upload akan mengisi $errors jika ada masalah upload
    $form_data_input['image_url_desktop'] = handle_slider_image_upload('image_file_desktop', $form_data_input['old_image_url_desktop'], 2, $errors);
    $form_data_input['image_url_mobile'] = handle_slider_image_upload('image_file_mobile', $form_data_input['old_image_url_mobile'], 1, $errors);
    
    // Validasi field input lainnya
    $validation_errors_fields = validate_slider_input($form_data_input, ($action === 'edit'));
    $errors = array_merge($errors, $validation_errors_fields); // Gabungkan error upload dengan error validasi field

    // Cek jika ada error setelah semua validasi
    if (!empty($errors)) {
        if ($is_ajax) { 
            http_response_code(422); // Unprocessable Entity
            echo json_encode(['success' => false, 'message' => 'Validasi gagal. Periksa kembali input Anda.', 'errors' => $errors]); 
        } else {
            $_SESSION['form_errors'] = $errors; 
            $_SESSION['form_data'] = $_POST; // Simpan semua data POST asli untuk repopulate
            set_flash_message('danger', 'Gagal menyimpan slider. Terdapat kesalahan pada input.'); 
            header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }

    // Jika tidak ada error, lanjutkan proses ke database
    try {
        $sql_params = [
            ':title' => $form_data_input['title'], 
            ':description' => $form_data_input['description'], // Akan null jika kosong
            ':image_url_desktop' => $form_data_input['image_url_desktop'], // Path dari upload atau lama
            ':image_url_mobile' => $form_data_input['image_url_mobile'],  // Path dari upload atau lama, bisa null
            ':link_url' => $form_data_input['link_url'],       // Akan null jika kosong
            ':button_text' => $form_data_input['button_text'],   // Akan null jika kosong
            ':slide_order' => $form_data_input['slide_order'], 
            ':is_active' => $form_data_input['is_active'],
            ':start_date' => $form_data_input['start_date'],   // Akan null jika kosong
            ':end_date' => $form_data_input['end_date'],       // Akan null jika kosong
        ];

        if ($action === 'create') {
            $sql = "INSERT INTO portal_sliders (title, description, image_url_desktop, image_url_mobile, link_url, button_text, slide_order, is_active, start_date, end_date, created_at, updated_at)
                    VALUES (:title, :description, :image_url_desktop, :image_url_mobile, :link_url, :button_text, :slide_order, :is_active, :start_date, :end_date, NOW(), NOW())";
            $stmt = $pdo->prepare($sql);
        } elseif ($action === 'edit' && $slider_id) {
            $sql = "UPDATE portal_sliders SET 
                        title = :title, description = :description, 
                        image_url_desktop = :image_url_desktop, image_url_mobile = :image_url_mobile, 
                        link_url = :link_url, button_text = :button_text, 
                        slide_order = :slide_order, is_active = :is_active, 
                        start_date = :start_date, end_date = :end_date, 
                        updated_at = NOW()
                    WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $sql_params[':id'] = $slider_id;
        } else { 
            throw new Exception("Aksi tidak valid atau ID slider tidak ada untuk mode edit."); 
        }
        
        $stmt->execute($sql_params);
        $message_verb = ($action === 'create' ? 'dibuat' : 'diperbarui');

        if ($is_ajax) {
            echo json_encode(['success' => true, 'message' => 'Slider berhasil ' . $message_verb . '.', 'redirect_url' => $module_redirect_url_base]);
        } else {
            set_flash_message('success', 'Slider berhasil ' . $message_verb . '.');
            header('Location: ' . $module_redirect_url_base);
        }
        exit;

    } catch (PDOException $e) { // Error Database
        error_log("PDOException processing slider ($action): " . $e->getMessage() . " SQL: " . ($sql ?? 'N/A'));
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan database: ' . $e->getMessage()]); }
        else {
            set_flash_message('danger', 'Terjadi kesalahan database: ' . $e->getMessage());
            $_SESSION['form_data'] = $_POST;
            header('Location: ' . $redirect_on_error_url);
        }
        exit;
    } catch (Exception $e) { // Error Umum lainnya
        error_log("Exception processing slider ($action): " . $e->getMessage());
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan server: ' . $e->getMessage()]); }
        else {
            set_flash_message('danger', 'Terjadi kesalahan server: ' . $e->getMessage());
            $_SESSION['form_data'] = $_POST;
            header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }

} elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'delete') {
    // ... (Logika DELETE slider, pastikan CSRF divalidasi juga untuk GET delete) ...
    // Untuk GET delete, CSRF token idealnya ada di URL dan divalidasi
    if (!isset($_GET['csrf_token']) || !validate_csrf_token($_GET['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF (delete).']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token (delete).'); header('Location: ' . $module_redirect_url_base); exit;
    }
    // ... Sisa logika delete ...
    // (Anda sudah memiliki logika delete yang cukup baik di kode sebelumnya)

} else {
    // Jika bukan POST create/edit, atau GET delete yang valid
    if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'Permintaan tidak valid atau metode tidak diizinkan.']); }
    else { 
        set_flash_message('danger', 'Permintaan tidak valid.'); 
        header('Location: ' . $module_redirect_url_base); 
    }
    exit;
}
?>