<?php
// admin/modules/menus/manage_menu_items.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$menu_id = isset($_GET['menu_id']) ? (int)$_GET['menu_id'] : 0;

if ($menu_id <= 0) {
    set_flash_message('danger', 'ID Grup Menu tidak valid.');
    header('Location: index.php');
    exit;
}

$menu_group = null;
$menu_items_raw = []; 
$menu_items_hierarchical = [];

if (isset($pdo)) {
    try {
        $stmt_group = $pdo->prepare("SELECT id, name, location FROM portal_menus WHERE id = :id");
        $stmt_group->execute([':id' => $menu_id]);
        $menu_group = $stmt_group->fetch();

        if ($menu_group) {
            $stmt_items = $pdo->prepare("SELECT * FROM portal_menu_items WHERE menu_id = :menu_id ORDER BY parent_id ASC, item_order ASC, title ASC");
            $stmt_items->execute([':menu_id' => $menu_id]);
            $menu_items_raw = $stmt_items->fetchAll(PDO::FETCH_ASSOC);
            
            if (!function_exists('build_menu_tree_mmi_page')) { // Unique function name for this page
                function build_menu_tree_mmi_page(array $elements, $parentId = null) {
                    $branch = [];
                    foreach ($elements as $element) {
                        if ($element['parent_id'] == $parentId) {
                            $children = build_menu_tree_mmi_page($elements, $element['id']);
                            if ($children) {
                                $element['children'] = $children;
                            }
                            $branch[] = $element;
                        }
                    }
                    return $branch;
                }
            }
            $menu_items_hierarchical = build_menu_tree_mmi_page($menu_items_raw);

        } else {
            set_flash_message('danger', 'Grup menu tidak ditemukan.');
            header('Location: index.php');
            exit;
        }
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data menu: ' . $e->getMessage());
        error_log("Error in manage_menu_items.php (fetch data): " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}

$page_title = "Kelola Item Menu: " . esc_html($menu_group['name'] ?? 'Tidak Diketahui');
require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

// Retrieve and clear form data from session for non-JS fallback
$form_data_item_add = $_SESSION['form_data_item_add'] ?? [ 'title' => '', 'url' => '#', 'target' => '_self', 'parent_id' => null, 'item_order' => 0, 'css_class' => '', 'icon_class' => '' ];
if (isset($_SESSION['form_data_item_add'])) unset($_SESSION['form_data_item_add']);

// Function to display menu items list (initial PHP render)
if (!function_exists('display_menu_items_list_recursive_page')) {
    function display_menu_items_list_recursive_page($items, $level = 0, $menu_id_param) {
        if (empty($items)) return '';
        $html = '<ul class="list-group' . ($level > 0 ? ' ms-4 mt-1 nested-sortable' : ' sortable-list main-sortable-list') . '" data-parent-id="' . ($items[0]['parent_id'] ?? 'null') . '">';
        foreach ($items as $item) {
            $html .= '<li class="list-group-item d-flex justify-content-between align-items-center" data-id="' . $item['id'] . '" data-order="' . $item['item_order'] . '">';
            $html .= '<div>';
            $html .= '<i class="fas fa-grip-vertical me-2 text-muted drag-handle" style="cursor: move;" title="Drag untuk urutkan"></i> ';
            $html .= str_repeat('<span class="text-muted">— </span>', $level) . esc_html($item['title']);
            $html .= ' <small class="text-muted">(' . esc_html($item['url']) . ')</small>';
            $html .= '</div>';
            $html .= '<div>';
            $html .= ' <button type="button" class="btn btn-sm btn-outline-warning edit-item-btn" 
                              data-bs-toggle="modal" data-bs-target="#editMenuItemModal"
                              data-id="' . $item['id'] . '" data-title="' . esc_html($item['title']) . '"
                              data-url="' . esc_html($item['url']) . '" data-target="' . esc_html($item['target']) . '"
                              data-parentid="' . esc_html($item['parent_id'] ?? '') . '" data-order="' . esc_html($item['item_order']) . '"
                              data-cssclass="' . esc_html($item['css_class'] ?? '') . '" data-iconclass="' . esc_html($item['icon_class'] ?? '') . '"
                              title="Edit Item">
                            <i class="fas fa-edit"></i>
                          </button>';
            $html .= ' <a href="process_menu_item.php?action=delete_item&id=' . $item['id'] . '&menu_id=' . $menu_id_param . '&csrf_token=' . generate_csrf_token() . '" 
                         class="btn btn-sm btn-outline-danger btn-delete-menu-item" title="Hapus Item">
                           <i class="fas fa-trash"></i>
                         </a>';
            $html .= '</div>';
            $html .= '</li>';
            if (!empty($item['children'])) {
                $html .= display_menu_items_list_recursive_page($item['children'], $level + 1, $menu_id_param);
            }
        }
        $html .= '</ul>';
        return $html;
    }
}

// Function to generate options for parent dropdown (initial PHP render)
if (!function_exists('generate_parent_options_recursive_page')) {
    function generate_parent_options_recursive_page($items, $level = 0, $selected_parent_id = null, $prefix = '') {
        $html = '';
        foreach ($items as $item) {
            $isSelected = ($selected_parent_id !== null && $item['id'] == $selected_parent_id);
            $html .= '<option value="' . $item['id'] . '"' . ($isSelected ? ' selected' : '') . '>';
            $html .= $prefix . esc_html($item['title']);
            $html .= '</option>';
            if (!empty($item['children'])) {
                $html .= generate_parent_options_recursive_page($item['children'], $level + 1, $selected_parent_id, $prefix . '&nbsp;&nbsp;–&nbsp;');
            }
        }
        return $html;
    }
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Grup Menu', 'url' => 'index.php'],
        ['label' => esc_html($menu_group['name'] ?? 'Grup Menu'), 'url' => 'edit.php?id=' . $menu_id],
        'Kelola Item Menu'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo $page_title; ?></h1>
    <div class="mb-3">
        <a href="edit.php?id=<?php echo $menu_id; ?>" class="btn btn-outline-secondary"><i class="fas fa-arrow-left me-1"></i> Kembali ke Edit Grup Menu</a>
    </div>
    <?php echo display_flash_message(); ?>

    <div class="row">
        <div class="col-lg-7">
            <div class="card mb-4 shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><i class="fas fa-list-ul me-1"></i> Struktur Menu (ID Menu: <?php echo $menu_id; ?>)</span>
                    <button type="button" class="btn btn-sm btn-success" id="saveOrderButton" style="display:none;"><i class="fas fa-save me-1"></i> Simpan Urutan</button>
                </div>
                <div class="card-body" id="menu-items-container">
                    <?php if (!empty($menu_items_hierarchical)): ?>
                        <?php echo display_menu_items_list_recursive_page($menu_items_hierarchical, 0, $menu_id); ?>
                        <p class="mt-3 text-muted small">Drag & drop item menu untuk mengurutkan atau mengubah induknya.</p>
                    <?php else: ?>
                        <p class="text-center text-muted" id="noMenuItemsMessage">Belum ada item di grup menu ini.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-lg-5">
            <div class="card shadow-sm" id="addMenuItemCard">
                <div class="card-header"><i class="fas fa-plus-circle me-1"></i> Tambah Item Menu Baru</div>
                <div class="card-body">
                    <form action="process_menu_item.php" method="POST" id="addMenuItemForm">
                        <input type="hidden" name="action" value="add_item">
                        <input type="hidden" name="menu_id" value="<?php echo $menu_id; ?>">
                        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                        <div class="mb-3">
                            <label for="add_title" class="form-label">Judul Tampilan <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="add_title" name="title" value="<?php echo old_form_data('title', '', $form_data_item_add); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="add_url" class="form-label">URL Tujuan <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="add_url" name="url" value="<?php echo old_form_data('url', '#', $form_data_item_add); ?>" placeholder="/halaman atau https://eksternal.com" required>
                            <div class="form-text">Gunakan # untuk placeholder atau menu dropdown.</div>
                        </div>
                        <div class="mb-3">
                            <label for="add_target" class="form-label">Target</label>
                            <select class="form-select" id="add_target" name="target">
                                <option value="_self" <?php echo (old_form_data('target', '_self', $form_data_item_add) == '_self') ? 'selected' : ''; ?>>Buka di tab/jendela yang sama</option>
                                <option value="_blank" <?php echo (old_form_data('target', '_self', $form_data_item_add) == '_blank') ? 'selected' : ''; ?>>Buka di tab/jendela baru</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="add_parent_id" class="form-label">Induk Item (untuk Sub-menu)</label>
                            <select class="form-select" id="add_parent_id" name="parent_id">
                                <option value="">-- Tidak Ada Induk (Top Level) --</option>
                                <?php echo generate_parent_options_recursive_page($menu_items_hierarchical, 0, old_form_data('parent_id', null, $form_data_item_add)); ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="add_item_order" class="form-label">Urutan Item</label>
                            <input type="number" class="form-control" id="add_item_order" name="item_order" value="<?php echo old_form_data('item_order', '0', $form_data_item_add); ?>" min="0">
                            <div class="form-text">Default 0. Akan diurutkan otomatis jika tidak diisi.</div>
                        </div>
                        <div class="mb-3">
                            <label for="add_css_class" class="form-label">Kelas CSS Kustom (Opsional)</label>
                            <input type="text" class="form-control" id="add_css_class" name="css_class" value="<?php echo old_form_data('css_class', '', $form_data_item_add); ?>" placeholder="misal: btn btn-cta">
                        </div>
                        <div class="mb-3">
                            <label for="add_icon_class" class="form-label">Kelas Ikon (Opsional)</label>
                            <input type="text" class="form-control" id="add_icon_class" name="icon_class" value="<?php echo old_form_data('icon_class', '', $form_data_item_add); ?>" placeholder="misal: fas fa-home">
                        </div>
                        <button type="submit" class="btn btn-primary" id="addMenuItemButton"><i class="fas fa-plus me-1"></i> Tambah Item Menu</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editMenuItemModal" tabindex="-1" aria-labelledby="editMenuItemModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editMenuItemModalLabel">Edit Item Menu</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="process_menu_item.php" method="POST" id="editMenuItemForm">
        <div class="modal-body">
            <input type="hidden" name="action" value="edit_item">
            <input type="hidden" name="menu_id" value="<?php echo $menu_id; ?>">
            <input type="hidden" name="item_id" id="edit_item_id">
            <input type="hidden" name="csrf_token" value=""> <div class="mb-3"><label for="edit_title" class="form-label">Judul <span class="text-danger">*</span></label><input type="text" class="form-control" id="edit_title" name="title" required></div>
            <div class="mb-3"><label for="edit_url" class="form-label">URL <span class="text-danger">*</span></label><input type="text" class="form-control" id="edit_url" name="url" required></div>
            <div class="mb-3"><label for="edit_target" class="form-label">Target</label><select class="form-select" id="edit_target" name="target"><option value="_self">Tab Sama</option><option value="_blank">Tab Baru</option></select></div>
            <div class="mb-3"><label for="edit_parent_id" class="form-label">Induk</label><select class="form-select" id="edit_parent_id" name="parent_id"><option value="">-- Memuat... --</option></select></div>
            <div class="mb-3"><label for="edit_item_order" class="form-label">Urutan</label><input type="number" class="form-control" id="edit_item_order" name="item_order" min="0"></div>
            <div class="mb-3"><label for="edit_css_class" class="form-label">Kelas CSS</label><input type="text" class="form-control" id="edit_css_class" name="css_class"></div>
            <div class="mb-3"><label for="edit_icon_class" class="form-label">Kelas Ikon</label><input type="text" class="form-control" id="edit_icon_class" name="icon_class"></div>
            <div id="editMenuItemFormErrors" class="text-danger small"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" class="btn btn-primary" id="saveEditMenuItemButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php
$page_scripts = [];
$page_scripts[] = "https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js";
$page_scripts[] = "
<script>
// --- GLOBAL VARIABLES & HELPERS ---
let currentCsrfToken = '" . rawurlencode(generate_csrf_token()) . "';
const currentMenuId = " . json_encode($menu_id) . ";

// Helper function to escape HTML in JS
function escapeHtmlJs(unsafe) {
    if (unsafe === null || typeof unsafe === 'undefined') return '';
    return unsafe
         .toString()
         .replace(/&/g, \"&amp;\")
         .replace(/</g, \"&lt;\")
         .replace(/>/g, \"&gt;\")
         .replace(/\"/g, \"&quot;\")
         .replace(/'/g, \"&#039;\");
}



// --- DYNAMIC RENDERING FUNCTIONS ---

// Renders a single menu item node and its children recursively
function renderMenuItemNode(item, level, menuId) {
    let childrenHtml = '';
    if (item.children && item.children.length > 0) {
        childrenHtml = `<ul class=\"list-group ms-4 mt-1 nested-sortable\" data-parent-id=\"\${item.id}\">`;
        item.children.forEach(child => { childrenHtml += renderMenuItemNode(child, level + 1, menuId); });
        childrenHtml += '</ul>';
    }
    return `
        <li class=\"list-group-item d-flex justify-content-between align-items-center\" data-id=\"\${item.id}\" data-order=\"\${item.item_order}\">
            <div>
                <i class=\"fas fa-grip-vertical me-2 text-muted drag-handle\" style=\"cursor: move;\" title=\"Drag untuk urutkan\"></i>
                \${'<span class=\"text-muted\">— </span>'.repeat(level)}\${escapeHtmlJs(item.title)}
                <small class=\"text-muted\">(\${escapeHtmlJs(item.url)})</small>
            </div>
            <div>
                <button type=\"button\" class=\"btn btn-sm btn-outline-warning edit-item-btn\"
                        data-bs-toggle=\"modal\" data-bs-target=\"#editMenuItemModal\"
                        data-id=\"\${item.id}\" data-title=\"\${escapeHtmlJs(item.title)}\"
                        data-url=\"\${escapeHtmlJs(item.url)}\" data-target=\"\${escapeHtmlJs(item.target)}\"
                        data-parentid=\"\${item.parent_id || ''}\" data-order=\"\${item.item_order}\"
                        data-cssclass=\"\${escapeHtmlJs(item.css_class || '')}\" data-iconclass=\"\${escapeHtmlJs(item.icon_class || '')}\"
                        title=\"Edit Item\"><i class=\"fas fa-edit\"></i></button>
                <a href=\"process_menu_item.php?action=delete_item&id=\${item.id}&menu_id=\${menuId}&csrf_token=\${currentCsrfToken}\"
                   class=\"btn btn-sm btn-outline-danger btn-delete-menu-item\" title=\"Hapus Item\"><i class=\"fas fa-trash\"></i></a>
            </div>
        </li>
        \${childrenHtml}
    `;
}

// Main function to refresh the entire menu list and parent dropdowns via AJAX
function refreshFullMenuList(callback) {
    $.ajax({
        url: 'process_menu_item.php',
        method: 'GET',
        data: { action: 'get_menu_items_hierarchical', menu_id: currentMenuId, csrf_token: currentCsrfToken },
        dataType: 'json',
        success: function(response) {
            const menuContainer = $('#menu-items-container');
            menuContainer.empty(); 
            if (response.success && response.menu_items_hierarchical) {
                const menuData = response.menu_items_hierarchical;
                if (menuData.length > 0) {
                    let listHtml = '<ul class=\"list-group sortable-list main-sortable-list\" data-parent-id=\"null\">';
                    menuData.forEach(item => {
                        listHtml += renderMenuItemNode(item, 0, currentMenuId);
                    });
                    listHtml += '</ul><p class=\"mt-3 text-muted small\">Drag & drop untuk mengurutkan atau mengubah induk.</p>';
                    menuContainer.html(listHtml);
                } else {
                    menuContainer.html('<p class=\"text-center text-muted\" id=\"noMenuItemsMessage\">Belum ada item di grup menu ini.</p>');
                }
                
                initializeAllSortable(); // Re-initialize SortableJS
                updateAddFormParentDropdown(menuData); // Update 'Add' form dropdown
                
                if (typeof callback === 'function') callback(menuData);

            } else {
                showAdminNotification('warning', response.message || 'Gagal memuat ulang daftar item menu.');
            }
        },
        error: function() { showAdminNotification('danger', 'Error saat memuat ulang daftar item menu.'); }
    });
}

// Updates the parent dropdown in the 'Add Item' form
function updateAddFormParentDropdown(hierarchicalItems) {
    const parentSelectAdd = $('#add_parent_id');
    parentSelectAdd.html('<option value=\"\">-- Tidak Ada Induk (Top Level) --</option>');
    
    function populateOptions(items, selectElement, level) {
        items.forEach(item => {
            const option = $('<option></option>')
                .val(item.id)
                .html('&nbsp;'.repeat(level * 3) + '– ' + escapeHtmlJs(item.title));
            selectElement.append(option);
            if (item.children && item.children.length > 0) {
                populateOptions(item.children, selectElement, level + 1);
            }
        });
    }
    populateOptions(hierarchicalItems, parentSelectAdd, 0);
}

// --- SORTABLEJS (DRAG & DROP) ---
let mainSortable = null;
const nestedSortableInstances = [];

function initializeAllSortable() {
    if (mainSortable) mainSortable.destroy();
    nestedSortableInstances.forEach(instance => instance.destroy());
    nestedSortableInstances.length = 0;

    const mainList = document.querySelector('#menu-items-container .main-sortable-list');
    const onEndAction = () => { $('#saveOrderButton').fadeIn(); };

    if (mainList) {
        mainSortable = new Sortable(mainList, { group: 'nested-menu', animation: 150, handle: '.drag-handle', onEnd: onEndAction });
    }
    document.querySelectorAll('#menu-items-container .nested-sortable').forEach(function(nestedList) {
        nestedSortableInstances.push(new Sortable(nestedList, { group: 'nested-menu', animation: 150, handle: '.drag-handle', onEnd: onEndAction }));
    });
}

// --- DOCUMENT READY - EVENT BINDINGS ---
$(document).ready(function() {
    
    initializeAllSortable();

    // 1. ADD ITEM FORM SUBMISSION (AJAX)
    $('#addMenuItemForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#addMenuItemButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menambah...');
        form.find('input[name=\"csrf_token\"]').val(currentCsrfToken); // Ensure latest token

        $.ajax({
            url: form.attr('action'), method: form.attr('method'), data: form.serialize(), dataType: 'json',
            success: function(response) {
                currentCsrfToken = response.new_csrf_token || currentCsrfToken;
                $('input[name=\"csrf_token\"]').val(currentCsrfToken);

                if (response.success) {
                    showAdminNotification('success', response.message);
                    form[0].reset();
                    $('#add_parent_id').val('');
                    refreshFullMenuList();
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menambah item.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') { 
                        displayAdminFormErrors(form, response.errors); 
                    }
                }
            },
            error: function() { showAdminNotification('danger', 'Error server saat menambah item.'); },
            complete: function() { submitButton.prop('disabled', false).html(originalButtonText); }
        });
    });

    // 2. EDIT MODAL: POPULATE DATA & PARENT OPTIONS
    const editMenuItemModalEl = document.getElementById('editMenuItemModal');
    editMenuItemModalEl.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const itemId = button.getAttribute('data-id');
        const currentParentId = button.getAttribute('data-parentid');
        
        // Populate simple fields from data attributes
        $('#edit_item_id').val(itemId);
        $('#edit_title').val(button.getAttribute('data-title'));
        $('#edit_url').val(button.getAttribute('data-url'));
        $('#edit_target').val(button.getAttribute('data-target'));
        $('#edit_item_order').val(button.getAttribute('data-order'));
        $('#edit_css_class').val(button.getAttribute('data-cssclass'));
        $('#edit_icon_class').val(button.getAttribute('data-iconclass'));
        $('#editMenuItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
        $('#editMenuItemFormErrors').html('');

        // Populate parent dropdown with fresh data, excluding the item itself and its descendants
        const parentIdSelectEdit = $('#edit_parent_id');
        parentIdSelectEdit.html('<option value=\"\">-- Memuat daftar induk... --</option>').prop('disabled', true);

        $.ajax({
            url: 'process_menu_item.php', method: 'GET',
            data: { action: 'get_menu_items_hierarchical', menu_id: currentMenuId, csrf_token: currentCsrfToken },
            dataType: 'json',
            success: function(response) {
                if (response.success && response.menu_items_hierarchical) {
                    parentIdSelectEdit.html('<option value=\"\">-- Tidak Ada Induk --</option>');
                    
                    function populateEditOptions(items, level, idToExclude) {
                        items.forEach(item => {
                            // Prevent an item from being its own parent or a child of its descendants
                            if (item.id.toString() === idToExclude.toString()) {
                                return; 
                            }
                            const option = $('<option></option>')
                                .val(item.id)
                                .html('&nbsp;'.repeat(level * 3) + '– ' + escapeHtmlJs(item.title));
                            
                            if (currentParentId && item.id.toString() === currentParentId.toString()) {
                                option.prop('selected', true);
                            }
                            parentIdSelectEdit.append(option);

                            if (item.children && item.children.length > 0) {
                                populateEditOptions(item.children, level + 1, idToExclude);
                            }
                        });
                    }
                    populateEditOptions(response.menu_items_hierarchical, 0, itemId);
                    parentIdSelectEdit.prop('disabled', false);
                } else {
                     parentIdSelectEdit.html('<option value=\"\">-- Gagal memuat --</option>');
                }
            }
        });
    });

    // 3. EDIT ITEM FORM SUBMISSION (AJAX)
    $('#editMenuItemForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveEditMenuItemButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');
        form.find('input[name=\"csrf_token\"]').val(currentCsrfToken); // Ensure latest token

        $.ajax({
            url: form.attr('action'), method: form.attr('method'), data: form.serialize(), dataType: 'json',
            success: function(response) {
                currentCsrfToken = response.new_csrf_token || currentCsrfToken;
                $('input[name=\"csrf_token\"]').val(currentCsrfToken);

                if (response.success) {
                    bootstrap.Modal.getInstance(editMenuItemModalEl).hide();
                    showAdminNotification('success', response.message);
                    refreshFullMenuList();
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan perubahan.');
                    $('#editMenuItemFormErrors').html(response.message);
                }
            },
            error: function() { showAdminNotification('danger', 'Error server saat menyimpan perubahan.'); },
            complete: function() { submitButton.prop('disabled', false).html(originalButtonText); }
        });
    });

    // 4. DELETE ITEM (AJAX)
    $('#menu-items-container').on('click', '.btn-delete-menu-item', function(e) {
        e.preventDefault();
        if (!confirm('Anda yakin ingin menghapus item ini? Semua sub-item (anak) dari item ini juga akan terhapus.')) {
            return;
        }
        
        const deleteUrl = $(this).attr('href');
        $.ajax({
            url: deleteUrl, method: 'GET', dataType: 'json',
            success: function(response) {
                currentCsrfToken = response.new_csrf_token || currentCsrfToken;
                $('input[name=\"csrf_token\"]').val(currentCsrfToken);
                showAdminNotification(response.success ? 'success' : 'danger', response.message);
                if (response.success) {
                    refreshFullMenuList();
                }
            },
            error: function() { showAdminNotification('danger', 'Gagal menghapus item.'); }
        });
    });

    // 5. SAVE SORTED ORDER (AJAX)
    $('#saveOrderButton').on('click', function() {
        const button = $(this);
        button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        function buildSortData(listElement) {
            let data = [];
            $(listElement).children('li.list-group-item').each(function(index) {
                const li = $(this);
                const itemId = li.data('id');
                const parentUl = li.parent('ul');
                const parentId = parentUl.data('parent-id');
                
                data.push({
                    id: itemId,
                    parent_id: (parentId === 'null' || parentId === null) ? null : parentId,
                    item_order: index
                });

                const nestedList = li.children('ul.nested-sortable');
                if (nestedList.length > 0) {
                    data = data.concat(buildSortData(nestedList[0]));
                }
            });
            return data;
        }

        const orderData = buildSortData($('.main-sortable-list')[0]);
        
        $.ajax({
            url: 'process_menu_item.php',
            method: 'POST',
            data: {
                action: 'update_order',
                menu_id: currentMenuId,
                order_data: JSON.stringify(orderData),
                csrf_token: currentCsrfToken
            },
            dataType: 'json',
            success: function(response) {
                currentCsrfToken = response.new_csrf_token || currentCsrfToken;
                $('input[name=\"csrf_token\"]').val(currentCsrfToken);
                showAdminNotification(response.success ? 'success' : 'danger', response.message);
                if (response.success) {
                    button.fadeOut();
                    // Refresh to get potentially cleaned order numbers from server
                    refreshFullMenuList();
                }
            },
            error: function() { showAdminNotification('danger', 'Gagal menyimpan urutan menu.'); },
            complete: function() { button.prop('disabled', false).html('<i class=\"fas fa-save me-1\"></i> Simpan Urutan'); }
        });
    });
});
</script>
";
require_once $project_root . '/admin/includes/footer.php';
?>