<?php
// admin/modules/gallery_albums/manage_items.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__, 3)); }
require_once PROJECT_ROOT . '/config.php'; // Memuat db_connect.php dan functions.php

$module_base_path_admin = admin_url('modules/gallery_albums/'); // Untuk link internal modul

$album_id = isset($_GET['album_id']) ? (int)$_GET['album_id'] : 0;
$album_data = null;
$gallery_items = [];

if ($album_id <= 0) {
    set_flash_message('danger', 'ID Album tidak valid.');
    header('Location: ' . $module_base_path_admin . 'index.php');
    exit;
}

if (isset($pdo)) {
    try {
        // Ambil data album
        $stmt_album = $pdo->prepare("SELECT id, title, slug FROM portal_gallery_albums WHERE id = :album_id");
        $stmt_album->execute([':album_id' => $album_id]);
        $album_data = $stmt_album->fetch();

        if (!$album_data) {
            set_flash_message('danger', 'Album tidak ditemukan.');
            header('Location: ' . $module_base_path_admin . 'index.php');
            exit;
        }

        // Ambil item galeri untuk album ini, diurutkan berdasarkan item_order
        $stmt_items = $pdo->prepare("SELECT id, item_url, item_type, title, caption, item_order 
                                     FROM portal_gallery_items 
                                     WHERE album_id = :album_id 
                                     ORDER BY item_order ASC, created_at ASC");
        $stmt_items->execute([':album_id' => $album_id]);
        $gallery_items = $stmt_items->fetchAll();

    } catch (\PDOException $e) {
        error_log("Error fetching gallery items or album: " . $e->getMessage());
        set_flash_message('danger', 'Gagal mengambil data: ' . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}

$page_title = "Kelola Item Album: " . esc_html($album_data['title'] ?? 'Tidak Diketahui');

require_once PROJECT_ROOT . '/admin/includes/header.php';
require_once PROJECT_ROOT . '/admin/includes/sidebar.php';

// Data dan error form untuk Add Item (dari session jika ada redirect error)
$form_data_item_add = $_SESSION['form_data_item_add'] ?? [
    'item_type' => 'image', 'item_url_embed' => '', 'item_title' => '', 
    'item_caption' => '', 'item_order' => (count($gallery_items) + 1) * 10 // Default order
];
$form_errors_item_add = $_SESSION['form_errors_item_add'] ?? [];
if(isset($_SESSION['form_data_item_add'])) unset($_SESSION['form_data_item_add']);
if(isset($_SESSION['form_errors_item_add'])) unset($_SESSION['form_errors_item_add']);

// Data dan error form untuk Edit Item (dari session)
$form_data_item_edit = $_SESSION['form_data_item_edit'] ?? []; // Akan diisi oleh JS saat modal dibuka
$form_errors_item_edit = $_SESSION['form_errors_item_edit'] ?? [];
if(isset($_SESSION['form_data_item_edit'])) unset($_SESSION['form_data_item_edit']);
if(isset($_SESSION['form_errors_item_edit'])) unset($_SESSION['form_errors_item_edit']);

?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => admin_url('index.php')],
        ['label' => 'Manajemen Album Galeri', 'url' => $module_base_path_admin . 'index.php'],
        ['label' => esc_html($album_data['title'] ?? 'Album'), 'url' => $module_base_path_admin . 'edit.php?id=' . $album_id],
        'Kelola Item Album'
    ]); ?>

    <div class="d-flex justify-content-between align-items-center mt-4 mb-3">
        <h1 class="mb-0"><?php echo $page_title; ?></h1>
        <a href="<?php echo $module_base_path_admin . 'edit.php?id=' . $album_id; ?>" class="btn btn-outline-secondary btn-sm">
            <i class="fas fa-pencil-alt me-1"></i> Edit Detail Album
        </a>
    </div>
    <?php echo display_flash_message(); ?>

    <div class="row">
        <div class="col-lg-8 mb-4">
            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><i class="fas fa-images me-1"></i> Daftar Item dalam Album (<?php echo count($gallery_items); ?> item)</span>
                    <button type="button" class="btn btn-success btn-sm" id="saveOrderButton" style="display:none;">
                        <i class="fas fa-save me-1"></i> Simpan Urutan Item
                    </button>
                </div>
                <div class="card-body">
                    <?php if (empty($gallery_items)): ?>
                        <p class="text-muted text-center" id="noItemsMessage">Belum ada item di album ini. Silakan tambahkan item baru.</p>
                    <?php endif; ?>
                    <ul class="list-group list-group-flush" id="galleryItemsList" data-album-id="<?php echo $album_id; ?>">
                        <?php foreach ($gallery_items as $item): ?>
                            <li class="list-group-item gallery-item-sortable p-2" data-item-id="<?php echo $item['id']; ?>">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-grip-vertical me-2 text-muted item-handle" style="cursor: move;"></i>
                                    <?php if ($item['item_type'] === 'image' && !empty($item['item_url'])): ?>
                                         <img src="<?php echo resolve_url(esc_html($item['item_url'])); ?>" alt="<?php echo esc_html($item['title'] ?? 'Item Gambar'); ?>"  class="img-thumbnail me-2" style="width: 60px; height: 60px; object-fit: cover;">
                                    <?php elseif ($item['item_type'] === 'video_embed'): ?>
                                        <div class="me-2 d-flex align-items-center justify-content-center bg-dark text-white" style="width: 60px; height: 60px;">
                                            <i class="fab fa-youtube fa-2x"></i> </div>
                                    <?php endif; ?>
                                    <div class="flex-grow-1">
                                        <strong class="item-title-display"><?php echo esc_html($item['title'] ?: ($item['item_type'] === 'image' ? 'Gambar Tanpa Judul' : 'Video Embed')); ?></strong>
                                        <small class="d-block text-muted item-caption-display"><?php echo esc_html(substr($item['caption'] ?? '', 0, 50)) . (strlen($item['caption'] ?? '') > 50 ? '...' : ''); ?></small>
                                    </div>
                                    <div class="ms-auto">
                                        <button type="button" class="btn btn-outline-warning btn-sm btn-edit-item me-1" 
                                                data-item-id="<?php echo $item['id']; ?>" 
                                                data-item-type="<?php echo esc_html($item['item_type']); ?>"
                                                data-item-url="<?php echo esc_html($item['item_url']); ?>"
                                                data-item-title="<?php echo esc_html($item['title'] ?? ''); ?>"
                                                data-item-caption="<?php echo esc_html($item['caption'] ?? ''); ?>"
                                                data-item-order="<?php echo (int)$item['item_order']; ?>"
                                                title="Edit Item">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <a href="<?php echo $module_base_path_admin . 'process_gallery_item.php?action=delete_item&id=' . $item['id'] . '&album_id=' . $album_id . '&csrf_token=' . generate_csrf_token(); ?>" 
                                           class="btn btn-outline-danger btn-sm btn-delete-item" 
                                           data-item-title="<?php echo esc_html($item['title'] ?: 'Item ini'); ?>"
                                           title="Hapus Item">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </div>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                     <?php if (!empty($gallery_items)): ?>
                        <small class="d-block text-muted mt-2">Drag & drop untuk mengubah urutan item.</small>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm sticky-top" style="top: 80px;"> <div class="card-header"><i class="fas fa-plus-circle me-1"></i> Tambah Item Baru ke Album</div>
                <div class="card-body">
                    <form action="<?php echo $module_base_path_admin . 'process_gallery_item.php'; ?>" method="POST" enctype="multipart/form-data" id="addItemForm">
                        <input type="hidden" name="action" value="add_item">
                        <input type="hidden" name="album_id" value="<?php echo $album_id; ?>">
                        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                        <div class="mb-3">
                            <label for="add_item_type" class="form-label">Tipe Item <span class="text-danger">*</span></label>
                            <select class="form-select" id="add_item_type" name="item_type" required>
                                <option value="image" <?php echo (old_form_data('item_type', 'image', $form_data_item_add) == 'image') ? 'selected' : ''; ?>>Gambar</option>
                                <option value="video_embed" <?php echo (old_form_data('item_type', 'image', $form_data_item_add) == 'video_embed') ? 'selected' : ''; ?>>Video Embed (YouTube/Vimeo)</option>
                            </select>
                            <?php echo get_form_error('item_type', $form_errors_item_add); ?>
                        </div>

                        <div id="addImageFields" class="mb-3 <?php echo (old_form_data('item_type', 'image', $form_data_item_add) != 'image') ? 'd-none' : ''; ?>">
                            <label for="add_item_file" class="form-label">Upload File Gambar <span class="text-danger">*</span></label>
                            <img id="addItemImagePreview" src="#" alt="Preview Tambah Item" class="img-thumbnail mb-2" style="max-height: 120px; display: none;">
                            <input type="file" class="form-control form-control-sm" id="add_item_file" name="item_file" accept="image/jpeg, image/png, image/gif, image/webp">
                            <div class="form-text">Maks 2MB.</div>
                            <?php echo get_form_error('item_file', $form_errors_item_add); ?>
                        </div>

                        <div id="addVideoEmbedFields" class="mb-3 <?php echo (old_form_data('item_type', 'image', $form_data_item_add) != 'video_embed') ? 'd-none' : ''; ?>">
                            <label for="add_item_url_embed" class="form-label">URL Embed Video <span class="text-danger">*</span></label>
                            <input type="url" class="form-control" id="add_item_url_embed" name="item_url_embed" value="<?php echo old_form_data('item_url_embed', '', $form_data_item_add); ?>" placeholder="https://www.youtube.com/embed/VIDEO_ID">
                            <div class="form-text">Contoh: https://www.youtube.com/embed/VIDEO_ID atau https://player.vimeo.com/video/VIDEO_ID</div>
                            <?php echo get_form_error('item_url_embed', $form_errors_item_add); ?>
                        </div>
                        
                        <div class="mb-3">
                            <label for="add_item_title" class="form-label">Judul Item (Opsional)</label>
                            <input type="text" class="form-control" id="add_item_title" name="item_title" value="<?php echo old_form_data('item_title', '', $form_data_item_add); ?>">
                            <?php echo get_form_error('item_title', $form_errors_item_add); ?>
                        </div>
                        <div class="mb-3">
                            <label for="add_item_caption" class="form-label">Keterangan/Caption (Opsional)</label>
                            <textarea class="form-control" id="add_item_caption" name="item_caption" rows="2"><?php echo old_form_data('item_caption', '', $form_data_item_add); ?></textarea>
                            <?php echo get_form_error('item_caption', $form_errors_item_add); ?>
                        </div>
                        <div class="mb-3">
                             <label for="add_item_order" class="form-label">Urutan Item</label>
                            <input type="number" class="form-control form-control-sm" id="add_item_order" name="item_order" value="<?php echo old_form_data('item_order', (count($gallery_items) + 1) * 10, $form_data_item_add); ?>" min="0">
                            <div class="form-text">Angka lebih kecil tampil lebih dulu.</div>
                             <?php echo get_form_error('item_order', $form_errors_item_add); ?>
                        </div>

                        <button type="submit" class="btn btn-primary w-100" id="addItemButton"><i class="fas fa-plus me-1"></i> Tambahkan Item</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editItemModal" tabindex="-1" aria-labelledby="editItemModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editItemModalLabel">Edit Item Galeri</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo $module_base_path_admin . 'process_gallery_item.php'; ?>" method="POST" enctype="multipart/form-data" id="editItemForm">
        <div class="modal-body">
            <input type="hidden" name="action" value="edit_item">
            <input type="hidden" name="album_id" value="<?php echo $album_id; ?>">
            <input type="hidden" name="item_id" id="edit_item_id">
            <input type="hidden" name="csrf_token" value=""> <input type="hidden" name="old_item_url" id="edit_old_item_url">

            <div class="mb-3">
                <label for="edit_item_type" class="form-label">Tipe Item <span class="text-danger">*</span></label>
                <select class="form-select" id="edit_item_type" name="item_type" required>
                    <option value="image">Gambar</option>
                    <option value="video_embed">Video Embed</option>
                </select>
                <div id="edit_item_type_error" class="invalid-feedback custom-error"></div>
            </div>

            <div id="editImageFields" class="mb-3">
                <label for="edit_item_file" class="form-label">Upload File Gambar Baru (Opsional)</label>
                <div class="mb-2">
                    <small>Gambar saat ini:</small><br>
                    <img id="editItemCurrentImagePreview" src="#" alt="Gambar Item Saat Ini" class="img-thumbnail" style="max-height: 100px; display: none;">
                    <span id="editItemCurrentImageText" class="text-muted small"></span>
                </div>
                <input type="file" class="form-control form-control-sm" id="edit_item_file" name="item_file" accept="image/jpeg, image/png, image/gif, image/webp">
                <div class="form-text">Kosongkan jika tidak ingin mengubah gambar. Maks 2MB.</div>
                <div id="edit_item_file_error" class="invalid-feedback custom-error"></div>
            </div>

            <div id="editVideoEmbedFields" class="mb-3">
                <label for="edit_item_url_embed" class="form-label">URL Embed Video <span class="text-danger">*</span></label>
                <input type="url" class="form-control" id="edit_item_url_embed" name="item_url_embed" placeholder="https://www.youtube.com/embed/VIDEO_ID">
                <div id="edit_item_url_embed_error" class="invalid-feedback custom-error"></div>
            </div>
            
            <div class="mb-3">
                <label for="edit_item_title" class="form-label">Judul Item (Opsional)</label>
                <input type="text" class="form-control" id="edit_item_title" name="item_title">
                <div id="edit_item_title_error" class="invalid-feedback custom-error"></div>
            </div>
            <div class="mb-3">
                <label for="edit_item_caption" class="form-label">Keterangan/Caption (Opsional)</label>
                <textarea class="form-control" id="edit_item_caption" name="item_caption" rows="2"></textarea>
                <div id="edit_item_caption_error" class="invalid-feedback custom-error"></div>
            </div>
            <div class="mb-3">
                 <label for="edit_item_order" class="form-label">Urutan Item</label>
                <input type="number" class="form-control form-control-sm" id="edit_item_order" name="item_order" min="0">
                <div id="edit_item_order_error" class="invalid-feedback custom-error"></div>
            </div>
             <div id="editItemFormGeneralErrors" class="text-danger small mt-2"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" class="btn btn-primary" id="saveEditItemButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php
$page_scripts = [];
// Ensure SortableJS is included if you plan to use it; it was in your original $page_scripts
// If it's loaded globally or from footer.php, you might not need this line here.
// Example: $page_scripts[] = "https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"; 

$page_scripts[] = "<script>
// Helper to resolve URLs in JavaScript using BASE_URL_JS from header.php
function resolve_url_js(relativePath) {
    if (typeof BASE_URL_JS === 'undefined' || BASE_URL_JS === null || BASE_URL_JS === '') {
        console.error('BASE_URL_JS is not defined. Image paths might be incorrect.');
        // Fallback: try to construct path relative to document root if possible, or just return relativePath
        // This is a very basic fallback and might not work in all hosting configurations.
        let currentPath = window.location.pathname;
        // Crude way to get to a 'root' if BASE_URL_JS is missing, assuming 'admin' is part of path
        let adminIndex = currentPath.indexOf('/admin/');
        let basePathForFallback = adminIndex !== -1 ? currentPath.substring(0, adminIndex) : '';
        return (basePathForFallback + '/' + (relativePath || '')).replace(/\/\//g, '/'); // Avoid double slashes
    }
    return BASE_URL_JS + '/' + (relativePath || '').replace(/^\/+/, ''); // Remove leading slashes from relativePath
}

// Helper to escape HTML entities for use in JavaScript-generated HTML
function escapeHtmlJs(unsafe) {
    if (typeof unsafe !== 'string') {
        if (unsafe === null || typeof unsafe === 'undefined') {
            return '';
        }
        unsafe = String(unsafe);
    }
    return unsafe
         .replace(/&/g, \"&amp;\")
         .replace(/</g, \"&lt;\")
         .replace(/>/g, \"&gt;\")
         .replace(/\"/g, \"&quot;\")
         .replace(/'/g, \"&#039;\");
}

// Helper untuk render satu item galeri di daftar (digunakan setelah AJAX add/edit)
function renderGalleryItemLi(item, albumId, csrfToken) {
    const itemImageUrl = (item.item_type === 'image' && item.item_url)
                         ? resolve_url_js(item.item_url) // Use resolve_url_js
                         : '#';

    const itemImageHtml = item.item_type === 'image' ? 
        `<img src=\"\${escapeHtmlJs(itemImageUrl)}\" alt=\"\${escapeHtmlJs(item.title || 'Item Gambar')}\" class=\"img-thumbnail me-2\" style=\"width: 60px; height: 60px; object-fit: cover;\">` :
        `<div class=\"me-2 d-flex align-items-center justify-content-center bg-dark text-white\" style=\"width: 60px; height: 60px;\"><i class=\"fab fa-youtube fa-2x\"></i></div>`;

    return \`
        <li class=\"list-group-item gallery-item-sortable p-2\" data-item-id=\"\${item.id}\">
            <div class=\"d-flex align-items-center\">
                <i class=\"fas fa-grip-vertical me-2 text-muted item-handle\" style=\"cursor: move;\"></i>
                \${itemImageHtml}
                <div class=\"flex-grow-1\">
                    <strong class=\"item-title-display\">\${escapeHtmlJs(item.title || (item.item_type === 'image' ? 'Gambar Tanpa Judul' : 'Video Embed'))}</strong>
                    <small class=\"d-block text-muted item-caption-display\">\${escapeHtmlJs(item.caption ? item.caption.substring(0,50) + (item.caption.length > 50 ? '...' : '') : '')}</small>
                </div>
                <div class=\"ms-auto\">
                    <button type=\"button\" class=\"btn btn-outline-warning btn-sm btn-edit-item me-1\" 
                            data-item-id=\"\${item.id}\" data-item-type=\"\${escapeHtmlJs(item.item_type)}\"
                            data-item-url=\"\${escapeHtmlJs(item.item_url)}\" data-item-title=\"\${escapeHtmlJs(item.title || '')}\"
                            data-item-caption=\"\${escapeHtmlJs(item.caption || '')}\" data-item-order=\"\${parseInt(item.item_order)}\"
                            title=\"Edit Item\">
                        <i class=\"fas fa-edit\"></i>
                    </button>
                    <a href=\"<?php echo $module_base_path_admin; ?>process_gallery_item.php?action=delete_item&id=\${item.id}&album_id=\${albumId}&csrf_token=\${csrfToken}\" 
                       class=\"btn btn-outline-danger btn-sm btn-delete-item\" 
                       data-item-title=\"\${escapeHtmlJs(item.title || 'Item ini')}\"
                       title=\"Hapus Item\">
                        <i class=\"fas fa-trash\"></i>
                    </a>
                </div>
            </div>
        </li>
    \`;
}


$(document).ready(function() {
    const albumId = $('#galleryItemsList').data('album-id');
    let currentCsrfToken = $('input[name=\"csrf_token\"]').first().val(); 

    $('#add_item_type').change(function() {
        if ($(this).val() === 'image') {
            $('#addImageFields').removeClass('d-none');
            $('#addVideoEmbedFields').addClass('d-none');
            $('#add_item_file').prop('required', true);
            $('#add_item_url_embed').prop('required', false);
        } else {
            $('#addImageFields').addClass('d-none');
            $('#addVideoEmbedFields').removeClass('d-none');
            $('#add_item_file').prop('required', false);
            $('#add_item_url_embed').prop('required', true);
        }
    }).trigger('change'); 

    if (typeof initializeImagePreview === 'function') {
        initializeImagePreview('add_item_file', 'addItemImagePreview');
        // For edit modal, image preview is handled inside modal 'show' event or if input changes
    }

    $('#addItemForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#addItemButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menambah...');
        
        const formData = new FormData(this);
        // Ensure CSRF token is up-to-date if page reuses tokens without reload
        currentCsrfToken = form.find('input[name=\"csrf_token\"]').val(); 
        formData.set('csrf_token', currentCsrfToken);


        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error, .invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'), method: form.attr('method'), data: formData,
            processData: false, contentType: false, dataType: 'json',
            success: function(response) {
                if (response.success && response.item) {
                    showAdminNotification('success', response.message);
                    form[0].reset();
                    $('#addItemImagePreview').hide().attr('src', '#');
                    $('#add_item_type').trigger('change'); 
                    
                    // Update CSRF token for the next AJAX request on this form if a new one is provided
                    if(response.new_csrf_token) {
                        currentCsrfToken = response.new_csrf_token;
                        form.find('input[name=\"csrf_token\"]').val(currentCsrfToken);
                        // Also update token in edit modal form preemptively
                        $('#editItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                    }
                    
                    const newItemLi = renderGalleryItemLi(response.item, albumId, currentCsrfToken); // Pass currentCsrfToken
                    $('#galleryItemsList').append(newItemLi);
                    $('#noItemsMessage').hide();
                    $('#add_item_order').val( (parseInt($('#galleryItemsList li').length) + 1) * 10 );

                } else {
                    showAdminNotification('danger', response.message || 'Gagal menambah item.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                    if(response.new_csrf_token) { // Update CSRF even on failure
                        currentCsrfToken = response.new_csrf_token;
                        form.find('input[name=\"csrf_token\"]').val(currentCsrfToken);
                        $('#editItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                    }
                }
            },
            error: function(jqXHR) { 
                let errorMsg = 'Kesalahan server.';
                if(jqXHR.responseJSON && jqXHR.responseJSON.message) errorMsg = jqXHR.responseJSON.message;
                showAdminNotification('danger', errorMsg);
                 if(jqXHR.responseJSON && jqXHR.responseJSON.new_csrf_token) { // Update CSRF on server error
                    currentCsrfToken = jqXHR.responseJSON.new_csrf_token;
                    form.find('input[name=\"csrf_token\"]').val(currentCsrfToken);
                    $('#editItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                }
            },
            complete: function() { submitButton.prop('disabled', false).html(originalButtonText); }
        });
    });

    const editItemModalElement = document.getElementById('editItemModal');
    const editItemModal = editItemModalElement ? new bootstrap.Modal(editItemModalElement) : null;
    const editForm = $('#editItemForm');
    
    $('#galleryItemsList').on('click', '.btn-edit-item', function() {
        if (!editItemModal) return;
        const itemData = $(this).data();
        editForm[0].reset();
        editForm.find('.is-invalid').removeClass('is-invalid');
        editForm.find('.invalid-feedback.custom-error, .invalid-feedback').html('');
        $('#editItemFormGeneralErrors').html('');
        editForm.find('input[name=\"csrf_token\"]').val(currentCsrfToken); // Use current CSRF

        $('#edit_item_id').val(itemData.itemId);
        $('#edit_item_type').val(itemData.itemType).trigger('change'); 
        $('#edit_item_title').val(itemData.itemTitle);
        $('#edit_item_caption').val(itemData.itemCaption);
        $('#edit_item_order').val(itemData.itemOrder);
        $('#edit_old_item_url').val(itemData.itemUrl); 

        if (itemData.itemType === 'image') {
            $('#editImageFields').removeClass('d-none');
            $('#editVideoEmbedFields').addClass('d-none');
            $('#edit_item_url_embed').val(''); // Clear video embed field
             $('#edit_item_file').prop('required', false); // Not required if not changing
             $('#edit_item_url_embed').prop('required', false);


            if (itemData.itemUrl && itemData.itemUrl !== '#' && itemData.itemUrl.trim() !== '') {
                $('#editItemCurrentImagePreview').attr('src', resolve_url_js(itemData.itemUrl)).show(); 
                $('#editItemCurrentImageText').text('');
            } else {
                $('#editItemCurrentImagePreview').hide().attr('src', '#');
                $('#editItemCurrentImageText').text('Tidak ada gambar saat ini.');
            }
            $('#edit_item_file').val(''); 
        } else { 
            $('#editImageFields').addClass('d-none');
            $('#editVideoEmbedFields').removeClass('d-none');
            $('#edit_item_url_embed').val(itemData.itemUrl);
            $('#editItemCurrentImagePreview').hide().attr('src', '#');
            $('#editItemCurrentImageText').text('');
            $('#edit_item_file').prop('required', false);
            $('#edit_item_url_embed').prop('required', true);
        }
        editItemModal.show();
    });

    if (typeof initializeImagePreview === 'function') { // For edit modal new image preview
        initializeImagePreview('edit_item_file', 'editItemCurrentImagePreview');
    }


    $('#edit_item_type').change(function() {
        if ($(this).val() === 'image') {
            $('#editImageFields').removeClass('d-none');
            $('#editVideoEmbedFields').addClass('d-none');
            $('#edit_item_file').prop('required', false); // Only required if new image uploaded, server handles this
            $('#edit_item_url_embed').prop('required', false);
        } else {
            $('#editImageFields').addClass('d-none');
            $('#editVideoEmbedFields').removeClass('d-none');
            $('#edit_item_file').prop('required', false);
            $('#edit_item_url_embed').prop('required', true);
        }
    });

    editForm.on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveEditItemButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');
        
        const formData = new FormData(this);
        // Ensure CSRF token is up-to-date
        formData.set('csrf_token', currentCsrfToken);

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error, .invalid-feedback').html('');
        $('#editItemFormGeneralErrors').html('');


        $.ajax({
            url: form.attr('action'), method: form.attr('method'), data: formData,
            processData: false, contentType: false, dataType: 'json',
            success: function(response) {
                if (response.success && response.item) {
                    showAdminNotification('success', response.message);
                    if (editItemModal) editItemModal.hide();
                    
                    if(response.new_csrf_token) { // Update CSRF token
                        currentCsrfToken = response.new_csrf_token;
                        form.find('input[name=\"csrf_token\"]').val(currentCsrfToken);
                        $('#addItemForm input[name=\"csrf_token\"]').val(currentCsrfToken); // Also update add form
                    }

                    const editedLi = $('#galleryItemsList li[data-item-id=\"' + response.item.id + '\"]');
                    if (editedLi.length) {
                        // Pass currentCsrfToken for delete link in re-rendered item
                        editedLi.replaceWith(renderGalleryItemLi(response.item, albumId, currentCsrfToken));
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal memperbarui item.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors); 
                    } else if(response.message) {
                         $('#editItemFormGeneralErrors').text(response.message);
                    }
                    if(response.new_csrf_token) { // Update CSRF even on failure
                        currentCsrfToken = response.new_csrf_token;
                        form.find('input[name=\"csrf_token\"]').val(currentCsrfToken);
                        $('#addItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                    }
                }
            },
            error: function(jqXHR) { 
                let errorMsg = 'Kesalahan server.';
                if(jqXHR.responseJSON && jqXHR.responseJSON.message) errorMsg = jqXHR.responseJSON.message;
                $('#editItemFormGeneralErrors').text(errorMsg);
                showAdminNotification('danger', 'Gagal memperbarui: ' + errorMsg);
                if(jqXHR.responseJSON && jqXHR.responseJSON.new_csrf_token) { // Update CSRF on server error
                    currentCsrfToken = jqXHR.responseJSON.new_csrf_token;
                    form.find('input[name=\"csrf_token\"]').val(currentCsrfToken);
                    $('#addItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                }
            },
            complete: function() { submitButton.prop('disabled', false).html(originalButtonText); }
        });
    });

    $('#galleryItemsList').on('click', '.btn-delete-item', function(e) {
        e.preventDefault();
        const button = $(this);
        let deleteUrl = button.attr('href'); // URL already contains CSRF from renderGalleryItemLi
        const itemTitle = button.data('item-title');
        
        if (confirm('Anda yakin ingin menghapus item: ' + itemTitle + '? Aksi ini tidak dapat dibatalkan.')) {
            const originalButtonHtml = button.html();
            button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
            
            // Ensure the latest CSRF token is part of the URL if it changed since rendering
            // This is safer if tokens are frequently refreshed.
            // For GET, we modify the href. For POST, it'd be in data.
            const urlParts = deleteUrl.split('csrf_token=');
            if (urlParts.length > 1) {
                const baseAndParams = urlParts[0];
                const otherParams = urlParts[1].substring(urlParts[1].indexOf('&')); // Get params after token
                deleteUrl = baseAndParams + 'csrf_token=' + currentCsrfToken + (otherParams.startsWith('&') ? otherParams : '');
            } else { // Fallback if csrf_token wasn't in the original URL structure (shouldn't happen with renderGalleryItemLi)
                 deleteUrl += (deleteUrl.includes('?') ? '&' : '?') + 'csrf_token=' + currentCsrfToken;
            }
            button.attr('href', deleteUrl); // Update href just in case, though AJAX uses this value

            $.ajax({
                url: deleteUrl, method: 'GET', dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        showAdminNotification('success', response.message);
                        button.closest('li.gallery-item-sortable').fadeOut(300, function() { $(this).remove(); });
                        if ($('#galleryItemsList li').length === 0) {
                             $('#noItemsMessage').show();
                        }
                    } else {
                        showAdminNotification('danger', response.message || 'Gagal menghapus item.');
                        button.prop('disabled', false).html(originalButtonHtml);
                    }
                     if(response.new_csrf_token) { // Update CSRF token
                        currentCsrfToken = response.new_csrf_token;
                        // Update tokens on forms
                        $('#addItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                        $('#editItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                        // Note: Re-rendering list items or updating their delete links with new CSRF might be needed
                        // if user performs multiple deletes without page reload and tokens change each time.
                        // For simplicity, this example primarily updates form tokens.
                    }
                },
                error: function(jqXHR) { 
                    showAdminNotification('danger', 'Kesalahan server saat menghapus.');
                    button.prop('disabled', false).html(originalButtonHtml);
                     if(jqXHR.responseJSON && jqXHR.responseJSON.new_csrf_token) {
                        currentCsrfToken = jqXHR.responseJSON.new_csrf_token;
                        $('#addItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                        $('#editItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                    }
                }
            });
        }
    });

    const sortableList = document.getElementById('galleryItemsList');
    if (sortableList && typeof Sortable !== 'undefined') {
        new Sortable(sortableList, {
            animation: 150,
            handle: '.item-handle', 
            ghostClass: 'bg-light', 
            onEnd: function (evt) {
                $('#saveOrderButton').fadeIn();
            }
        });

        $('#saveOrderButton').click(function() {
            const button = $(this);
            const originalText = button.html();
            button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan urutan...');

            const orderedItems = [];
            $('#galleryItemsList li.gallery-item-sortable').each(function(index) {
                orderedItems.push({
                    id: $(this).data('item-id'),
                    order: (index + 1) * 10 
                });
            });

            $.ajax({
                url: '<?php echo $module_base_path_admin; ?>process_gallery_item.php', 
                method: 'POST',
                data: {
                    action: 'save_order',
                    album_id: albumId,
                    ordered_items: orderedItems,
                    csrf_token: currentCsrfToken 
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        showAdminNotification('success', response.message);
                        button.fadeOut();
                        $.each(orderedItems, function(i, itemData){
                            $('li[data-item-id=\"'+itemData.id+'\"]').find('.btn-edit-item').data('item-order', itemData.order);
                        });
                    } else {
                        showAdminNotification('danger', response.message || 'Gagal menyimpan urutan.');
                    }
                    if(response.new_csrf_token) { // Update CSRF token
                        currentCsrfToken = response.new_csrf_token;
                        $('#addItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                        $('#editItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                    }
                },
                error: function(jqXHR) { 
                    showAdminNotification('danger', 'Kesalahan server saat menyimpan urutan.'); 
                    if(jqXHR.responseJSON && jqXHR.responseJSON.new_csrf_token) {
                        currentCsrfToken = jqXHR.responseJSON.new_csrf_token;
                        $('#addItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                        $('#editItemForm input[name=\"csrf_token\"]').val(currentCsrfToken);
                    }
                },
                complete: function() { button.prop('disabled', false).html(originalText); }
            });
        });
    }
});
</script>";

require_once PROJECT_ROOT . '/admin/includes/footer.php';
?>