<?php
// admin/modules/events/create.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Tambah Acara Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => '', 'slug' => '', 'description_html' => '',
    'start_datetime' => date('Y-m-d\TH:i'), 'end_datetime' => '',
    'location' => '', 'organizer' => '', 'contact_person' => '',
    'contact_email' => '', 'contact_phone' => '', 'event_url' => '',
    'is_published' => 1,
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <form action="process_event.php" method="POST" enctype="multipart/form-data" id="eventForm">
        <input type="hidden" name="action" value="create">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

        <div class="row">
            <div class="col-lg-9">
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-calendar-plus me-1"></i> Detail Acara</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Judul Acara <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', '', $form_data); ?>" required>
                            <?php echo get_form_error('title', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="slug" class="form-label">Slug (URL Friendly)</label>
                            <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', '', $form_data); ?>" placeholder="Otomatis jika kosong">
                            <?php echo get_form_error('slug', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="description_html" class="form-label">Deskripsi Acara (Opsional)</label>
                            <textarea class="form-control" id="description_html" name="description_html" rows="10"><?php echo old_form_data('description_html', '', $form_data); ?></textarea>
                            <?php echo get_form_error('description_html', $form_errors); ?>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="location" class="form-label">Lokasi Acara (Opsional)</label>
                                <input type="text" class="form-control" id="location" name="location" value="<?php echo old_form_data('location', '', $form_data); ?>">
                                <?php echo get_form_error('location', $form_errors); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="organizer" class="form-label">Penyelenggara (Opsional)</label>
                                <input type="text" class="form-control" id="organizer" name="organizer" value="<?php echo old_form_data('organizer', '', $form_data); ?>">
                                <?php echo get_form_error('organizer', $form_errors); ?>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="event_url" class="form-label">URL Eksternal Acara (Opsional)</label>
                            <input type="url" class="form-control" id="event_url" name="event_url" value="<?php echo old_form_data('event_url', '', $form_data); ?>" placeholder="https://linkpendaftaran.com">
                            <?php echo get_form_error('event_url', $form_errors); ?>
                        </div>
                    </div>
                </div>
                 <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-address-book me-1"></i> Informasi Kontak Acara (Opsional)</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="contact_person" class="form-label">Narahubung</label>
                                <input type="text" class="form-control" id="contact_person" name="contact_person" value="<?php echo old_form_data('contact_person', '', $form_data); ?>">
                                <?php echo get_form_error('contact_person', $form_errors); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="contact_email" class="form-label">Email Kontak</label>
                                <input type="email" class="form-control" id="contact_email" name="contact_email" value="<?php echo old_form_data('contact_email', '', $form_data); ?>">
                                <?php echo get_form_error('contact_email', $form_errors); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="contact_phone" class="form-label">Telepon Kontak</label>
                                <input type="tel" class="form-control" id="contact_phone" name="contact_phone" value="<?php echo old_form_data('contact_phone', '', $form_data); ?>">
                                <?php echo get_form_error('contact_phone', $form_errors); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3">
                <div class="card mb-4 shadow-sm sticky-lg-top" style="top: 70px;">
                    <div class="card-header"><i class="fas fa-cog me-1"></i> Pengaturan Publikasi</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="start_datetime" class="form-label">Tanggal & Waktu Mulai <span class="text-danger">*</span></label>
                            <input type="datetime-local" class="form-control" id="start_datetime" name="start_datetime" value="<?php echo old_form_data('start_datetime', date('Y-m-d\TH:i'), $form_data); ?>" required>
                            <?php echo get_form_error('start_datetime', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="end_datetime" class="form-label">Tanggal & Waktu Selesai (Opsional)</label>
                            <input type="datetime-local" class="form-control" id="end_datetime" name="end_datetime" value="<?php echo old_form_data('end_datetime', '', $form_data); ?>">
                            <?php echo get_form_error('end_datetime', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="is_published" class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select" id="is_published" name="is_published" required>
                                <option value="1" <?php echo (old_form_data('is_published', '1', $form_data) == '1') ? 'selected' : ''; ?>>Publikasikan</option>
                                <option value="0" <?php echo (old_form_data('is_published', '1', $form_data) == '0') ? 'selected' : ''; ?>>Simpan sebagai Draft</option>
                            </select>
                            <?php echo get_form_error('is_published', $form_errors); ?>
                        </div>
                        <button type="submit" class="btn btn-primary w-100" id="saveEventButton"><i class="fas fa-save me-1"></i> Simpan Acara</button>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-image me-1"></i> Gambar Unggulan (Opsional)</div>
                    <div class="card-body text-center">
                        <img id="featuredImagePreview" src="#" alt="Preview Gambar Unggulan" class="img-thumbnail mb-2" style="max-height: 150px; display: none;">
                        <input type="file" class="form-control form-control-sm" id="featured_image_file" name="featured_image_file" accept="image/jpeg, image/png, image/gif, image/webp">
                        <div class="form-text">Rekomendasi: min. 800x450px. Maks 2MB.</div>
                        <?php echo get_form_error('featured_image_file', $form_errors); // Ganti error key jika perlu ?>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php
$page_scripts = [];
$page_scripts[] = "https://cdn.tiny.cloud/1/qlw978ky0kcpi9tdpmnoih6myrw4usd6crxwdzms7b9jm9ic/tinymce/6/tinymce.min.js"; // Ganti API Key Anda
$page_scripts[] = "<script>
$(document).ready(function() {
    tinymce.init({
      selector: 'textarea#description_html',
      plugins: 'lists link image table code help wordcount autoresize preview fullscreen media visualblocks',
      toolbar: 'undo redo | styles | bold italic | bullist numlist | link image | code preview',
      height: 350,
      menubar: false
    });

    if (typeof initializeSlugGenerator === 'function') {
        initializeSlugGenerator('title', 'slug');
    }
    if (typeof initializeImagePreview === 'function') {
        initializeImagePreview('featured_image_file', 'featuredImagePreview');
    }

    $('#eventForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveEventButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        if (typeof tinymce !== 'undefined' && tinymce.get('description_html')) {
            tinymce.get('description_html').save();
        }
        const formData = new FormData(this);

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) {
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    } else {
                        form[0].reset();
                        if (tinymce.get('description_html')) tinymce.get('description_html').setContent('');
                        $('#slug').val('');
                        $('#featuredImagePreview').hide().attr('src', '#');
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan acara.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>