<?php
// /oldugk/admin/modules/contact_messages/process_message_new.php

// Sesuaikan path jika Anda membuat config_new.php terpisah atau cara lain
$project_root_pm = dirname(__DIR__, 3); // Mundur 3 level ke /oldugk/

// Ini akan memuat $pdo dari db_connect_new.php
require_once $project_root_pm . '/includes/db_connect_new.php';
// Ini akan memuat fungsi seperti validate_csrf_token, esc_html, set_flash_message (jika dibutuhkan AJAX)
require_once $project_root_pm . '/admin/includes/functions_new.php';

// Pastikan $pdo ada
if (!isset($pdo)) {
    header('Content-Type: application/json');
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Koneksi database tidak tersedia. (PMN01)']);
    exit;
}

// Default response
$response = ['success' => false, 'message' => 'Aksi tidak valid atau gagal.'];
http_response_code(400); // Bad Request by default

// Validasi Metode (Harus POST untuk AJAX yang aman)
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { // Ubah ini ke POST jika Anda meng-AJAX sebagai POST
    // Jika Anda masih menggunakan GET dari link untuk beberapa aksi (tidak ideal)
    // Anda mungkin perlu logika if/else di sini atau memisahkan file
    // Untuk contoh ini, kita asumsikan bisa GET atau POST untuk fleksibilitas awal
    // tapi POST lebih direkomendasikan untuk aksi modifikasi
    $request_data = $_SERVER['REQUEST_METHOD'] === 'POST' ? $_POST : $_GET;
} else {
    $request_data = $_POST;
}


// Validasi CSRF
if (!isset($request_data['csrf_token']) || !validate_csrf_token($request_data['csrf_token'])) {
    http_response_code(403);
    $response = ['success' => false, 'message' => 'Validasi keamanan gagal. (CSRF_NEW)'];
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// Ambil action dan ID
$action = isset($request_data['action']) ? trim($request_data['action']) : null;
$message_id = isset($request_data['message_id']) ? (int)$request_data['message_id'] : (isset($request_data['id']) ? (int)$request_data['id'] : 0);


if (empty($action) || $message_id <= 0) {
    $response['message'] = 'Parameter aksi atau ID pesan tidak valid.';
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

try {
    switch ($action) {
        case 'mark_read':
            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET is_read = 1, read_at = NOW() WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Pesan ditandai sudah dibaca.'];
            } else {
                $response['message'] = 'Pesan sudah dibaca atau tidak ditemukan.';
            }
            break;

        case 'mark_unread':
            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET is_read = 0, read_at = NULL WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Pesan ditandai belum dibaca.'];
            } else {
                $response['message'] = 'Pesan sudah belum dibaca atau tidak ditemukan.';
            }
            break;
        
        case 'archive':
            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET is_archived = 1, archived_at = NOW() WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Pesan berhasil diarsipkan.'];
            } else {
                $response['message'] = 'Pesan sudah diarsipkan atau tidak ditemukan.';
            }
            break;

        case 'unarchive':
            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET is_archived = 0, archived_at = NULL WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Pengarsipan pesan dibatalkan.'];
            } else {
                $response['message'] = 'Pesan tidak diarsipkan atau tidak ditemukan.';
            }
            break;

        case 'delete':
            $stmt = $pdo->prepare("DELETE FROM portal_contact_messages WHERE id = :id");
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                http_response_code(200);
                $response = ['success' => true, 'message' => 'Pesan berhasil dihapus permanen.'];
            } else {
                $response['message'] = 'Pesan tidak ditemukan untuk dihapus.';
            }
            break;

        case 'add_note':
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                 $response = ['success' => false, 'message' => 'Metode tidak diizinkan untuk aksi ini.'];
                 break;
            }
            $note_content = isset($_POST['note_content']) ? trim($_POST['note_content']) : '';
            if (empty($note_content)) {
                $response = ['success' => false, 'message' => 'Isi catatan tidak boleh kosong.', 'errors' => ['note_content' => 'Isi catatan wajib diisi.']];
                break;
            }
            // Ambil catatan lama, tambahkan yang baru
            $stmt_get_notes = $pdo->prepare("SELECT notes FROM portal_contact_messages WHERE id = :id");
            $stmt_get_notes->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt_get_notes->execute();
            $current_notes_data = $stmt_get_notes->fetch();
            
            $current_notes = $current_notes_data ? $current_notes_data['notes'] : '';
            $new_note_entry = "[" . date('d M Y H:i') . " - " . ($_SESSION['username'] ?? 'Admin') . "]:\n" . $note_content;
            $updated_notes = $current_notes ? $current_notes . "\n\n---\n\n" . $new_note_entry : $new_note_entry;

            $stmt = $pdo->prepare("UPDATE portal_contact_messages SET notes = :notes WHERE id = :id");
            $stmt->bindParam(':notes', $updated_notes, PDO::PARAM_STR);
            $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt->execute();
            
            http_response_code(200);
            $response = ['success' => true, 'message' => 'Catatan berhasil ditambahkan.'];
            break;
            
        default:
            $response['message'] = 'Aksi tidak dikenal: ' . esc_html($action);
            break;
    }
} catch (\PDOException $e) {
    error_log("Process Message Error (New): " . $e->getMessage() . " for action: $action, id: $message_id");
    http_response_code(500); // Internal Server Error
    $response['message'] = 'Terjadi kesalahan pada server: ' . $e->getMessage();
}

// Selalu generate CSRF token baru untuk dikirim balik jika diperlukan oleh klien
// Terutama jika Anda menggunakan token sekali pakai atau ingin AJAX selanjutnya aman
// $response['new_csrf_token'] = generate_csrf_token(); // Aktifkan jika Anda mengimplementasikan refresh token

header('Content-Type: application/json');
echo json_encode($response);
exit;
?>