<?php
// admin/modules/categories/process_category.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 3));
}
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

function is_ajax_request_category() {
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}
$is_ajax = is_ajax_request_category();
if ($is_ajax) {
    header('Content-Type: application/json');
}

$module_redirect_url_base = 'index.php';

// Hanya admin dan editor yang bisa create/edit kategori, hanya admin yang bisa delete
$action = $_POST['action'] ?? $_GET['action'] ?? null;
if (($action === 'create' || $action === 'edit') && !in_array($_SESSION['role'], ['admin', 'editor'])) {
    if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Akses ditolak.']); exit; }
    set_flash_message('danger', 'Anda tidak memiliki izin untuk aksi ini.'); header('Location: '. $module_redirect_url_base); exit;
}
if ($action === 'delete' && $_SESSION['role'] !== 'admin') {
    if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Akses ditolak.']); exit; }
    set_flash_message('danger', 'Anda tidak memiliki izin untuk aksi ini.'); header('Location: '. $module_redirect_url_base); exit;
}
if (!isset($_SESSION['user_id'])) { // General login check
    if ($is_ajax) { http_response_code(401); echo json_encode(['success' => false, 'message' => 'Sesi tidak valid.']); exit; }
    header('Location: ../../login.php'); exit;
}


if (!isset($pdo)) {
    if ($is_ajax) { http_response_code(503); echo json_encode(['success' => false, 'message' => 'Koneksi database gagal.']); exit; }
    set_flash_message('danger', 'Koneksi database gagal.'); header('Location: ' . $module_redirect_url_base); exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.');
        $action_post = $_POST['action'] ?? 'create';
        $id_post = $_POST['id'] ?? null;
        header('Location: ' . ($action_post === 'edit' && $id_post ? 'edit.php?id=' . $id_post : 'create.php'));
        exit;
    }

    // $action sudah di-set di atas
    $category_id = isset($_POST['id']) ? (int)$_POST['id'] : null;
    $redirect_on_error_url = ($action === 'edit' && $category_id ? 'edit.php?id=' . $category_id : 'create.php');

    $name = trim($_POST['name'] ?? '');
    $slug_input = trim($_POST['slug'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $parent_id = !empty($_POST['parent_id']) ? (int)$_POST['parent_id'] : null;

    $errors = [];
    if (empty($name)) {
        $errors['name'] = 'Nama kategori wajib diisi.';
    }
    if ($parent_id !== null && $parent_id == $category_id && $action === 'edit') {
        $errors['parent_id'] = 'Kategori tidak bisa menjadi parent untuk dirinya sendiri.';
    }

    $slug = !empty($slug_input) ? generate_slug($slug_input) : generate_slug($name);
    if (empty($slug)) {
        $errors['slug'] = 'Slug tidak boleh kosong (jika nama hanya berisi karakter spesial).';
    } else {
        $stmt_check_slug = $pdo->prepare("SELECT id FROM portal_categories WHERE slug = :slug" . ($category_id ? " AND id != :id_category" : ""));
        $params_check_slug = [':slug' => $slug];
        if ($category_id) $params_check_slug[':id_category'] = $category_id;
        $stmt_check_slug->execute($params_check_slug);
        if ($stmt_check_slug->fetch()) {
            $errors['slug'] = 'Slug "' . esc_html($slug) . '" sudah digunakan.';
        }
    }

    if (!empty($errors)) {
        if ($is_ajax) {
            http_response_code(422);
            echo json_encode(['success' => false, 'message' => 'Validasi gagal.', 'errors' => $errors]);
        } else {
            $_SESSION['form_errors'] = $errors;
            $_SESSION['form_data'] = $_POST;
            set_flash_message('danger', 'Gagal menyimpan kategori. Harap periksa input Anda.');
            header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }

    try {
        // ... (SQL dan params seperti sebelumnya) ...
        if ($action === 'create') {
            $sql = "INSERT INTO portal_categories (name, slug, description, parent_id, created_at, updated_at)
                    VALUES (:name, :slug, :description, :parent_id, NOW(), NOW())";
            $stmt = $pdo->prepare($sql);
        } elseif ($action === 'edit' && $category_id) {
            $sql = "UPDATE portal_categories SET name = :name, slug = :slug, description = :description, parent_id = :parent_id, updated_at = NOW()
                    WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $category_id, PDO::PARAM_INT);
        } else {
            throw new Exception("Aksi tidak valid.");
        }

        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':slug', $slug);
        $stmt->bindParam(':description', $description);
        $stmt->bindParam(':parent_id', $parent_id, $parent_id === null ? PDO::PARAM_NULL : PDO::PARAM_INT);
        $stmt->execute();

        if ($is_ajax) {
            echo json_encode(['success' => true, 'message' => 'Kategori berhasil ' . ($action === 'create' ? 'dibuat' : 'diperbarui') . '.', 'redirect_url' => $module_redirect_url_base]);
        } else {
            set_flash_message('success', 'Kategori berhasil ' . ($action === 'create' ? 'dibuat' : 'diperbarui') . '.');
            header('Location: ' . $module_redirect_url_base);
        }
        exit;

    } catch (PDOException | Exception $e) {
        error_log("Error processing category ($action): " . $e->getMessage());
        if ($is_ajax) {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan: ' . $e->getMessage()]);
        } else {
            set_flash_message('danger', 'Terjadi kesalahan: ' . $e->getMessage());
            $_SESSION['form_data'] = $_POST;
            header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }

} elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && $action === 'delete') {
    if (!isset($_GET['csrf_token']) || !validate_csrf_token($_GET['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.'); header('Location: ' . $module_redirect_url_base); exit;
    }

    $category_id_to_delete = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    if ($category_id_to_delete <= 0) {
        if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'ID Kategori tidak valid.']); exit; }
        set_flash_message('danger', 'ID kategori tidak valid.'); header('Location: ' . $module_redirect_url_base); exit;
    }

    try {
        // ... (Cek artikel dan sub-kategori seperti sebelumnya) ...
        $stmt_check_articles = $pdo->prepare("SELECT COUNT(*) FROM portal_articles WHERE category_id = :category_id");
        $stmt_check_articles->execute([':category_id' => $category_id_to_delete]);
        if ($stmt_check_articles->fetchColumn() > 0) {
            if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'Kategori tidak dapat dihapus karena masih digunakan oleh artikel.']); exit;}
            set_flash_message('warning', 'Kategori tidak dapat dihapus karena masih digunakan oleh artikel.'); header('Location: ' . $module_redirect_url_base); exit;
        }
        
        $stmt_check_children = $pdo->prepare("SELECT COUNT(*) FROM portal_categories WHERE parent_id = :parent_id");
        $stmt_check_children->execute([':parent_id' => $category_id_to_delete]);
        if ($stmt_check_children->fetchColumn() > 0) {
             if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'Kategori tidak dapat dihapus karena merupakan parent dari sub-kategori.']); exit;}
            set_flash_message('warning', 'Kategori tidak dapat dihapus karena merupakan parent dari sub-kategori.'); header('Location: ' . $module_redirect_url_base); exit;
        }

        $stmt_delete = $pdo->prepare("DELETE FROM portal_categories WHERE id = :id");
        $stmt_delete->execute([':id' => $category_id_to_delete]);

        if ($stmt_delete->rowCount() > 0) {
            if ($is_ajax) { echo json_encode(['success' => true, 'message' => 'Kategori berhasil dihapus.']); }
            else { set_flash_message('success', 'Kategori berhasil dihapus.'); header('Location: ' . $module_redirect_url_base); }
        } else {
            if ($is_ajax) { echo json_encode(['success' => false, 'message' => 'Kategori tidak ditemukan atau sudah dihapus.']); }
            else { set_flash_message('warning', 'Kategori tidak ditemukan atau sudah dihapus.'); header('Location: ' . $module_redirect_url_base); }
        }
    } catch (PDOException $e) {
        error_log("Error deleting category: " . $e->getMessage());
        $error_message_user = 'Gagal menghapus kategori: Kesalahan database.';
        if ($e->getCode() == '23000') {
             $error_message_user = 'Gagal menghapus kategori. Pastikan tidak ada entitas lain yang masih menggunakan kategori ini.';
        }
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => $error_message_user]); }
        else { set_flash_message('danger', $error_message_user); header('Location: ' . $module_redirect_url_base); }
    }
    exit;

} else {
    if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'Permintaan tidak valid.']); }
    else { set_flash_message('danger', 'Permintaan tidak valid.'); header('Location: ' . $module_redirect_url_base); }
    exit;
}
?>