
<?php
// admin/login.php
// THIS MUST BE THE VERY FIRST LINE OF PHP CODE
require_once dirname(__DIR__) . '/config.php'; 
// config.php now handles:
// - PROJECT_ROOT, BASE_URL definition
// - Session start (session_start())
// - Error reporting settings
// - Timezone
// - Loading root includes/functions.php (for resolve_url, esc_html)
// - Loading admin/includes/functions.php (for admin_url, CSRF, form helpers, etc.)
// - Loading includes/db_connect.php (for $pdo)
// - Loading global $settings from database

// Function to check if it's an AJAX request
function is_ajax_request_login() { // Keep this local or move to admin/includes/functions.php if used elsewhere
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}

$is_ajax_login = is_ajax_request_login();
if ($is_ajax_login) {
    header('Content-Type: application/json');
}

// If already logged in, redirect to admin dashboard
if (isset($_SESSION['user_id'])) {
    $dashboard_url = admin_url('index.php'); // Use admin_url()
    if ($is_ajax_login) { echo json_encode(['success' => true, 'redirect_url' => $dashboard_url, 'message' => 'Sudah login. Mengarahkan...']); exit; }
    header('Location: ' . $dashboard_url); exit;
}

$error_message = '';
$username_value = '';
$new_csrf_token_for_response = generate_csrf_token(); // Generate initial/new token for the form

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
       $error_message = 'Kesalahan validasi keamanan (CSRF). Silakan coba lagi.';
       // Regenerate token for the next attempt
       $_SESSION['csrf_token'] = null; // Clear old one
       $new_csrf_token_for_response = generate_csrf_token();
       if ($is_ajax_login) { http_response_code(403); echo json_encode(['success' => false, 'message' => $error_message, 'new_csrf_token' => $new_csrf_token_for_response]); exit; }
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';
        $username_value = $username; // For repopulating form

        if (empty($username) || empty($password)) {
            $error_message = 'Username dan password tidak boleh kosong.';
        } else {
            if (isset($pdo)) { // $pdo should be available from config.php -> db_connect.php
                try {
                    $stmt = $pdo->prepare("SELECT id, username, password_hash, role, full_name, is_active FROM portal_users WHERE username = :username LIMIT 1");
                    $stmt->execute([':username' => $username]);
                    $user = $stmt->fetch();

                    if ($user && password_verify($password, $user['password_hash'])) {
                        if ($user['is_active'] == 1) {
                            $_SESSION['user_id'] = $user['id'];
                            $_SESSION['username'] = $user['username'];
                            $_SESSION['full_name'] = $user['full_name'] ?? ''; // Ensure it handles NULL
                            $_SESSION['role'] = $user['role'];
                            session_regenerate_id(true); // Good security practice
                            
                            // Update last login timestamp
                            try {
                                $stmt_update_login = $pdo->prepare("UPDATE portal_users SET last_login_at = NOW() WHERE id = :id");
                                $stmt_update_login->execute([':id' => $user['id']]);
                            } catch (\PDOException $e) { 
                                error_log("Login Page: Failed to update last_login_at for user {$user['id']}: " . $e->getMessage());
                            }
                            
                            $dashboard_url = admin_url('index.php');
                            if ($is_ajax_login) { echo json_encode(['success' => true, 'redirect_url' => $dashboard_url, 'message' => 'Login berhasil! Mengarahkan...']); exit; }
                            header('Location: ' . $dashboard_url); exit;
                        } else {
                            $error_message = 'Akun Anda tidak aktif. Hubungi administrator.';
                        }
                    } else {
                        $error_message = 'Username atau password salah.';
                    }
                } catch (\PDOException $e) {
                    error_log("Login Page Error (DB Query): " . $e->getMessage());
                    $error_message = 'Terjadi kesalahan pada server. Silakan coba lagi nanti.';
                }
            } else {
                $error_message = 'Koneksi database tidak tersedia. Mohon hubungi administrator.';
                error_log("Login Page: PDO object not available for login attempt.");
            }
        }
    }
    // If AJAX and error occurred, send error response
    if ($is_ajax_login && !empty($error_message)) { 
        $_SESSION['csrf_token'] = null; // Clear old one on failed attempt
        $new_csrf_token_for_response = generate_csrf_token(); // Provide a new token for the next try
        http_response_code(401); // Unauthorized or Bad Credentials
        echo json_encode(['success' => false, 'message' => $error_message, 'new_csrf_token' => $new_csrf_token_for_response]); 
        exit; 
    }
}

// Theme and site details (global $settings is loaded by config.php)
global $settings;
$theme_cookie = $_COOKIE['theme'] ?? 'light'; // Assuming 'light' or 'dark'
$site_name_login = get_site_setting('site_name', 'UGKMB Admin Panel');
$favicon_path = get_site_setting('site_favicon_url', 'public/assets/images/favicon.ico'); // Path from public web root
$favicon_url_login = resolve_url($favicon_path); // resolve_url handles paths from public root
$logo_path = get_site_setting('site_logo_url', 'public/assets/images/logo_ugkmb.png');
$logo_url_login = resolve_url($logo_path);

?>
<!DOCTYPE html>
<html lang="id" data-bs-theme="<?php echo esc_html($theme_cookie); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title>Login Admin - <?php echo esc_html($site_name_login); ?></title>
    <link rel="icon" href="<?php echo esc_html($favicon_url_login); ?>" type="image/x-icon">
    
    <!-- Google Fonts: Nunito -->
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Bootstrap 5.3 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Custom Admin CSS (can be loaded from admin/assets/ if needed, or inline for login) -->
    <link rel="stylesheet" href="<?php echo resolve_url('admin/assets/css/admin-login.css'); ?>">
    
    <script>
        // FOUC Prevention & Theme Application
        (function() {
            const storedTheme = localStorage.getItem('theme') || 
                                (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light');
            document.documentElement.setAttribute('data-bs-theme', storedTheme);
        })();
    </script>
</head>
<body>
    <main class="form-signin w-100 m-auto text-center">
        <form action="<?php echo admin_url('login.php'); ?>" method="POST" id="loginForm" novalidate>
            <input type="hidden" name="csrf_token" id="csrf_token_login" value="<?php echo $new_csrf_token_for_response; ?>">
            
            <img class="mb-4 login-logo" src="<?php echo esc_html($logo_url_login); ?>" alt="Logo <?php echo esc_html($site_name_login); ?>" >
            <h1 class="h3 mb-3 fw-normal">Admin Login</h1>
            <p class="mb-4 text-muted">Silakan masuk untuk melanjutkan ke panel admin.</p>

            <?php if (!$is_ajax_login && !empty($error_message)): ?>
                <div class="alert alert-danger text-start py-2" role="alert">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i><?php echo esc_html($error_message); ?>
                </div>
            <?php endif; ?>
            <div class="alert alert-danger text-start py-2" id="ajaxLoginErrorAlert" style="display:none;" role="alert"></div>

            <div class="form-floating mb-3">
                <input type="text" class="form-control" id="username" name="username" placeholder="Username Anda" 
                       value="<?php echo esc_html($username_value); ?>" required autofocus autocomplete="username">
                <label for="username"><i class="bi bi-person-fill me-2"></i>Username</label>
            </div>
            <div class="form-floating mb-2">
                <input type="password" class="form-control" id="password" name="password" placeholder="Password Anda" 
                       required autocomplete="current-password">
                <label for="password"><i class="bi bi-lock-fill me-2"></i>Password</label>
            </div>
            
            <!-- Optional: "Remember Me" and "Forgot Password"
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="form-check text-start">
                    <input class="form-check-input" type="checkbox" value="remember-me" id="rememberMe">
                    <label class="form-check-label" for="rememberMe"> Ingat Saya </label>
                </div>
                <a href="#" class="small">Lupa Password?</a>
            </div>
            -->

            <button class="btn btn-primary w-100 py-2 btn-lg" type="submit" id="loginButton">
                <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true" style="display: none;"></span>
                <i class="bi bi-box-arrow-in-right me-1 login-icon"></i> Login
            </button>
            
            <p class="mt-5 mb-3 text-body-secondary">
                © <?php echo date('Y'); ?> <?php echo esc_html(get_site_setting('site_name', 'Universitas Anda')); ?>
            </p>
        </form>
    </main>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <!-- jQuery (if still preferred for AJAX) -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    
    <script>
    $(document).ready(function() {
        $('#loginForm').on('submit', function(e) {
            e.preventDefault();
            const form = $(this);
            const submitButton = $('#loginButton');
            const spinner = submitButton.find('.spinner-border');
            const loginIcon = submitButton.find('.login-icon');
            const originalButtonText = 'Login'; // Assuming this is the text without icon
            
            submitButton.prop('disabled', true);
            spinner.show();
            loginIcon.hide();
            submitButton.contents().filter(function(){ return this.nodeType === 3; }).first().replaceWith(" Memproses..."); // Text part


            $('#ajaxLoginErrorAlert').hide().removeClass('alert-success alert-danger').html('');

            $.ajax({
                url: form.attr('action'),
                method: form.attr('method'),
                data: form.serialize(), // Sends form data including the current CSRF token
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $('#ajaxLoginErrorAlert').removeClass('alert-danger').addClass('alert-success')
                            .html('<i class="bi bi-check-circle-fill me-2"></i>' + (response.message || 'Login berhasil! Mengarahkan...')).show();
                        // Small delay to show success message before redirect
                        setTimeout(function() {
                            window.location.href = response.redirect_url || '<?php echo admin_url("index.php"); ?>';
                        }, 700);
                    } else {
                        $('#ajaxLoginErrorAlert').removeClass('alert-success').addClass('alert-danger')
                            .html('<i class="bi bi-exclamation-triangle-fill me-2"></i>' + (response.message || 'Login gagal.')).show();
                        if (response.new_csrf_token) {
                            $('#csrf_token_login').val(response.new_csrf_token);
                        }
                    }
                },
                error: function(jqXHR) {
                    let errorMsg = 'Terjadi kesalahan pada server. Silakan coba lagi.';
                    if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                        errorMsg = jqXHR.responseJSON.message;
                    } else if (jqXHR.status === 0) {
                        errorMsg = 'Tidak dapat terhubung ke server. Periksa koneksi internet Anda.';
                    } else if (jqXHR.status === 403) {
                        errorMsg = 'Akses ditolak atau sesi tidak valid. Silakan muat ulang halaman dan coba lagi.';
                    }
                    $('#ajaxLoginErrorAlert').removeClass('alert-success').addClass('alert-danger')
                        .html('<i class="bi bi-shield-fill-exclamation me-2"></i>' + errorMsg).show();
                    if (jqXHR.responseJSON && jqXHR.responseJSON.new_csrf_token) {
                        $('#csrf_token_login').val(jqXHR.responseJSON.new_csrf_token);
                    }
                },
                complete: function() {
                    submitButton.prop('disabled', false);
                    spinner.hide();
                    loginIcon.show();
                    submitButton.contents().filter(function(){ return this.nodeType === 3; }).first().replaceWith(" Login");
                }
            });
        });
    });
    </script>
</body>
</html>
