<?php
// admin/includes/header.php

// --- INCLUSION CONFIG DAN SESSION MANAGEMENT ---
// Hanya panggil session_start jika belum aktif.
// config.php adalah tempat yang ideal untuk session_start() setelah pengaturan session path jika ada.
if (session_status() == PHP_SESSION_NONE) {
    // Jika PROJECT_ROOT belum ada, coba definisikan untuk mencari config.php
    if (!defined('PROJECT_ROOT')) {
        // Asumsi header.php ada di admin/includes/
        // Ini adalah fallback, idealnya file yang meng-include header sudah mendefinisikan PROJECT_ROOT via config.php
        define('PROJECT_ROOT', dirname(__DIR__, 2)); 
    }
    // Muat config.php HANYA jika belum dimuat. config.php akan menangani session_start()
    // Biasanya, file seperti index.php atau create.php sudah require config.php di awal.
    // Jika kita memaksa require_once di sini, itu bisa jadi redundan atau menyebabkan error jika config.php tidak boleh di-include dua kali.
    // Namun, untuk keamanan, kita pastikan konstanta penting ada.
    if (!defined('BASE_URL')) { // Indikator bahwa config.php mungkin belum sepenuhnya termuat.
        if (file_exists(PROJECT_ROOT . '/config.php')) {
            require_once PROJECT_ROOT . '/config.php'; // config.php HARUS menangani session_start()
        } else {
            error_log("CRITICAL: config.php not found from admin/includes/header.php. PROJECT_ROOT: " . PROJECT_ROOT);
            die("Site configuration error (H01). Please contact administrator.");
        }
    }
}
// Pada titik ini, config.php seharusnya sudah dimuat, dan session sudah aktif.

// Cek jika user login, kecuali di halaman login itu sendiri
$current_page_basename = basename($_SERVER['PHP_SELF']);
if (!isset($_SESSION['user_id']) && $current_page_basename !== 'login.php') {
    // BASE_URL harusnya sudah didefinisikan oleh config.php
    $login_redirect_url = defined('BASE_URL') ? rtrim(BASE_URL, '/') . '/admin/login.php' : 'login.php'; 
    header('Location: ' . $login_redirect_url);
    exit;
}

// Ambil settings global (seharusnya sudah di-load oleh config.php)
global $settings; // Pastikan $settings bisa diakses
$site_name_admin_header = isset($settings['site_name']) ? htmlspecialchars($settings['site_name']) : "UGKMB CMS";
$admin_theme = $_COOKIE['admin_theme'] ?? ($settings['default_admin_theme'] ?? 'light-theme'); // light-theme atau dark-theme

// --- KALKULASI PATH ASET RELATIF KE ADMIN ROOT ---
$admin_asset_path_prefix = '';
$current_script_for_path = str_replace('\\', '/', $_SERVER['SCRIPT_NAME']); // Use SCRIPT_NAME for consistency
$admin_folder_segment = '/admin/';
$admin_pos = strpos($current_script_for_path, $admin_folder_segment);

if ($admin_pos !== false) {
    $path_after_admin = substr($current_script_for_path, $admin_pos + strlen($admin_folder_segment));
    $depth = substr_count(dirname($path_after_admin), '/'); // Count directories *after* /admin/
    if (dirname($path_after_admin) === '.') { // file is directly in /admin/
        $depth = 0;
    } else {
        $depth = substr_count($path_after_admin, '/') - (is_dir(PROJECT_ROOT . $current_script_for_path) ? 0 : 1);
        $depth = max(0, $depth); // Ensure depth is not negative
    }
     $admin_asset_path_prefix = str_repeat('../', $depth);

    // Specific check for files directly in /admin (e.g. /admin/index.php, /admin/login.php)
    // dirname('/admin/index.php') is '/admin', dirname('/admin/modules/file.php') is '/admin/modules'
    $script_dir_from_doc_root = dirname($current_script_for_path);
    $expected_admin_root_dir = rtrim(substr($current_script_for_path, 0, $admin_pos + strlen($admin_folder_segment)), '/');

    if (rtrim($script_dir_from_doc_root, '/') === $expected_admin_root_dir) {
        $admin_asset_path_prefix = ''; // Correct for files directly in /admin
    } else {
        $path_segments_after_admin_root = explode('/', trim(substr($script_dir_from_doc_root, strlen($expected_admin_root_dir)), '/'));
        $path_segments_after_admin_root = array_filter($path_segments_after_admin_root); // Remove empty segments
        $admin_asset_path_prefix = str_repeat('../', count($path_segments_after_admin_root));
    }


} else {
    // Should not happen if header is used within admin area
    error_log("WARNING: Admin header included from outside an /admin/ path structure. Current path: {$current_script_for_path}");
    $admin_asset_path_prefix = './'; // Fallback
}


// Favicon (resolve_url HARUS tersedia dari config.php)
$favicon_url_resolved = isset($settings['site_favicon_url']) && !empty($settings['site_favicon_url']) 
    ? htmlspecialchars(resolve_url($settings['site_favicon_url'])) 
    : htmlspecialchars($admin_asset_path_prefix . 'assets/img/favicon.ico'); // Fallback path relatif dari admin root

?>
<!DOCTYPE html>
<html lang="id" class="<?php echo htmlspecialchars($admin_theme); // Class tema awal untuk FOUC prevention ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Admin Panel - <?php echo $site_name_admin_header; ?>">
    <meta name="author" content="UGKMB Dev Team">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) . ' - ' : ''; ?><?php echo $site_name_admin_header; ?></title>

    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <link href="<?php echo htmlspecialchars($admin_asset_path_prefix); ?>assets/css/style.css" rel="stylesheet">
    
    <link rel="icon" href="<?php echo $favicon_url_resolved; ?>" type="image/x-icon">

    <?php if (isset($include_datatables_css) && $include_datatables_css): ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">
    <?php endif; ?>
    
    <?php
    // Output page-specific styles DARI VARIABLE $page_header_styles
    if (isset($page_header_styles) && is_array($page_header_styles)) {
        foreach ($page_header_styles as $style_link_or_block) {
            echo $style_link_or_block . "\n";
        }
    }
    ?>

    <script>
        // FOUC Prevention untuk Tema Admin dan Definisi BASE_URL_JS
        (function() {
            const cookieTheme = document.cookie.split('; ').find(row => row.startsWith('admin_theme='))?.split('=')[1];
            const systemPrefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
            let currentTheme = cookieTheme || (systemPrefersDark ? 'dark-theme' : 'light-theme');
            <?php if (!empty($settings['default_admin_theme'])): ?>
                currentTheme = cookieTheme || '<?php echo htmlspecialchars($settings['default_admin_theme']); ?>';
            <?php endif; ?>
            
            document.documentElement.className = currentTheme;
            if (currentTheme === 'dark-theme') {
                document.body.setAttribute('data-bs-theme', 'dark');
            } else {
                document.body.setAttribute('data-bs-theme', 'light');
            }
        })();
        const BASE_URL_JS = '<?php echo rtrim(BASE_URL, '/'); ?>';
        const ADMIN_ASSET_PATH_JS = '<?php echo $admin_asset_path_prefix; ?>'; 
    </script>
</head>
<body class="<?php echo htmlspecialchars($admin_theme); ?> sb-nav-fixed"> 

    <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark">
        <a class="navbar-brand ps-3" href="<?php echo admin_url('index.php'); ?>"><?php echo $site_name_admin_header; ?></a>
        
        <?php if ($current_page_basename !== 'login.php'): ?>
        <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!"><i class="fas fa-bars"></i></button>
        <?php endif; ?>
        
        <div class="d-none d-md-inline-block form-inline ms-auto me-0 me-md-3 my-2 my-md-0">
            </div>
        
        <ul class="navbar-nav ms-auto ms-md-0 me-3 me-lg-4 align-items-center">
            <li class="nav-item">
                 <button class="btn btn-link btn-sm text-white" id="adminThemeToggle" title="Toggle Dark/Light Mode">
                    <i class="fas <?php echo $admin_theme === 'dark-theme' ? 'fa-sun' : 'fa-moon'; ?>" id="adminThemeIcon"></i>
                </button>
            </li>
            <?php if (isset($_SESSION['user_id'])): ?>
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" id="navbarDropdownUser" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="fas fa-user fa-fw"></i>
                    <?php echo isset($_SESSION['full_name']) && !empty($_SESSION['full_name']) ? htmlspecialchars($_SESSION['full_name']) : (isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Pengguna'); ?>
                </a>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdownUser">
                    <li><a class="dropdown-item" href="<?php echo admin_url('modules/users/edit_profile.php'); ?>">Profil Saya</a></li>
                    <li><a class="dropdown-item" href="<?php echo admin_url('modules/settings/index.php'); ?>">Pengaturan Situs</a></li>
                    <li><hr class="dropdown-divider" /></li>
                    <li><a class="dropdown-item" href="<?php echo admin_url('logout.php'); ?>">Logout</a></li>
                </ul>
            </li>
            <?php endif; ?>
        </ul>
    </nav>

    <?php if ($current_page_basename !== 'login.php'): ?>
    <div id="layoutSidenav"> 
        <?php
            // Path ke sidebar dari root admin adalah 'includes/sidebar.php'
            // $admin_asset_path_prefix sudah menghitung kedalaman relatif
            // Logic to include sidebar
            $sidebar_path_from_admin_root = 'includes/sidebar.php';
            $actual_sidebar_path = '';

            // Construct path from PROJECT_ROOT to ensure correctness
            if (defined('PROJECT_ROOT')) {
                $actual_sidebar_path = PROJECT_ROOT . '/admin/' . $sidebar_path_from_admin_root;
            } else {
                // Fallback if PROJECT_ROOT is not defined (should not happen if config.php is loaded)
                // This relative path assumes this header.php is in admin/includes/
                $actual_sidebar_path = $admin_asset_path_prefix . $sidebar_path_from_admin_root; 
            }
            
            if (file_exists($actual_sidebar_path)) {
                 include_once $actual_sidebar_path;
            } else {
                 error_log("CRITICAL: Sidebar not found. Tried path: " . $actual_sidebar_path . " (Calculated prefix: " . $admin_asset_path_prefix . ")");
                 echo "";
            }
        ?>
        <div id="layoutSidenav_content">
            <main> 
                <?php endif; // End if not login.php ?>