<?php
// /oldugk/admin/includes/footer_new.php
global $page_scripts; // Array untuk skrip spesifik halaman
?>
        </main> <!-- End .main-content -->
    </div> <!-- End .row -->
</div> <!-- End .container-fluid (dari header) -->

<footer class="bg-dark text-white text-center py-3 mt-auto">
    <div class="container">
        <p class="mb-0">© <?php echo date('Y'); ?> UGKMB. All Rights Reserved. (Admin Panel New)</p>
    </div>
</footer>

<!-- Bootstrap Bundle with Popper (Untuk Modal, Dropdown, dll) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<!-- jQuery (Anda masih menggunakannya untuk AJAX) -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- Skrip Admin Global (jika ada) -->
<!-- <script src="<?php echo esc_html(rtrim($module_base_path, '/')); ?>/assets/js/admin_global_new.js"></script> -->

<script>
// Fungsi showAdminNotification yang akan dipanggil oleh JS di view.php
// Ini adalah implementasi sederhana menggunakan Bootstrap Toasts atau Alerts
// Anda bisa menggantinya dengan library notifikasi yang lebih canggih seperti Toastr.js
function showAdminNotification(type, message) {
    // Cek apakah container untuk toast sudah ada, jika tidak buat
    if ($('#toastPlacement').length === 0) {
        $('body').append('<div aria-live="polite" aria-atomic="true" class="position-fixed top-0 end-0 p-3" style="z-index: 1080;" id="toastPlacement"><div id="toastContainer" class="toast-container"></div></div>');
    }

    const toastId = 'toast-' + Date.now();
    let toastClass = '';
    let iconClass = '';

    switch(type) {
        case 'success':
            toastClass = 'bg-success text-white';
            iconClass = 'fas fa-check-circle';
            break;
        case 'danger':
            toastClass = 'bg-danger text-white';
            iconClass = 'fas fa-times-circle';
            break;
        case 'warning':
            toastClass = 'bg-warning text-dark';
            iconClass = 'fas fa-exclamation-triangle';
            break;
        default:
            toastClass = 'bg-info text-white';
            iconClass = 'fas fa-info-circle';
            break;
    }

    const toastHtml = `
        <div class="toast ${toastClass}" role="alert" aria-live="assertive" aria-atomic="true" id="${toastId}" data-bs-delay="5000">
            <div class="toast-header ${toastClass} border-0">
                <strong class="me-auto"><i class="${iconClass} me-2"></i> Notifikasi</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">
                ${message}
            </div>
        </div>
    `;

    $('#toastContainer').append(toastHtml);
    const toastElement = new bootstrap.Toast(document.getElementById(toastId));
    toastElement.show();

    // Hapus elemen toast dari DOM setelah disembunyikan untuk menjaga kebersihan DOM
    $('#' + toastId).on('hidden.bs.toast', function () {
        $(this).remove();
    });
}
</script>

<?php
// Output skrip spesifik halaman jika ada
if (isset($page_scripts) && is_array($page_scripts)) {
    foreach ($page_scripts as $script) {
        echo $script; // $script harus sudah berisi tag <script>...</script>
    }
}
?>
</body>
</html>