// admin/assets/js/scripts.js

document.addEventListener('DOMContentLoaded', function () {
    
    // --- Admin Theme Toggler ---
    const adminThemeToggleButton = document.getElementById('adminThemeToggleButton');
    const adminThemeIconSun = document.getElementById('adminThemeIconSun');
    const adminThemeIconMoon = document.getElementById('adminThemeIconMoon');
    const htmlAdminRootElement = document.documentElement; // Target <html> for data-bs-theme

    function applyAdminThemePreference(theme) { // theme is 'light' or 'dark'
        htmlAdminRootElement.setAttribute('data-bs-theme', theme);
        
        if (adminThemeIconSun && adminThemeIconMoon) {
            if (theme === 'dark') {
                adminThemeIconSun.style.display = 'inline-block';
                adminThemeIconMoon.style.display = 'none';
            } else {
                adminThemeIconSun.style.display = 'none';
                adminThemeIconMoon.style.display = 'inline-block';
            }
        }
        localStorage.setItem('admin_theme_preference', theme);
        
        // Calculate correct cookie path for admin area
        let adminPathForCookie = '/admin'; // Fallback
        if (typeof BASE_URL_JS !== 'undefined' && BASE_URL_JS) { // BASE_URL_JS is defined in header.php
            try {
                const projectBasePath = new URL(BASE_URL_JS).pathname;
                // Ensure path starts with / and ends with /admin
                let calculatedPath = (projectBasePath.endsWith('/') ? projectBasePath : projectBasePath + '/');
                calculatedPath = (calculatedPath.startsWith('/') ? calculatedPath : '/' + calculatedPath);
                adminPathForCookie = calculatedPath + 'admin';
                adminPathForCookie = adminPathForCookie.replace(/\/\//g, '/'); // Remove double slashes
            } catch (e) {
                console.warn("Could not parse BASE_URL_JS for admin cookie path, using default /admin.", e);
            }
        }
        document.cookie = "admin_theme=" + theme + ";path=" + adminPathForCookie + ";max-age=" + (60*60*24*365) + ";SameSite=Lax";
    }

    // Initialize theme based on saved preferences or system settings on page load
    // This logic is also present inline in header.php for FOUC prevention; this ensures icons are correct.
    let initialAdminTheme = localStorage.getItem('admin_theme_preference');
    const cookieInitialAdminTheme = document.cookie.split('; ').find(row => row.startsWith('admin_theme='))?.split('=')[1];

    if (cookieInitialAdminTheme) { // Cookie (potentially set by PHP or previous JS) takes precedence
        initialAdminTheme = cookieInitialAdminTheme;
    } else if (!initialAdminTheme) { // No localStorage, no cookie set by PHP
        initialAdminTheme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
    }
    applyAdminThemePreference(initialAdminTheme || 'light'); // Default to 'light' if somehow still undefined


    if (adminThemeToggleButton) {
        adminThemeToggleButton.addEventListener('click', function () {
            // Toggle based on the current attribute of <html> tag
            let newTheme = htmlAdminRootElement.getAttribute('data-bs-theme') === 'dark' ? 'light' : 'dark';
            applyAdminThemePreference(newTheme);
        });
    }

    // --- SB Admin Sidebar Toggler ---
    const sidebarToggleAdminButton = document.body.querySelector('#sidebarToggleAdminButton'); // Use the ID from header.php
    if (sidebarToggleAdminButton) {
        // Check localStorage for saved sidebar state
        if (localStorage.getItem('admin_sb_sidebar_toggle') === 'true') {
            document.body.classList.add('sb-sidenav-toggled');
        } else if (localStorage.getItem('admin_sb_sidebar_toggle') === 'false') {
             document.body.classList.remove('sb-sidenav-toggled');
        }
        // If not in localStorage, the default state (untoggled) will apply.

        sidebarToggleAdminButton.addEventListener('click', event => {
            event.preventDefault();
            document.body.classList.toggle('sb-sidenav-toggled');
            localStorage.setItem('admin_sb_sidebar_toggle', document.body.classList.contains('sb-sidenav-toggled'));
        });
    } else {
        // console.warn("Admin sidebar toggle button #sidebarToggleAdminButton not found.");
    }

    // --- Initialize Bootstrap Tooltips (Example of a global component init) ---
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.map(function (tooltipTriggerEl) {
      try {
        return new bootstrap.Tooltip(tooltipTriggerEl);
      } catch (e) {
        console.warn("Failed to initialize Bootstrap tooltip on element:", tooltipTriggerEl, e);
        return null;
      }
    });

    // --- Initialize DataTables on tables with class 'datatable' ---
    // This requires jQuery and DataTables library to be included on the page.
    // The calling PHP page should set $include_datatables_js = true;
    if (typeof $ !== 'undefined' && typeof $.fn.DataTable !== 'undefined' && $('.datatable').length > 0) {
        $('.datatable').each(function() {
            if (!$.fn.DataTable.isDataTable(this)) { // Initialize only if not already a DataTable
                $(this).DataTable({
                    responsive: true,
                    language: {
                        url: "//cdn.datatables.net/plug-ins/1.13.8/i18n/id.json" // Indonesian translation
                    },
                    order: [], // You can set default order e.g., [[0, 'desc']]
                    // Add more default DataTables options here if needed
                    // "paging": true,
                    // "lengthChange": true,
                    // "searching": true,
                    // "ordering": true,
                    // "info": true,
                    // "autoWidth": false,
                });
            }
        });
    }

    // --- Auto-generate slug from title (example, make it more specific if needed) ---
    // Example usage: Call initializeSlugGenerator('titleFieldId', 'slugFieldId'); from a page-specific script block.
    if (typeof window.initializeSlugGenerator === 'undefined') {
        window.initializeSlugGenerator = function(titleInputId, slugInputId) {
            const titleInput = document.getElementById(titleInputId);
            const slugInput = document.getElementById(slugInputId);

            if (!titleInput || !slugInput) return;

            let slugManuallyEdited = slugInput.value.trim() !== '';

            const generateSlugFromTitle = function() {
                if (!slugManuallyEdited) {
                    let slug = titleInput.value.toString().toLowerCase()
                        .trim()
                        .replace(/\s+/g, '-')           // Replace spaces with -
                        .replace(/[^\w-]+/g, '')       // Remove all non-word chars (keeps hyphens)
                        .replace(/--+/g, '-')          // Replace multiple - with single -
                        .replace(/^-+/, '')             // Trim - from start of text
                        .replace(/-+$/, '');            // Trim - from end of text
                    slugInput.value = slug;
                }
            };
            titleInput.addEventListener('keyup', generateSlugFromTitle);
            titleInput.addEventListener('blur', generateSlugFromTitle); // Also on blur
            slugInput.addEventListener('input', function() { // If user types in slug field, stop auto-generation
                slugManuallyEdited = this.value.trim() !== '';
            });
        };
    }

    // --- Initialize Image Preview for file inputs (example) ---
    // Example usage: Call initializeImagePreview('fileInputId', 'imagePreviewId');
    if (typeof window.initializeImagePreview === 'undefined') {
        window.initializeImagePreview = function(fileInputId, previewImgId) {
            const fileInput = document.getElementById(fileInputId);
            const previewImg = document.getElementById(previewImgId);

            if (!fileInput || !previewImg) return;

            fileInput.addEventListener('change', function(event) {
                if (event.target.files && event.target.files[0]) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        previewImg.src = e.target.result;
                        previewImg.style.display = 'block';
                    }
                    reader.readAsDataURL(event.target.files[0]);
                } else {
                    previewImg.src = '#';
                    previewImg.style.display = 'none';
                }
            });
        };
    }

}); // End DOMContentLoaded