<?php
// admin/modules/users/edit_profile.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Profil Saya";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$user_id_to_edit = $_SESSION['user_id'];
$user_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT id, username, email, full_name FROM portal_users WHERE id = :id");
        $stmt->execute([':id' => $user_id_to_edit]);
        $user_data = $stmt->fetch();
    } catch (\PDOException $e) { set_flash_message('danger', 'Gagal mengambil data profil.'); }
}
if (!$user_data) { set_flash_message('danger', 'Data profil tidak ditemukan.'); /* Redirect or show error */ }

$form_data = $_SESSION['form_data'] ?? [
    'email' => $user_data['email'] ?? '', 'full_name' => $user_data['full_name'] ?? '',
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <?php if ($user_data): ?>
    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-user-edit me-1"></i> Formulir Edit Profil</div>
        <div class="card-body">
            <form action="process_user.php" method="POST" id="editProfileForm">
                <input type="hidden" name="action" value="edit_profile">
                <input type="hidden" name="id" value="<?php echo $user_data['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <input type="text" class="form-control" value="<?php echo esc_html($user_data['username']); ?>" disabled readonly>
                    <div class="form-text">Username tidak dapat diubah.</div>
                </div>
                <div class="mb-3">
                    <label for="full_name" class="form-label">Nama Lengkap</label>
                    <input type="text" class="form-control" id="full_name" name="full_name" value="<?php echo old_form_data('full_name', $user_data['full_name'] ?? '', $form_data); ?>">
                    <?php echo get_form_error('full_name', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                    <input type="email" class="form-control" id="email" name="email" value="<?php echo old_form_data('email', $user_data['email'] ?? '', $form_data); ?>" required>
                    <?php echo get_form_error('email', $form_errors); ?>
                </div>
                <hr class="my-4"><h5 class="mb-3">Ubah Password (Opsional)</h5>
                <p class="text-muted small">Kosongkan field password jika Anda tidak ingin mengubah password.</p>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="current_password" class="form-label">Password Saat Ini</label>
                        <input type="password" class="form-control" id="current_password" name="current_password" autocomplete="current-password">
                        <div class="form-text">Diperlukan jika Anda ingin mengubah password.</div>
                        <?php echo get_form_error('current_password', $form_errors); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="new_password" class="form-label">Password Baru</label>
                        <input type="password" class="form-control" id="new_password" name="new_password" autocomplete="new-password">
                        <div class="form-text">Minimal 8 karakter.</div>
                        <?php echo get_form_error('new_password', $form_errors); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="confirm_new_password" class="form-label">Konfirmasi Password Baru</label>
                        <input type="password" class="form-control" id="confirm_new_password" name="confirm_new_password" autocomplete="new-password">
                        <?php echo get_form_error('confirm_new_password', $form_errors); ?>
                    </div>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveProfileButton"><i class="fas fa-save me-1"></i> Simpan Profil</button>
                    <a href="<?php echo $module_base_path . 'index.php'; ?>" class="btn btn-secondary">Kembali ke Dashboard</a>
                </div>
            </form>
        </div>
    </div>
    <?php else: ?> <div class="alert alert-danger">Gagal memuat data profil.</div> <?php endif; ?>
</div>
<?php
$page_scripts = [];
$page_scripts[] = "<script>
$(document).ready(function() {
    $('#editProfileForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveProfileButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    // Update nama di topbar jika berubah
                    if (response.updated_full_name) {
                        let currentFullName = response.updated_full_name.trim();
                        if(currentFullName === '') currentFullName = form.find('input[name=\"username\"]').val(); // fallback ke username jika nama kosong
                        $('#navbarDropdownUser').html('<i class=\"fas fa-user fa-fw\"></i> ' + escapeHtmlJs(currentFullName) );
                    }
                    // Kosongkan field password setelah sukses update
                    $('#current_password').val('');
                    $('#new_password').val('');
                    $('#confirm_new_password').val('');
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan profil.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
    // Fungsi escapeHtmlJs jika belum ada global
    function escapeHtmlJs(unsafe) {
      if (typeof unsafe !== 'string') return '';
      return unsafe.replace(/&/g, \"&\").replace(/</g, \"<\").replace(/>/g, \">\").replace(/'/g, \"'\");
    }
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>